// Jamroom jrFollower Javascript
// @copyright 2003-2011 by Talldude Networks LLC
// @author Brian Johnson - brian@talldude.net

/**
 * jrFollowProfile
 */
function jrFollowProfile(id, pid)
{
    var bid = '#' + id;
    $(bid).attr('disabled', 'disabled');
    var url = core_system_url + '/' + jrFollower_url + '/follow/' + pid + '/__ajax=1';
    jrCore_set_csrf_cookie(url);
    $.ajax({
        type: 'POST',
        cache: false,
        dataType: 'json',
        url: url,
        success: function(m)
        {
            if (typeof m.error != "undefined") {
                jrCore_alert('a system level error was encountered submitting the request - please try again (1)');
            }
            else {
                window.location.reload();
            }
            return true;
        },
        error: function()
        {
            jrCore_alert('a system level error was encountered submitting the request - please try again (2)');
            return false;
        }
    });
    return false;
}

/**
 * jrUnFollowProfile
 */
function jrUnFollowProfile(id, pid)
{
    var bid = '#' + id;
    $(bid).attr('disabled', 'disabled');
    var url = core_system_url + '/' + jrFollower_url + '/unfollow/' + pid + '/__ajax=1';
    jrCore_set_csrf_cookie(url);
    $.ajax({
        type: 'POST',
        cache: false,
        dataType: 'json',
        url: url,
        success: function(m)
        {
            if (typeof m.error != "undefined") {
                jrCore_alert('a system level error was encountered submitting the request - please try again (3)');
            }
            else {
                window.location.reload();
            }
            return true;
        },
        error: function()
        {
            jrCore_alert('a system level error was encountered submitting the request - please try again (4)');
            return false;
        }
    });
    return false;
}

/**
 * Get profiles followed by a user
 */
function jrFollower_get_followed()
{
    var url = core_system_url + '/' + jrFollower_url + '/get_followed/__ajax=1';
    $.ajax({
        type: 'GET',
        cache: false,
        dataType: 'json',
        url: url,
        success: function(r)
        {
            if (typeof r.error != "undefined") {
                jrCore_alert(r.error);
            }
            else {
                var e = $('.follow_entry');
                if (e.length > 0) {
                    e.each(function()
                    {
                        var i = $(this).attr('data-id');
                        if (typeof r.following[i] === "undefined") {
                            $('#f' + i).show();
                        }
                        else {
                            if (r.following[i] === 0) {
                                $('#p' + i).show();
                            }
                            else {
                                $('#a' + i).show();
                            }
                        }
                    });
                }
            }
            return true;
        }
    });
}
