<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: widget_list_get_module_info
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_widget_list_get_module_info($_post, $_user, $_conf)
{
    jrUser_master_only();
    if (!isset($_post['m']) || !jrCore_module_is_active($_post['m'])) {
        jrCore_json_response(array('error' => 'invalid module'));
    }
    $key = json_encode($_post);
    if (!$_mi = jrCore_is_cached('jrCore', $key, false)) {

        $_mi = array();

        // Get unique DataStore keys
        $_mi[0] = jrCore_db_get_unique_keys($_post['m']);
        if (!$_mi[0] || !is_array($_mi[0])) {
            $_mi[0] = array('_created', '_updated');
        }
        foreach ($_mi[0] as $k => $v) {
            if (strpos($v, '_file_') && !strpos($v, 'count')) {
                unset($_mi[0][$k]);
            }
        }
        $_mi[0]['_'] = ' ';
        switch ($_post['m']) {
            case 'jrUser':
            case 'jrProfile':
                break;
            default:
                $_mi[0]['_item_id'] = '_item_id';
                break;
        }
        sort($_mi[0]);

        // Get module widget templates
        $_mi[1]           = jrCore_widget_list_get_module_templates($_post['m']);
        $_mi[1]['custom'] = 'custom';

        jrCore_add_to_cache('jrCore', $key, $_mi, 0, 0, false);
    }
    jrCore_json_response($_mi);
}
