<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: performance_share
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_performance_share($_post, $_user, $_conf)
{
    jrUser_master_only();
    $tbl = jrCore_db_table_name('jrCore', 'performance');
    $req = "SELECT * FROM {$tbl} ORDER BY p_id DESC LIMIT 1";
    $_tm = jrCore_db_query($req, 'SINGLE');
    if (!$_tm || !is_array($_tm)) {
        jrCore_notice_page('error', 'There are no results to share - please run the Performance Check tool at least once');
    }
    if (isset($_tm['p_provider']) && strlen($_tm['p_provider']) > 0) {
        // See if they JUST shared this
        if (!jrCore_get_temp_value('jrCore', 'performance_shared')) {
            jrCore_set_form_notice('warning', "This performance result has already been shared - resubmitting will overwrite your previous entry");
        }
        else {
            jrCore_delete_temp_value('jrCore', 'performance_shared');
        }
    }

    // If we are EMPTY on provider, price and rating get the LAST entry so we can pre-fill
    if (!isset($_tm['p_provider']) || strlen($_tm['p_provider']) === 0) {
        $req = "SELECT * FROM {$tbl} WHERE LENGTH(p_provider) > 0 ORDER BY p_id DESC LIMIT 1";
        $_ol = jrCore_db_query($req, 'SINGLE');
        if ($_ol && is_array($_ol)) {
            $_tm['p_provider'] = $_ol['p_provider'];
            $_tm['p_price']    = $_ol['p_price'];
            $_tm['p_rating']   = $_ol['p_rating'];
            $_tm['p_type']     = (strlen($_ol['p_type']) > 0) ? $_ol['p_type'] : 'none';
        }
        unset($_ol);
    }

    $pid  = (int) $_tm['p_id'];
    $_pr  = json_decode($_tm['p_val'], true);
    $_inf = jrCore_get_proc_info();
    $pnum = count($_inf);
    $tot  = round((10 / $_pr['total']) * 800);
    if ($pnum > 1) {
        $tot += round(($tot / (8 + $pnum)) * ($pnum / 2));
    }
    $tot = jrCore_number_format($tot);

    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrCore');
    jrCore_page_banner('share your performance results');

    $_tmp = array(
        'submit_value'     => 'share these results',
        'cancel'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/performance_check",
        'form_ajax_submit' => false
    );
    jrCore_form_create($_tmp);

    $titl = '';
    $line = '';
    $cadd = '';
    $_cpu = jrCore_get_proc_info();
    if ($_cpu && is_array($_cpu) && isset($_cpu[1]['mhz'])) {
        $cadd = "&nbsp;<b>Server CPU:</b> {$_cpu[1]['mhz']}<br>";
    }
    $madd = '';
    $_mem = jrCore_get_system_memory();
    if ($_mem && is_array($_mem) && isset($_mem['memory_total'])) {
        $madd = "&nbsp;<b>Server RAM:</b> " . jrCore_format_size($_mem['memory_total']) . '<br>';
    }
    if (strlen("{$cadd}{$madd}") > 0) {
        $titl = 'Server Info:<br><br>';
        $line = '<br>Performance Results:<br><br>';
    }

    // Results
    $_tmp = array(
        'name'  => 'result',
        'type'  => 'hidden',
        'value' => jrCore_url_encode_string($_tm['p_val'])
    );
    jrCore_form_field_create($_tmp);

    // Performance ID
    $_tmp = array(
        'name'  => 'p_id',
        'type'  => 'hidden',
        'value' => $pid
    );
    jrCore_form_field_create($_tmp);

    // Hardware
    if (strlen($cadd) > 0) {
        $_tmp = array(
            'name'  => 'p_cpu',
            'type'  => 'hidden',
            'value' => $_cpu[1]['mhz']
        );
        jrCore_form_field_create($_tmp);
    }
    if (strlen($madd) > 0) {
        $_tmp = array(
            'name'  => 'p_mem',
            'type'  => 'hidden',
            'value' => jrCore_format_size($_mem['memory_total'])
        );
        jrCore_form_field_create($_tmp);
    }

    // Provider
    $_tmp = array(
        'name'     => 'provider',
        'label'    => 'Provider Name',
        'help'     => 'Enter the name of your Hosting Provider',
        'type'     => 'text',
        'validate' => 'not_empty',
        'section'  => 'required information',
        'required' => true,
        'value'    => (isset($_tm['p_provider']) && strlen($_tm['p_provider']) > 0) ? jrCore_entity_string($_tm['p_provider']) : ''
    );
    jrCore_form_field_create($_tmp);

    jrCore_page_custom("<div class=\"success p10 fixed-width rounded\" style=\"margin-left:4px\">{$titl}{$cadd}{$madd}{$line}&nbsp;&nbsp;<b>Processor:</b> {$_pr['cpu']}<br>&nbsp;&nbsp;&nbsp;<b>Database:</b> {$_pr['db']}<br>&nbsp;<b>Filesystem:</b> {$_pr['fs']}<br><b>Total Score:</b> {$tot}</div>", 'Results To Share');

    // Comment
    $_tmp = array(
        'name'     => 'comment',
        'label'    => 'Result Comments',
        'sublabel' => '(max 512 characters)',
        'help'     => 'If you would like to provide a short Comment or Review of your Provider or Test Results, enter it here and it will be shared.',
        'type'     => 'textarea',
        'validate' => 'not_empty',
        'section'  => 'optional',
        'required' => false,
        'value'    => (isset($_tm['p_comment']) && strlen($_tm['p_comment']) > 0) ? jrCore_entity_string($_tm['p_comment']) : ''
    );
    jrCore_form_field_create($_tmp);

    // Price
    $_val = array(
        0 => '-',
        1 => 'Under &#36;10',
        2 => '&#36;10 to &#36;25',
        3 => '&#36;25 to &#36;50',
        4 => '&#36;50 to &#36;100',
        5 => 'Over &#36;100'
    );
    $_tmp = array(
        'name'     => 'price',
        'label'    => 'Monthly Hosting Cost',
        'help'     => 'How much do you pay <strong>monthly</strong> for your Jamroom hosting account?',
        'type'     => 'select',
        'options'  => $_val,
        'default'  => 0,
        'validate' => 'number_nz',
        'required' => false,
        'value'    => (isset($_tm['p_price']) && is_numeric($_tm['p_price'])) ? intval($_tm['p_price']) : 0
    );
    jrCore_form_field_create($_tmp);

    // Type
    $_val = array(
        'none'      => '-',
        'jamroom'   => 'Jamroom Hosted',
        'shared'    => 'Shared Hosting',
        'reseller'  => 'Reseller Hosting',
        'vps'       => 'VPS (Virtual Private Server)',
        'dedicated' => 'Dedicated Server',
        'cloud'     => 'Cloud Provider (Amazon Web Services, Rackspace Cloud, Heroku, etc.)'
    );
    $_tmp = array(
        'name'     => 'type',
        'label'    => 'Hosting Type',
        'help'     => 'What type of Hosting Account do you run Jamroom on?  Select the account type that fits your hosting account the closest.',
        'type'     => 'select',
        'options'  => $_val,
        'default'  => 'none',
        'validate' => 'core_string',
        'required' => false,
        'value'    => (isset($_tm['p_type']) && strlen($_tm['p_type']) > 0) ? $_tm['p_type'] : 'none'
    );
    jrCore_form_field_create($_tmp);

    // Rating
    $_val = array(
        0 => '-',
        5 => 'Excellent',
        4 => 'Above Average',
        3 => 'Average',
        2 => 'Below Average',
        1 => 'Poor'
    );
    $_tmp = array(
        'name'     => 'rating',
        'label'    => 'Provider Rating',
        'help'     => 'How would you rate the value of the service you receive from your provider?',
        'type'     => 'select',
        'options'  => $_val,
        'default'  => 0,
        'validate' => 'number_nz',
        'required' => false,
        'value'    => (isset($_tm['p_rating']) && is_numeric($_tm['p_rating'])) ? intval($_tm['p_rating']) : 0
    );
    jrCore_form_field_create($_tmp);

    jrCore_page_display();
}
