<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: dashboard
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_dashboard($_post, $_user, $_conf)
{
    global $_mods, $_urls;
    jrUser_admin_only();
    // http://www.site.com/core/dashboard/online
    // http://www.site.com/core/dashboard/pending
    // http://www.site.com/core/dashboard/browser
    $title = '';
    if (!isset($_post['_1'])) {
        $_post['_1'] = 'bigview';
    }

    jrCore_page_dashboard_tabs($_post['_1']);
    switch ($_post['_1']) {

        //------------------------------
        // BIGVIEW
        //------------------------------
        case 'bigview':

            $title = 'Dashboard';
            // Setup timer
            $refresh = '';
            if (!jrCore_is_mobile_device()) {
                $refresh = jrCore_page_button('reload', '60', "jrCore_dashboard_reload_page(60,0)");
            }
            if (jrUser_is_master()) {
                $refresh .= jrCore_page_button('custom', 'customize', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/dashboard_config')");
            }
            if (!jrCore_is_mobile_device() || jrCore_is_tablet_device()) {
                $refresh .= jrCore_page_icon_button('refresh', 'aspect_ratio', "jrCore_dashboard_fullscreen('page_table_jr_bigview')", array('title' => 'Launch Full Screen'));
            }
            $refresh .= jrCore_page_icon_button('refresh', 'refresh', "location.reload();", array('title' => 'Refresh'));

            // for reload timer
            if (jrCore_get_cookie('reload') == 'on') {
                $_js = array('jrCore_dashboard_reload_page(60,1);');
            }
            else {
                $_js = array('$(\'#reload\').addClass(\'form_button_disabled\'); jrCore_dashboard_reload_page(60,1);');
            }
            jrCore_create_page_element('javascript_ready_function', $_js);

            jrCore_page_banner('dashboard', $refresh);
            jrCore_get_form_notice();
            jrCore_dashboard_bigview($_post, $_user, $_conf);

            break;

        //------------------------------
        // USERS ONLINE
        //------------------------------
        case 'online':
            $btn = null;
            if (!isset($_conf['jrUser_bot_sessions']) || $_conf['jrUser_bot_sessions'] == 'on') {
                $url = jrCore_strip_url_params(jrCore_get_current_url(), array('show_bots'));
                if (isset($_post['show_bots'])) {
                    $btn = jrCore_page_button('sb', 'Hide Bots', "jrCore_window_location('{$url}')");
                }
                else {
                    $btn = jrCore_page_button('sb', 'Show Bots', "jrCore_window_location('{$url}/show_bots=1')");
                }
            }
            $url = jrCore_get_module_url('jrUser');
            $btn .= jrCore_page_button('newuser', 'new user account', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$url}/create')");

            jrCore_page_banner('users online', $btn);
            jrCore_get_form_notice();
            jrUser_online_users($_post, $_user, $_conf);
            $title = 'Users Online';
            break;

        //------------------------------
        // PENDING USERS
        //------------------------------
        case 'pending_users':
            $title = 'Pending Users';
            jrCore_page_banner('pending users');
            jrCore_get_form_notice();
            jrUser_dashboard_pending_users($_post, $_user, $_conf);
            break;

        //------------------------------
        // PENDING
        //------------------------------
        case 'pending':

            if (!isset($_post['m']) || !jrCore_module_is_active($_post['m'])) {
                $_post['m'] = jrCore_get_dashboard_default_pending_tab();
            }
            jrCore_dashboard_pending_tabs($_post['m']);
            $title = 'Pending: ' . $_mods["{$_post['m']}"]['module_name'];
            jrCore_page_banner($title);
            jrCore_get_form_notice();
            switch ($_post['m']) {
                case 'jrUser':
                    jrUser_dashboard_pending_users($_post, $_user, $_conf);
                    break;
                default:
                    $func = "{$_post['m']}_dashboard_pending";
                    if (function_exists($func)) {
                        $func($_post, $_user, $_conf);
                    }
                    else {
                        jrCore_dashboard_pending($_post, $_user, $_conf);
                    }
                    break;
            }
            break;

        //------------------------------
        // ACTIVITY LOG
        //------------------------------
        case 'activity':
            $title = 'Activity Log';
            jrCore_dashboard_activity_log($_post, $_user, $_conf, 'dashboard');
            break;

        //------------------------------
        // DATA BROWSER
        //------------------------------
        case 'browser':
            $title = 'Data Browser';
            jrCore_dashboard_browser('dashboard', $_post, $_user, $_conf);
            break;

        //------------------------------
        // RECYCLE BIN
        //------------------------------
        case 'recycle_bin':
            $title = 'Recycle Bin';
            jrCore_dashboard_recycle_bin($_post, $_user, $_conf);
            break;

        //------------------------------
        // QUEUE VIEWER
        //------------------------------
        case 'queue_viewer':
            $title = 'Queue Viewer';
            jrCore_dashboard_queue_viewer($_post, $_user, $_conf);
            break;

        //------------------------------
        // MODULE FUNCTION
        //------------------------------
        default:
            // Do we have a module function that lines up?
            if (isset($_urls["{$_post['_1']}"]) && isset($_post['_2'])) {
                $mod = $_urls["{$_post['_1']}"];
                $fnc = "{$mod}_dashboard_{$_post['_2']}";
                if (function_exists($fnc)) {
                    $title = $fnc($_post, $_user, $_conf);
                }
            }
            else {
                jrCore_page_not_found();
            }
            break;
    }
    jrCore_page_title($title);
    jrCore_page_display();
}
