<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: advanced_config_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_advanced_config_save($_post, $_user, $_conf)
{
    jrUser_master_only();

    // There are some keys we cannot set here
    switch ($_post['config_key']) {
        case 'jrCore_db_host':
        case 'jrCore_db_port':
        case 'jrCore_db_name':
        case 'jrCore_db_user':
        case 'jrCore_db_pass':
            jrCore_set_form_notice('error', 'Invalid config key - key can only be set manually in data/config.php');
            jrCore_form_result();
            break;
    }

    if ($_post['action'] == 'create') {
        jrCore_form_validate($_post);
        if (jrCore_add_key_to_config($_post['config_key'], $_post['config_value'])) {
            jrCore_delete_config_cache();
            jrCore_form_delete_session();
            jrCore_set_form_notice('success', 'The new config key was successfully added');
        }
        else {
            jrCore_set_form_notice('error', 'An error was encountered adding the config key');
        }
    }
    else {
        jrCore_validate_location_url();
        if (jrCore_delete_key_from_config($_post['config_key'])) {
            unset($_conf["{$_post['config_key']}"]);
            jrCore_delete_config_cache();
            jrCore_form_delete_session();
            jrCore_set_form_notice('success', 'The config key was successfully removed');
        }
        else {
            jrCore_set_form_notice('error', 'An error was encountered removing the config key');
        }
    }
    jrCore_form_result();
}
