<?php
 /**
 * Jamroom Banned Items module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 * @author Brian Johnson <brian [at] jamroom [dot] net>
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * config
 */
function jrBanned_config()
{
    // Scan Forms
    $_tmp = array(
        'name'     => 'form_scan',
        'label'    => 'enable in forms',
        'help'     => 'If this option is enabled, when a form is submitted by a non-admin user, any "name" and "title" fields in the form will be scanned for banned words.',
        'default'  => 'on',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'required' => 'on',
        'order'    => 1
    );
    jrCore_register_setting('jrBanned', $_tmp);

    // Auto Block
    $_tmp = array(
        'name'     => 'auto_block',
        'label'    => 'enable blocking',
        'help'     => 'If this option is enabled the system will automatically reject requests from Scanners and User Agent strings configured in the lists below.',
        'default'  => 'off',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'required' => 'on',
        'order'    => 2
    );
    jrCore_register_setting('jrBanned', $_tmp);

    // Log Block
    $_tmp = array(
        'name'     => 'log_block',
        'label'    => 'log blocked requests',
        'help'     => 'If this option is enabled an activity log entry will be created when a site request is blocked',
        'default'  => 'on',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'required' => 'on',
        'order'    => 3
    );
    jrCore_register_setting('jrBanned', $_tmp);

    // Log Block
    $_tmp = array(
        'name'     => 'auto_block_ban',
        'label'    => 'auto ban blocked requests',
        'help'     => 'If this option is enabled, when a site request is <b>Blocked</b>, the IP address of the user will be automatically added as a Banned User IP.<br><br><b>Note:</b> Admin users are never blocked.',
        'default'  => 'off',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'required' => 'on',
        'order'    => 4
    );
    jrCore_register_setting('jrBanned', $_tmp);

    // Auto Block Strings
    $temp = implode("\n", jrBanned_get_default_honeypot_urls());
    $_tmp = array(
        'name'     => 'auto_block_strings',
        'label'    => 'blocked URL strings',
        'help'     => 'Enter URL keywords, 1 per line, that if found in a URL will be blocked.',
        'default'  => $temp,
        'type'     => 'textarea',
        'validate' => 'false',
        'required' => 'off',
        'order'    => 5
    );
    jrCore_register_setting('jrBanned', $_tmp);

    // Auto Block Agents
    $temp = implode("\n", jrBanned_get_default_blocked_user_agent_strings());
    $_tmp = array(
        'name'     => 'auto_block_agents',
        'label'    => 'blocked user agents',
        'help'     => 'Enter strings, 1 per line, that if found in the viewing User Agent will be blocked.',
        'default'  => $temp,
        'type'     => 'textarea',
        'validate' => 'false',
        'required' => 'off',
        'order'    => 6
    );
    jrCore_register_setting('jrBanned', $_tmp);

    return true;
}
