<?php
 /**
 * Jamroom Users module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: online_status
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_online_status($_post, $_user, $_conf)
{
    // Make sure we get the correct incoming data
    if (!isset($_post['_2']) || strlen($_post['_2']) === 0) {
        if (jrUser_is_admin()) {
            return 'invalid unique_id';
        }
        return '&nbsp;';
    }
    if (!isset($_post['_3']) || !jrCore_checktype($_post['_3'], 'number_nz')) {
        $_post['_3'] = 900;
    }
    if (empty($_post['_4'])) {
        $_post['_4'] = 'default';
    }

    $_ui = array();
    foreach (explode(',', $_post['_2']) as $uid) {
        if (!jrCore_checktype($uid, 'number_nz')) {
            if (jrUser_is_admin()) {
                return 'invalid value in unique_id (2)';
            }
            return '&nbsp;';
        }
        $_ui[] = (int) $uid;
    }

    // Check for cache
    $ckey = md5(json_encode($_post));
    if (!$out = jrCore_is_cached('jrUser', $ckey)) {

        // First - get info about the specified users/profile
        switch ($_post['_1']) {

            // We've been asked to get online status for all users attached to a specific profile
            case 'profile':
                // We must get all users associated with the profile
                $tbl = jrCore_db_table_name('jrProfile', 'profile_link');
                $req = "SELECT user_id FROM {$tbl} WHERE profile_id IN(" . implode(',', $_ui) . ')';
                $_us = jrCore_db_query($req, 'user_id');
                if ($_us && is_array($_us)) {
                    $_sr = array(
                        'search'                       => array(
                            "_item_id in " . implode(',', array_keys($_us))
                        ),
                        'include_jrProfile_keys'       => true,
                        'exclude_jrProfile_quota_keys' => true,
                        'ignore_pending'               => true,
                        'quota_check'                  => false,
                        'limit'                        => count($_us)
                    );
                    $_rt = jrCore_db_search_items('jrUser', $_sr);
                }
                else {
                    // No user accounts for this profile
                    return '&nbsp;';
                }
                break;

            case 'user':
                $_sr = array(
                    'search'                       => array(
                        "_item_id in " . implode(',', $_ui)
                    ),
                    'include_jrProfile_keys'       => true,
                    'exclude_jrProfile_quota_keys' => true,
                    'ignore_pending'               => true,
                    'quota_check'                  => false,
                    'limit'                        => count($_ui)
                );
                $_rt = jrCore_db_search_items('jrUser', $_sr);
                break;

            default:
                return 'invalid online type';
        }

        // Now see if these users are online
        if (!$_rt || !isset($_rt['_items']) || !is_array($_rt['_items'])) {
            return '';
        }

        $_us = array();
        foreach ($_rt['_items'] as $v) {
            $_us[] = $v['_user_id'];
        }

        // See if users are online
        $_st = jrUser_session_online_user_ids($_post['_3'], $_us);
        if ($_st && is_array($_st)) {
            foreach ($_rt['_items'] as $k => $v) {
                if (isset($_st["{$v['_user_id']}"])) {
                    $_rt['_items'][$k]['user_is_online'] = 1;
                }
                else {
                    $_rt['_items'][$k]['user_is_online'] = 0;
                }
            }
        }
        // See what we are doing for a template
        if ($_post['_4'] == 'default') {
            $tpl = 'online_status_row.tpl';
            $mod = 'jrUser';
        }
        elseif (jrCore_checktype($_post['_4'], 'md5')) {
            $cdr = jrCore_get_module_cache_dir($_conf['jrCore_active_skin']);
            $tpl = "{$cdr}/{$_post['_4']}.tpl";
            $mod = null;
        }
        else {
            $tpl = $_post['_4'];
            $mod = null;
        }
        $out = jrCore_parse_template($tpl, $_rt, $mod);

        // Logged out users will see our online list updated
        // ever 60 seconds - logged in users every 15
        $sec = 60;
        if (jrUser_is_logged_in()) {
            $sec = 15;
        }
        // Save to cache
        jrCore_add_to_cache('jrUser', $ckey, $out, $sec);

    }
    return $out;
}
