<?php
 /**
 * Jamroom Users module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: activate
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_activate($_post, $_user, $_conf)
{
    global $_user;
    // Bring in user and language
    ignore_user_abort();
    jrUser_load_lang_strings();

    if (!isset($_post['_1']) || !jrCore_checktype($_post['_1'], 'md5')) {
        jrCore_notice_page('error', 38, false, false, false);
    }

    $url = false;
    if (isset($_post['r']) && strlen($_post['r']) > 0) {
        if ($url = jrCore_get_memory_url($_post['r'])) {
            jrCore_delete_memory_url($_post['r']);
        }
    }

    // Make sure account has been created
    $_rt = jrCore_db_get_item_by_key('jrUser', 'user_validate', $_post['_1'], true, true);
    if (!$_rt || !is_array($_rt)) {
        jrCore_notice_page('error', 38, false, false, false);
    }
    // Make sure this account has not already been validated
    if ($_rt['user_validated'] != '0') {
        jrCore_set_form_notice('success', 56);
        jrCore_location("{$_conf['jrCore_base_url']}/{$_post['module_url']}/login");
    }

    // Make sure account is not blocked
    if (isset($_rt['user_blocked']) && $_rt['user_blocked'] == 1) {
        jrCore_set_form_notice('error', 49);
        jrCore_form_result();
    }

    // Update user account so it is active
    $_data = array(
        'user_last_login' => 'UNIX_TIMESTAMP()',
        'user_active'     => '1',
        'user_validated'  => '1'
    );
    jrCore_db_update_item('jrUser', $_rt['_user_id'], $_data);

    // Reload user data
    $_rt = jrUser_get_user_session_data($_rt['_user_id']);
    $_rt = jrCore_trigger_event('jrUser', 'signup_activated', $_rt);
    jrCore_logger('INF', "user: {$_rt['user_email']} has validated their account and logged in");

    // Reset this user's cache
    jrUser_reset_cache($_rt['_user_id']);

    // Startup session with user info
    $_SESSION = $_rt;
    $_user    = $_SESSION;
    unset($_rt);
    $_SESSION['is_logged_in'] = true;

    // Save home profile keys
    jrUser_save_profile_home_keys();

    // Login Success Trigger - other modules can add to our User Info
    $_user = jrCore_trigger_event('jrUser', 'login_success', $_user);

    if (jrUser_is_master() && jrCore_db_get_datastore_item_count('jrUser') === 1) {
        // This will only happen on the FIRST account in the system
        jrCore_notice_page('success', 39, "{$_conf['jrCore_base_url']}/core/system_check", 'Continue to System Check', false);
    }

    // If signup_page set in quota, redirect as appropriate
    if (!$url && isset($_user['quota_jrUser_signup_page'])) {
        $_ln = jrUser_load_lang_strings();
        $spg = strtolower(trim($_user['quota_jrUser_signup_page']));
        if ($spg == 'index') {
            jrCore_notice_page('success', 39, $_conf['jrCore_base_url'], $_ln['jrCore'][87], false);
        }
        elseif ($spg == 'profile') {
            jrCore_notice_page('success', 39, "{$_conf['jrCore_base_url']}/{$_user['profile_url']}", $_ln['jrCore'][87], false);
        }
        elseif (jrCore_checktype($spg, 'url')) {
            jrCore_notice_page('success', 39, $spg, $_ln['jrCore'][87], false);
        }
    }

    // Show them success
    if ($url && jrCore_is_local_url($url)) {
        $_ln = jrUser_load_lang_strings();
        jrCore_notice_page('success', 39, $url, $_ln['jrCore'][87], false);
    }
    // Save from a signup?
    if ($url = jrUser_get_saved_cookie_location()) {
        $_ln = jrUser_load_lang_strings();
        jrCore_notice_page('success', 39, $url, $_ln['jrCore'][87], false);
    }
    else {
        jrCore_notice_page('success', 39, "{$_conf['jrCore_base_url']}/{$_user['profile_url']}", 54, false);
    }
    return true;
}
