<?php
 /**
 * Jamroom Profiles module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: rebuild_count_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrProfile_rebuild_count_save($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_form_validate($_post);

    jrCore_logger('INF', 'profile: profile counts rebuild started for ' . $_mods["{$_post['module']}"]['module_name']);
    $pid = 0;
    $i   = 0;
    while (true) {
        $_rt = array(
            'search'          => array(
                "_profile_id > {$pid}"
            ),
            'order_by'        => array('_profile_id' => 'numerical_asc'),
            'return_keys'     => array('_profile_id'),
            'skip_all_checks' => true,
            'index_key'       => '_profile_id',
            'limit'           => 500
        );
        $_rt = jrCore_db_search_items('jrProfile', $_rt);
        if ($_rt && is_array($_rt['_items']) && count($_rt['_items']) > 0) {
            foreach ($_rt['_items'] as $_p) {
                $pid = $_p['_profile_id'];
                jrCore_db_update_profile_item_count($_post['module'], $pid);
                $i++;
            }
            jrCore_form_modal_notice('update', "successfully updated counts for " . jrCore_number_format($i) . " profiles");

            jrCore_start_timer('sleep');
            usleep(100000);  // Max 500 per second
            jrCore_stop_timer('sleep');
        }
        else {
            // No more items
            break;
        }
    }
    jrCore_logger('INF', 'profile: profile counts rebuild completed for ' . $_mods["{$_post['module']}"]['module_name']);
    jrCore_form_modal_notice('complete', 'The profile counts were successfully rebuilt');
    jrCore_form_delete_session();
    jrProfile_reset_cache();
    jrCore_exit();
}
