<?php
 /**
 * Jamroom Email Support module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: browse
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrMailer_browse($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_session_require_login();
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrMailer');
    jrCore_page_banner('Stats Browser');

    $p = 1;
    if (isset($_post['p']) && jrCore_checktype($_post['p'], 'number_nz')) {
        $p = (int) $_post['p'];
    }
    $tbl = jrCore_db_table_name('jrMailer', 'campaign');
    $req = "SELECT * FROM {$tbl} ORDER BY c_created DESC";
    $_rt = jrCore_db_paged_query($req, $p, 12);

    $dat             = array();
    $dat[1]['title'] = 'subject';
    $dat[1]['width'] = '60%';
    $dat[2]['title'] = 'sent';
    $dat[2]['width'] = '20%';
    $dat[3]['title'] = 'recipients';
    $dat[3]['width'] = '10%';
    $dat[4]['title'] = 'stats';
    $dat[4]['width'] = '5%';
    $dat[5]['title'] = 'delete';
    $dat[5]['width'] = '5%';
    jrCore_page_table_header($dat);

    if ($_rt && is_array($_rt) && isset($_rt['_items']) && is_array($_rt['_items'])) {

        foreach ($_rt['_items'] as $k => $_c) {
            $dat             = array();
            $dat[1]['title'] = $_mods["{$_c['c_module']}"]['module_name'] . ' - ' . $_c['c_title'];
            $dat[2]['title'] = jrCore_format_time($_c['c_created']);
            $dat[2]['class'] = 'center';
            $dat[3]['title'] = jrCore_number_format($_c['c_sent']);
            $dat[3]['class'] = 'center';
            $dat[4]['title'] = jrCore_page_button("r{$k}", 'view stats', "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/campaign_result/{$_c['c_id']}')");
            $dat[5]['title'] = jrCore_page_button("d{$k}", 'delete', "jrCore_confirm('', 'Delete these stats?', function() { jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/campaign_delete_save/{$_c['c_id']}') } )");
            jrCore_page_table_row($dat);
        }
        jrCore_page_table_pager($_rt);
    }
    else {
        $dat             = array();
        $dat[1]['title'] = '<p>There are no mailer stats to show</p>';
        $dat[1]['class'] = 'center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();
    jrCore_page_cancel_button("{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools");
    jrCore_page_display();
}
