<?php
 /**
 * Jamroom Image Support module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: conversion
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrImage_conversion($_post, $_user, $_conf)
{
    // Is this image done processing?
    if (!empty($_post['_1'])) {
        if ($url = jrImage_get_image_url_for_conversion_key($_post['_1'])) {
            // We have finished conversion and have created the image - redirect
            // @note: This redirect is only needed until the cache is reset
            // for the calling template.  Once the cache is reset for the calling
            // template, the correct image URL will be used in place of this redirect
            jrCore_location($url);
        }
    }
    // Fall through - show "conversion in progress" default image
    header_remove('Cache-Control');
    header_remove('Expires');
    header_remove('Pragma');
    jrCore_set_custom_header('Content-Type: image/svg+xml');
    jrCore_set_custom_header('Content-Disposition: inline; filename="conversion.svg"');
    $img = jrCore_file_get_contents(APP_DIR . "/modules/jrImage/img/conversion.svg");
    jrCore_send_response_and_detach($img);
}
