{if isset($_post.standalone)}
<!doctype html>
<html lang="en-US">
<head>
    <title>Graph</title>
    <script type="text/javascript" src="{jrCore_javascript_src}"></script>
</head>
<body>
{/if}

<input id="graph-unique-id" type="hidden" value="{$unique_id}">
<input id="graph-timezone" type="hidden" value="{$timezone}">
<input id="graph-date-format" type="hidden" value="{$tooltip_format}">
<script type="text/javascript">

    $(document).ready(function() {

        __ds = [ {$data_set} ];

        {if !empty($options)}
            __do = {$options|trim:","};
        {/if}
        jrGraph_create_modal_graph('{$unique_id}');

        {if $hoverable == 1}

            var id = $("#g{$unique_id}");

            {if isset($function)}

                id.on('plothover', {$function});

            {else}

                id.on('plothover', function (e, p, i) {
                    var xy = id.parent('td').parent('tr').prev('tr').find('#xyval');
                    var tu = '#t{$unique_id}';
                    if (i) {
                        {if isset($tooltip_format)}
                        var x = strftime('{$tooltip_format}', new Date(i.datapoint[0]));
                        {/if}
                        var y;
                        if (typeof i.datapoint[1] === 'number' && i.datapoint[1] % 1 === 0) {
                            y = i.datapoint[1];
                        }
                        else {
                            y = i.datapoint[1].toFixed({$precision});
                        }
                        if ($(xy).length === 0) {
                            $(tu).html(x +': '+ y).css({ top: i.pageY-38, left: i.pageX-30 }).show();
                        }
                        else {
                            $(xy).html(x + ': ' + y).show();
                        }
                    }
                    else {
                        if ($(xy).length === 0) {
                            $(tu).hide();
                        }
                        else {
                            $(xy).hide();
                        }
                    }
                });

            {/if}
        {/if}

    });

</script>

<div id="g{$unique_id}" class="graph-holder" style="width:{$width};height:{$height}"></div>
<div id="l{$unique_id}" class="graph-legend"></div>
<div id="t{$unique_id}" class="p5 notice graph-tooltip" style="position:absolute;display:none"></div>

{if isset($_post.standalone)}
</body>
</html>
{/if}
