<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: test_template
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_test_template($_post, $_user, $_conf)
{
    global $_mods;
    if (!isset($_post['_1']) || strlen($_post['_1']) !== 8) {
        echo "error: invalid template";
        jrCore_db_close();
        jrCore_exit(false);
    }
    $key = $_post['_1'];
    $tpl = jrCore_get_temp_value('jrCore', "{$key}_template");
    if (!$tpl) {
        echo "error: invalid template";
        jrCore_db_close();
        jrCore_exit(false);
    }

    $cdr = jrCore_get_module_cache_dir('jrCore');
    $nam = 'test_template_' . $_post['_1'] . '.tpl';
    jrCore_write_to_file("{$cdr}/{$nam}", $tpl);
    if (!is_file("{$cdr}/{$nam}")) {
        echo "error : unable to create template file for testing - check directory permissions";
        jrCore_db_close();
        jrCore_exit(false);
    }

    ini_set('display_errors', 1);
    ini_set('html_errors', 0);
    ini_set('log_errors', 0);
    jrCore_set_flag('jrCore_suppress_activity_log', 1);

    jrCore_start_timer('template');
    if (!class_exists('Smarty')) {
        require_once APP_DIR . '/modules/jrCore/contrib/smarty4/libs/Smarty.class.php';
    }

    // Set our compile dir
    $temp             = new Smarty;
    $temp->compile_id = md5(APP_DIR);
    $temp->setCompileDir(jrCore_get_module_cache_dir($_conf['jrCore_active_skin']));

    // Get plugin directories
    $_dir = array(APP_DIR . '/modules/jrCore/contrib/smarty4/libs/plugins');
    $temp->setPluginsDir($_dir);
    $temp->force_compile = true;

    $_data['page_title']  = jrCore_get_flag('jrcore_html_page_title');
    $_data['jamroom_dir'] = APP_DIR;
    $_data['jamroom_url'] = $_conf['jrCore_base_url'];
    $_data['_conf']       = $_conf;
    $_data['_post']       = $_post;
    $_data['_mods']       = $_mods;
    $_data['_user']       = $_user;
    $_data['_items']      = array();

    // Remove User and MySQL info - we don't want this to ever leak into a template
    unset($_data['_user']['user_password'], $_data['_user']['user_old_password'], $_data['_user']['user_forgot_key']);
    unset($_data['_conf']['jrCore_db_host'], $_data['_conf']['jrCore_db_user'], $_data['_conf']['jrCore_db_pass'], $_data['_conf']['jrCore_db_name'], $_data['_conf']['jrCore_db_port']);

    // We also need to load the include.php for the skin this template file belongs to
    if (isset($_post['_2']) && is_file(APP_DIR . "/skins/{$_post['_2']}/include.php")) {
        require_once APP_DIR . "/skins/{$_post['_2']}/include.php";
    }

    $temp->assign($_data);
    ob_start();
    try {
        $temp->display("{$cdr}/{$nam}");
    }
    catch (Exception $e) {
        echo "error: syntax: " . $e->getMessage();
        jrCore_stop_timer('template');
        jrCore_db_close();
        jrCore_exit(false);
    }
    jrCore_stop_timer('template');
    $html = ob_get_clean();
    jrCore_db_close();
    echo $html;
    jrCore_unlink("{$cdr}/{$nam}");
    jrCore_exit(false);
}
