<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: skin_admin
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_skin_admin($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_create_media_directory(0);
    jrUser_load_lang_strings();

    if (!isset($_post['_1'])) {
        $_post['_1'] = 'info';
    }
    if (empty($_post['skin'])) {
        $_post['skin'] = $_conf['jrCore_active_skin'];
    }
    else {
        $_mta = jrCore_skin_meta_data($_post['skin']);
        if (!$_mta || !is_array($_mta)) {
            $_post['skin'] = $_conf['jrCore_active_skin'];
        }
    }

    $admin = '';
    $title = '';
    // See if we are getting an INDEX page for this module.  The Index
    // Page will tell us what "view" for the module config they are showing.
    // This can be either a config page for the module (i.e. global settings,
    // quota settings, language, etc.) OR it can be a tool.
    // Our URL will be like:
    // http://www.site.com/core/config/global
    // http://www.site.com/core/config/quota
    // http://www.site.com/core/config/language
    // http://www.site.com/core/config/tools
    switch ($_post['_1']) {

        //------------------------------
        // GLOBAL SETTINGS
        //------------------------------
        case 'global':
            $title = 'Global Config';
            $admin = jrCore_show_global_settings('skin', $_post['skin'], $_post, $_user, $_conf);
            break;

        //------------------------------
        // STYLE
        //------------------------------
        case 'style':
            $title = 'Style';
            $admin = jrCore_show_skin_style($_post['skin'], $_post, $_user, $_conf);
            if ($_tmp = jrCore_get_flag('style_color_picker')) {
                foreach ($_tmp as $v) {
                    jrCore_create_page_element('javascript_ready_function', $v);
                }
            }
            break;

        //------------------------------
        // IMAGES
        //------------------------------
        case 'images':
            $title = 'Images';
            $admin = jrCore_show_skin_images('skin', $_post['skin'], $_post, $_user, $_conf);
            break;

        //------------------------------
        // LANGUAGE STRINGS
        //------------------------------
        case 'language':
            $title = 'Language Strings';
            $admin = jrUser_show_module_lang_strings('skin', $_post['skin'], $_post, $_user, $_conf);
            break;

        //------------------------------
        // TEMPLATES
        //------------------------------
        case 'templates':
            $title = 'Templates';
            $admin = jrCore_show_skin_templates($_post['skin'], $_post, $_user, $_conf);
            break;

        //------------------------------
        // INFO
        //------------------------------
        case 'info':
            $title = 'Info';
            $admin = jrCore_show_skin_info($_post['skin'], $_post, $_user, $_conf);
            break;
    }

    // Process view
    $_rep = array(
        'active_tab'         => 'skins',
        'admin_page_content' => $admin,
        '_skins'             => jrCore_get_acp_skins()
    );

    $_mta                     = jrCore_skin_meta_data($_post['skin']);
    $_rep['default_category'] = 'general';
    if (isset($_mta['category']) && strlen($_mta['category']) > 0) {
        $_tmp = explode(',', $_mta['category']);
        if ($_tmp[0] != $_mta['category']) {
            $_rep['default_category'] = trim(strtolower($_tmp[0]));
        }
        else {
            $_rep['default_category'] = trim(strtolower($_mta['category']));
        }
    }

    jrCore_install_new_modules();
    $html = jrCore_parse_template('admin.tpl', $_rep, 'jrCore');

    // Output
    jrCore_page_title("{$title} - {$_mta['title']}");
    jrCore_admin_menu_accordion_js($_rep['default_category']);
    jrCore_page_custom($html);
    jrCore_page_display();
}
