<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: cache_reset
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_cache_reset($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrCore');
    jrCore_page_banner('Reset Caches');

    // Form init
    $_tmp = array(
        'submit_value' => 'reset selected caches',
        'cancel'       => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools"
    );
    jrCore_form_create($_tmp);

    jrCore_page_section_header('Database Caches');

    // Reset Database Cache
    $_tmp = array(
        'name'     => 'reset_database_cache',
        'label'    => 'Database Items',
        'help'     => 'Check this box to delete cached database items',
        'type'     => 'checkbox',
        'value'    => 'on',
        'validate' => 'onoff'
    );
    jrCore_form_field_create($_tmp);

    // Language String cache
    $_tmp = array(
        'name'     => 'reset_language_cache',
        'label'    => 'Language Strings',
        'help'     => 'Check this box to delete cached language strings',
        'type'     => 'checkbox',
        'value'    => 'on',
        'validate' => 'onoff'
    );
    jrCore_form_field_create($_tmp);

    // Reset Sprite Cache
    $_tmp = array(
        'name'     => 'reset_form_cache',
        'label'    => 'Form Sessions',
        'help'     => 'Check this box to delete all active and cached form sessions - any in-progress form submissions will need to be reloaded',
        'type'     => 'checkbox',
        'value'    => 'off',
        'validate' => 'onoff'
    );
    jrCore_form_field_create($_tmp);

    // Reset APCu cache
    if (jrCore_local_cache_is_enabled() && !jrCore_is_developer_mode()) {
        $_tmp = array(
            'name'     => 'reset_local_cache',
            'label'    => 'Local Memory',
            'help'     => 'Check this box to reset the memory based local cache',
            'type'     => 'checkbox',
            'value'    => 'on',
            'validate' => 'onoff'
        );
        jrCore_form_field_create($_tmp);
    }

    // Reset Opcode Cache
    if (function_exists('opcache_reset')) {
        $_tmp = array(
            'name'     => 'reset_opcode_cache',
            'label'    => 'PHP Opcache',
            'help'     => 'Resets the PHP Opcode cache for PHP scripts.  This is normally not needed but if changes to PHP scripts are not being detected, resetting the opcache can force PHP to update.',
            'type'     => 'checkbox',
            'value'    => 'off',
            'validate' => 'onoff'
        );
        jrCore_form_field_create($_tmp);
    }

    jrCore_page_section_header('File System Caches');

    // Reset Smarty cache
    $_tmp = array(
        'name'     => 'reset_javascript_cache',
        'label'    => 'Javascript Files',
        'help'     => 'Delete the compiled Javascript files - these will be rebuilt on request',
        'type'     => 'checkbox',
        'value'    => 'on',
        'validate' => 'onoff'
    );
    jrCore_form_field_create($_tmp);

    // Reset Smarty cache
    $_tmp = array(
        'name'     => 'reset_css_cache',
        'label'    => 'CSS Files',
        'help'     => 'Delete the compiled CSS files - these will be rebuilt on request',
        'type'     => 'checkbox',
        'value'    => 'on',
        'validate' => 'onoff'
    );
    jrCore_form_field_create($_tmp);

    // Reset Sprite Cache
    $_tmp = array(
        'name'     => 'reset_sprite_cache',
        'label'    => 'Sprite Icons',
        'help'     => 'Delete the cached sprite icon images so they are rebuilt',
        'type'     => 'checkbox',
        'value'    => 'on',
        'validate' => 'onoff'
    );
    jrCore_form_field_create($_tmp);

    // Reset Smarty cache
    $_tmp = array(
        'name'     => 'reset_template_cache',
        'label'    => 'All Template Files',
        'sublabel' => '<a onclick="jrCore_toggle_config_option(\'#reset_template_cache\',\'#ff-row-reset_template_cache_file\')" style="user-select:none"><u>select individual templates</u></a>',
        'help'     => 'Delete the compiled Modile and Skin template files - these will be rebuilt as needed',
        'type'     => 'checkbox',
        'value'    => 'on',
        'validate' => 'onoff'
    );
    jrCore_form_field_create($_tmp);

    // Reset Smarty cache (individual template)
    $_tmp = array(
        'name'     => 'reset_template_cache_file',
        'label'    => 'Selected Template Files',
        'sublabel' => 'select multiple',
        'help'     => 'Delete the compiled Modile and Skin template files - these will be rebuilt as needed',
        'type'     => 'select_multiple',
        'options'  => jrCore_get_active_skin_cached_template_array(),
        'value'    => '',
        'validate' => 'not_empty'
    );
    jrCore_form_field_create($_tmp);

    $_css = array("#ff-row-reset_template_cache_file { display: none }");
    jrCore_create_page_element('css_embed', $_css);

    jrCore_page_display();
}
