<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: browser_item_update
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_browser_item_update($_post, $_user, $_conf)
{
    jrUser_admin_only();

    // See if we are an admin or master user...
    $url = jrCore_get_local_referrer();
    if (jrUser_is_master() && !strpos($url, 'dashboard')) {
        jrCore_page_include_admin_menu();
        jrCore_page_admin_tabs($_post['module']);
    }
    else {
        jrCore_page_dashboard_tabs('browser');
    }
    jrCore_page_banner('modify datastore item', "item id: {$_post['id']}");
    jrCore_get_form_notice();

    if (!isset($_post['id']) || !jrCore_checktype($_post['id'], 'number_nz')) {
        jrCore_set_form_notice('error', 'Invalid item id');
        jrCore_form_result();
    }
    $_rt = jrCore_db_get_item($_post['module'], $_post['id'], SKIP_TRIGGERS);
    if (!$_rt || !is_array($_rt)) {
        jrCore_set_form_notice('error', 'Unable to retrieve item from DataStore - please try again');
    }
    // Go through each field and show it on a form
    $_tmp = array(
        'submit_value' => 'save changes',
        'cancel'       => 'referrer'
    );
    jrCore_form_create($_tmp);

    // Item ID
    $_tmp = array(
        'name'     => 'id',
        'type'     => 'hidden',
        'value'    => $_rt['_item_id'],
        'validate' => 'number_nz'
    );
    jrCore_form_field_create($_tmp);

    $pfx = jrCore_db_get_prefix($_post['module']);
    ksort($_rt);
    foreach ($_rt as $k => $v) {
        if (strpos($k, $pfx) !== 0) {
            continue;
        }
        switch ($k) {
            case 'user_group':
            case 'user_password':
            case 'user_old_password':
                break;
            default:
                // New Form Field
                if (strlen($v) > 128 || strpos(' ' . $v, "\n")) {
                    $_tmp = array(
                        'name'  => "ds_key_{$k}",
                        'label' => '<span style="text-transform:none">' . $k . '</span>',
                        'type'  => 'textarea',
                        'value' => $v
                    );
                }
                else {
                    $_tmp = array(
                        'name'  => "ds_key_{$k}",
                        'label' => '<span style="text-transform:none">' . $k . '</span>',
                        'type'  => 'text',
                        'value' => $v
                    );
                }
                jrCore_form_field_create($_tmp);
                break;
        }
    }

    // New Field...
    $text = '<input type="text" class="form_text" id="ds_browser_new_key" name="ds_browser_new_key" value="">';
    $html = '<input type="text" class="form_text" id="ds_browser_new_value" name="ds_browser_new_value" value="">';
    $_tmp = array(
        'type'     => 'page_link_cell',
        'label'    => $text,
        'url'      => $html,
        'module'   => 'jrCore',
        'template' => 'page_link_cell.tpl'
    );
    jrCore_create_page_element('page', $_tmp);
    jrCore_page_display();
}
