<?php
 /**
 * Jamroom Blog module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: create
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrBlog_create($_post, $_user, $_conf)
{
    // Must be logged in to create a new blog
    jrUser_session_require_login();
    jrUser_check_quota_access('jrBlog');
    jrProfile_check_disk_usage();

    // Get language strings
    $_lang = jrUser_load_lang_strings();

    // Start our create form
    $_sr = array(
        "_profile_id = {$_user['user_active_profile_id']}",
    );
    $tmp = jrCore_page_banner_item_jumper('jrBlog', 'blog_title', $_sr, 'create', 'update');
    jrCore_page_banner($_lang['jrBlog'][1], $tmp);

    // Form init
    $_tmp = array(
        'submit_value' => 2,
        'cancel'       => jrCore_is_profile_referrer()
    );
    jrCore_form_create($_tmp);

    // Blog Title
    $_tmp = array(
        'name'      => 'blog_title',
        'label'     => 3,
        'help'      => 4,
        'type'      => 'text',
        'validate'  => 'printable',
        'required'  => true
    );
    jrCore_form_field_create($_tmp);

    // Blog Category
    $_tmp = array(
        'name'      => 'blog_category',
        'label'     => 5,
        'help'      => 6,
        'type'      => 'select_and_text',
        'validate'  => 'not_empty',
        'required'  => false
    );
    jrCore_form_field_create($_tmp);

    // Blog Publish Date
    $_tmp = array(
        'name'     => 'blog_publish_date',
        'label'    => 22,
        'help'     => 23,
        'type'     => 'datetime',
        'validate' => 'date',
        'required' => false
    );
    jrCore_form_field_create($_tmp);

    // Blog Text
    $_tmp = array(
        'name'      => 'blog_text',
        'label'     => 7,
        'help'      => 8,
        'type'      => 'editor',
        'validate'  => 'allowed_html',
        'required'  => true
    );
    jrCore_form_field_create($_tmp);

    // Blog Image
    $_tmp = array(
        'name'     => 'blog_image',
        'label'    => 9,
        'help'     => 10,
        'text'     => 11,
        'type'     => 'image',
        'required' => false
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
