<?php
 /**
 * Jamroom Timeline module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2012 Talldude Networks, LLC.
 * @author Brian Johnson <brian [at] jamroom [dot] net>
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * quota_config
 */
function jrAction_quota_config()
{
    // Can Post
    $_tmp = array(
        'name'     => 'can_post',
        'default'  => 'on',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'required' => 'on',
        'label'    => 'can post activity updates',
        'help'     => 'If this option is checked, the &quot;Post a new Activity Update&quot; form will appear at the top of their Activity Timeline where they can post an update.',
        'section'  => 'permissions',
        'order'    => 10
    );
    jrProfile_register_quota_setting('jrAction', $_tmp);

    // Show Add To Timeline checkbox
    $_tmp = array(
        'name'     => 'show_add',
        'default'  => 'on',
        'type'     => 'checkbox',
        'validate' => 'onoff',
        'required' => 'on',
        'label'    => 'add to timeline option',
        'help'     => 'If this option is checked, an &quot;Add To Timeline&quot; checkbox will appear in create/update forms that will allow the user to decide if they want their action added to their timeline.  If this is unchecked, then all actions will be recorded to the Timeline.',
        'section'  => 'permissions',
        'order'    => 11
    );
    jrProfile_register_quota_setting('jrAction', $_tmp);

    // Show Share To Timeline button
    $_tmp = array(
        'name'     => 'show_detail',
        'type'     => 'checkbox',
        'default'  => 'off',
        'validate' => 'onoff',
        'label'    => 'Show on Detail Pages',
        'help'     => 'If this option is checked, a &quot;Share To Timeline&quot; button will show at the bottom of Item Detail Pages for profiles in this quota.',
        'section'  => 'permissions',
        'order'    => 12
    );
    jrProfile_register_quota_setting('jrAction', $_tmp);
    return true;
}
