<?php
 /**
 * Jamroom Users module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: new_password
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrUser_new_password($_post, $_user, $_conf)
{
    // Make sure our token is valid
    if (!isset($_post['_1']) || !jrCore_checktype($_post['_1'], 'md5')) {
        jrCore_notice_page('error', 52);
    }

    // Validate Token
    $tbl = jrCore_db_table_name('jrUser', 'forgot');
    $req = "SELECT * FROM {$tbl} WHERE forgot_key = '" . jrCore_db_escape($_post['_1']) . "' LIMIT 1";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!$_rt || !is_array($_rt)) {
        jrCore_notice_page('error', 52);
    }

    // Check for maintenance mode
    if (isset($_conf['jrCore_maintenance_mode']) && $_conf['jrCore_maintenance_mode'] == 'on') {
        $_lang = jrUser_load_lang_strings();
        jrCore_set_form_notice('notice', $_lang['jrCore'][35]);
    }

    // our page banner
    jrCore_page_banner(50);

    // Form init
    $_tmp = array(
        'submit_value' => 51,
        'cancel'       => false
    );
    $tok  = jrCore_form_create($_tmp);

    // Token
    $_tmp = array(
        'name'  => 'password_token',
        'type'  => 'hidden',
        'value' => $_post['_1']
    );
    jrCore_form_field_create($_tmp);

    // Password #1
    $_tmp = array(
        'name'      => 'user_passwd1',
        'label'     => 20,
        'help'      => 21,
        'type'      => 'password',
        'error_msg' => 9,
        'validate'  => 'not_empty'
    );
    jrCore_form_field_create($_tmp);

    // Password #2
    $_tmp = array(
        'name'       => 'user_passwd2',
        'label'      => 22,
        'help'       => 23,
        'type'       => 'password',
        'error_msg'  => 9,
        'validate'   => 'not_empty',
        'onkeypress' => "if (event && event.keyCode == 13 && this.value.length > 0) { jrFormSubmit('#jrUser_new_password','{$tok}','ajax'); }"
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
