<?php
 /**
 * Jamroom 2 Factor Authentication module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: login_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrTwoFactor_login_save($_post, $_user, $_conf)
{
    global $_user;
    if (!isset($_post['factor_user_id']) || !jrCore_checktype($_post['factor_user_id'], 'number_nz')) {
        jrCore_notice_page('error', 'invalid user_id');
    }
    // This is a user coming in from clicking on the link in their email
    if (!empty($_post['factor_code'])) {
        $tfc = $_post['factor_code'];
    }
    // This is a user entering or pasting the code on the form
    else {
        jrCore_form_validate($_post);
        $tfc = '';
        foreach ($_post as $k => $v) {
            if (strpos($k, 'idx') === 0) {
                $tfc .= $v;
            }
        }
    }
    if (strlen($tfc) !== 6) {
        jrCore_set_form_notice('error', 5); // You have entered an invalid authentication code - please check your entry
        jrCore_form_result();
    }
    $cod = jrCore_db_escape($tfc);
    $uid = (int) $_post['factor_user_id'];
    $tbl = jrCore_db_table_name('jrTwoFactor', 'session');
    $req = "SELECT factor_session FROM {$tbl} WHERE factor_code = '{$cod}' AND factor_user_id = {$uid}";
    $_rt = jrCore_db_query($req, 'SINGLE');
    if (!is_array($_rt)) {
        if (!empty($_post['factor_code'])) {
            jrCore_notice_page('error', 'invalid login code');
        }
        jrCore_set_form_notice('error', 5); // You have entered an invalid authentication code - please check your entry
        jrCore_form_result();
    }

    // OK - we passed - cleanup and restart session
    $old = (time() - 14400); // 4 hours
    $req = "DELETE FROM {$tbl} WHERE (factor_code = '{$cod}' AND factor_user_id = {$uid}) OR factor_created < {$old}";
    jrCore_db_query($req);

    // Startup user session
    $_SESSION = json_decode($_rt['factor_session'], true);

    // Setup our "remember me" cookie if requested
    if (isset($_SESSION['user_remember']) && $_SESSION['user_remember'] == 'on') {
        jrUser_session_set_login_cookie($_SESSION['_user_id']);
        unset($_SESSION['user_remember']);
    }
    else {
        jrUser_session_delete_login_cookie();
    }

    jrCore_logger('INF', "successful login by {$_SESSION['user_name']}");
    jrCore_form_delete_session();

    // Re-trigger login_success trigger since we hijacked it
    $_SESSION['jrtwofactor_authenticated'] = true;
    $_user                                 = $_SESSION;
    /** @noinspection PhpUnusedLocalVariableInspection */
    $_user = jrCore_trigger_event('jrUser', 'login_success', $_user);  // DO NOT REMOVE!

    // Redirect to Profile
    jrCore_form_result(jrCore_get_base_url() . "/{$_SESSION['profile_url']}");
}
