<?php
 /**
 * Jamroom 2 Factor Authentication module
 *
 * copyright 2023 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: login
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrTwoFactor_login($_post, $_user, $_conf)
{
    // Non logged in users only
    if (jrUser_is_logged_in()) {
        // Redirect to user profile
        $url = jrCore_get_base_url() . "/{$_user['profile_url']}";
        jrCore_location($url);
    }
    // We should get the user_id as $_1
    if (!isset($_post['_1']) || !jrCore_checktype($_post['_1'], 'number_nz')) {
        jrCore_notice_page('error', 6); // invalid user_id received - please try again
    }

    // See if we get the key as $_2....
    if (isset($_post['_2']) && strlen($_post['_2']) === 6) {
        // Redirect...
        $uid = (int) $_post['_1'];
        $url = jrCore_get_base_url() . "/{$_post['module_url']}/login_save/factor_user_id={$uid}/factor_code={$_post['_2']}";
        jrCore_location($url);
    }

    $_ln = jrUser_load_lang_strings();

    jrCore_set_form_notice('notice', $_ln['jrTwoFactor'][10], false);
    jrCore_page_banner($_ln['jrTwoFactor'][11], jrCore_page_button('resend', $_ln['jrTwoFactor'][4], "jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/resend_save/{$_post['_1']}')"));

    // Form init
    $_tmp = array(
        'submit_value' => 1,
        'cancel'       => 'referrer'
    );
    jrCore_form_create($_tmp);

    // Code input
    $htm = '<div id="jrtwofactor-box">';
    $idx = 0;
    while ($idx < 6) {
        $jvs = "var o = $(this); if (event.keyCode === 8) { if (o.val().length === 0) { o.prev('input').removeAttr('readonly').trigger('focus') } } else { if (o.val().length === 1) { o.attr('readonly', 'readonly');";
        if ($idx === 5) {
            $jvs .= "$('.form_button').jrCore_disable_button();$('#jrTwoFactor_login').trigger('submit') } }";
            $htm .= '<input type="text" id="jt' . $idx . '" name="idx' . $idx . '" class="jrtwofactor-num" data-num="' . $idx . '" onkeyup="' . $jvs . '">';
        }
        else {
            $jvs .= "var v=Number(o.data('num')) + 1; $('#jt' + v).trigger('focus') } }";
            $htm .= '<input type="text" id="jt' . $idx . '" name="idx' . $idx . '" class="jrtwofactor-num" data-num="' . $idx . '" onkeydown="' . $jvs . '">';
        }
        $idx++;
    }
    jrCore_page_custom($htm);

    // Code
    /*
    $_tmp = array(
        'name'     => 'factor_code',
        'label'    => 2,
        'help'     => 3,
        'type'     => 'text',
        'required' => true,
        'min'      => 6,
        'max'      => 6,
        'validate' => 'printable'
    );
    jrCore_form_field_create($_tmp);
    */

    // User_ID
    $_tmp = array(
        'name'  => 'factor_user_id',
        'type'  => 'hidden',
        'value' => (int) $_post['_1']
    );
    jrCore_form_field_create($_tmp);

    $_js = array("$('#jt0').focus();$('html').on('paste', function(e) {
        var t = e.originalEvent.clipboardData.getData('text/plain');
        if (typeof t !== 'undefined' && t !== null && t.length === 6) {
            var i = 0, c = t.split('');
            while (i < 6) {
                $('#jt' + i).val(c[i]).attr('readonly', 'readonly');
                i++;
            }
            $('.form_button').jrCore_disable_button();
            $('#jrTwoFactor_login').trigger('submit');
        }
    })");
    jrCore_create_page_element('javascript_ready_function', $_js);

    jrCore_page_display();
}
