<?php
 /**
 * Jamroom Developer Tools module
 *
 * copyright 2024 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: clone_skin_save
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrDeveloper_clone_skin_save($_post, $_user, $_conf)
{
    jrUser_master_only();
    jrCore_form_validate($_post);

    $_rt = jrCore_get_skins();
    if (!isset($_post['skin_to_clone']) || !in_array($_post['skin_to_clone'], $_rt)) {
        jrCore_set_form_notice('error', 'You have selected an invalid Skin To Clone - please select a valid Skin To Clone from the list of available skins');
        jrCore_form_result();
    }
    if (isset($_post['skin_name']) && in_array($_post['skin_name'], $_rt)) {
        jrCore_set_form_notice('error', 'The Directory Name you have entered already exists');
        jrCore_form_result();
    }

    // If we have a developer Prefix - must start with Prefix
    if (!empty($_conf['jrDeveloper_developer_prefix'])) {
        if (strpos($_post['skin_name'], $_conf['jrDeveloper_developer_prefix']) !== 0) {
            jrCore_form_field_hilight('skin_name');
            jrCore_set_form_notice('error', 'Invalid Directory Name - directory must begin with your developer prefix: ' . $_conf['jrDeveloper_developer_prefix']);
            jrCore_form_result();
        }
    }

    // New Skin name must start with letter
    if (!preg_match('/^[a-z]/i', trim($_post['skin_name']))) {
        jrCore_form_field_hilight('skin_name');
        jrCore_set_form_notice('error', 'Invalid Directory Name - must begin with a letter');
        jrCore_form_result();
    }

    $_post['skin_name'] = trim($_post['skin_name']);

    // clone the skin
    $_rp = array(
        $_post['skin_to_clone']                        => $_post['skin_name'],
        strtolower($_post['skin_to_clone'])            => strtolower($_post['skin_name']),
        strtoupper($_post['skin_to_clone'])            => strtoupper($_post['skin_name']),
        substr($_post['skin_to_clone'], 2)             => substr($_post['skin_name'], 2),
        strtolower(substr($_post['skin_to_clone'], 2)) => strtolower(substr($_post['skin_name'], 2)),
        strtoupper(substr($_post['skin_to_clone'], 2)) => strtoupper(substr($_post['skin_name'], 2)),
    );

    // Bring in include
    if (is_file(APP_DIR . "/skins/{$_post['skin_to_clone']}/include.php")) {
        require_once APP_DIR . "/skins/{$_post['skin_to_clone']}/include.php";
    }

    // skin title
    $func = $_post['skin_to_clone'] . '_skin_meta';
    if (function_exists($func)) {
        $_orig = $func();
        if (isset($_orig['title'])) {
            $_rp[$_orig['title']] = trim($_post['skin_title']);
        }
    }

    $res = jrCore_copy_dir_recursive(APP_DIR . "/skins/{$_post['skin_to_clone']}", APP_DIR . "/skins/{$_post['skin_name']}", $_rp);
    if (!$res) {
        jrCore_set_form_notice('error', "An error was encountered trying to copy the skin directory - check Error Log");
    }
    else {

        // Bring in include
        if (is_file(APP_DIR . "/skins/{$_post['skin_name']}/include.php")) {
            require_once APP_DIR . "/skins/{$_post['skin_name']}/include.php";
        }

        // Load config
        if (is_file(APP_DIR . "/skins/{$_post['skin_name']}/config.php")) {
            require_once APP_DIR . "/skins/{$_post['skin_name']}/config.php";
            $func = "{$_post['skin_name']}_skin_config";
            if (function_exists($func)) {
                $func();
            }
        }

        // remove old entries (if any)
        $new = jrCore_db_escape($_post['skin_name']);
        $tbl = jrCore_db_table_name('jrCore', 'template');
        $req = "DELETE FROM {$tbl} WHERE template_module = '{$new}'";
        jrCore_db_query($req);

        // copy template alterations over to new skin
        $skin = jrCore_db_escape($_post['skin_to_clone']);
        $req  = "SELECT * FROM {$tbl} WHERE template_module = '{$skin}'";
        $_rt  = jrCore_db_query($req, 'NUMERIC');
        // Overwrite templates with our custom templates
        if ($_rt && is_array($_rt)) {
            foreach ($_rt as $_row) {
                if ($_row['template_active'] == '1') {
                    jrCore_write_to_file(APP_DIR . "/skins/{$_post['skin_name']}/{$_row['template_name']}", strtr($_row['template_body'], $_rp));
                }
                else {
                    // Load it into the DB but make it INACTIVE
                    $usr = jrCore_db_escape($_row['template_user']);
                    $nam = jrCore_db_escape($_row['template_name']);
                    $typ = jrCore_db_escape($_row['template_type']);
                    $bod = jrCore_db_escape(strtr($_row['template_body'], $_rp));
                    $req = "INSERT INTO {$tbl} (template_module,template_created,template_updated,template_user,template_active,template_name,template_type,template_body)
                            VALUES ('{$new}','{$_row['template_created']}','{$_row['template_updated']}','{$usr}','0','{$nam}','{$typ}','{$bod}')
                            ON DUPLICATE KEY UPDATE template_created = '{$_row['template_created']}', template_updated = '{$_row['template_updated']}', template_user = '{$usr}', template_active = '0', template_type = '{$typ}', template_body = '{$bod}'";
                    $cnt = jrCore_db_query($req, 'COUNT');
                    if ($cnt === 0) {
                        jrCore_logger('MAJ', "developer: unable to copy inactive custom template: {$_row['template_name']} from {$_post['skin_to_clone']} to {$_post['skin_name']}");
                    }
                }
            }
        }

        // copy settings
        $tbl = jrCore_db_table_name('jrCore', 'setting');
        $req = "SELECT * FROM {$tbl} WHERE `module` = '{$skin}'";
        $_rt = jrCore_db_query($req, 'NUMERIC');
        if ($_rt && is_array($_rt)) {

            // remove old entries (if they exist)
            $req = "DELETE FROM {$tbl} WHERE `module` = '{$new}'";
            jrCore_db_query($req);

            $tim = time();
            foreach ($_rt as $_row) {
                $_inf = array();
                foreach ($_row as $name => $value) {
                    $_inf["`{$name}`"] = jrCore_db_escape(str_replace($_post['skin_to_clone'], $_post['skin_name'], $value));
                }
                $_inf['`created`'] = $tim;
                $_inf['`updated`'] = $tim;
                $req               = "INSERT INTO {$tbl} (" . implode(',', array_keys($_inf)) . ") VALUES ('" . implode("','", $_inf) . "')";
                jrCore_db_query($req);
            }
        }

        // copy any image over-rides over to the new skin
        $_im = array();
        if (!empty($_conf["jrCore_{$_post['skin_to_clone']}_custom_images"])) {
            $_im = json_decode($_conf["jrCore_{$_post['skin_to_clone']}_custom_images"], true);
        }
        if (is_array($_im)) {
            $media_dir = jrCore_get_media_directory(0, FORCE_LOCAL);
            foreach ($_im as $source_file => $junk) {
                copy("{$media_dir}/{$_post['skin_to_clone']}_{$source_file}", APP_DIR . "/skins/{$_post['skin_name']}/img/{$source_file}");
            }
        }

        // copy custom CSS
        $tbl = jrCore_db_table_name('jrCore', 'skin');
        $req = "DELETE FROM {$tbl} WHERE skin_directory = '{$new}'";
        jrCore_db_query($req);

        $req = "SELECT * FROM {$tbl} WHERE skin_directory = '{$skin}'";
        $_rt = jrCore_db_query($req, 'SINGLE');
        if ($_rt && is_array($_rt)) {
            $_cl = array();
            foreach ($_rt as $k => $v) {
                $_cl[$k] = jrCore_db_escape($v);
            }
            $_cl['skin_directory']   = jrCore_db_escape($_post['skin_name']);
            $_cl['skin_cloned_from'] = $_post['skin_to_clone'];
            $req                     = "INSERT INTO {$tbl} (" . implode(',', array_keys($_cl)) . ") VALUES ('" . implode("','", $_cl) . "')";
            jrCore_db_query($req);
        }

        // Install lang strings
        $tbl = jrCore_db_table_name('jrUser', 'language');
        $req = "SELECT * FROM {$tbl} WHERE lang_module = '{$skin}'";
        $_rt = jrCore_db_query($req, 'NUMERIC');
        if ($_rt && is_array($_rt)) {
            $req = "INSERT INTO {$tbl} (lang_module,lang_code,lang_charset,lang_ltr,lang_key,lang_text,lang_default) VALUES\n";
            foreach ($_rt as $_ln) {
                $cod = jrCore_db_escape($_ln['lang_code']);
                $ltr = jrCore_db_escape($_ln['lang_ltr']);
                $key = jrCore_db_escape($_ln['lang_key']);
                $str = jrCore_db_escape($_ln['lang_text']);
                $def = jrCore_db_escape($_ln['lang_default']);
                $req .= "('{$new}','{$cod}','utf-8','{$ltr}','" . jrCore_db_escape($key) . "','" . jrCore_db_escape($str) . "','" . jrCore_db_escape($def) . "'),";
            }
            $req = substr($req, 0, strlen($req) - 1);
            $cnt = jrCore_db_query($req, 'COUNT');
            if ($cnt === 0) {
                jrUser_install_lang_strings('skin', $_post['skin_name']);
            }
        }

        jrCore_create_master_css($_post['skin_name']);
        jrCore_create_master_javascript($_post['skin_name']);

        jrCore_form_delete_session();
        jrCore_set_form_notice('success', "The {$_post['skin_name']} skin has been cloned from the {$_post['skin_to_clone']} skin");
        $url = jrCore_get_module_url('jrCore');
        jrCore_form_result("{$_conf['jrCore_base_url']}/{$url}/skin_admin/info/skin={$_post['skin_name']}");
    }
    jrCore_form_result();
}
