<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: item_action_button_modify
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_item_action_button_modify($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_validate_location_url();

    if (!isset($_post['t']) || strlen($_post['t']) === 0) {
        jrCore_set_form_notice('error', 'Invalid button type');
        jrCore_location('referrer');
    }
    $type = '';
    switch ($_post['t']) {
        case 'index':
        case 'list':
        case 'detail':
            $type = $_post['t'];
            break;
        default:
            jrCore_set_form_notice('error', 'Invalid button type');
            jrCore_location('referrer');
            break;
    }
    if (!isset($_post['m']) || !jrCore_module_is_active($_post['m'])) {
        jrCore_set_form_notice('error', 'invalid module');
        jrCore_location('referrer');
    }
    $mod = $_post['m'];
    if (!isset($_post['o']) || !jrCore_checktype($_post['o'], 'number_nn')) {
        jrCore_set_form_notice('error', 'invalid button offset');
        jrCore_location('referrer');
    }
    $idx = (int) $_post['o'];

    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrCore');
    jrCore_page_banner("modify item {$type} button");
    jrCore_get_form_notice();

    // See if we have customized this button
    $opt = "{$mod}_item_{$type}_buttons";
    if (isset($_conf[$opt])) {
        $_rs = json_decode($_conf[$opt], true);
        if (is_array($_rs)) {
            $_dn = array();
            foreach ($_rs as $_ab) {
                $_dn["{$_ab['function']}"] = 1;
            }
            // We need to go through and see if any new action buttons have been added
            $_rf = jrCore_get_registered_module_features('jrCore', "item_{$type}_button");
            if ($_rf && is_array($_rf)) {
                foreach ($_rf as $bmod => $_ft) {
                    foreach ($_ft as $func => $_inf) {
                        if (!isset($_dn[$func])) {
                            $_inf['module']   = $bmod;
                            $_inf['function'] = $func;
                            $_rs[]            = $_inf;
                        }
                    }
                }
            }
        }
    }
    else {
        // Get our existing (default) order
        $_rs = array();
        $_rf = jrCore_get_registered_module_features('jrCore', "item_{$type}_button");
        if ($_rf && is_array($_rf)) {
            foreach ($_rf as $bmod => $_ft) {
                foreach ($_ft as $func => $_inf) {
                    $_inf['module']   = $bmod;
                    $_inf['function'] = $func;
                    $_rs[]            = $_inf;
                }
            }
        }
        else {
            jrCore_set_form_notice('error', "no registered {$type} buttons found");
            jrCore_location('referrer');
        }
        if (!isset($_rs[$idx])) {
            jrCore_set_form_notice('error', "invalid button offset");
            jrCore_location('referrer');
        }
    }

    // See if they are active for this view
    foreach ($_rs as $k => $_inf) {
        if (isset($_inf['function'])) {
            $func = $_inf['function'];
            if (function_exists($func)) {
                if (!$func($mod, false, false, false, true)) {
                    unset($_rs[$k]);
                }
            }
        }
    }
    $_rs = array_values($_rs);
    $_rt = $_rs[$idx];

    $dat             = array();
    $dat[1]['title'] = 'icon';
    $dat[1]['width'] = '2%';
    $dat[2]['title'] = 'provider';
    $dat[2]['width'] = '49%';
    $dat[3]['title'] = 'button name';
    $dat[3]['width'] = '49%';
    jrCore_page_table_header($dat);

    $dat             = array();
    $dat[1]['title'] = (isset($_rt['icon'])) ? jrCore_get_icon_html($_rt['icon']) : '';
    $dat[2]['title'] = $_mods["{$_rt['module']}"]['module_name'];
    $dat[2]['class'] = 'center';
    $dat[3]['title'] = $_rt['title'];
    $dat[3]['class'] = 'center';
    jrCore_page_table_row($dat);
    jrCore_page_table_footer();

    // Form init
    $_tmp = array(
        'submit_value' => 'save changes',
        'cancel'       => 'referrer',
        'values'       => $_rt
    );
    jrCore_form_create($_tmp);

    // module
    $_tmp = array(
        'name'  => 'm',
        'type'  => 'hidden',
        'value' => $mod
    );
    jrCore_form_field_create($_tmp);

    // type
    $_tmp = array(
        'name'  => 't',
        'type'  => 'hidden',
        'value' => $type
    );
    jrCore_form_field_create($_tmp);

    // offset
    $_tmp = array(
        'name'  => 'o',
        'type'  => 'hidden',
        'value' => $idx
    );
    jrCore_form_field_create($_tmp);

    $_tmp = array(
        'name'     => 'active',
        'label'    => 'active',
        'help'     => 'Uncheck this option to disable this button from showing up in this location',
        'type'     => 'checkbox',
        'default'  => 'on',
        'validate' => 'onoff',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    $_opt = array(
        '0'       => '(no group restrictions)',
        'owner'   => 'profile owners',
        'master'  => 'master admins',
        'admin'   => 'profile admins',
        'power'   => 'power users',
        'multi'   => 'multi profile users',
        'user'    => 'logged in users',
        'visitor' => 'logged out users'
    );
    $_tmp = array(
        'name'     => 'group',
        'label'    => 'group',
        'sublabel' => '(required)',
        'help'     => 'Select the group you would like this button to visible to',
        'type'     => 'select',
        'options'  => $_opt,
        'validate' => 'core_string',
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    $_tmp = array(
        'name'     => 'quota',
        'label'    => 'quotas',
        'sublabel' => '(optional)',
        'help'     => 'Select the group you would like this button to visible to',
        'type'     => 'optionlist',
        'options'  => 'jrProfile_get_quotas',
        'default'  => '',
        'validate' => 'number_nz',
        'required' => false
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
