<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
* @copyright 2021 Talldude Networks, LLC.
*/

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: delete_file
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_delete_file($_post, $_user, $_conf)
{
    // Upload progress
    jrUser_session_require_login();
    if (empty($_post['upload_token']) || !jrCore_checktype($_post['upload_token'], 'md5')) {
        jrCore_json_response(array('error' => 'invalid upload_token'));
    }
    if (empty($_post['upload_name'])) {
        jrCore_json_response(array('error' => 'invalid upload_name'));
    }
    if ($_up = jrCore_get_uploaded_meter_files($_post['upload_token'])) {

        // S3
        // [uploads/2d052bacb7ea3883e134aa6a7f77204b/000_user_image::Screenshot_20210224103233.jpg::145866::jpg] => Array(
        //     [saved] =>
        //     [field] => user_image
        //     [name] => Screenshot_20210224103233.jpg
        //     [size] => 145866
        //     [extension] => jpg
        // )
        // Local
        // [user_image] => Array(
        //     [tmp_name] => /Users/brian/Web/Master/data/cache/jrCore/c2524bc39239e9ed33a881df87a05040/000_user_image
        //     [name] => IMG_2885.JPG
        //     [size] => 205658
        //     [type] => image/jpeg
        //     [error] => 0
        // )

        // find the right file
        foreach ($_up as $k => $_d) {
            $pfx  = str_pad($_post['file_order'], 3, '0', STR_PAD_LEFT);
            $file = false;
            // Check for local file
            if (!empty($_d['tmp_name']) && strpos($_d['tmp_name'], "/{$pfx}_")) {
                $file = $k;
            }
            // Check for S3
            elseif (strpos($k, "/{$pfx}_")) {
                $file = $_d['field'];
            }
            if ($file) {
                if (jrCore_delete_uploaded_file($_up, $file)) {
                    jrCore_json_response(array('success' => 'the file was deleted successfully'));
                }
            }
        }
    }
    jrCore_json_response(array('error' => 'an error was encountered deleting the uploaded file - please try again'));
}
