<?php
 /**
 * Jamroom System Core module
 *
 * copyright 2025 The Jamroom Network
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0.  Please see the included "license.html" file.
 *
 * This module may include works that are not developed by
 * The Jamroom Network
 * and are used under license - any licenses are included and
 * can be found in the "contrib" directory within this module.
 *
 * Jamroom may use modules and skins that are licensed by third party
 * developers, and licensed under a different license  - please
 * reference the individual module or skin license that is included
 * with your installation.
 *
 * This software is provided "as is" and any express or implied
 * warranties, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose are
 * disclaimed.  In no event shall the Jamroom Network be liable for
 * any direct, indirect, incidental, special, exemplary or
 * consequential damages (including but not limited to, procurement
 * of substitute goods or services; loss of use, data or profits;
 * or business interruption) however caused and on any theory of
 * liability, whether in contract, strict liability, or tort
 * (including negligence or otherwise) arising from the use of this
 * software, even if advised of the possibility of such damage.
 * Some jurisdictions may not allow disclaimers of implied warranties
 * and certain statements in the above disclaimer may not apply to
 * you as regards implied warranties; the other terms and conditions
 * remain enforceable notwithstanding. In some jurisdictions it is
 * not permitted to limit liability and therefore such limitations
 * may not apply to you.
 *
 * @copyright 2021 Talldude Networks, LLC.
 */

// make sure we are not being called directly
defined('APP_DIR') or exit();

/**
 * view: advanced_config
 * @param array $_post Posted Data
 * @param array $_user Viewing User data
 * @param array $_conf Global Config
 */
function view_jrCore_advanced_config($_post, $_user, $_conf)
{
    global $_mods;
    jrUser_master_only();
    jrCore_page_include_admin_menu();
    jrCore_page_admin_tabs('jrCore');
    jrCore_page_banner('Advanced Config Keys');
    jrCore_get_form_notice();

    $dat             = array();
    $dat[1]['title'] = 'config key';
    $dat[1]['width'] = '38%';
    $dat[2]['title'] = 'value';
    $dat[2]['width'] = '58%';
    $dat[3]['title'] = 'delete';
    $dat[3]['width'] = '4%';
    jrCore_page_table_header($dat);

    // Get existing advanced config keys
    $done = false;
    $_rep = array('$_conf', '[', ']', ';');
    $_tmp = file(APP_DIR . "/data/config/config.php");
    natcasesort($_tmp);
    foreach ($_tmp as $line) {
        if (!strpos($line, '=')) {
            continue;
        }
        list($k, $v) = explode('=', $line, 2);
        $k = trim(trim(str_replace($_rep, '', $k)), "'");
        $v = trim(trim(str_replace($_rep, '', $v)), "'");
        $v = trim($v, '"');
        if (empty($k) || strpos(' ' . $k, 'jrCore_db_') || $k == 'jrCore_base_url') {
            continue;
        }
        $dat             = array();
        $dat[1]['title'] = $k;
        $dat[2]['title'] = $v;
        $dat[3]['title'] = jrCore_page_button("ac-delete-{$k}", "delete", "jrCore_confirm('Delete this Config Key?', 'Are you sure you want to delete this config key?', function() { jrCore_window_location('{$_conf['jrCore_base_url']}/{$_post['module_url']}/advanced_config_save/action=delete/config_key={$k}') })");
        jrCore_page_table_row($dat);
        $done = true;
    }
    if (!$done) {
        $dat             = array();
        $dat[1]['title'] = 'No Advanced Config keys have been created yet';
        $dat[1]['class'] = 'p20 center';
        jrCore_page_table_row($dat);
    }
    jrCore_page_table_footer();

    // Bring in advanced config keys for modules
    foreach ($_mods as $mod => $_info) {
        if (is_file(APP_DIR . "/modules/{$mod}/config.php")) {
            require_once APP_DIR . "/modules/{$mod}/config.php";
        }
        $func = "{$mod}_advanced_config";
        if (function_exists($func)) {
            $func();
        }
    }

    // Add new Advanced Config Keys
    jrCore_page_section_header('Add a new Advanced Config Key');
    jrCore_page_notice('error', '<b>WARNING!</b> Advanced Config Keys should only be used if you are sure you need them!<br>You can render your site unusable by entering an invalid value here, so be careful!', false);

    // Form init
    $_tmp = array(
        'submit_value'     => 'create new config key',
        'cancel'           => "{$_conf['jrCore_base_url']}/{$_post['module_url']}/admin/tools",
        'form_ajax_submit' => false
    );
    jrCore_form_create($_tmp);

    $_tmp = array(
        'name'  => 'action',
        'type'  => 'hidden',
        'value' => 'create'
    );
    jrCore_form_field_create($_tmp);

    // Config key
    $_opts    = array();
    $_help    = array();
    $_advkeys = jrCore_get_flag('jrCore_defined_advanced_keys');
    foreach ($_advkeys as $module => $_keys) {
        foreach ($_keys as $key => $_v) {
            $_opts["{$module}_{$key}"] = "{$module}_{$key}";
            $default                   = (isset($_v['default']) && strlen($_v['default']) > 0) ? $_v['default'] : 'not set';
            $_help["{$module}_{$key}"] = "<b>{$module}_{$key}</b><br>{$_v['help']}<br>default: {$default}<br><br>";
        }
    }
    ksort($_opts);
    $help = 'Select the Config key that will be added or removed from the config.php file<br><br>';
    foreach ($_opts as $v) {
        $help .= $_help[$v];
    }
    $_tmp = array(
        'name'     => 'config_key',
        'label'    => 'config key',
        'help'     => $help,
        'type'     => 'select',
        'options'  => $_opts,
        'required' => true
    );
    jrCore_form_field_create($_tmp);

    // Config value
    $_tmp = array(
        'name'     => 'config_value',
        'label'    => 'config value',
        'help'     => 'Enter the value that will be used for this config key - see help for the Config Key for details on what value to use here.',
        'type'     => 'text',
        'validate' => 'printable',
        'required' => false
    );
    jrCore_form_field_create($_tmp);
    jrCore_page_display();
}
