<?php
class manageCookies {

	private static $_encodeFlg = true;
	private static $_extende = false;
	private static $_cookiePrx = "wp_iwp_";

	/*
	** Set the cookie
	*/
	public static function cookieSet($cName, $cValue, $extra=array()) {
		$defalutParms = array(
			'expire'	=>	time()+60*60*24*5,
			'path'		=>	'',
			'domain'	=>	'',
			'secure'	=>	false,
			'httponly'	=>	false
		);
		$parms = array_merge($defalutParms,$extra);
		@extract($parms);
		if($cValue != "") {
			if(self::$_encodeFlg) {
				$cValue = base64_encode(serialize($cValue));
			}
			$cValue = urlencode($cValue);
		}
		$cName = self::$_cookiePrx.$cName;
                $_COOKIE[$cName] = $cValue;
		@setcookie ( $cName ,$cValue ,$expire ,$path ,$domain ,$secure ,$httponly);
	}

	/*
	** get the cookie
	*/
	public static function cookieGet($cName,$encodeflg = true, $extende = false) {
		$tempCName = self::$_cookiePrx.$cName;
                if(isset($_COOKIE[$tempCName]) && (!empty($_COOKIE[$tempCName]))) {
                    $cValue = $_COOKIE[$tempCName];
                    $cValue = urldecode($cValue);
                    if(self::$_encodeFlg && $encodeflg) {
                            $cValue = unserialize(base64_decode($cValue));
                    }
                    if(self::$_extende || $extende) {
                            self::cookieSet ( $cName , $cValue );
                    }
                    return $cValue;
                } else {
                    return '';
                }
	}

	/*
	** cookie unset
	*/
	public static function cookieUnset($cName) {
		if(is_array($cName)) {
			foreach($cName as $cData) {
                                $_COOKIE[$cData] = '';
				self::cookieset($cData,'',array('expire'=>time()-3600));
			}
		} else {
                        $_COOKIE[$cName] = '';
			self::cookieset($cName,'',array('expire'=>time()-3600));
		}
	}
        
        /*
	** All cookie unset 
	*/
	public static function cookieAllUnset() {
            if (!empty($_COOKIE)) {
                $cNames = array();
                foreach ($_COOKIE as $cName=>$cData) {
                    $cName = str_replace(self::$_cookiePrx, '', $cName);
                    array_push($cNames, $cName);
                }
                if(count($cNames)>0) {
                    self::cookieUnset($cNames);
                }

                /*  
                issue : v3 log out issue. issue happen <= 3.1.14.2 
                scenarios : need to login v2 panel then open v3 panel . then logout v3 panel after logout directly hit /v3 it should be automatically logged in code explanation : we handle APP_DOMAIN_PATH_V2 both main domain and subfolder case
                sample APP_DOMAIN_PATH_V2 URL : ragupathi.rxforge.in/iwp-admin/
                */
                if(defined('APP_V3') && defined('APP_DOMAIN_PATH_V2')){
					$path = '/';
					$app_domain_path = parse_url("https://".APP_DOMAIN_PATH_V2);
					if(!empty($app_domain_path['path'])){
						$path = '/'.trim($app_domain_path['path'], '/');
					}
					self::cookieV2Allset($cNames,array('path'=>$path));
                }
            }
	}

	public static function cookieV2Allset($cNames, $extra=array()){
		if(is_array($cNames)) {
			$defalutParms = array(
				'expire'	=>	time()-3600,
				'path'		=>	''
			);
			$parms = array_merge($defalutParms,$extra);
			foreach($cNames as $cData) {
				self::cookieset($cData,'',$parms);
			}
		}
	}
}