<?php
/************************************************************
 * InfiniteWP Admin panel									*
 * Copyright (c) 2012 Revmakx								*
 * www.revmakx.com											*
 *															*
 ************************************************************/

class panelRequestManagerV3 extends panelRequestManager{

	public static function getGroupsSitesV3(){
		$groups = $groupsSites = $result = array();
		
		$where = " ";
		$where2 = "1";
		$where3 = array(
	      		'query' =>  "GS.groupID =  :groupID ".$where." ORDER BY G.name",
	      		'params' => array(
	               ':groupID'=>'G.groupID'
   				)
			);
		$groupsSites = DB::getArray("?:groups_sites GS, ?:groups G", "GS.siteID, GS.groupID", $where3);
		$groups = DB::getArray("?:groups", "groupID, name", $where2." ORDER BY name", "groupID");
		foreach($groupsSites as $groupSites){
			$siteData = getSiteData($groupSites['siteID']);
			if (empty($siteData)) {
				continue;
			}else{
				$groups[ $groupSites['groupID'] ]['siteIDs'][] = $groupSites['siteID'];
				$groups[ $groupSites['groupID']]['sites'][$groupSites['siteID']]['ID'] = $groupSites['siteID'];
				$groups[ $groupSites['groupID']]['sites'][$groupSites['siteID']]['name'] = $siteData['name'];
			}
		}
		foreach($groups as $groupKey => $group){
			$where = array(
				'query' =>  "groupID =  :groupID ",
					'params' => array(
					':groupID'=>$group['groupID']
					)
			);
			$groupSites = DB::getArray("?:groups_sites", "siteID", $where);
			if ((empty($group['siteIDs'])) && !empty($groupSites)) {
				unset($groups[$groupKey]);
			}
		}
		return $groups;
	}

	public static function getSitesUpdatesV3($userID = '', $doCache = true, $siteIDs = array()){
		$userID = $GLOBALS['userID'];
		$siteView = $pluginView = $themeView = $coreView = $translationsView = $reloadStats = array();
		$sitesStats = self::getRawSitesStats($siteIDs, $userID, $doCache);
		$updateAvailableSiteIDS = array_keys($sitesStats);
		if(!empty($updateAvailableSiteIDS)){
				$siteIDs = DB::esc($updateAvailableSiteIDS);
				$where = array(
			      		'query' =>  "H.historyID = HAD.historyID AND H.type = ':type' AND H.status not IN('completed', 'error', 'netError') AND H.siteID IN ('". implode("','", $siteIDs) ."')",
			      		'params' => array(
			               ':type'=>'PTC',
				   		   ':action'=> 'update',
						)
					);
				$fields = "H.siteID,H.historyID,H.type,HAD.uniqueName";
				$updateRunningDetails = DB::getArray("?:history H, ?:history_additional_data HAD",$fields,$where);
		}
		$wooDBUpdateCount = 0;
		foreach($sitesStats as $siteID){
			if (!empty($siteID['stats']['additional_updates'])) {
				foreach ($siteID['stats']['additional_updates'] as $item) {
					$wooDBUpdateCount++;
				}
			}

			if (!empty($siteID['lastUpdatedTime'])) {
				$reloadStats[$siteID['siteID']] = ($siteID['lastUpdatedTime'] > 0) ? @date('M d @ h:ia', $siteID['lastUpdatedTime']) : '';
			}

			$siteID['stats']['upgradable_plugins'] = (array)$siteID['stats']['upgradable_plugins'];
			foreach($siteID['stats']['upgradable_plugins'] as $item){			
				$temp = objectToArray($item);
				if(!is_array($temp))
				$temp=array();
				
				$isHiddenItem = false;
				$where = array(
		      		'query' =>  "URL = ':URL' AND siteID = ':siteID'",
		      		'params' => array(
		               ':URL'=>$temp['file'],
		               ':siteID'=>$siteID['siteID']
	   				)
				);
				$ignoredUpdates = DB::getField("?:hide_list", "URL", $where); 
				if($ignoredUpdates){ 
					$pluginView['hiddenItem'] = true;
				} else {
					$pluginView['hiddenItem'] = false;
				}
				$pluginView['isUpdating'] = self::findRunningUpdate($updateRunningDetails,$siteID['siteID'],$temp['file']);
				$pluginView['siteID'] = $siteID['siteID'];
				$pluginView['type'] = 'plugins';
				$pluginView['name'] = $temp['name'];
				$pluginView['new_version'] = $temp['new_version'];
				$pluginView['old_version'] = $temp['old_version'];
				$pluginView['slug'] = $temp['slug'];
				$pluginView['URI'] = $temp['file'];
				$pluginView['isActivated'] = 'no';
				if (!empty($siteID['stats']['plugins_status'])) {
					if (!empty($siteID['stats']['plugins_status'][$temp['file']])) {
						if (!empty($siteID['stats']['plugins_status'][$temp['file']])) {
							$pluginView['isActivated'] = $siteID['stats']['plugins_status'][$temp['file']]['isActivated'];
						}
					}
				}
				$pluginView['change_log'] = WP_PLUGIN_CHANGELOG_URL. $temp['slug'].'/#developers';
				array_push($siteView, $pluginView);
			}
			
			$siteID['stats']['upgradable_translations'] = (array)$siteID['stats']['upgradable_translations'];
			foreach($siteID['stats']['upgradable_translations'] as $item){			
				$temp = objectToArray($item);
				if(!is_array($temp))
				$temp=array();
				
				$isHiddenItem = false;
				$where = array(
		      		'query' =>  "type = ':type' AND siteID = ':siteID'",
		      		'params' => array(
		               ':type'=>'translations',
		               ':siteID'=>$siteID['siteID']
	   				)
				);
				$ignoredUpdates = DB::getField("?:hide_list", "ID", $where);
				if($ignoredUpdates){ 
					$translationsView['hiddenItem'] = true;
				} else {
					$translationsView['hiddenItem'] = false;
				}
				$translationsView['isUpdating'] = self::findRunningUpdate($updateRunningDetails,$siteID['siteID'],'translations');
				$translationsView['siteID'] = $siteID['siteID'];
				$translationsView['type'] = 'translations';
				$translationsView['name'] = 'Translation';
				$translationsView['URI'] = true;
				array_push($siteView, $translationsView);
			}

			$siteID['stats']['upgradable_themes'] = (array)$siteID['stats']['upgradable_themes'];
			foreach($siteID['stats']['upgradable_themes'] as $item){
				$isHiddenItem = false;
				$where = array(
			      		'query' =>  "URL = ':URL' AND siteID = ':siteID'",
			      		'params' => array(
			               ':URL'=>$item['theme_tmp'],
			               ':siteID'=>$siteID['siteID']
		   				)
					);
				$ignoredUpdates = DB::getField("?:hide_list", "URL", $where); 
				if($ignoredUpdates){ 
					$themeView['hiddenItem'] = true;
				} else {
					$themeView['hiddenItem'] = false;
				}
				$themeView['isUpdating'] = self::findRunningUpdate($updateRunningDetails,$siteID['siteID'],$item['theme_tmp']);
				$themeView['siteID'] = $siteID['siteID'];
				$themeView['type'] = 'themes';
				$themeView['name'] = $item['name'];
				$themeView['URI'] = $item['theme_tmp'];
				$themeView['slug'] = $item['theme_tmp'];
				$themeView['new_version'] = $item['new_version'];
				$themeView['old_version'] = $item['old_version'];
				$themeView['isActivated'] = 'no';
				if (!empty($siteID['stats']['themes_status'])) {
					if (!empty($siteID['stats']['themes_status']['active'])) {
						foreach ($siteID['stats']['themes_status']['active'] as $theme) {
							if ($themeView['slug'] == $theme['path']) {
								$themeView['isActivated'] = true;
								break;
							}
						}
					}
					if ($themeView['isActivated'] === 'no') {
						if (!empty($siteID['stats']['themes_status']['inactive'])) {
							foreach ($siteID['stats']['themes_status']['inactive'] as $theme) {
								if ($themeView['slug'] == $theme['path']) {
									$themeView['isActivated'] = false;
									break;
								}
							}
						}
					}
				}
				array_push($siteView, $themeView);
							
			}
			
			if(!empty($siteID['stats']['core_updates'])){
				
				$item = $siteID['stats']['core_updates'];
				$temp = objectToArray($item);
				if(!is_array($temp))
				$temp=array();
				$isHiddenItem = false;
				$where = array(
			      		'query' =>  "URL = ':URL' AND siteID = ':siteID'",
			      		'params' => array(
			               ':URL'=>$temp['current'],
			               ':siteID'=>$siteID['siteID']
		   				)
					);
				$ignoredUpdates = DB::getField("?:hide_list", "URL", $where); 
				if($ignoredUpdates){ 
					$coreView['hiddenItem'] = true;
				} else {
					$coreView['hiddenItem'] = false;
				}
				
				$wordpress_locale_pckg = '';
				if (!empty($siteID['stats']['wordpress_locale_pckg'])) {
					$wordpress_locale_pckg = ' ('.$siteID['stats']['wordpress_locale_pckg'].')';
				}
				$coreView['isUpdating'] = self::findRunningUpdate($updateRunningDetails,$siteID['siteID'],'core');
				$coreView['siteID'] = $siteID['siteID'];
				$coreView['type'] = 'core';
				$coreView['name'] = $temp['current'].$wordpress_locale_pckg;
				$coreView['new_version'] = $temp['current'];
				$coreView['old_version'] = $temp['current_version'];
				$coreView['URI'] = $temp['current'];
				$coreView['change_log'] = WP_CHANGELOG_URL. 'Version-'.$temp['current'].'/';
				array_push($siteView, $coreView);
			}	
		}
		$updatePageEmailCronReqNotification = self::updatePageEmailCronReqNotification(count($siteView));
		$lastReloadTime = DB::getField("?:site_stats SS, ?:sites S", "SS.lastUpdatedTime", "S.type = 'normal' AND S.siteID = SS.siteID ORDER BY SS.lastUpdatedTime LIMIT 1");
		$lastReloadTime = ($lastReloadTime > 0) ? @date('M d @ h:ia', $lastReloadTime) : '';
		setHook('updateViewsV3', $siteView);
		$updateViews = array('updates' => $siteView, 'lastReloadTime' => $lastReloadTime, 'reloadStats'=> $reloadStats,'wooDBUpdateCount' =>$wooDBUpdateCount, 'updatePageEmailCronReqNotification' => $updatePageEmailCronReqNotification);
		setHook('updateStatusV3', $updateViews);
		return $updateViews;
	}
	
	public static function findRunningUpdate($updateRunningDetails,$siteID, $uniqueName){
		if(!empty($updateRunningDetails)){
			foreach ($updateRunningDetails as $key => $value) {
				if($value['siteID'] == $siteID && $value['uniqueName'] == $uniqueName){
					return true;
				}
			}
		}
		return false;
	}
	public static function getSitesV3(){

		$sitesData = array();

		if(function_exists('multiUserGetSites')){
			multiUserGetSites($sitesData);
		}
		else{
			$sitesData = DB::getArray("?:sites", "siteID, URL, adminURL, name, IP, WPVersion, adminUsername, isOpenSSLActive, network, parent, httpAuth, callOpt, connectURL, connectionStatus, links, notes, favicon, lastFaviconUpdate, stagingFtpDetails, ftpDetails,multisiteID, customBranding, siteTechinicalInfo ", "type = 'normal' ORDER BY name", "siteID");
		}

		if (empty($sitesData)) {
			return array();
		}
		$groupsSites = DB::getArray("?:groups_sites", "*", "1");
		if(!empty($groupsSites)){
			foreach($groupsSites as $groupSite){
				if(!empty($sitesData[$groupSite['siteID']])){
					$sitesData[$groupSite['siteID']]['groupIDs'][] = $groupSite['groupID'];
				}
			}
		}
		if(is_array($sitesData)){
			foreach($sitesData as $siteID => $siteData){
				if(!empty($siteData['httpAuth'])){
					$sitesData[$siteID]['httpAuth'] = @unserialize($siteData['httpAuth']);
				}
				if(!empty($siteData['callOpt'])){
					$sitesData[$siteID]['callOpt'] = @unserialize($siteData['callOpt']);
				}if(!empty($siteData['links'])){
					$sitesData[$siteID]['links'] = explode(",",$siteData['links']);
				} if ($siteData['favicon'] == 'default' || $siteData['favicon'] == '' || $siteData['favicon'] == NULL ) {
					$sitesData[$siteID]['favicon'] = 'images/custom_wp_favicon.ico';
				}
				if(!empty($siteData['stagingFtpDetails'])){
					$stagingFtpDetails = @unserialize($siteData['stagingFtpDetails']);
					if (!empty($stagingFtpDetails)) {
						$stagingType = key($stagingFtpDetails);
						$stagingFtpDetails[$stagingType]['humanReadTime'] = @date(Reg::get('dateFormatLong'), $stagingFtpDetails[$stagingType]['createdTime']);
						$sitesData[$siteID]['stagingFtpDetails'] = $stagingFtpDetails;
						if (function_exists('stagingGetStagingSiteID') && stagingGetStagingSiteID($siteID)) {
							$sitesData[$siteID]['isStaging'] = 1;
						}
						if(function_exists('stagingGetStagingBaseSiteInfo')){
							$sitesData[$siteID]['stagingSiteInfo'] = stagingGetStagingBaseSiteInfo($siteID);
						}
					}
				}
				if(!empty($siteData['ftpDetails'])){
					$sitesData[$siteID]['ftpDetails'] = @unserialize($siteData['ftpDetails']);
				}
				if(!empty($siteData['customBranding'])){
					$sitesData[$siteID]['customBranding'] = @unserialize($siteData['customBranding']);
				}
				if(!empty($siteData['siteTechinicalInfo'])){
					$server = unserialize($siteData['siteTechinicalInfo']);
					if (!empty($server['serverInfo']) && !empty($server['serverInfo']['http_server_software'])) {
						$server_software = strtolower($server['serverInfo']['http_server_software']['status']);
						if(strpos($server_software, 'litespeed') !== false){
							$sitesData[$siteID]['isLiteSpeedServer'] = true;
						}
						
					}
				}
			}
		}
		setHook('getSitesV3', $sitesData);
		return $sitesData;
	}

	public static function getPluginsViewUpdatesContentV3($data = array()){
		$sitesStats = manageUpdates::getPaginatedSitesStats($data, 'plugin');
		return $sitesStats;
	}

	public static function getPluginsRowDetailedUpdatesV3($data){
		$where = array(
			      		'query' =>  "updateInfo LIKE '%,:itemID-P,%'",
			      		'params' => array(
			               ':itemID'=>$data['itemID']
							)
					);
		$siteIDs = DB::getFields('?:site_stats', 'siteID', $where);
		if(empty($pluginStats)){
			$sitesStats  = panelRequestManager::getSitesUpdates('','', $siteIDs);
			$pluginStats = $sitesStats['pluginsView']['plugins'];
		}
		foreach ($pluginStats as $key => $value) {
			if ($key != $data['key']) {
				unset($pluginStats[$key]);
			}else {
				foreach ($value as $siteID => $item) {
					if (!empty($item['hiddenItem'])) {
						unset($pluginStats[$key][$siteID]);
					}
				}
			}
		}
		return $pluginStats;
	}

	public static function getThemesViewUpdatesContentV3($data = array()){
		$sitesStats = manageUpdates::getPaginatedSitesStats($data, 'theme');
		return $sitesStats;
	}

	public static function getThemesRowDetailedUpdatesV3($data){
		$where = array(
			      		'query' =>  "updateInfo LIKE '%,:itemID-P,%'",
			      		'params' => array(
			               ':itemID'=>$data['itemID']
							)
					);
		$siteIDs = DB::getFields('?:site_stats', 'siteID', $where);
		if(empty($themesStats)){
			$sitesStats  = panelRequestManager::getSitesUpdates('','', $siteIDs);
			$themesStats = $sitesStats['themesView']['themes'];
		}
		
		foreach ($themesStats as $key => $value) {
			
			if ($key != $data['key']) {
				unset($themesStats[$key]);
			}else {
				foreach ($value as $siteID => $item) {
					if (!empty($item['hiddenItem'])) {
						unset($themesStats[$key][$siteID]);
					}
				}
			}
		}
	
		return $themesStats;
	}

	public static function getWPViewUpdatesContentV3($data = array()){
		$sitesStats = manageUpdates::getPaginatedSitesStats($data, 'core');
		return $sitesStats;
	}

	public static function getCoreRowDetailedUpdatesv3($data){
		$where = array(
			      		'query' =>  "updateInfo LIKE '%,:itemID-P,%'",
			      		'params' => array(
			               ':itemID'=>$data['itemID']
							)
					);
		$siteIDs = DB::getFields('?:site_stats', 'siteID', $where);
		if(empty($coreStats)){
			$sitesStats  = panelRequestManager::getSitesUpdates('','', $siteIDs);
			$coreStats = $sitesStats['coreView']['core'];
		}
		
		foreach ($coreStats as $key => $value) {
			if (version_compare($key, $data['key'],'!=')) {
				unset($coreStats[$key]);
			}else {
				foreach ($value as $siteID => $item) {
					if (!empty($item['hiddenItem'])) {
						unset($coreStats[$key][$siteID]);
					}
				}
			}
		}
		
		return $coreStats;
	}

	public static function getPluginsAndThemesV3(){
		$pluginsAndThemes = $tempStack = $plugins_status = $activeThemesStatus = array();
		$sitesStats = panelRequestManager::getRawSitesStats();
		foreach ($sitesStats as $siteID => $data) {
			$plugins_status = (array)$data['stats']['plugins_status'];
			foreach ($plugins_status as $pKey => $plugin) {
				if ($pKey == 'iwp-client/init.php') {
					continue;
				}
				$tempStack ['siteID'] = (string)$siteID;
				$tempStack ['type'] = 'plugins';
				$tempStack ['isActivated'] = $plugin['isActivated'];
				$tempStack ['name'] = $plugin['name'];
				$tempStack ['URI'] = $pKey;
				$tempStack ['old_version'] = $plugin['version'];

				array_push($pluginsAndThemes, $tempStack);
			}

			$activeThemesStatus = (array)$data['stats']['themes_status']['active'];
			$inactiveThemesStatus = (array)$data['stats']['themes_status']['inactive'];
			foreach ($activeThemesStatus as $tKey => $theme) {
				$tempStack ['siteID'] = (string)$siteID;
				$tempStack ['type'] = 'themes';
				$tempStack ['isActivated'] = true;
				$tempStack ['name'] = $theme['name'];
				$tempStack ['URI'] = $theme['stylesheet'];
				$tempStack ['old_version'] = $theme['version'];

				array_push($pluginsAndThemes, $tempStack);
			}

			foreach ($inactiveThemesStatus as $tKey => $theme) {
				$tempStack ['siteID'] = (string)$siteID;
				$tempStack ['type'] = 'themes';
				$tempStack ['isActivated'] = false;
				$tempStack ['name'] = $theme['name'];
				$tempStack ['URI'] = $theme['stylesheet'];
				$tempStack ['old_version'] = $theme['version'];

				array_push($pluginsAndThemes, $tempStack);
			}


		}
		return $pluginsAndThemes;
	}

	public static function getWPRepositoryHTMLV3($params){
		
		$searchVar = $params['searchVar'];
		$searchItem = $params['searchItem'];
		$type = $params['type'];
		if($type =='plugins')
		{
			$action='query_plugins';
			$URL= 'http://api.wordpress.org/plugins/info/1.0/';
		}
		if($type=='themes')
		{
			$action='query_themes';
			$URL= 'http://api.wordpress.org/themes/info/1.0/';
		}
		$args = (object)[];
		//$args->search= 'WP ecommerce';
		if($searchVar==1)
		$args->search=$searchItem;
		else
		$args->browse=$searchItem;
		$args->per_page=30;
		$args->page=1;
		$args->fields['downloadlink'] = true;
		$Array['action']=$action;
		$Array['request']=serialize($args);
		
	
		$return = unserialize(repoDoCall($URL,$Array));
		
		return $return->{$params['type']};
	}

	public static function addHideV3($params){
		if(empty($params)){
			 return false; 
		}
		foreach($params as $siteID => $data){	
			foreach ($data as $key => $value) {
				DB::insert("?:hide_list", array('type' => $value['type'], 'siteID' => $siteID, 'name' => $value['name'], 'URL' => $value['path']));
				$where = array(
		      		'query' =>  "siteID=':siteID'",
		      		'params' => array(
		               ':siteID'=>$siteID
						)
				);	
				$sitesStats = DB::getRow('?:site_stats', '*',$where);
				$where2 = array(
		      		'query' =>  "URL=':URL'",
		      		'params' => array(
		               ':URL'=>$value['path']
						)
				);
				$updateInfo = DB::getRow('?:update_stats', '*',$where2);
				if ($value['type'] == 'plugins') {
					(int)$sitesStats['updatePluginCounts'] -= 1;
					$updateInfo['updatePresentCount'] -= 1;
					$sitesStats['updateInfo'] = str_replace(','.$updateInfo['ID'].'-P', '', $sitesStats['updateInfo']);
				} elseif ($value['type'] == 'themes') {
					$sitesStats['updateThemeCounts'] -= 1;
					$updateInfo['updatePresentCount']-= 1;
					$sitesStats['updateInfo'] = str_replace(','.$updateInfo['ID'].'-T', '', $sitesStats['updateInfo']);
				} elseif ($value['type'] == 'core') {
					$sitesStats['isCoreUpdateAvailable'] -= 1;
					$updateInfo['updatePresentCount'] -= 1;
					$sitesStats['updateInfo'] = str_replace(','.$updateInfo['ID'].'-C', '', $sitesStats['updateInfo']);
				} elseif ($value['type'] == 'translations') {
					$sitesStats['isTranslationUpdateAvailable'] -= 1;
					$updateInfo['updatePresentCount'] -= 1;
					$sitesStats['updateInfo'] = str_replace(','.$updateInfo['ID'].'-R', '', $sitesStats['updateInfo']);
				}
				DB::update('?:site_stats', $sitesStats, $where);
				DB::update('?:update_stats', $updateInfo, $where2);
			}
		}
	}

	public static function removeHideV3($params){
		if(empty($params)){
			 return false; 
		}
		$updateType = array('plugins' => 'plugin', 'themes' => 'theme', 'core' => 'core', 'translations'=>'translation' );		
		foreach($params as $siteID => $data){
			foreach ($data as $key => $value) {
				$where = array(
		          'query' => "type = ':type' AND siteID = ':siteID' AND URL  = ':URL' ",
		          'params' => array(
		               ':type'=>$value['type'],
		               ':siteID'=>$siteID,
		               ':URL'=>$value['path']

		           )
		        );
		        $where2 = array(
		      		'query' =>  "URL=':URL'",
		      		'params' => array(
		               ':URL'=>$value['path']
						)
				);
				$name = DB::getField('?:hide_list','name',$where2);
				$isDone = DB::delete("?:hide_list", $where);
				$where = array(
		      		'query' =>  "siteID=':siteID'",
		      		'params' => array(
		               ':siteID'=>$siteID
						)
				);	
				$sitesStats = DB::getRow('?:site_stats', '*',$where);
				
				if (!DB::getExists('?:update_stats','ID', $where2)) {
					$ID  = DB::insert('?:update_stats', array('type' =>$updateType[$value['type']], 'URL'=>$value['path'],'name'=>$name, 'updatePresentCount'=>0));
					$updateInfo['updatePresentCount'] = 0;
					$updateInfo['ID'] = $ID;
				}else{
					$updateInfo = DB::getRow('?:update_stats', '*',$where2);
				}
				if ($value['type'] == 'plugins') {
					(int)$sitesStats['updatePluginCounts'] += 1;
					$updateInfo['updatePresentCount'] += 1;
					$sitesStats['updateInfo'] = $sitesStats['updateInfo'].$updateInfo['ID'].'-P,';
				} elseif ($value['type'] == 'themes') {
					$sitesStats['updateThemeCounts'] += 1;
					$updateInfo['updatePresentCount']+= 1;
					$sitesStats['updateInfo'] = $sitesStats['updateInfo'].$updateInfo['ID'].'-T,';
				} elseif ($value['type'] == 'core') {
					$sitesStats['isCoreUpdateAvailable'] += 1;
					$updateInfo['updatePresentCount'] += 1;
					$sitesStats['updateInfo'] = $sitesStats['updateInfo'].$updateInfo['ID'].'-C,';
				} elseif ($value['type'] == 'translations') {
					$sitesStats['isTranslationUpdateAvailable'] += 1;
					$updateInfo['updatePresentCount'] += 1;
					$sitesStats['updateInfo'] = $sitesStats['updateInfo'].$updateInfo['ID'].'-R,';
				}

				DB::update('?:site_stats', $sitesStats, $where);
				 DB::update('?:update_stats', $updateInfo, $where2);
			}
		}
		return $isDone;
	}

	public static function getFavouritesPluginsAndThemesV3(){
		 $favourites = $favouriteGroups = $groups = array();
		
		$favourites = DB::getArray("?:favourites", "*", 1);
		$favouritesGroupMap = DB::getArray("?:favourites_groups_map", "*", 1);
		$groups = DB::getArray("?:favourite_groups", "*", 1);
		if (!empty($groups)) {
			foreach ($favourites as $fKey => $fValue) {
				$groupID = array();
				foreach ($favouritesGroupMap as $mKey => $mValue) {
					if ($fValue['ID'] == $mValue['favouriteID']) {
						$groupID[] = $mValue['groupID'];
					}
				}
				$favouriteGroups[$fKey] = $fValue;
				$favouriteGroups[$fKey]['groups'] = $groupID;
			}		
		}else{
			$favouriteGroups = $favourites;
		}
		return array('items' =>$favouriteGroups, 'groups' => $groups);
	}

	public static function getSitesBackupsV3(){
		$sitesStats = panelRequestManager::getRawSitesStats(array(), '', false);
		
		$sitesBackups = array();
		$isVue = 1;
		foreach($sitesStats as $siteID => $siteStats){
			if (isChildSite($siteID)) {
				$parentSiteID = getParentSiteID($siteID);
				if ($parentSiteID == false) {
					continue;
				}else{
					$parentSiteStats = self::getRawSitesStats(array($parentSiteID), '', false);
					$siteStats = $parentSiteStats[$parentSiteID];
				}
			}else{
				$parentSiteID = false;
			}
			if (empty($siteStats['stats']) || (empty($siteStats['stats']['iwp_backups']) && empty($siteStats['stats']['iwp_new_backups']))) {
				continue;
			}

			$backupKeys = !empty($siteStats['stats']['iwp_backups'])?@array_keys($siteStats['stats']['iwp_backups']): array();
			if (!empty($siteStats['stats']['iwp_new_backups'])) {
				$backupNewKeys = @array_keys($siteStats['stats']['iwp_new_backups']);
				$backupKeys = @array_merge($backupKeys, $backupNewKeys);
			}
			$totalCount = 0;
			if(!empty($backupKeys) && is_array($backupKeys)){	
			foreach($backupKeys as $key => $backupKey){
				$refrenceCounter = 0;
				$backupTaskType = 'backupNow';
				$backupType = 'manual';
				if($backupKey != 'Backup Now'){
					$where = array(
				      		'query' =>  "BS.scheduleKey = ':backupKey' AND BSL.siteID=':siteID' AND BS.scheduleID = :scheduleID",
				      		'params' => array(
				               ':backupKey'=>$backupKey,
				               ':siteID'=>$siteID,
				               ':scheduleID'=>'BSL.scheduleID'
			   				)
						);
					$siteExist = DB::getExists("?:backup_schedules_link BSL, ?:backup_schedules BS", "siteID", $where);
					if($siteExist){ 
						continue;
						// if ($isVue) {
						// 	$backupType = 'schedule';
						// 	$backupTaskType = DB::getField("?:backup_schedules_link BSL, ?:backup_schedules BS", "BS.backupName", $where);
						// }else{
						// 	continue;
						// }
					}else{
						$backupType = 'others';
						$backupTaskType = 'otherBackup';
					}	
					if ($parentSiteID != false) {
						$backupType = 'parent';
						$backupTaskType = 'otherBackup';
					}else{
						$backupType = 'others';
						$backupTaskType = 'parentBackup';
					}			
				}
				
				if(empty($siteStats['stats']['iwp_backups'][$backupKey])) { 
					if (empty($siteStats['stats']['iwp_new_backups'][$backupKey])) {
						continue;
					}
				 }
				if (!empty($siteStats['stats']['iwp_new_backups'])) {
					$siteBackupsTemp = $siteStats['stats']['iwp_new_backups'][$backupKey];
					if (!empty($siteBackupsTemp)) {
						$siteBackups[$siteID] = array();
						foreach ($siteBackupsTemp as $referenceKey => $siteBackupTemp) {
							$otherParts = '';
							$newBackupMethod = true;
							$backupURLs = false;
							$size = 0;
							if ($siteBackupTemp['service'][0] == 'ftp') {
								$otherParts = 'ftp';
								$repo = "FTP";
							}
							if ($siteBackupTemp['service'][0] == 's3') {
								$otherParts = 's3';
								$repo = "Amazon S3";
							}
							if ($siteBackupTemp['service'][0] == 'dropbox') {
								$otherParts = 'dropbox';
								$repo = "Dropbox";
							}
							if ($siteBackupTemp['service'][0] == 'googledrive') {
								$otherParts = 'googledrive';
								$repo = "G Drive";
							}
							if ($siteBackupTemp['service'][0] == 'sftp') {
								$otherParts = 'sftp';
								$repo = "SFTP";
							}
							if ($siteBackupTemp['service'][0] == 'none') {
								$otherParts = 'sftp';
								$repo = "Server";
								$backupContentURL = $siteBackupTemp['wp_content_url'].'/infinitewp/backups/';
								$backupURLs = getBackupURL($siteBackupTemp);
								foreach ($backupURLs as $k => $v) {
									$backupURLs[$k] = $backupContentURL.$v;
								}
								$backupURLs['backup_file_basename'] = $siteBackupTemp['wp_content_url'].'/infinitewp/backups/'.$siteBackupTemp['backup_file_basename'];
							}
							$fileURLParts = '';
							if (!empty($siteBackupTemp['plugins']) && !empty($siteBackupTemp['db'])) {
								$what = 'full';
								$size+= getSizeOfBackup($siteBackupTemp['plugins'], 'plugins', $siteBackupTemp);
								$size+= getSizeOfBackup($siteBackupTemp['themes'], 'themes', $siteBackupTemp);
								$size+= getSizeOfBackup($siteBackupTemp['uploads'], 'uploads', $siteBackupTemp);
								$size+= getSizeOfBackup($siteBackupTemp['more'], 'more', $siteBackupTemp);
								$size+= getSizeOfBackup($siteBackupTemp['others'], 'others', $siteBackupTemp);
								$size+= $siteBackupTemp['db-size'];
								
							}elseif (!empty($siteBackupTemp['db']) && empty($siteBackupTemp['plugins'])) {
								$what = 'db';
								$size = $siteBackupTemp['db-size'];
							}else{
								$what = 'files';
								$size+= getSizeOfBackup($siteBackupTemp['plugins'], 'plugins', $siteBackupTemp);
								$size+= getSizeOfBackup($siteBackupTemp['themes'], 'themes', $siteBackupTemp);
								$size+= getSizeOfBackup($siteBackupTemp['uploads'], 'uploads', $siteBackupTemp);
								$size+= getSizeOfBackup($siteBackupTemp['more'], 'more', $siteBackupTemp);
								$size+= getSizeOfBackup($siteBackupTemp['others'], 'others', $siteBackupTemp);
							}
							if (round($size / (1024*1024), 2) > 1) {
							    $size = round($size / (1024*1024), 2) . " MB";//Modified by IWP //Mb => MB
							} elseif(round($size / (1024), 2)>1) {
							    $size = round($size / (1024), 2) . ' KB';//Modified by IWP //Kb => KB
							}else{
								$size =  $size .' B';
							}
							$backupFileBasename = $siteBackupTemp['wp_content_path'].'/infinitewp/backups/'.$siteBackupTemp['backup_file_basename'];

							if (empty($siteBackupTemp['backup_name'])) {
								$siteBackupTemp['backup_name'] = $siteBackupTemp['label'];
							}
							if ($isVue) {
								$timeStamp = @date(Reg::get('dateFormatLong'), $referenceKey);
							}else{
								$timeStamp = $referenceKey;
							}
							if (empty($sitesBackups[$siteID]['backups'][$backupType][$backupTaskType][$refrenceCounter])) {
								$totalCount++;
								$sitesBackups[$siteID]['totalCount'] = $totalCount;
							}
							$sitesBackups[$siteID]['backups'][$backupType][$backupTaskType][$refrenceCounter] = array('backupName' 	=> $siteBackupTemp['label'],
																								'sitesCount'	=> $totalCount,
																								'backupFileBasename'	=> $backupFileBasename,
																								'what'			=> $what,
																								'backupNameDisplay' 	=> $siteBackupTemp['backup_name'],
																								'time' 			=> $timeStamp,
																								'downloadURL' 	=> $backupURLs,
																								'size' 			=> $size,
																								'referenceKey' 	=> $referenceKey,
																								'newBackupMethod' 	=> $newBackupMethod,
																								'siteID' 		=> $siteID,
																								'repository' 		=> $repo,
																								'task_name' 		=> $backupKey,
																								'method'        =>'Phoenix',
																								'parentSiteID'  => $parentSiteID,
																								'repo' 			=> $repo);
							$refrenceCounter++;
						}
					}

				}

				if (!empty($siteStats['stats']['iwp_backups']) && $parentSiteID == false){
				
					$siteBackupsTemp = $siteStats['stats']['iwp_backups'][$backupKey];
					$siteBackups[$siteID] = array();
					if (!empty($siteBackupsTemp)){ 
						@krsort( $siteBackupsTemp );
						foreach($siteBackupsTemp as $referenceKey => $siteBackupTemp){
							if(!empty($siteBackupTemp['error']) || isFailedbackup($siteBackupTemp) === true){ continue; }
							
							$otherParts = '';
															
							if(empty($siteBackupTemp['server']['file_url']) && !empty($siteBackupTemp['ftp'])){
								$otherParts = $siteBackupTemp['ftp'];
							}
							if(empty($siteBackupTemp['server']['file_url']) && !empty($siteBackupTemp['amazons3'])){
								$otherParts = $siteBackupTemp['amazons3'];
							}
							if(empty($siteBackupTemp['server']['file_url']) && !empty($siteBackupTemp['dropbox'])){
								$otherParts = $siteBackupTemp['dropbox'];
							}
							if(empty($siteBackupTemp['server']['file_url']) && !empty($siteBackupTemp['gDriveOrgFileName'])){
								$otherParts = $siteBackupTemp['gDriveOrgFileName'];
							}
							if((is_array($siteBackupTemp['server']['file_url']))||(is_array($otherParts)))
							{
								$fileURLParts = explode('/', $siteBackupTemp['server']['file_url'][0] ? $siteBackupTemp['server']['file_url'][0] : $otherParts[0]);
							}
							else
							{
								$fileURLParts = explode('/', $siteBackupTemp['server']['file_url'] ? $siteBackupTemp['server']['file_url'] : $otherParts);
							}
							$fileName = array_pop($fileURLParts);
							$fileNameParts = explode('_', $fileName);
							$what = $fileNameParts[2];
							
							$repo = '';
							//only showing files which are available
							if(array_key_exists('server', $siteBackupTemp))
							{
								$repo = "Server";
							}
							if(array_key_exists('ftp', $siteBackupTemp))
							{
								$repo = "FTP";
							}
							if(array_key_exists('amazons3', $siteBackupTemp))
							{
								$repo = "Amazon S3";
							}
							if(array_key_exists('dropbox', $siteBackupTemp))
							{
								$repo = "Dropbox";
							}
							if(array_key_exists('gDriveOrgFileName', $siteBackupTemp))
							{
								$repo = "G Drive";
							}
							if(array_key_exists('sftp', $siteBackupTemp)){
								$repo = "SFTP";
							}	

							if ($isVue) {
								$timeStamp = @date(Reg::get('dateFormatLong'), $siteBackupTemp['time']);
							}else{
								$timeStamp = $siteBackupTemp['time'];
							}
										
							if (empty($sitesBackups[$siteID]['backups'][$backupType][$backupTaskType][$refrenceCounter])) {
								$totalCount++;
								$sitesBackups[$siteID]['totalCount'] = $totalCount;
							}		
							$sitesBackups[$siteID]['backups'][$backupType][$backupTaskType][$refrenceCounter] = array('time' => $timeStamp,
																		  'type' => 'backupNow',
																		  'downloadURL' => $siteBackupTemp['server']['file_url'],
																		  'size' => $siteBackupTemp['size'],
																		  'what' => $what,
																		  'referenceKey' => $referenceKey,
																		  'backupName' => $backupKey,
																		  'backupNameDisplay' => $siteBackupTemp['backup_name'],
																		  'siteID' => $siteID,
																		  'repository' => $repo,
																		  'repo' => $repo,
																		  'backupTaskType' => $backupTaskType,
																		  'task_name' 		=> $backupKey,
																		  'method'         => $siteBackupTemp['mechanism'],
																		  'data' => array('scheduleKey' => $backupKey));
							$refrenceCounter++;
						}
					}
				}
		}
			}
		}
		$finalResponse = array();
		if (!empty($sitesBackups)) {
			foreach ($sitesBackups as $siteKey => $details) {
				if (!empty($details['backups']['manual'])) {
					$finalResponse[$siteKey]['backups']['manual'] = $details['backups']['manual'];
				}
				// if (!empty($details['backups']['schedule'])) {
				// 	$finalResponse[$siteKey]['backups']['schedule'] = $details['backups']['schedule'];
				// }
				if (!empty($details['backups']['others'])) {
					$finalResponse[$siteKey]['backups']['others'] = $details['backups']['others'];
				}

				if (!empty($details['backups']['parent'])) {
					$finalResponse[$siteKey]['backups']['parent'] = $details['backups']['parent'];
				}

				$finalResponse[$siteKey]['totalCount'] = $details['totalCount'];
			}
			return $finalResponse;
		}
		return $sitesBackups;
	}

	public static function getAccessibleUsersV3($params){
    	$accessUsers = " ";
    	setHook('historyHTML', $accessUsers);
    	$where = array(
      		'query' =>  ":accessUsers 1",
      		'params' => array(
               ':accessUsers'=>$accessUsers
				)
		);
    	$users = DB::getArray("?:users", "email, userID", $where); 
    	foreach ($users as $key => $value) {
    		$gravURL = "https://www.gravatar.com/avatar/" . md5( strtolower( trim( $value['email'] ) ) );
    		$users[$key]['gravURL'] = $gravURL;
    	}
    	return $users;
    	
	}

	public static function getHistoryPageHTMLV3($args){
		$searching = false;
		$itemsPerPage = 20;		
		$page = (isset($args['page']) && !empty($args['page'])) ? $args['page'] : 1;
		$where = "showUser='Y'";
		if(!empty($args['dates']) && (empty($args['getKeyword']) || ($args['getKeyword'] != 'running'))){
			$fromDate 	= $args['dates']['fromDate'];
			$toDate		= $args['dates']['toDate'];
			if(!empty($fromDate) && !empty($toDate) && $fromDate != -1 && $toDate != -1){
				$searching = true;
				$toDate += 86399;
				$where .= " AND microtimeAdded >= '".DB::esc($fromDate)."' AND  microtimeAdded <= '".DB::esc($toDate)."' ";
			}
		}
		$getKeyword = "";
		if(!empty($args['getKeyword'])){
			$searching = true;
			if ($args['getKeyword'] === 'running') {
				$getKeyword = " AND status IN ('writingRequest','pending','initiated','running','processingResponse','multiCallWaiting','retry','scheduled') ";
			}elseif ($args['getKeyword'] === 'error') {
				$getKeyword = " AND status IN ('error','netError') ";
			}else{
				$keyword = "'".implode("','", explode(',', DB::esc($args['getKeyword']) ) )."'" ;
				$getKeyword = " AND type IN (".$keyword.") ";
			}
		}
		if (!empty($args['actionID'])) {
			$where .= " AND actionID = '".DB::esc($args['actionID'])."' ";
		}
		if(!empty($args['userID'])){
			$searching = true;
			$where .= " AND userID = '".DB::esc($args['userID'])."' ";
		}
		$siteKeyword = "";
		if (!empty($args['siteIDs'])) {
			$siteIDSearch = "'".implode("','", $args['siteIDs'])."'";
			$siteKeyword = " AND siteID IN (".$siteIDSearch.") ";
		}
		$where2 = " ";
		if(empty($args['searchByUser']) )
			setHook('historyHTML', $where2);
		$total = DB::getField("?:history", "SQL_CALC_FOUND_ROWS actionID ", $where2.$where.$getKeyword.$siteKeyword. " GROUP BY actionID");
		$total = DB::getField("SELECT FOUND_ROWS()");
		$limitSQL = paginate($page, $total, $itemsPerPage);
		$actionIDs = DB::getFields("?:history", "actionID ", $where2.$where.$getKeyword.$siteKeyword. " GROUP BY actionID ORDER BY historyID DESC ".$limitSQL);
		$showInProgress = false;
		if(!empty($actionIDs)){ 
			$actionsHistoryData = array();
			foreach($actionIDs as $actionID){
				$actionsHistoryData[] = self::getActionStatusV3($actionID);
			}
		}
		if( $searching ){
			$searching = $total;
		}
		$totalPage = ceil($total / $itemsPerPage);
		// file_put_contents(APP_ROOT."/__debugger1.php", var_export($actionsHistoryData,1)."\n<br><br>\n",FILE_APPEND );
		// $HTML = TPL::get('/templates/history/view.tpl.php', array('actionsHistoryData' => $actionsHistoryData,'searching'=>$searching));
		
		return array('activities' => $actionsHistoryData, 'totalPages' => $totalPage);
	}

	public static function getHistoryPanelHTMLV3(){
		$itemsPerPage = 10;
		
		$where = '';
		
		setHook('historyHTML', $where);
		$where2 = array(
		      		'query' =>  $where. " showUser=':showUser' GROUP BY actionID ORDER BY historyID DESC LIMIT :itemsPerPage",
		      		'params' => array(
		               ':showUser'=>'Y',
		               ':itemsPerPage'=>$itemsPerPage
	   				)
				);
		$actionIDs = DB::getFields("?:history", "actionID", $where2);
		if(empty($actionIDs)){ $actionIDs = array(); }
		$actionsHistoryData = array();
		$showInProgress = false;
		foreach($actionIDs as $actionID){
			$actionsHistoryData[$actionID] = self::getActionStatusV3($actionID, '', true);
			if(($actionsHistoryData[ $actionID ]['status'] == 'pending')||($actionsHistoryData[ $actionID ]['status'] == 'multiCallWaiting')){ $showInProgress = true; }
		}
		return array("showInProgress" => $showInProgress, "activities" => $actionsHistoryData);
		
	}

	public static function getHistoryPanelDetailedHTMLV3($data){
		if (empty($data['actionid'])) {
			return false;
		}
		$actionID = $data['actionid'];
		$actionsHistoryData[ $actionID ] = self::getActionStatusV3($actionID);
		if (empty($actionsHistoryData[ $actionID ])) {
			return false;
		}
		if(($actionsHistoryData[ $actionID ]['status'] == 'pending')||($actionsHistoryData[ $actionID ]['status'] == 'multiCallWaiting')){ $showInProgress = true; }

		return array("showInProgress" => $showInProgress, "activities" => $actionsHistoryData);
	}

	public static function getActionStatusV3($actionID, $action='', $skipDetailedAction = false){
		$where = array(
		      		'query' =>  "actionID = ':actionID'",
		      		'params' => array(
		               ':actionID'=>$actionID
	   				)
				);
		$actionType = DB::getField("?:history", "type", $where);
		$where = array(
		      		'query' =>  "actionID = ':actionID' ORDER BY historyID ASC",
		      		'params' => array(
		               ':actionID'=>$actionID
	   				)
				);
		$historyDatas = DB::getArray("?:history", "historyID, siteID, type, userID, action, status, error, microtimeAdded",$where, "historyID");		

		if(empty($historyDatas)){ return false;	}
		
		$totalRequest 			= count($historyDatas);
		$where = array(
		      		'query' =>  "actionID = ':actionID' AND status NOT IN ('completed')",
		      		'params' => array(
		               ':actionID'=>$actionID,
		               ':status'=>'completed'
	   				)
				);
		$totalNonSuccessRequest = DB::getField("?:history", "count(status)", $where);
		$where = array(
		      		'query' =>  "actionID = ':actionID' AND status IN ('pending','initiated', 'running', 'processingResponse', 'scheduled')",
		      		'params' => array(
		               ':actionID'=>$actionID
	   				)
				);
		$totalPendingRequest = DB::getField("?:history", "count(status)", $where);
		$where = array(
		      		'query' => "actionID = ':actionID' AND status = ':status'",
		      		'params' => array(
		               ':actionID'=>$actionID,
		               ':status'=>'completed'
	   				)
				);
		$totalSuccessRequest = DB::getField("?:history", "count(status)", $where);
		$where = array(
		      		'query' =>  "actionID = ':actionID' AND status IN ('error','netError' )" ,
		      		'params' => array(
		               ':actionID'=>$actionID
	   				)
				);
		$totalErrorRequest = DB::getField("?:history", "count(status)", $where );
			$where = array(
		      		'query' =>  "actionID = ':actionID' AND status IN ('retry')",
			      	'params' => array(
		               ':actionID'=>$actionID
					)
				);
		$totalRertyRequest 		= DB::getField("?:history", "count(status)", $where);
		$where = array(
		      		'query' =>  "actionID = ':actionID' AND status = ':status'",
		      		'params' => array(
		               ':actionID'=>$actionID,
		               ':status'=>'multiCallWaiting'
	   				)
				);
		$totalMultiCallRequest = DB::getField("?:history", "count(status)", $where);

		if($totalPendingRequest > 0 || $totalRertyRequest > 0 ){ $status = 'pending';  }
		elseif($totalMultiCallRequest > 0){ $status = 'multiCallWaiting'; }	 //Modified to get status= 'multiCallWaitig' in processQueue.tpl && view.tpl.
		elseif($totalNonSuccessRequest == 0){ $status = 'success'; }
		elseif($totalNonSuccessRequest < $totalRequest){ $status = 'partial'; }
		elseif($totalNonSuccessRequest == $totalRequest){ $status = 'error'; }
		
		$historyStatusSummary = array('total' => $totalRequest,
									  'pending' => $totalPendingRequest,
									  'nonSuccess' => $totalNonSuccessRequest,
									  'error' => $totalErrorRequest,
									  'success' => $totalSuccessRequest);
	
		$historyData = reset($historyDatas);
		$type = $historyData['type'];//getting type from first history only, assuming type is common for one actionID
		$action = $historyData['action'];
		$time = round($historyData['microtimeAdded']);//getting time from first history ordered by historyID ASC
		$actionSitesCount = 0;
		if (!empty($actionHistory)) {
			$actionSitesCount = count($actionHistory);
		}
		$userID = $historyData['userID']; //who creaed this history.
		
		$historyIDs = array_keys($historyDatas);
		
		$where = array(
		      		'query' =>  "H.actionID = ':actionID' AND HAD.historyID = :historyID",
		      		'params' => array(
		               ':actionID'=>$actionID,
		               ':historyID'=>'H.historyID'
	   				)
				);
		if ($skipDetailedAction) {
			$historyAdditionalDatas = array();
			$totalCount = DB::getField("?:history_additional_data HAD, ?:history H", "count(H.historyID)", $where);
		}else{
			$historyAdditionalDatas = DB::getArray("?:history_additional_data HAD, ?:history H", "HAD.*, H.siteID, H.URL, H.microtimeInitiated,H.status AS mainStatus,H.isV3 AS isV3", $where);
			$totalCount = count($historyAdditionalDatas);
		}

		if(empty($historyAdditionalDatas) && !$totalCount){ return false; }
		
		$historyAdditionalDatasStatusArray = DB::getFields("?:history_additional_data HAD, ?:history H", "count(HAD.historyID), HAD.status", "H.actionID = '".$actionID."' AND HAD.historyID = H.historyID GROUP BY status", "status");		
		if(empty($historyAdditionalDatasStatusArray)){
			$historyAdditionalDatasStatusArray = array();
		}
		$historyAdditionalDatasStatusArray['total'] = $totalCount;
		$where = array(
		      		'query' =>  "H.actionID = ':actionID' AND HAD.historyID = H.historyID GROUP BY detailedAction ",
		      		'params' => array(
		               ':actionID'=>$actionID
	   				)
				);

		if ($actionType == 'PTC') {

			$detailedActions = DB::getArray("?:history_additional_data HAD, ?:history H", "count(DISTINCT H.siteID) as sitesCount, count(DISTINCT HAD.uniqueName) as detailedActionCount,  HAD.detailedAction, HAD.uniqueName", $where,"detailedAction");
		}else{
			$detailedActions = DB::getArray("?:history_additional_data HAD, ?:history H", "count(DISTINCT HAD.historyID) as sitesCount, count(DISTINCT HAD.uniqueName) as detailedActionCount,  HAD.detailedAction, HAD.uniqueName", $where,"detailedAction");
		}
		
		
		if($status == 'success'){//up to this line status only check connection is done successfully after this we will check task completed or not
			if(empty($historyAdditionalDatasStatusArray['success'])){
				$status = 'error';
			}
			elseif($historyAdditionalDatasStatusArray['total'] > $historyAdditionalDatasStatusArray['success']){
				$status = 'partial';
			}
		}
		$formatedDetailedStatus = array();
		if ($skipDetailedAction === false) {
			$formatedDetailedStatus = self::formatHistoryDetailedStatus($historyAdditionalDatas, $action, $type);
		}
		$percentageDone = (((int)$historyStatusSummary['success']+(int)$historyStatusSummary['error'])/(float)$historyStatusSummary['total'])*100;

		$percentageDone = ($percentageDone<2)?2:$percentageDone;
		if($historyStatusSummary['total'] == 1) $percentageDone = 100;//99.9;
		$actionResult = array(
						'userID' => $userID,
						'status' => $status,
						'statusMsg' => $status,
						'actionID' => $actionID,
						'statusSummary' => $historyAdditionalDatasStatusArray,
						'historyStatusSummary' => $historyStatusSummary,
						'detailedStatus' => $formatedDetailedStatus,
						'detailedActions' => $detailedActions, 
						'type' => $type,
						'action' => $action,
						'dayLabel' => @date('l', $time),
						'monthLabel' => @date('M d', $time),
						'timeLabel' => @date('h:ia', $time),
						'activityLabel' => @date('M d D', $time),
						'time' =>(int)$time,
						'actionSitesCount' => $actionSitesCount,
						'percentageDone' => $percentageDone,
						);
		
		$titleTweak = processQueueTweak($actionResult, 'staging', 'title');
		// file_put_contents(APP_ROOT."/__debugger1.php", var_export($actionResult,1)."\n<br><br>\n",FILE_APPEND );
		if($titleTweak){
		  $TPLPrepareHistoryBriefTitle = $titleTweak;
		} else {
		  $TPLPrepareHistoryBriefTitle = TPLPrepareHistoryBriefTitle($actionResult);
		}
		$actionResult['title'] = $TPLPrepareHistoryBriefTitle;
		$netError = $error = $success = 0;
		if (!empty($historyAdditionalDatasStatusArray['netError']) && $historyAdditionalDatasStatusArray['netError'] != 0) {
			$netError = $historyAdditionalDatasStatusArray['netError'];
		}
		if (!empty($historyAdditionalDatasStatusArray['error']) && $historyAdditionalDatasStatusArray['error'] !=0) {
			$error = $historyAdditionalDatasStatusArray['error'];
		}
		if (!empty($historyAdditionalDatasStatusArray['success']) && $historyAdditionalDatasStatusArray['success'] !=0) {
			$success = $historyAdditionalDatasStatusArray['success'];
		}
		if ($success != 0) {
			$historyAdditionalDatasStatusArray['success'] = $success;
		}
		if ($error !=0 || $netError !=0) {
			$historyAdditionalDatasStatusArray['error'] = $error+$netError;
		}
		$actionResult['statusSummary'] = $historyAdditionalDatasStatusArray;
		return $actionResult;
	}

	public static function formatHistoryDetailedStatus($actionHistory, $action, $type){
		$return = $updateAction = array();
		$sitesData = getSitesData();
		$statusMessages = array(
			"writingRequest" => "Adding to queue",
			"pending" => "Pending",
			"initiated" => "Initiated",
			"running" => "Running",
			"scheduled" => "Waiting in queue",
			"processingResponse" => "Processing response",
			"multiCallWaiting" => "Running"
			  );
		foreach ($actionHistory as $key => $oneAction) {

			if($type == 'PTC' && $oneAction['detailedAction'] == 'plugin'){
				$uniqueNameTemp = explode('/', $oneAction['uniqueName']);
				$oneAction['uniqueName'] = reset($uniqueNameTemp);
				$oneAction['title'] = str_replace('.php', '', $oneAction['uniqueName']);
			}

			if($type == 'PTC'){
				$oneAction['title'] = $oneAction['uniqueName'];
			}

			if ($action == 'manage' || $action == 'install') {
				$oneAction['title'] = $oneAction['uniqueName'];
			}
			
			if(in_array($type, array('themes', 'plugins')) && $action == 'install' && strpos($oneAction['uniqueName'], '%20') !== false){//this to replace %20 in the file name
				$oneAction['title'] = str_replace('%20', ' ', $oneAction['uniqueName']);
			}
			$oneAction['siteName'] = isset($sitesData[$oneAction['siteID']]['name']) ?  $sitesData[$oneAction['siteID']]['name'] : $oneAction['URL'];
			$oneAction['action']= $action;
			$oneAction['type']= $type;
			$oneAction['name']= $oneAction['uniqueName'];
			if (!empty($statusMessages[$oneAction['mainStatus']])) {
				$oneAction['mainStatus'] = $statusMessages[$oneAction['mainStatus']];
			}elseif ($oneAction['mainStatus'] == 'netError') {
				$oneAction['mainStatus'] = 'error';
			}
			if ($oneAction['type'] == 'staging' || $oneAction['type'] == 'stagingToLive'){
			    processQueueTweak($oneAction, 'staging', 'content');
			}
			if ($type != 'PTC' && !in_array($type, array('themes', 'plugins'))) {
				if ($oneAction['status'] == 'error' || $oneAction['status'] == 'netError') {
					$oneAction['status'] = 'error';
					$oneAction['title'] = TPLAddErrorHelp($oneAction, $oneAction['siteID']);
				}else{
					if ($oneAction['successMsg']) {
						$oneAction['title'] = TPLActionTitle($oneAction);
					}else{
						$oneAction['title'] = TPLActionTitle($oneAction);
					}
				}
				$return[$oneAction['historyID']] = $oneAction;
			}else{
				if ($oneAction['status'] == 'error' || $oneAction['status'] == 'netError') {
					$oneAction['status'] = 'error';
				}
				if ((in_array($type, array('themes', 'plugins')) && $oneAction['action'] == 'get' )) {
					$oneAction['title'] = TPLActionTitle($oneAction);
				}
				if ((in_array($type, array('themes', 'plugins', 'PTC')) && in_array($oneAction['action'], array('install', 'update')) )) {
					if ($oneAction['status'] == 'error' || $oneAction['status'] == 'netError') {
						$oneAction['errorMsg'] = TPLAddErrorHelp($oneAction, $oneAction['siteID']);
					}
				}
				$return[$key] = $oneAction;
			}

		}
		//if ($type == 'PTC' || in_array($type, array('themes', 'plugins'))) {
			$i=0;
			foreach ($return as $k => $value) {
				$updateAction[$value['historyID']]['siteName'] = $value['siteName'];
				$updateAction[$value['historyID']]['status'] = $value['status'];
				$updateAction[$value['historyID']]['historyID'] = $value['historyID'];
				if(isset($value['isV3'])){
					$updateAction[$value['historyID']]['isV3'] = $value['isV3'];
				}else{
					$updateAction[$value['historyID']]['isV3'] = 0;
				}
				if ($type == 'PTC' || (in_array($type, array('themes', 'plugins')) && $value['action'] != 'get')) {
					$updateAction[$value['historyID']]['additionalDetails'][$value['detailedAction']]['label'] = $value['detailedAction'];
					$versionDetails = findUpdatedVersionByIDV3($value['historyID'], $value['detailedAction']);
					if (is_array($versionDetails)) {
						$updateAction[$value['historyID']]['additionalDetails'][$value['detailedAction']]['version'] = findUpdatedVersionByIDV3($value['historyID'], $value['detailedAction']);
					}
					$value['showErrorMsg'] = 1;
				}
				$updateAction[$value['historyID']]['additionalDetails'][$value['detailedAction']]['items'][$i] = $value;
				$i++;
			}
			return $updateAction;
		//}
		return $return;
	}

	public static function getActivityCategoriesV3($params){
		$addonDetails = Reg::get('addonDetails');
		$backups = '';
		$activity = array();
		$activity[] = array('name' => 'Running',
							 'value' => 'running'
							);
		$activity[] = array('name' => 'Error',
								'value' => 'error'
							);
		$activity[] = array('name' => 'Reload Data',
							 'value' => 'stats'
							);
		$activity[] = array('name' => 'Plugins',
							 'value' => 'plugins'
							); 
		$activity[] = array('name' => 'Themes',
							 'value' => 'themes'
							); 
		$activity[] = array('name' => 'Site Actions',
							 'value' => 'site'
							); 
		$activity[] = array('name' => 'Update Actions',
							 'value' => 'PTC'
							);
		$activity[] = array('name' => 'Update Client',
							 'value' => 'clientPlugin'
							);
		foreach ($addonDetails as $name => $addon) {
			if ($addon['slug'] == 'bulkPublish') {
				$activity[] = array('name' => 'Bulk Publish',
									'value' => 'post,page,links,posts,pages'
									);
			}elseif ($addon['slug'] == 'brokenLinks') {
				$activity[] = array('name' => 'Broken Links',
									'value' => 'brokenLinks,brokenLinksV3'
									);
			}elseif ($addon['slug'] == 'clientPluginBranding') {
				$activity[] = array('name' => 'Client Plugin Branding',
									'value' => 'clientPluginBranding'
									);
			}elseif ($addon['slug'] == 'clientPluginBranding') {
				$activity[] = array('name' => 'Client Plugin Branding',
									'value' => 'clientPluginBranding'
									);
			}elseif ($addon['slug'] == 'codeSnippets') {
				$activity[] = array('name' => 'Code Snippets',
									'value' => 'codeSnippets'
									);
			}elseif ($addon['slug'] == 'fileEditor') {
				$activity[] = array('name' => 'File Editor',
									'value' => 'fileEditor'
									);
			}elseif ($addon['slug'] == 'googleWebMasters') {
				$activity[] = array('name' => 'Google Webmasters',
									'value' => 'googleWebMasters'
									);
			}elseif ($addon['slug'] == 'installClone') {
				$activity[] = array('name' => 'Install Clone_WP',
									'value' => 'installClone'
									);
			}elseif ($addon['slug'] == 'ithemesSecurity') {
				$activity[] = array('name' => 'iThemes Security',
									'value' => 'ithemesSecurity'
									);
			}elseif ($addon['slug'] == 'malwareScanningSucuri') {
				$activity[] = array('name' => 'Malware Scanning_Sucuri',
									'value' => 'malwareScanningSucuri'
									);
			}elseif ($addon['slug'] == 'manageComments') {
				$activity[] = array('name' => 'Manage Comments',
									'value' => 'comments,commentsV3'
									);
			}elseif ($addon['slug'] == 'manageUsers') {
				$activity[] = array('name' => 'Manage Users',
									'value' => 'manageUsers,manageUsersV3'
									);
			}elseif ($addon['slug'] == 'wordFence') {
				$activity[] = array('name' => 'Wordfence',
									'value' => 'wordFence'
									);
			}elseif ($addon['slug'] == 'wp') {
				$activity[] = array('name' => 'WP Optimize',
									'value' => 'wp'
									);
			}elseif ($addon['slug'] == 'staging') {
				$activity[] = array('name' => 'Staging',
									'value' => 'staging'
									);
			}elseif ($addon['slug'] == 'backupRepository') {
				$backups.='backupRepository,'; 
			}elseif ($addon['slug'] == 'scheduleBackup') {
				$backups.='scheduleBackup,'; 
			}elseif ($addon['slug'] == 'clientReporting') {
				$activity[] = array('name' => 'Client Reporting',
									'value' => 'clientReporting'
									);
			}elseif ($addon['slug'] == 'defendwp') {
				$activity[] = array('name' => 'DefendWP',
									'value' => 'defendwp'
									);
			}

		}
		$activity[] = array('name' => 'Backups',
							 'value' => $backups.'backup'
							);

		return $activity;
	}

	public static function getSettingsAllV3(){
		$email = self::getAccountSettings($GLOBALS['userID']);
		$notifications = self::getNotificationSettings();


		$allSettings['accountSettings']['email'] = $email['email'];
		$allSettings['accountSettings']['updatesNotificationMail'] = $notifications['updatesNotificationMail'];

		$settingsRow = DB::getRow("?:settings", "*", "1");
		$allSettings['appSettings'] = @unserialize($settingsRow['general']);
		$defaultPanelV3 = getOption('defaultPanelV3');
		if(!empty($defaultPanelV3)){
			$allSettings['appSettings']['defaultPanelV3'] = $defaultPanelV3;
		}else{
			$allSettings['appSettings']['defaultPanelV3'] = 0;
		}

		$timeZones = self::getTimeZones();
		$allSettings['appSettings']['timeZones'] = $timeZones['timeZones'];

		$allSettings['securitySettings']['allowedLoginIPs'] = DB::getFields("?:allowed_login_ips", "IP", "1");
		$allSettings['securitySettings']['loginAuthType'] = getOption('loginAuthType');
		if (!empty($allSettings['appSettings']['httpAuth'])) {
			$allSettings['securitySettings']['httpAuth'] = $allSettings['appSettings']['httpAuth'];
		}

		if (!empty($allSettings['appSettings']['enableHTTPS'])) {
			$allSettings['securitySettings']['enableHTTPS'] = $allSettings['appSettings']['enableHTTPS'];
		}
		if (!empty($allSettings['appSettings']['enableSSLVerify'])) {
			$allSettings['securitySettings']['enableSSLVerify'] = $allSettings['appSettings']['enableSSLVerify'];
		}

		$this_email_settings = getOption('emailSettings');
		if(!empty($this_email_settings)){
			$allSettings['emailSettings'] = @unserialize($this_email_settings);
        }

        if(function_exists('getDuoSettings')){
        	$allSettings['securitySettings']['duoAuth'] = getDuoSettings();
        }
        // if(function_exists('clientPluginBrandingGet')){
        // 	$allSettings['clientPluginBranding'] = clientPluginBrandingGet();
        // }

		$allSettings['appUpdateSettings']['ftpDetails'] = self::getFTPValuesV3();
		$allSettings['appUpdateSettings']['isDirectFS'] = getOption('isDirectFSV3');
		$allSettings['connectionMethod']['connectionMethodData'] = self::getConnectionMethodData();
		$allSettings['connectionMethod']['connectionMethodCompatibility'] = self::connectionMethodCompatibility();
		$allSettings['cloneStagingConnectionSetting'] = self::getCloneStagingConnectionSetting();
        setHook('getAddonSettings',$allSettings);
		return $allSettings;
	}

	public static function getNotificationSettings(){
		$userID=$GLOBALS['userID'];
		$where = array(
				'query' =>  "userID = ':userID'",
				'params' => array(
		       ':userID'=>$userID
				)
		);
		$settingsRow = DB::getRow("?:users", "notifications", $where);
		return @unserialize($settingsRow['notifications']);
	}

	public static function updateSettingsAllV3($settings){
		if (!empty($settings['accountSettings'])) {
			if (!empty($settings['accountSettings']['email'])) {
				$return = self::updateAccountSettings($settings['accountSettings']);
				if ($return['status'] == 'error') {
					return $return; 
				}
			}
			if (!empty($settings['accountSettings']['updatesNotificationMail'])) {
				$where = array(
		      		'query' =>  "userID = ':userID' ",
		      		'params' => array(
		               ':userID'=>$GLOBALS['userID']
	   				)
				);
				unset($data['accountSettings']['email'],$data['accountSettings']['currentPassword'],$data['accountSettings']['newPassword']);
				$return = DB::update("?:users", array("notifications" => serialize($settings['accountSettings'])), $where);
				return $return;
			}
		}

		if (!empty($settings['appSettings'])) {
			$currentGeneralSettings = Reg::get('settings');
			if($settings['appSettings']['autoSelectConnectionMethod'] == 1){
				$settings['appSettings']['executeUsingBrowser'] = $currentGeneralSettings['executeUsingBrowser'];
				if($settings['appSettings']['TIMEZONE'] != ''){
					@date_default_timezone_set( $settings['appSettings']['TIMEZONE']);
				}
			}
				if(!empty($currentGeneralSettings['httpAuth'])){
					$settings['appSettings']['httpAuth'] = $currentGeneralSettings['httpAuth'];
				}
			if(!empty($currentGeneralSettings['enableHTTPS'])){
				$settings['appSettings']['enableHTTPS'] = $currentGeneralSettings['enableHTTPS'];
			}
			if(!empty($settings['appSettings']['defaultPanelV3']) && $settings['appSettings']['defaultPanelV3'] == 1){
				updateOption('defaultPanelV3', 1);
			}else{
				updateOption('defaultPanelV3', 0);
			}
			$updateSettings['general'] = serialize($settings['appSettings']);
			if(!empty($updateSettings)){
				$updateSettings['timeUpdated'] = time();
				return DB::update("?:settings", $updateSettings, "1");
			}
		}

		if (!empty($settings['securitySettings'])) {
			return self::updateSecuritySettingsV3($settings['securitySettings']);
		}

		if(!empty($settings['emailSettings'])){
			$emailSettings = unserialize(getOption('emailSettings'));
			if($settings['emailSettings']['smtpSettings']['useSmtp'] == 0){
				$settings['emailSettings']['smtpSettings']['smtpHost'] = $emailSettings['smtpSettings']['smtpHost'];
				$settings['emailSettings']['smtpSettings']['smtpPort'] = $emailSettings['smtpSettings']['smtpPort'];
				$settings['emailSettings']['smtpSettings']['smtpAuthUsername'] = $emailSettings['smtpSettings']['smtpAuthUsername'];
				$settings['emailSettings']['smtpSettings']['smtpAuthPassword'] = $emailSettings['smtpSettings']['smtpAuthPassword'];
				$settings['emailSettings']['smtpSettings']['smtpEncryption'] = $emailSettings['smtpSettings']['smtpEncryption'];
				$settings['emailSettings']['smtpSettings']['smtpAuth'] = $emailSettings['smtpSettings']['smtpAuth'];
			}
			return updateOption('emailSettings', serialize($settings['emailSettings']));
		}
		if(!empty($settings['connectionMethod'])){
			return self::saveConnectionMethod($settings['connectionMethod']['connectionMethodData']);
		}
		if(!empty($settings['appUpdateSettings'])){
			$ftp['FTPValues'] = $settings['appUpdateSettings']['ftpDetails'];
			$ftp['isDirectFS'] = $settings['appUpdateSettings']['isDirectFS'];
			return self::saveAppUpdateSettingsV3($ftp);
		}
	}

	public static function iwpLoadServerInfoV3($siteID){
		$where = array(
      		'query' =>  "siteID=':siteID'",
      		'params' => array(
               ':siteID'=>$siteID
				)
		);
        $historyData = DB::getRow("?:sites", "siteTechinicalInfo", $where);
        return unserialize($historyData['siteTechinicalInfo']);
	}

	public static function getMenusV3(){
		$menus['manage'] 	= array();
		$menus['protect'] 	= array();
		// $menus['tools'] 	= array();
		$isUpdates = true;
		$isPluginsAndThemes = true;
		$userLevel = userStatus();
		$isScheduleBackup = true;
		$isRepo = true;
		if ($userLevel != 'admin' && function_exists('multiUserAllowAccess')) {
			$userAccess = multiUserAllowAccess();
			if (!empty($userAccess['restrict'])) {
				$removeAccess = $userAccess['restrict'];
				$isUpdates = !in_array('updates', $removeAccess);
				$isPluginsAndThemes = !in_array('items', $removeAccess);
			}
		}
		
		if ($isUpdates) {
			$menus['manage']['name'] 	= 'Manage';
			$menus['manage']['children'][] 		= array('page' => 'updates', 'name' => 'Updates');
		}
		if ($isPluginsAndThemes) {
			$menus['manage']['name'] 	= 'Manage';
			$menus['manage']['children'][] 		= array('page' => 'pluginsAndThemes', 'name' => 'Plugins & Themes');
		}
		$menus['protect']['name'] 	= 'Protect';
		$menus['protect']['children'][] 	= array('page' => 'backups', 'name' => 'Backups');
		
		
		setHook('addonMenus', $menus);

		return $menus;
	}

	public static function getInstalledAddonsV3(){
		$addons = DB::getFields("?:addons_v3", "slug", "status = 'active'");
		if(userStatus() != 'admin'){
			userAddonsAccessV3($addons);
			$addons = array_values($addons);
		}
		return $addons;
	}

	public static function getAppInfoV3(){
		$appInfo = array();
		$appInfo['APP_VERSION'] = APP_VERSION;
		$appInfo['APP_INSTALL_HASH'] = APP_INSTALL_HASH;
		$appInfo['serviceURL'] = getOption('serviceURL');
		$appInfo['APP_PHP_CRON_CMD'] = APP_PHP_CRON_CMD.''.APP_ROOT.'/cron.php >/dev/null 2>&1';		
		$appInfo['APP_ROOT'] = APP_ROOT;		
		$appInfo['GA_HELP_TRACKING'] = GA_HELP_TRACKING;		
		$appInfo['SUPPORT_URL'] = SUPPORT_URL;		
		$appInfo['IWP_SITE_URL'] = IWP_SITE_URL;		
		$appInfo['IP'] = $_SERVER['REMOTE_ADDR'];
		$appInfo['APP_URL'] = APP_URL;
		$appInfo['APP_DOMAIN_PATH'] =APP_DOMAIN_PATH;
		$appInfo['APP_ROOT_V2'] =APP_DOMAIN_PATH_V2;
		$appInfo['APP_DOMAIN_PATH_V2'] = trim(APP_DOMAIN_PATH_V2, '/');
		$APP_URL = 'http'.((APP_HTTPS == 1 ) ? 's' : '').'://'.rtrim(APP_DOMAIN_PATH_V2,"/")."/";
		$appInfo['APP_URL_V2'] = $APP_URL;
		$appInfo['profilePicURL'] = getLogginUserPic();
		$cronFrequency = getRealSystemCronRunningFrequency(true);
		$cronScheduleFrequency = 0;
		if($cronFrequency > 0 && $cronFrequency <= 6){//5 min system cron
			$cronScheduleFrequency = 5;
		}elseif($cronFrequency > 6){
			$cronScheduleFrequency = 20;
		}
		$cronFrequencyV2 = getRealSystemCronRunningFrequency(false, false, true);
		$cronScheduleFrequencyV2 = 0;
		if($cronFrequencyV2 > 0 && $cronFrequencyV2 <= 6){//5 min system cron
			$cronScheduleFrequencyV2 = 5;
		}elseif($cronFrequencyV2 > 6){
			$cronScheduleFrequencyV2 = 20;
		}
		$appInfo['cronFrequency'] = $cronFrequency;
		$appInfo['cronFrequencyV2'] = $cronFrequencyV2;
		$appInfo['isEasyCronActive'] = manageEasyCron::isActive();
		$appInfo['systemCronRunningFrequency'] = $cronScheduleFrequency;
		$appInfo['WP_CHANGELOG_URL'] = WP_CHANGELOG_URL;
		$appInfo['WP_PLUGIN_CHANGELOG_URL'] = WP_PLUGIN_CHANGELOG_URL;
		$appInfo['appRegisteredUser'] = getOption("appRegisteredUserV3");
		$appInfo['userInfo'] = userStatusV3($GLOBALS['userID']);
		$appInfo['inAppNotifications'] = self::getupdateNotificationContentV3();
		$appInfo['lastPanelUpdatedV3'] = getLastPanelUpdatedV3();
		$appInfo['v3DirectInstall'] = getV3DirectInstall();



		return $appInfo;	
	}
	public static function getLogPageHTMLV3($args){
		$where = " ";
		$getKeyword = " ";
		$where2 = " ";
		$itemsPerPage = 20;
		$page = (isset($args['page']) && !empty($args['page'])) ? $args['page'] : 1;
		$total = DB::getField("?:login_logs", "SQL_CALC_FOUND_ROWS ID ", 1);
		$total = DB::getField("SELECT FOUND_ROWS()");
		$limitSQL = paginate($page, $total, $itemsPerPage,'logPagination');
		if (!empty($args['ID'])) {
			$where = array(
	      		'query' =>  "ID=':ID'",
	      		'params' => array(
	               ':ID'=>$args['ID']
					)
			);
			$logDetails = DB::getArray("?:login_logs", "ID,email,accessLevel,time,browserInfo,loginAuthType,IP,error,loginAttemptStatus,protocol,loginRedirect" ,$where);
		}else{
			$where = array(
	      		'query' =>  "1 ORDER BY ID DESC :limit",
	      		'params' => array(
	               ':limit'=>$limitSQL
					)
			);
			$logDetails = DB::getArray("?:login_logs", "ID,email,accessLevel,time,browserInfo,loginAuthType,IP,error,loginAttemptStatus,protocol,loginRedirect",$where);
		}
		$totalPage = ceil($total / $itemsPerPage);
		if (!empty($logDetails)) {
			foreach ($logDetails as $key => $value) {
				$time = $value['time'];
				$logDetails[$key]['dayLabel'] = @date('l', $time);
				$logDetails[$key]['monthLabel'] = @date('M d', $time);
				$logDetails[$key]['timeLabel'] = @date('h:ia', $time);
				$logDetails[$key]['activityLabel'] = @date('D M d', $time);
			}
		}
		return array('logDetails' => $logDetails, 'totalPage' => $totalPage);
	}

	public static function clearHistoryTasksV3($params){
    	if(isset($params) && isset($params['clearWhat'])){
    		if($params['clearWhat'] == 'uncomplete'){
				$accessUsers = " ";
				setHook('historyHTML', $accessUsers);
				$where = array(
		      		'query' =>  "status NOT IN ('completed','error','netError') AND :accessUsers showUser = ':showUser' ",
		      		'params' => array(
		               ':accessUsers'=>$accessUsers,
		               ':showUser'=>'Y'
	   				)
				);
				$historyData = DB::getArray("?:history", "historyID", $where); 
				$error = 'task_cleared';
				$errorMsg = 'Task cleared by user';

				if(!empty($historyData) && is_array($historyData)){
					foreach($historyData as $key => $history){
						updateHistory(array("status" => "error", "error" => $error,'userIDCleared'=>$GLOBALS['userID']), $history['historyID'], array("status" => "error", "errorMsg" => $errorMsg));
					}
				}
    		}elseif($params['clearWhat'] == 'searchList'){
    			$where = "showUser='Y'";

				if(!empty($params['dates'])){
					$fromDate 	= $params['dates']['fromDate'];
					$toDate		= $params['dates']['toDate'];
					if(!empty($fromDate) && !empty($toDate) && $fromDate != -1 && $toDate != -1){
						$toDate += 86399;
						$where .= " AND microtimeAdded >= '".DB::esc($fromDate)."' AND  microtimeAdded <= '".DB::esc($toDate)."' ";
					}
				}


				$getKeyword = "";
				if(!empty($params['getKeyword'])){
					$keyword = "'".implode("','", explode(',', DB::esc($params['getKeyword']) ) )."'" ;
					$getKeyword = " AND type IN (".$keyword.") ";
				}
				
				if(!empty($params['userID'])){
					$where .= " AND userID = '".DB::esc($params['userID'])."' ";
				}
				$where2 = " ";
				if(empty($params['searchByUser']) ){
					setHook('historyHTML', $where2);
				}
				if( trim($where2.$where.$getKeyword) != "showUser='Y'" ){
					$historyIDs = DB::getFields("?:history", "historyID", $where2.$where.$getKeyword );
					self::clearHistoryByIDs($historyIDs);
					// $historyIDs = implode("','", $historyIDs);
					// DB::delete("?:history", "historyID IN ('".$historyIDs."')");
					// DB::delete("?:history_additional_data", "historyID IN ('".$historyIDs."')");
					// DB::delete("?:history_raw_details", "historyID IN ('".$historyIDs."')");
				}else{
					DB::delete("?:history","1");
					DB::delete("?:history_additional_data","1");
					DB::delete("?:history_raw_details","1");
					
					DB::doQuery("OPTIMIZE TABLE `?:history`");
					DB::doQuery("OPTIMIZE TABLE `?:history_additional_data`");
					DB::doQuery("OPTIMIZE TABLE `?:history_raw_details`");
				}
    		}elseif($params['clearWhat'] == 'autoDeleteLog' ){
				if(!empty($params['time'])){
					$where = " microtimeAdded <= '".DB::esc($params['time'])."' ";
	    			$accessUsers = " ";
					setHook('historyHTML', $accessUsers);
					if($accessUsers != " ") $accessUsers = " AND ".DB::esc($accessUsers);
					$historyIDs = DB::getFields("?:history", "historyID", $where.$accessUsers );
					self::clearHistoryByIDs($historyIDs);
					// if(!empty($historyIDs)){
					// 	$historyIDs = implode("','", $historyIDs);
					// 	DB::delete("?:history", "historyID IN ('".$historyIDs."')");
					// 	DB::delete("?:history_additional_data", "historyID IN ('".$historyIDs."')");
					// 	DB::delete("?:history_raw_details", "historyID IN ('".$historyIDs."')");
		
					// 	DB::doQuery("OPTIMIZE TABLE `?:history`");
					// 	DB::doQuery("OPTIMIZE TABLE `?:history_additional_data`");
					// 	DB::doQuery("OPTIMIZE TABLE `?:history_raw_details`");
					// }
					if(!empty($params['LastAutoDeleteLogTime'])){
						$now = $params['LastAutoDeleteLogTime'];
					}else{
						$now = time();
					}
					updateOption('LastAutoDeleteLogTime', $now);
				}
    		}elseif($params['clearWhat'] == 'singleAct' ){
    			if(!empty($params['actionID'])){
    				$where = array(
			      		'query' =>  "actionID = ':actionID'",
			      		'params' => array(
			               ':actionID'=>$params['actionID']
		   				)
					);
    				$historyIDs = DB::getFields("?:history", "historyID", $where );
    				self::clearHistoryByIDs($historyIDs);
    			}
    		}
    	}
	}

	public static function getRealSystemCronRunningFrequencyV3(){
		return getRealSystemCronRunningFrequency();
	}

	public static function generalCheckV3(&$finalResponse){
		
		if($updateAvailable = checkUpdateV3()){
			if( getOption('V3UpdateNotifySentToJS') != $updateAvailable['newVersion'] ){
				$finalResponse['V3UpdateAvailable'] = $updateAvailable;
				updateOption('V3UpdateNotifySentToJS', $updateAvailable['newVersion']);
			}
		}

		$notifications = getNotifications(true);
		if(!empty($notifications)){
			$finalResponse['notifications'] = $notifications;
		}
		
		$waitData = self::getWaitDataV3();
		if(!empty($waitData)){
			$finalResponse['data']['getWaitData'] = $waitData;
		}

		$fireQueue = self::processFireQueue();
		if (!empty($fireQueue) && is_array($fireQueue)) {
			$finalResponse['fireQueue'] = $fireQueue;
		}
		$alertCount = self::getAddonAlertCount();
		//$cookieAlertCount = manageCookies::cookieGet('addonAlertCount');
        $cookieAlertCount = getOption('addonAlertCount');
		$finalResponse['addonAlertCount'] = $alertCount;
		// if($cookieAlertCount !== $alertCount){
		// 	//manageCookies::cookieSet('addonAlertCount',$alertCount,array('expire'=>0));
  //                       updateOption('addonAlertCount',  $alertCount);
		// }
		
	}
	
	public static function initialCheckUpdateV3(){
		return checkUpdateV3(false, false);
	}

	public static function forceCheckUpdateV3(){
        if(userStatus()=="admin"){
            return checkUpdateV3(true);
        }
        else{ 
            return false;
         }
	}

	public static function getFTPValuesV3(){
		$FTPDetails = getOption('FTPCredentialsV3');
		$FTPCreds = false;
		if (empty($FTPDetails)) {
			$FTPCreds = @unserialize($FTPDetails);
		}
		return $FTPCreds;
	}

	public static function updateSecuritySettingsV3($settings){
		if(isset($settings['allowedLoginIPsCount'])){
			DB::delete("?:allowed_login_ips", "1");
			if(!empty($settings['allowedLoginIPs'])){
				foreach($settings['allowedLoginIPs'] as $IP){
					DB::insert("?:allowed_login_ips", array('IP' => $IP));
				}
			}
		}
		$updateSettings = array();
		$currentGeneralSettings = Reg::get('settings');
		if(!empty($settings['httpAuth'])){		
			$settings['httpAuth']['username'] = trim($settings['httpAuth']['username']);
			$settings['general'] = $currentGeneralSettings;
			$settings['general']['httpAuth'] = $settings['httpAuth'];
			// $updateSettings['general'] = serialize($settings['general']);
		}else{
			$settings['general'] = $currentGeneralSettings;
			unset($settings['general']['httpAuth']);

		}
		$settings['general']['enableHTTPS'] =  $settings['enableHTTPS'];
		$settings['general']['enableSSLVerify'] =  $settings['enableSSLVerify'];
		$updateSettings['general'] = serialize($settings['general']);

                updateOption('loginAuthType',  $settings['loginAuthType']);
                setHook('securitySettingsUpdate', $settings);
        
		if(!empty($updateSettings)){
			$updateSettings['timeUpdated'] = time();
			return DB::update("?:settings", $updateSettings, "1");
		}

		if(!empty($settings['duoAuth'])){
			$settings = array('duo_ikey'=>$settings['duoAuth']['duo_ikey'], 'duo_skey'=>$settings['duoAuth']['duo_skey'], 'duo_api_host'=>$settings['duoAuth']['duo_api_host']);
			setHook('securitySettingsUpdate', $settings);
		}
		
	}
	

	public static function saveAppUpdateSettingsV3($params){
		$getConfigFTP = self::getConfigFTP();
		$FTPDetails = array();
		$FTPDetails['FTPValues'] = unserialize(getOption('FTPCredentialsV3'));
		updateOption('isDirectFSV3', $params['isDirectFS']);
 		if(!empty($getConfigFTP) && $params['isDirectFS'] == 'N'){
 			self::removeConfigFTPDetails();
 		}
 		if($params['isDirectFS'] == 'Y' && empty($getConfigFTP) ){
			updateOption('FTPCredentialsV3', serialize($FTPDetails['FTPValues']));
			$FTPDetails['isDirectFS'] = $params['isDirectFS'];
			return $FTPDetails;
		}
		updateOption('FTPCredentialsV3', serialize($params['FTPValues']));	
		return $params;
	}

	public static function getDefaultFromEmailV3(){
		return getDefaultFromEmail();
	}

	public static function getAddonsPageHTMLV3(){
		$data = array();

		$data['installedAddons'] = getInstalledAddonsV3(true);
		$data['updateAvailableAddons'] = getUpdateAvailableAddonsV3(true);
		$data['newAddons'] = getNewAddonsAvailableV3();
		$data['promoAddons'] = getPromoAddons();
		$data['promos'] = getOption('promos');
		$data['isAppRegistered'] = isAppRegistered();
		$data['isAddonPlanExpired'] = panelRequestManagerV3::checkIsAddonPlanExpiredV3();
		$data['priceExistingToEnterprise'] = panelRequestManager::getPriceExistingToEnterprise();
		$data['priceExistingToFreelancer'] = panelRequestManager::getPriceExistingToFreelancer();
		$data['priceExistingToAgency'] = panelRequestManager::getPriceExistingToAgency();
		$data['priceExistingToDeveloper'] = panelRequestManager::getPriceExistingToDeveloper();
		$data['priceForEnterprise'] = panelRequestManager::getPriceForEnterprise();
		$data['priceForFreelancer'] = panelRequestManager::getPriceForFreelancer();
		$data['priceForAgency'] = panelRequestManager::getPriceForAgency();
		$data['priceForDeveloper'] = panelRequestManager::getPriceForDeveloper();
		$data['priceForStarter'] = panelRequestManager::getPriceForStarter();
		$data['renewPriceForStarter'] = panelRequestManager::getRenewPriceForStarter();
		$data['renewPriceForDeveloper'] = panelRequestManager::getRenewPriceForDeveloper();
		$data['renewPriceForFreelancer'] = panelRequestManager::getRenewPriceForFreelancer();
		$data['renewPriceForAgency'] = panelRequestManager::getRenewPriceForAgency();
		$data['renewPriceForEnterprise'] = panelRequestManager::getRenewPriceForEnterprise();
		$data['appRegisteredUser'] = getOption("appRegisteredUserV3");
		$data['newFreeAddons'] = getNewFreeAddonsAvailableV3();

		// $data['priceForSuiteUpgradedFromMini'] = panelRequestManager::getPriceForSuiteUpgradedFromMini();
		// $data['priceForAddonSuite'] = panelRequestManager::getPriceForAddonSuite();		
		
		$suiteDetails = unserialize(getOption('suiteDetailsV3'));

		if(empty($suiteDetails) and !is_array($suiteDetails)) {
			$data['activePlanSiteLimit'] = 0;
			$data['activePlanPurchasedDate'] = $data['addonSuiteActivity'] = $data['IDExistingToEnterprise']=$data['IDForAddonSuite']='';	
			$data['IDExistingToEnterprise'] = '';
			$data['IDExistingToFreelancer'] = '';
			$data['IDExistingToAgency'] = '';
			$data['IDExistingToDeveloper'] = '';
			$data['IDForEnterprise'] = '';
			$data['IDForFreelancer'] = '';
			$data['IDForAgency'] = '';
			$data['IDForDeveloper'] = '';		
		} else {
			$data['activePlanSiteLimit'] = $suiteDetails['activePlanSiteLimit'];	
			$data['activePlanPurchasedDate'] = $suiteDetails['activePlanPurchasedDate'];	
			$data['addonSuiteActivity'] = $suiteDetails['addonSuiteActivity'];
			$data['IDExistingToEnterprise'] = $suiteDetails['IDExistingToEnterprise'];
			$data['IDExistingToFreelancer'] = $suiteDetails['IDExistingToFreelancer'];
			$data['IDExistingToAgency'] = $suiteDetails['IDExistingToAgency'];
			$data['IDExistingToDeveloper'] = $suiteDetails['IDExistingToDeveloper'];
			$data['IDForEnterprise'] = $suiteDetails['IDForEnterprise'];
			$data['IDForFreelancer'] = $suiteDetails['IDForFreelancer'];
			$data['IDForAgency'] = $suiteDetails['IDForAgency'];
			$data['IDForDeveloper'] = $suiteDetails['IDForDeveloper'];
			$data['IDForStarter'] = $suiteDetails['IDForStarter'];
			$data['activeTierPlan'] = $suiteDetails['activeTierPlan'];
			$data['starterSiteLimit'] = $suiteDetails['starterSiteLimit'];
			$data['developerSiteLimit'] = $suiteDetails['developerSiteLimit'];
			$data['freelancerSiteLimit'] = $suiteDetails['freelancerSiteLimit'];
			$data['starterSupport'] = $suiteDetails['starterSupport'];
			$data['developerSupport'] = $suiteDetails['developerSupport'];
			$data['freelancerSupport'] = $suiteDetails['freelancerSupport'];
			$data['validity'] = panelRequestManagerV3::checkPlanValidityV3();
			$data['activePlanAddons'] = $suiteDetails['activePlanAddons'];
			$data['validTill'] = date("M d, Y",$data['validity']);
			if (in_array($data['activeTierPlan'], array('agency', 'enterprise'))) {
				$data['activePlanSiteLimit'] = 'unlimited';
			}
			$data['addonCounts'] = !empty($data['activePlanAddons'])?count($data['activePlanAddons']):0;
			if (in_array($data['activeTierPlan'], array('agency', 'enterprise'))) {
				$data['emailSupport'] = 'Priority';
			}elseif ($data['activeTierPlan'] == 'starter') {
				$data['emailSupport'] = $data['starterSupport'];
			}elseif ($data['activeTierPlan'] == 'developer') {
				$data['emailSupport'] = $data['developerSupport'];
			}elseif ($data['activeTierPlan'] == 'freelancer') {
				$data['emailSupport'] = $data['freelancerSupport'];
			}
		}		
		$data['addonsHTML'] = getAddonsHTMLV3();
		
		return $data;
	}
	public static function IWPAuthUserV3($params){
		
		$registerURL = IWP_SITE_URL.'app-login-v3/';
		$noCache      = '?no-cache-iwp='.md5(microtime(true).uniqid('',true).substr(str_shuffle("0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"), 0, rand(20,60)));
		$registerURL .= $noCache;

		$data = array('appInstallHash' => APP_INSTALL_HASH,
					  'installedHash' => getInstalledHash());

		$params['appDetails'] = base64_encode(serialize($data));
		$params['skipJsonCommunication'] =1;
		$params['V3'] =1;
		list($rawResponseData, , , $curlInfo)  = doCall($registerURL, $params, $timeout=30, array('normalPost' => 1));

		$cURLErrors = new cURLErrors($curlInfo);
		if(!$cURLErrors->isOk() && $curlInfo['info']['http_code'] != 403){
			$errorResponse = array();
			$errorResponse['error'] = 1;
			$errorResponse['message'] = $cURLErrors->getErrorMsg();
			return $errorResponse;
		}
		return json_decode($rawResponseData);
	}

	public static function checkPlanValidityV3() { //New pricing plan
		$suiteDetails = unserialize(getOption('suiteDetailsV3'));
		$installedAddons = getInstalledAddonsV3(true);
		if (empty($installedAddons)) {
			$installedAddons = getNewAddonsAvailableV3(true);
		}

		if(empty($suiteDetails) and !is_array($suiteDetails)) return(0);
		
		$pricingPlanTypes = array('starter','developer','freelancer','agency','enterprise');
		if($suiteDetails['addonSuiteActivity']=='installed') {
			foreach($installedAddons as  $addon){
				$validity = $addon['validityExpires'];
				if($addon['slug']!='multiUser' && $addon['isValidityExpired'] && time()-$addon['validityExpires']>=604800) return($validity);
			}
		}
		return($validity);
	}

	public static function activateAddonsV3($params){
		return activateAddonsV3($params['addons']);
	}

	public static function deactivateAddonsV3($params){
		return deactivateAddonsV3($params['addons']);
	}

	public static function getNewAddonsAvailableV3(){
		return getNewAddonsAvailableV3();
	}
	public static function getNewAddonAvailableV3(){
		return getNewAddonAvailableV3();
	}
	public static function getUpdateAvailableAddonsV3(){
		return getUpdateAvailableAddonsV3(true);
	}
	public static function getUpdateAvailableAddonV3(){
		return getUpdateAvailableAddonV3(true);
	}
	public static function getUpdateAvailableFreeAddonV3(){
		return getUpdateAvailableFreeAddonV3(true);
	}

	public static function getNewFreeAddonAvailableV3(){
		return getNewFreeAddonAvailableV3();
	}

	public static function checkIsAddonPlanExpiredV3() { //New pricing plan
		$suiteDetails = unserialize(getOption('suiteDetailsV3'));
		$installedAddons = getInstalledAddonsV3(true);
		
		if(empty($suiteDetails) and !is_array($suiteDetails)) return(0);
		
		$pricingPlanTypes = array('starter','developer','freelancer','agency','enterprise');
		if( !empty($installedAddons)) {
			foreach($installedAddons as  $addon){
				if($addon['slug']!='multiUser' && $addon['isValidityExpired'] && time()-$addon['validityExpires']>=604800) return(1);
			}
		}
		return(0);
	}

	public static function getAddonAlertCount(){

		//get addon updates count
		$i = 0;
		$addons = getInstalledAddonsV3(true);	
		if(!empty($addons)){
			foreach($addons as $slug => $addon){
				if(!empty($addon['updateAvailable'])) $i++;
			}
		}
		$i;

		//get new addons(non installed) count
		$newAddons = getNewAddonsAvailableV3();
		if(!empty($newAddons)){
			$i += count($newAddons);
		}

			//get new addons(non installed) count
		$newAddons = getNewFreeAddonsAvailableV3();
		if(!empty($newAddons)){
			$i += count($newAddons);
		}

		return $i;
	}
	public static function getAdditionalStatsV3(){
		$additionalStats = array();
		setHook('getAdditionalStatsData', $additionalStats);
		return $additionalStats;
	}

	public static function getEditSiteMenu(){
		$editSiteMenu = array();
		$editSiteMenu[] = array('name' => 'WP Admin Details', 'component' => 'WpAdminDetails', 'location' => './Common/');
		$editSiteMenu[] = array('name' => 'Assign Groups', 'component' => 'AssignGroups', 'location' => './Common/');
		$editSiteMenu[] = array('name' => 'Folder Protection', 'component' => 'FolderProtection', 'location' => './Common/');
		$editSiteMenu[] = array('name' => 'Advanced', 'component' => 'Advanced', 'location' => './Common/');
		$editSiteMenu[] = array('name' => 'Site Alias', 'component' => 'SiteAlias', 'location' => './Common/');
		$editSiteMenu[] = array('name' => 'FTP Details', 'component' => 'FTPDetails', 'location' => './Common/');

		setHook('getEditSiteMenu', $editSiteMenu);

		return $editSiteMenu;
	}


	public static function getSettingsMenu(){
		$settingsMenu = array();
		$settingsSubMenu = array();
		$userLevel = userStatus();
		$settingsMenu[] = array('name' => 'Account', 'component' => 'AccountSettings', 'location' => './Settings/');
		if ($userLevel == 'admin') {
			$settingsMenu[] = array('name' => 'App', 'component' => 'AppSettings', 'location' => './Settings/');
			$settingsMenu[] = array('name' => 'Security', 'component' => 'SecuritySettings', 'location' => './Settings/');
			$settingsMenu[] = array('name' => 'Email Settings', 'component' => 'EmailSettings', 'location' => './Settings/');
			$settingsMenu[] = array('name' => 'Cron', 'component' => 'CronSettings', 'location' => './Settings/');
			$settingsMenu[] = array('name' => 'App Update', 'component' => 'AppUpdateSettings', 'location' => './Settings/');
			$settingsMenu[] = array('name' => 'Connection settings', 'component' => 'ConnectionMethodSettings', 'location' => './Settings/');
			setHook('getSettingsMenu', $settingsMenu);
			setHook('getSettingsSubMenu', $settingsSubMenu);

			if(!empty($settingsSubMenu)){
				$arr = array();
				foreach ($settingsSubMenu as $key => $value) {
					$arr[$value['name']][] = $value;
				}
				foreach ($arr as $key => $value1) {
					$arr2 = array();
					$arr2['name'] = $key;
					foreach ($value1 as $title => $submenuDetails) {
						$arr2['component'] = $submenuDetails['component'];
						$arr2['location'] = $submenuDetails['location'];
						$arr2['details'][] = $submenuDetails;
					}
					array_push($settingsMenu,$arr2);		
				}
			}
		}
		return $settingsMenu;
	}

	public static function getSiteInfoMenu(){
		$siteInfoMenu = array();
		$userLevel = userStatus();
		$openAdmin = true;
		$createBackup = true;
		$editSiteDetails = true;
		if ($userLevel != 'admin' && function_exists('multiUserAllowAccess')) {
			$userAccess = multiUserAllowAccess();
			if (!empty($userAccess['restrict'])) {
				$removeAccess = $userAccess['restrict'];
				$openAdmin = !in_array('openAdmin', $removeAccess);
				$createBackup = !in_array('createBackup', $removeAccess);
				$editSiteDetails = !in_array('addEditRemoveSite', $removeAccess);
			}
		}
		$siteInfoMenu[] = array('component' => 'viewSite');
		$siteInfoMenu[] = array('component' => 'writeNewPost');
		if ($openAdmin) {
			$siteInfoMenu[] = array('component' => 'openAdminNewTab');
		}
		
		if ($createBackup) {
			$siteInfoMenu[] = array('component' => 'backupNow');
		}
		$siteInfoMenu[] = array('component' => 'viewBackup');
		setHook('getSiteInfoMenu', $siteInfoMenu);
		if ($editSiteDetails) {
			$siteInfoMenu[] = array('component' => 'editSiteDetails');
		}
		$siteInfoMenu[] = array('component' => 'reloadData');
		$siteInfoMenu[] = array('component' => 'maintenance');
		$siteInfoMenu[] = array('component' => 'serverInfo');
		if ($editSiteDetails) {
			$siteInfoMenu[] = array('component' => 'readdSite');
			$siteInfoMenu[] = array('component' => 'removeSite');
		}

		$keyOrder = array('viewSite','writeNewPost','openAdminNewTab','createStagingSiteInfo','addExistingStagingSiteInfo','stagingMenuInfo','backupNow','viewBackup','editSiteDetails','reloadData','scanForMalware','customBrandingSiteInfo','maintenance','serverInfo','readdSite','removeSite');
		$newKeyOrder = array();
		foreach ($keyOrder as $key => $menuName) {
			foreach ($siteInfoMenu as $key => $value) {
				foreach ($value as $key1 => $menuNameInHook) {
					if($menuNameInHook == $menuName){
						$newKeyOrder[] =array('component'=>$menuName);

					}					
				}
			}
		}
		return $newKeyOrder;
	}

	public static function getCurrentUserInfoV3(){
		$userInfo = userStatusV3();
		if ($userInfo['accessLevel'] != 'admin' && function_exists('multiUserAllowAccess')) {
			$userInfo['permissions'] = multiUserAllowAccess();
		}
		return $userInfo;
	}
	public static function getInitPageV3(){
		$menus = self:: getMenusV3();
		$menuValue = array_values($menus);
		$page = $menuValue[0]['children'][0]['page'];
		return $page;
	}
	public static function getupdateNotificationContentV3(){
		//get notification center content and notification offer content which is updated in options table
		$notifyCenter = unserialize(getOption("markNotifyCenter"));
		$notifyCenterCount = getOption("notif_count");
		$notifyCenterDeliveredCount = 0;
		$notifyOffer = unserialize(getOption("markNotifyOffer"));
		$notifyCountStyle = '';
		//$notifyCenterRead = array();
		if(!getOption("notifyCenterRead")){
			$notifyCenterRead = array();
		}
		else{
			$notifyCenterRead = unserialize(getOption("notifyCenterRead"));
		}
		if(!getOption("notifyCenterDelivered")){
			$notifyCenterDelivered = array();
		}
		else{
			$notifyCenterDelivered = unserialize(getOption("notifyCenterDelivered"));
		}
		if(!getOption("notifyOfferDelivered")){
			$notifyOfferDelivered = array();
		}
		else{
			$notifyOfferDelivered = unserialize(getOption("notifyOfferDelivered"));
		}
		if(empty($notifyCenterCount)){
			$notifyCountStyle = 'style="display:none"';
		}

		//prepare the html
		$notificationTypeBasedIcon = array('announcement' => 'bullhorn', 'occasionalOffer' => 'gift', 'blog' => 'file-text-o');
		//$notifyCenter = json_decode(getOption("markNotifyCenter"), true);
		$finalRefinedDataNotification = array();
		if(!empty($notifyCenter)){
			foreach($notifyCenter as $ID => $notifyDetail){
				if(!array_key_exists($ID, $notifyCenterRead)){
					$notifyCenterRead[$ID] = 1;					//marking read in array's key
					$this_class = 'unread';
				}
				else{
					$this_class = 'read';
				}
				if(!array_key_exists($ID, $notifyCenterDelivered)){
					$notifyCenterDelivered[$ID] = 1;					//marking delivered in array's key
					$notifyCenterDeliveredCount++;
				}
				$notifyDetail['viewStatus'] = $this_class;
				$notifyDetail['timestamp'] = date('M j ', $notifyDetail['publishedTime']).' at '.date('H:ia', $notifyDetail['publishedTime']);
				array_push($finalRefinedDataNotification,$notifyDetail);

			}
		}
		updateOption("notifyCenterDelivered", serialize($notifyCenterDelivered));

		$offer_content = '';
		if(!empty($notifyOffer)){
			//for displaying the discount
			$offer_content = $notifyOffer["htmlContent"];

			//for including offers into delivered count
			if(!array_key_exists($notifyOffer['ID'], $notifyOfferDelivered)){
				$notifyOfferDelivered[$notifyOffer["ID"]] = 1;					//marking delivered in array's key
				$notifyCenterDeliveredCount++;
			}
		}
		updateOption("notifyOfferDelivered", serialize($notifyOfferDelivered));
		updateOption("notifyCenterDeliveredCount", $notifyCenterDeliveredCount);
		return array('notification_content' => $finalRefinedDataNotification, 'offer_content' => $offer_content, 'notif_count' => $notifyCenterDeliveredCount);
	}	

	public static function isAddonPlanLimitExceededAttemptV3() {//New pricing plan
		$addonsDetails['isExceeded'] = self::checkIsAddonPlanLimitExceededV3();
		$addonsDetails['addSiteHTML'] = getAddSiteHTMLV3();
		return $addonsDetails;
	}
	public static function addonSuiteLimitExceededDetailsV3() {//New pricing plan
		$addonsDetails['addonSuiteLimitExceededAttempt'] = self::checkIsAddonPlanLimitExceededV3('addonSuiteLimitExceededIllegally');
		$addonsDetails['illegalHTML'] = getAddonsIllegalHTMLV3();
		
		return $addonsDetails;
	}

	public static function checkIsAddonPlanLimitExceededV3($mode='') { //New pricing plan

		$suiteDetails = unserialize(getOption('suiteDetailsV3'));

		if(empty($suiteDetails) and !is_array($suiteDetails)) return(0);

		$activePlanSiteLimit=$suiteDetails['activePlanSiteLimit'];
		$activeTierPlan=$suiteDetails['activeTierPlan'];
		$pricingPlanTypes = unserialize(getOption('pricingPlanTypes'));
		if (empty($pricingPlanTypes)) {
			$pricingPlanTypes = array();
		}
		$siteCount = DB::getField("?:sites", "count(*)", "type = 'normal'");
		if(in_array($mode,array('addonSuiteLimitExceededIllegally')) && $siteCount>$activePlanSiteLimit && in_array($activeTierPlan, $pricingPlanTypes) && (empty($suiteDetails['isUnlimitedSites']))) return(1);
		else if(!in_array($mode,array('addonSuiteLimitExceededAttempt','addonSuiteLimitExceededIllegally')) && $siteCount>=$activePlanSiteLimit && in_array($activeTierPlan, $pricingPlanTypes) && (empty($suiteDetails['isUnlimitedSites']))) return(1);
		else return(0);
	}

	public static function getAddonSuitePlanActivityV3() { //New pricing plan
		$suiteDetails = unserialize(getOption('suiteDetailsV3'));

		if(empty($suiteDetails) and !is_array($suiteDetails)) return('');

		$addonSuiteActivity=$suiteDetails['addonSuiteActivity'];
		$cancelMessageFlag=$suiteDetails['cancelMessageFlag'];

		if($addonSuiteActivity=='cancelled' && $cancelMessageFlag!='shown') uninstallAddons($suiteDetails['activePlanAddons'],0);
		return($addonSuiteActivity);
	}

	public static function getWaitDataV3($params=array()){
	    $waitActions= manageCookies::cookieGet('waitActions');
	    if(empty($waitActions)) {
	        $waitActions = array();
	    }
		if(!empty($params)){
			foreach($params as $actionID => $value){
				if($value == 'sendData'){
					$waitActions[$actionID]['sendData'] = true;
				}
			}
	        manageCookies::cookieSet('waitActions',$waitActions,array('expire'=>0));
			return true;
		}


	    if(count($waitActions)==0) return false;
		$result = array();

		foreach($waitActions as $actionID => $waitAction){
			$sendData = false;
			$result[$actionID] = array();

			if( !empty($waitAction['sendData']) || ($waitAction['timeInitiated'] > 0 && $waitAction['timeInitiated'] < (time() - (5 *60))) ){
				$sendData = true;
			}
			$where = array(
		      		'query' =>  "actionID=':actionID'",
		      		'params' => array(
		               ':actionID'=>$actionID
	   				)
				);
			$totalRequest = DB::getField("?:history", "count(status)", $where);
			$where = array(
		      		'query' =>  "actionID = ':actionID' AND status IN ('pending', 'running', 'initiated', 'processingResponse', 'retry', 'writingRequest', 'scheduled','multiCallWaiting')",
		      		'params' => array(
		               ':actionID'=>$actionID
	   				)
				);
			$totalPendingRequest = DB::getField("?:history", "count(status)", $where);
			$where = array(
		      		'query' =>  "actionID = ':actionID' AND status = ':status'",
		      		'params' => array(
		               ':actionID'=>$actionID,
		               ':status'=>'completed'
	   				)
				);
			$totalSuccessRequest = DB::getField("?:history", "count(status)", $where);
			$where = array(
		      		'query' =>  "actionID = ':actionID' AND status IN ('error', 'netError')",
		      		'params' => array(
		               ':actionID'=>$actionID,
	   				)
				);
			$totalErrorRequest = DB::getField("?:history", "count(status)", $where);
			
			$result[$actionID]['total'] = $totalRequest;
			$result[$actionID]['loaded'] = $totalSuccessRequest+$totalErrorRequest;
			
			
			if($totalPendingRequest == 0) $sendData = true;

			if($sendData){
				$currentActionID = Reg::get('currentRequest.actionID');
				Reg::set('currentRequest.actionID', $actionID);
				$result[$actionID]['requiredData'] = $waitActions[$actionID]['requiredData'];
				$result[$actionID]['data'] = self::requiredData($result[$actionID]['requiredData']);
				$result[$actionID]['actionResult'] = self::getActionStatus($actionID);
				Reg::set('currentRequest.actionID', $currentActionID);
				$additionalStats = manageClientsAdditionalDataFetch::triggerAdditionalStats($actionID);
			}

			if (!empty($waitActions[$actionID]['runningData'])) {
				$result[$actionID]['runningData'] = self::runningData($waitActions[$actionID]['runningData']);
			}

			if($sendData || $waitAction['timeExpiresFromSession'] < time()){
				unset($waitActions[$actionID]);
			}
		}
		if (!empty($GLOBALS['globlaSendAction'])) {
			$waitActions =array_merge($waitActions, $GLOBALS['globlaSendAction']);
			unset($GLOBALS['globlaSendAction']);
		}
		if (!headers_sent()) {
			manageCookies::cookieSet('waitActions',$waitActions,array('expire'=>0));
		}
		return $result;

	}

	public static function defendwpAddonInstallationNotificationV3(){
		$defendwpAddonInstalled = isAddonInstalledV3('defendwp');
		if ($defendwpAddonInstalled) {
			return false;
		}
	
		$newAddons = getNewFreeAddonsAvailableV3();
		if(!empty($newAddons)){
			if (!isset($newAddons['defendwp'])) {
				return false;
			}
		}else{
			return false;
		}

		$details = getoption('defendwpAddonInstallationNotificationV3');
		if (empty($details)) {
			$details = array();
			$details['lastNotify'] = time();
			updateOption('defendwpAddonInstallationNotificationV3', json_encode($details));
			return true;
		}
		$details = json_decode($details, true);
		if (!empty($details['count']) && $details['count'] > 3) {
			return false;
		}
		if (!empty($details['lastNotify'])) {
			$isDismised = $details['isDismised'];
			if (!empty($isDismised) && $isDismised == 1) {
				$retryTime = 60 * 60 * 24 * 1; // send notification again after one day
				$lastNotify = $details['lastNotify'];
				$lastNotify += $retryTime;
				if ($lastNotify >= time()) {
					return false;
				}
				$details['count'] = empty($details['count'])?1:$details['count']+1;
				$details['lastNotify'] = time();
				$details['isDismised'] = 0;
				updateOption('defendwpAddonInstallationNotificationV3', json_encode($details));
			}
			if (!empty($details['count']) && $details['count'] > 3) {
				return false;
			}
			return true;	
		}
		
		return false;
	}

	public static function defendwpAddonInstallationNotificationDismissV3(){
		$details = getoption('defendwpAddonInstallationNotificationV3');
		if (empty($details)) {
			return false;
		}
		$details = json_decode($details, true);
		$details['isDismised'] = 1;
		updateOption('defendwpAddonInstallationNotificationV3', json_encode($details));
	}

	public static function stopAutoInstallV3(){
		deleteOption('infinitewpAccountCredentials');
	}
}



panelRequestManager::addClassToPanelRequest('panelRequestManagerV3');