//////////////////////////////////////////////////////////////
// install.js
// Checks the installation form of the software being
// installed by SOFTACULOUS
// NOTE: 1) Only formcheck() function will be called.
//       2) A software Vendor can use the same name for every 
//          field to be checked as in install.xml . It can be
//          called using $('fieldname').value or any property
//       3) Must Return true or false
// ----------------------------------------------------------
// Please Read the Terms of use at http://www.softaculous.com
// ----------------------------------------------------------
// (c)Softaculous Inc.
//////////////////////////////////////////////////////////////

function formcheck(){
	
	//Check the Admin Email
	if(window.check_punycode){
		if(!check_punycode($('admin_email').value)){
			alert('{{err_ademail}}');
			return false;
		}
		
		return true;
	}
	
	return true;
};

jQuery(document).ready(function(){
	
	const loginizerInput = document.getElementById('loginizer');
	const socialCheckbox = document.getElementById('lz-social-login');
	
	if (loginizerInput && socialCheckbox) {
		
		// Get the closest <label> ancestor of the hidden input
		const label = loginizerInput.closest('label');
		
		if (label) {
			
			// Inject new span after the original .sai_exp2
			const saiExp2 = label.querySelector('.sai_exp2');

			// Avoid injecting multiple times
			if (!label.querySelector('.lz-social-status')) {
				
				const socialStatusSpan = document.createElement('span');
				socialStatusSpan.className = 'sai_exp2 lz-social-status';
				socialStatusSpan.style.cssText =
				'overflow: hidden;text-overflow: ellipsis;display: -webkit-box;-webkit-line-clamp: 1;-webkit-box-orient: vertical;line-height:1.3;';
				socialStatusSpan.innerHTML =
				'Social Login - <span style="color:green;">Enabled</span> <span style="color:white;background-color:#FF9800;padding: 2px 5px;border-radius:6px;">New</span>';

				// Insert after sai_exp2
				saiExp2.parentNode.insertBefore(socialStatusSpan, saiExp2.nextSibling);
			}
			
			label.onclick = function (e) {
	
				e.preventDefault();
				
				// Ignore clicks on the loginizer or social login checkboxes
				if (
					e.target === loginizerInput ||
					e.target === socialCheckbox
				) {
					return; // Do nothing
				}
				
				loginizer_select_plugin(label);
			};
		}
	}
	
});

var lzClickCounter = 0;

function loginizer_select_plugin(e) {
	
	var inputElement = e.querySelector("input[type=\"checkbox\"]");
	inputElement.style.display = "none";
	
	var check_icon = e.querySelector("i.fas.fa-check-square");

	// Increase click count
	lzClickCounter++;

	// Get checkboxes
	const loginizer = document.getElementById('loginizer');
	const social = document.getElementById('lz-social-login');
	const statusText = document.getElementById('social-status');
	const statusSpan = e.querySelector('.lz-social-status span');

	// Determine toggle state using modulo
	const state = lzClickCounter % 3;

	if (state === 1) {
		
		// 1st click: uncheck social, keep loginizer checked
		social.checked = false;
		loginizer.checked = true;
		statusSpan.textContent = 'Disabled';
		statusSpan.style.color = 'red';
		
		e.style.backgroundColor = "#edfffd";
		e.style.border = "1px solid green";
		check_icon.style.display = "block";
	} else if (state === 2) {
		
		// 2nd click: uncheck both
		social.checked = false;
		loginizer.checked = false;
		statusSpan.textContent = 'Disabled';
		statusSpan.style.color = 'red';
		
		e.style.backgroundColor = "";
		e.style.border = "1px solid #9d989878";
		check_icon.style.display = "none";
	} else {
		
		// 3rd click (reset): check both
		social.checked = true;
		loginizer.checked = true;
		statusSpan.textContent = 'Enabled';
        statusSpan.style.color = 'green';
		
		e.style.backgroundColor = "#edfffd";
		e.style.border = "1px solid green";
		check_icon.style.display = "block";
		
		lzClickCounter = 0;
	}

	// Optional: toggle .sai_checkbox_tick visibility if you're visually showing tick
	const tickIcon = e.querySelector('.sai_checkbox_tick');
	if (loginizer.checked) {
		tickIcon.style.display = 'block';
	} else {
		tickIcon.style.display = 'none';
	}
	
	if(inputElement.disabled){
		e.style.backgroundColor = "#f0f0f0";
		e.style.color = "#6c757d";
	}
	
}