ATA.
 */
static inline bool
RTYPEDDATA_P(VALUE obj)
{
#if RUBY_DEBUG
    if (RB_UNLIKELY(! RB_TYPE_P(obj, RUBY_T_DATA))) {
        Check_Type(obj, RUBY_T_DATA);
        RBIMPL_UNREACHABLE_RETURN(false);
    }
#endif

    return rbimpl_rtypeddata_p(obj);
}

RBIMPL_ATTR_PURE_UNLESS_DEBUG()
RBIMPL_ATTR_ARTIFICIAL()
/* :TODO: can this function be __attribute__((returns_nonnull)) or not? */
/**
 * Queries for the type of given object.
 *
 * @param[in]  obj    Object in question
 * @return     Data type struct that corresponds to `obj`.
 * @pre        `obj` must be an instance of ::RTypedData.
 */
static inline const struct rb_data_type_struct *
RTYPEDDATA_TYPE(VALUE obj)
{
#if RUBY_DEBUG
    if (RB_UNLIKELY(! RTYPEDDATA_P(obj))) {
        rb_unexpected_type(obj, RUBY_T_DATA);
        RBIMPL_UNREACHABLE_RETURN(NULL);
    }
#endif

    return RTYPEDDATA(obj)->type;
}

/**
 * While  we don't  stop  you from  using  this  function, it  seems  to be  an
 * implementation  detail of  #TypedData_Make_Struct, which  is preferred  over
 * this one.
 *
 * @param[in]  klass      Ruby level class of the returning object.
 * @param[in]  type       The data type
 * @param[out] datap      Return pointer.
 * @param[in]  size       Size of the C struct.
 * @exception  rb_eTypeError  `klass` is not a class.
 * @exception  rb_eNoMemError  Out of memory.
 * @return     A created Ruby object.
 * @post       `*datap` points to the C struct wrapped by the returned object.
 */
static inline VALUE
rb_data_typed_object_make(VALUE klass, const rb_data_type_t *type, void **datap, size_t size)
{
    TypedData_Make_Struct0(result, klass, void, size, type, *datap);
    return result;
}

RBIMPL_ATTR_DEPRECATED(("by: rb_data_typed_object_wrap"))
/** @deprecated  This function was renamed to rb_data_typed_object_wrap(). */
static inline VALUE
rb_data_typed_object_alloc(VALUE klass, void *datap, const rb_data_type_t *type)
{
    return rb_data_typed_object_wrap(klass, datap, type);
}

#endif /* RBIMPL_RTYPEDDATA_H */
PK       ! xִZ  Z    ruby/internal/core/rfile.hnu [        #ifndef RBIMPL_RFILE_H                               /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_RFILE_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines struct ::RFile.
 */
#include "ruby/internal/core/rbasic.h"
#include "ruby/internal/cast.h"

/* rb_io_t is in ruby/io.h.  The header file has historically not been included
 * into ruby/ruby.h.  We follow that tradition. */
struct rb_io_t;

/**
 * Ruby's File  and IO.  Ruby's  IO are not  just file descriptors.   They have
 * buffers.   They also  have  encodings.  Various  information are  controlled
 * using this struct.
 */
struct RFile {

    /** Basic part, including flags and class. */
    struct RBasic basic;

    /** IO's specific fields. */
    struct rb_io_t *fptr;
};

/**
 * Convenient casting macro.
 *
 * @param   obj  An object, which is in fact an ::RFile.
 * @return  The passed object casted to ::RFile.
 */
#define RFILE(obj) RBIMPL_CAST((struct RFile *)(obj))
#endif /* RBIMPL_RFILE_H */
PK       ! 3e3  3    ruby/internal/symbol.hnu [        #ifndef RBIMPL_SYMBOL_H                              /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_SYMBOL_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult 