y developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_ATTR_RETURNS_NONNULL.
 */
#include "ruby/internal/has/attribute.h"

/** Wraps (or simulates) `__attribute__((returns_nonnull))` */
#if defined(_Ret_nonnull_)
# /* Take SAL definition. */
# define RBIMPL_ATTR_RETURNS_NONNULL() _Ret_nonnull_

#elif RBIMPL_HAS_ATTRIBUTE(returns_nonnull)
# define RBIMPL_ATTR_RETURNS_NONNULL() __attribute__((__returns_nonnull__))

#else
# define RBIMPL_ATTR_RETURNS_NONNULL() /* void */
#endif

#endif /* RBIMPL_ATTR_RETURNS_NONNULL_H */
PK       ! $      ruby/internal/attr/nonnull.hnu [        #ifndef RBIMPL_ATTR_NONNULL_H                        /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ATTR_NONNULL_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_ATTR_NONNULL.
 */
#include "ruby/internal/has/attribute.h"

/** Wraps (or simulates) `__attribute__((nonnull))` */
#if RBIMPL_HAS_ATTRIBUTE(nonnull)
# define RBIMPL_ATTR_NONNULL(list) __attribute__((__nonnull__ list))
# define RBIMPL_NONNULL_ARG(arg) RBIMPL_ASSERT_NOTHING
#else
# define RBIMPL_ATTR_NONNULL(list) /* void */
# define RBIMPL_NONNULL_ARG(arg) RUBY_ASSERT(arg)
#endif

#endif /* RBIMPL_ATTR_NONNULL_H */
PK       ! Z      ruby/internal/attr/alloc_size.hnu [        #ifndef RBIMPL_ATTR_ALLOC_SIZE_H                     /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ATTR_ALLOC_SIZE_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_ATTR_ALLOC_SIZE.
 */
#include "ruby/internal/has/attribute.h"

/** Wraps (or simulates) `__attribute__((alloc_size))` */
#if RBIMPL_HAS_ATTRIBUTE(alloc_size)
# define RBIMPL_ATTR_ALLOC_SIZE(tuple) __attribute__((__alloc_size__ tuple))
#else
# define RBIMPL_ATTR_ALLOC_SIZE(tuple) /* void */
#endif

#endif /* RBIMPL_ATTR_ALLOC_SIZE_H */
PK       ! 9u       ruby/internal/attr/pure.hnu [        #ifndef RBIMPL_ATTR_PURE_H                           /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ATTR_PURE_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_ATTR_PURE.
 */
#include "ruby/internal/compiler_since.h"
#include "ruby/internal/has/attribute.h"
#include "ruby/assert.h"

/** Wraps (or simulates) `__attribute__((pure))` */
#if RBIMPL_HAS_ATTRIBUTE(pure)
# define RBIMPL_ATTR_PURE() __attribute__((__pure__))
#elif RBIMPL_COMPILER_SINCE(SunPro, 5, 10, 0)
# define RBIMPL_ATTR_PURE() _Pragma("does_not_write_global_data")
#else
# define RBIMPL_ATTR_PURE() /* void */
#endif

/** Enables #RBIMPL_ATTR_PURE if and only if. ! #RUBY_DEBUG. */
#if !RUBY_DEBUG
# define RBIMPL_ATTR_PURE_UNLESS_DEBUG() RBIMPL_ATTR_PURE()
#else
# define RBIMPL_ATTR_PURE_UNLESS_DEBUG() /* void */
#endif

#endif /* RBIMPL_ATTR_PURE_H */
PK       ! \    '  ruby/internal/attr/enum_extensibility.hnu [        #ifndef RBIMPL_ATTR_ENUM_EXTENSIBILITY_H             /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ATTR_ENUM_EXTENSIBILITY_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      #RBIMPL_ATTR_ENUM_EXTENSIBILITY.
 */
#include "ruby/internal/has/attribute.h"

/** Wraps (or simulates) `__attribute__((enum_extensibility))` */
#if RBIMPL_HAS_ATTRIBUTE(enum_extensibility)
# define RBIMPL_ATTR_ENUM_EXTENSIBILITY(_) __attribute__((__enum_extensibility__(_)))
#else
# define RBIMPL_ATTR_ENUM_EXTENSIBILITY(_) /* void */
#endif

#endif /* RBIMPL_ATTR_ENUM_EXTENSIBILITY_H */
PK       ! B-      ruby/internal/attr/format.hnu [        #ifndef RBIMPL_ATTR_FORMAT_H                         /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ATTR_FORMAT_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_ATTR_FORMAT.
 */
#include "ruby/internal/has/attribute.h"

/** Wraps (or simulates) `__attribute__((format))` */
#if RBIMPL_HAS_ATTRIBUTE(format)
# define RBIMPL_ATTR_FORMAT(x, y, z) __attribute__((__format__(x, y, z)))
#else
# define RBIMPL_ATTR_FORMAT(x, y, z) /* void */
#endif

#if defined(__MINGW_PRINTF_FORMAT)
# define RBIMPL_PRINTF_FORMAT __MINGW_PRINTF_FORMAT
#else
# define RBIMPL_PRINTF_FORMAT __printf__
#endif

#endif /* RBIMPL_ATTR_FORMAT_H */
PK       ! Xa        ruby/internal/attr/noinline.hnu [        #ifndef RBIMPL_ATTR_NOINLINE_H                       /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ATTR_NOINLINE_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
