se    What `scheduler.io_write` returns `[-errno, size]`.
 */
VALUE rb_fiber_scheduler_io_write(VALUE scheduler, VALUE io, VALUE buffer, size_t length, size_t offset);

/**
 * Non-blocking read from the passed IO at the specified offset.
 *
 * @param[in]   scheduler    Target scheduler.
 * @param[out]  io           An io object to read from.
 * @param[in]   from         The offset in the given IO to read the data from.
 * @param[out]  buffer       The buffer to read the data to.
 * @param[in]   length       Requested number of bytes to read.
 * @param[in]   offset       The offset in the buffer to read to.
 * @retval      RUBY_Qundef  `scheduler` doesn't have `#io_read`.
 * @return      otherwise    What `scheduler.io_read` returns.
 */
VALUE rb_fiber_scheduler_io_pread(VALUE scheduler, VALUE io, rb_off_t from, VALUE buffer, size_t length, size_t offset);

/**
 * Non-blocking write to the passed IO at the specified offset.
 *
 * @param[in]   scheduler    Target scheduler.
 * @param[out]  io           An io object to write to.
 * @param[in]   from         The offset in the given IO to write the data to.
 * @param[in]   buffer       The buffer to write the data from.
 * @param[in]   length       Number of bytes to write.
 * @param[in]   offset       The offset in the buffer to write from.
 * @retval      RUBY_Qund