unction that raises
 *      Ruby exceptions as `noexcept`.
 *
 * - Q: How, then, can I assert that  a function I wrote doesn't raise any Ruby
 *      exceptions?
 *
 * - A: `__attribute__((__leaf__))` is for that purpose.  A function attributed
 *      as leaf can still throw C++  exceptions, but not Ruby's.  Note however,
 *      that it's extremely difficult -- if  not impossible -- to assert that a
 *      function  doesn't  raise any  Ruby  exceptions  at  all.  Use  of  that
 *      attribute is not  recommended; mere mortals can't properly  use that by
 *      hand.
 *
 * - Q: Does it make sense to attribute an inline function `noexcept`?
 *
 * - A: I thought so before.  But no, I don't think they are useful any longer.
 *
 *     - When an  inline function attributed `noexcept`  actually doesn't throw
 *       any  exceptions at  all:  these days  I don't  see  any difference  in
 *       generated assembly  by adding/removing this attribute.   C++ compilers
 *       get smarter and  smarter.  Today they can infer if  it actually throws
 *       or not without any annotations by humans (correct me if I'm wrong).
 *
 *     - When an inline function attributed `noexcepr` actually _does_ throw an
 *       exception:  they  have to  call  `std::terminate`  then (C++  standard
 *       mandates  so).  This  means exception  handling routines  are actually
 *       enforced, not  omitted.  This doesn't impact  runtime performance (The
 *       Itan