IMPL_ATTR_FORCEINLINE_H                    /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ATTR_FORCEINLINE_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_ATTR_FORCEINLINE.
 */
#include "ruby/internal/compiler_since.h"
#include "ruby/internal/has/attribute.h"

/**
 * Wraps (or  simulates) `__forceinline`.  MSVC complains  on declarations like
 * `static inline __forceinline void foo()`.   It  seems  MSVC's  `inline`  and
 * `__forceinline` are mutually exclusive.  We have to mimic that behaviour for
 * non-MSVC compilers.
 */
#if RBIMPL_COMPILER_SINCE(MSVC, 12, 0, 0)
# define RBIMPL_ATTR_FORCEINLINE() __forceinline
#elif RBIMPL_HAS_ATTRIBUTE(always_inline)
# define RBIMPL_ATTR_FORCEINLINE() __attribute__((__always_inline__)) inline
#else
# define RBIMPL_ATTR_FORCEINLINE() inline
#endif

#endif /* RBIMPL_ATTR_FORCEINLINE_H */
PK       ! .3\
  
    ruby/internal/attr/constexpr.hnu [        #ifndef RBIMPL_ATTR_CONSTEXPR_H                      /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ATTR_CONSTEXPR_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      #RBIMPL_ATTR_CONSTEXPR.
 */
#include "ruby/internal/has/feature.h"
#include "ruby/internal/compiler_is.h"

/** @cond INTERNAL_MACRO */
#if ! defined(__cplusplus)
# /* Makes no sense. */
# define RBIMPL_HAS_ATTR_CONSTEXPR_CXX11 0
# define RBIMPL_HAS_ATTR_CONSTEXPR_CXX14 0

#elif defined(__cpp_constexpr)
# /* https://isocpp.org/std/standing-documents/sd-6-sg10-feature-test-recommendations */
# define RBIMPL_HAS_ATTR_CONSTEXPR_CXX11 (__cpp_constexpr >= 200704L)
# define RBIMPL_HAS_ATTR_CONSTEXPR_CXX14 (__cpp_constexpr >= 201304L)

#elif RBIMPL_COMPILER_SINCE(MSVC, 19, 0, 0)
# define RBIMPL_HAS_ATTR_CONSTEXPR_CXX11 RBIMPL_COMPILER_SINCE(MSVC, 19, 00, 00)
# define RBIMPL_HAS_ATTR_CONSTEXPR_CXX14 RBIMPL_COMPILER_SINCE(MSVC, 19, 11, 00)

#elif RBIMPL_COMPILER_SINCE(SunPro, 5, 13, 0)
# define RBIMPL_HAS_ATTR_CONSTEXPR_CXX11 (__cplusplus >= 201103L)
# define RBIMPL_HAS_ATTR_CONSTEXPR_CXX14 (__cplusplus >= 201402L)

#elif RBIMPL_COMPILER_SINCE(GCC, 4, 9, 0)
# define RBIMPL_HAS_ATTR_CONSTEXPR_CXX11 (__cplusplus >= 201103L)
# define RBIMPL_HAS_ATTR_CONSTEXPR_CXX14 (__cplusplus >= 201402L)

#elif RBIMPL_HAS_FEATURE(cxx_relaxed_constexpr)
# define RBIMPL_HAS_ATTR_CONSTEXPR_CXX11 1
# define RBIMPL_HAS_ATTR_CONSTEXPR_CXX14 1

#elif RBIMPL_HAS_FEATURE(cxx_constexpr)
# define RBIMPL_HAS_ATTR_CONSTEXPR_CXX11 1
# define RBIMPL_HAS_ATTR_CONSTEXPR_CXX14 0

#else
# /* :FIXME: icpc must have constexpr but don't know how to detect. */
# define RBIMPL_HAS_ATTR_CONSTEXPR_CXX11 0
# define RBIMPL_HAS_ATTR_CONSTEXPR_CXX14 0
#endif
/** @endcond */

/** Wraps (or simulates) C++11 `constexpr`.  */
#if RBIMPL_HAS_ATTR_CONSTEXPR_CXX14
# define RBIMPL_ATTR_CONSTEXPR(_) constexpr

#elif RBIMPL_HAS_ATTR_CONSTEXPR_CXX11
# define RBIMPL_ATTR_CONSTEXPR(_) RBIMPL_ATTR_CONSTEXPR_ ## _
# define RBIMPL_ATTR_CONSTEXPR_CXX11 constexpr
# define RBIMPL_ATTR_CONSTEXPR_CXX14 /* void */

#else
# define RBIMPL_ATTR_CONSTEXPR(_) /* void */
#endif

/** Enables #RBIMPL_ATTR_CONSTEXPR if and only if. ! #RUBY_DEBUG. */
#if !RUBY_DEBUG
# define RBIMPL_ATTR_CONSTEXPR_UNLESS_DEBUG(_) RBIMPL_ATTR_CONSTEXPR(_)
#else
# define RBIMPL_ATTR_CONSTEXPR_UNLESS_DEBUG(_) /* void */
#endif

#endif /* RBIMPL_ATTR_CONSTEXPR_H */
PK       ! z+u  u    ruby/internal/attr/weakref.hnu [        #ifndef RBIMPL_ATTR_WEAKREF_H                        /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ATTR_WEAKREF_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_ATTR_WEAKREF.
 */
#include "ruby/internal/has/attribute.h"

/** Wraps (or simulates) `__attribute__((weakref))` */
#if RBIMPL_HAS_ATTRIBUTE(weakref)
# define RBIMPL_ATTR_WEAKREF(sym) __attribute__((__weakref__(# sym)))
#else
# define RBIMPL_ATTR_WEAKREF(sym) /* void */
#endif

#endif /* RBIMPL_ATTR_WEAKREF_H */
PK       ! ]ڲU      ruby/internal/attr/flag_enum.hnu [        #ifndef RBIMPL_ATTR_FLAG_ENUM_H                      /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ATTR_FLAG_ENUM_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_ATTR_FLAG_ENUM.
 * @see        https://clang.llvm.org/docs/AttributeReference.html#flag_enum
 */
#include "ruby/internal/has/attribute.h"

/** Wraps (or simulates) `__attribute__((flag_enum)` */
#if RBIMPL_HAS_ATTRIBUTE(flag_enum)
# define RBIMPL_ATTR_FLAG_ENUM() __attribute__((__flag_enum__))
#else
# define RBIMPL_ATTR_FLAG_ENUM() /* void */
#endif

#endif /* RBIMPLATTR_FLAG_ENUM_H */
PK       ! 	  	    ruby/internal/attr/artificial.hnu [        #ifndef RBIMPL_ATTR_ARTIFICIAL_H                     /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ATTR_ARTIFICIAL_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_ATTR_ARTIFICIAL.
 *
 * ### Q&A ###
 *
 * - Q: What is this attribute?  I don't get what GCC manual is talking about.
 *
 * - A: In  short  it  is  an  attribute to  manipulate  GDB  backtraces.   The
 *      attribute    makes    the   best    sense    when    it   comes    with
 *      __attribute__((always_inline)).   When a  function annotated  with this
 *      attribute gets inlined, and when you  somehow look at a backtrace which
 *      includes such  inlined call site,  then the backtrace shows  the caller
 *      and  not the  callee.  This  is handy  for instance  when an  identical
 *      function is inlined  more than once in a single  big function.  On such
 *      case it gets  vital to know where the inlining  happened in the callee.
 *      See also https://stackoverflow.com/a/21936099
 */
#include "ruby/internal/has/attribute.h"

/** Wraps (or simulates) `__attribute__((artificial))` */
#if RBIMPL_HAS_ATTRIBUTE(artificial)
# define RBIMPL_ATTR_ARTIFICIAL() __attribute__((__artificial__))
#else
# define RBIMPL_ATTR_ARTIFICIAL() /* void */
#endif

#endif /* RBIMPL_ATTR_ARTIFICIAL_H */
PK       ! r  r    ruby/internal/attr/warning.hnu [        #ifndef RBIMPL_ATTR_WARNING_H                        /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ATTR_WARNING_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_ATTR_WARNING.
 */
#include "ruby/internal/has/attribute.h"

/** Wraps (or simulates) `__attribute__((warning))` */
#if RBIMPL_HAS_ATTRIBUTE(warning)
# define RBIMPL_ATTR_WARNING(msg) __attribute__((__warning__ msg))
#else
# define RBIMPL_ATTR_WARNING(msg) /* void */
#endif

#endif /* RBIMPL_ATTR_WARNING_H */
PK       ! qcH  H    ruby/internal/iterator.hnu [        #ifndef RBIMPL_ITERATOR_H                            /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ITERATOR_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Block related APIs.
 */
#include "ruby/internal/attr/deprecated.h"
#include "ruby/internal/attr/noreturn.h"
#include "ruby/internal/dllexport.h"
#include "ruby/internal/value.h"

RBIMPL_SYMBOL_EXPORT_BEGIN()

/**
 * @private
 *
 * @deprecated  This macro once was a thing in the old days, but makes no sense
 *              any  longer today.   Exists  here  for backwards  compatibility
 *              only.  You can safely forget about it.
 */
#define RB_BLOCK_CALL_FUNC_STRICT 1

/**
 * @private
 *
 * @deprecated  This macro once was a thing in the old days, but makes no sense
 *              any  longer today.   Exists  here  for backwards  compatibility
 *              only.  You can safely forget about it.
 */
#define RUBY_BLOCK_CALL_FUNC_TAKES_BLOCKARG 1

/**
 * Shim for block function parameters.  Historically ::rb_block_call_func_t had
 * only two parameters.  Over time it evolved  to have much more than that.  By
 * using this macro you can absorb such API differences.
 *
 * ```CXX
 * // This works since 2.1.0
 * VALUE my_own_iterator(RB_BLOCK_CALL_FUNC_ARGLIST(y, c));
 * ```
 */
#define RB_BLOCK_CALL_FUNC_ARGLIST(yielded_arg, callback_arg) \
    VALUE yielded_arg, VALUE callback_arg, int argc, const VALUE *argv, VALUE blockarg

/**
 * This is the  type of a function that the  interpreter expect for C-backended
 * blocks.  Blocks are  often written in Ruby.  But C  extensions might want to
 * have their own blocks.  In order to  do so authors have to create a separate
 * C function of this type, and pass its pointer to rb_block_call().
 *
 * ```CXX
 * VALUE
 * my_own_iterator(RB_BLOCK_CALL_FUNC_ARGLIST(y, c))
 * {
 *     const auto plus = rb_intern("+");
 *     return rb_funcall(c, plus, 1, y);
 * }
 *
 * VALUE
 * my_own_method(VALUE self)
 * {
 *     const auto each = rb_intern("each");
 *     return rb_block_call(self, each, 0, 0, my_own_iterator, self);
 * }
 * ```
 */
typedef VALUE rb_block_call_func(RB_BLOCK_CALL_FUNC_ARGLIST(yielded_arg, callback_arg));

/**
 * Shorthand type that represents an iterator-written-in-C function pointer.
 */
typedef rb_block_call_func *rb_block_call_func_t;

/**
 * This is a shorthand of calling `obj.each`.
 *
 * @param[in]  obj  The receiver.
 * @return     What `obj.each` returns.
 *
 * @internal
 *
 * Does anyone still need it?  This API  was to use with rb_iterate(), which is
 * marked deprecated (see below).  Old idiom to call an iterator was:
 *
 * ```CXX
 * VALUE recv;
 * VALUE iter_func(ANYARGS);
 * VALUE iter_data;
 * rb_iterate(rb_each, recv, iter_func, iter_data);
 * ```
 */
VALUE rb_each(VALUE obj);

/**
 * Yields the block.  In Ruby there is  a concept called a block.  You can pass
 * one to a  method.  In a method, when  called with a block, you  can yield it
 * using this function.
 *
 * ```CXX
 * VALUE
 * iterate(VALUE self)
 * {
 *     extern int get_n(VALUE);
 *     extern VALUE get_v(VALUE, VALUE);
 *     const auto n = get_n(self);
 *
 *     for (int i=0; i<n; i++) {
 *         auto v = get_v(self, i);
 *
 *         rb_yield(v);
 *     }
 *     return self;
 * }
 * ```
 *
 * @param[in]  val                 Passed to the block.
 * @exception  rb_eLocalJumpError  There is no block given.
 * @return     Evaluated value of the given block.
 */
VALUE rb_yield(VALUE val);

/**
 * Identical to rb_yield(),  except it takes variadic number  of parameters and
 * pass them to the block.
 *
 * @param[in]  n                   Number of parameters.
 * @param[in]  ...                 List of arguments passed to the block.
 * @exception  rb_eLocalJumpError  There is no block given.
 * @return     Evaluated value of the given block.
 */
VALUE rb_yield_values(int n, ...);

/**
 * Identical to rb_yield_values(),  except it takes the parameters as a C array
 * instead of variadic arguments.
 *
 * @param[in]  n                   Number of parameters.
 * @param[in]  argv                List of arguments passed to the block.
 * @exception  rb_eLocalJumpError  There is no block given.
 * @return     Evaluated value of the given block.
 */
VALUE rb_yield_values2(int n, const VALUE *argv);

/**
 * Identical to  rb_yield_values2(), except you  can specify how to  handle the
 * last element of the given array.
 *
 * @param[in]  n                   Number of parameters.
 * @param[in]  argv                List of arguments passed to the block.
 * @param[in]  kw_splat            Handling of keyword parameters:
 *   - RB_NO_KEYWORDS              `ary`'s last is not a keyword argument.
 *   - RB_PASS_KEYWORDS            `ary`'s last is a keyword argument.
 *   - RB_PASS_CALLED_KEYWORDS     makes no sense here.
 * @exception  rb_eLocalJumpError  There is no block given.
 * @return     Evaluated value of the given block.
 */
VALUE rb_yield_values_kw(int n, const VALUE *argv, int kw_splat);

/**
 * Identical to  rb_yield_values(), except it  splats an array to  generate the
 * list of parameters.
 *
 * @param[in]  ary                 Array to splat.
 * @exception  rb_eLocalJumpError  There is no block given.
 * @return     Evaluated value of the given block.
 */
VALUE rb_yield_splat(VALUE ary);

/**
 * Identical to rb_yield_splat(), except you can specify how to handle the last
 * element of the given array.
 *
 * @param[in]  ary                 Array to splat.
 * @param[in]  kw_splat            Handling of keyword parameters:
 *   - RB_NO_KEYWORDS              `ary`'s last is not a keyword argument.
 *   - RB_PASS_KEYWORDS            `ary`'s last is a keyword argument.
 *   - RB_PASS_CALLED_KEYWORDS     makes no sense here.
 * @exception  rb_eLocalJumpError  There is no block given.
 * @return     Evaluated value of the given block.
 */
VALUE rb_yield_splat_kw(VALUE ary, int kw_splat);

/**
 * Pass a passed block.
 *
 * Sometimes you  want to "pass" a  block form one method  to another.  Suppose
 * you have this Ruby method `foo`:
 *
 * ```ruby
 * def foo(x, y)
 *   x.open(y) do |*z|
 *     yield(*z)
 *   end
 * end
 * ```
 *
 * And  suppose you  want  to  translate this  into  C.  Then  rb_yield_block()
 * function is usable in this situation.
 *
 * ```CXX
 * VALUE
 * foo_translated_into_C(VALUE self, VALUE x, VALUE y)
 * {
 *     const auto open = rb_intern("open");
 *
 *     return rb_block_call(x, open, 1, &y, rb_yield_block, Qfalse);
 *     //                                   ^^^^^^^^^^^^^^  Here.
 * }
 * ```
 *
 * @see rb_funcall_passing_block
 *
 * @internal
 *
 * @shyouhei  honestly  doesn't understand  why  this  is needed,  given  there
 * already was rb_funcall_passing_block()  at the time it  was implemented.  If
 * somebody knows its raison d'etre, please improve the document :FIXME:
 */
VALUE rb_yield_block(RB_BLOCK_CALL_FUNC_ARGLIST(yielded_arg, callback_arg)); /* rb_block_call_func */

/**
 * Determines if the current method is given a keyword argument.
 *
 * @retval  false  No keyword argument is given.
 * @retval  true   Keyword argument(s) are given.
 * @ingroup defmethod
 */
int rb_keyword_given_p(void);

/**
 * Determines if the current method is given a block.
 *
 * @retval  false  No block is given.
 * @retval  true   A block is given.
 * @ingroup defmethod
 *
 * @internal
 *
 * This function should have returned a bool.   But at the time it was designed
 * the project was entirely written in K&R C.
 */
int rb_block_given_p(void);

/**
 * Declares that the current method needs a block.
 *
 * @exception  rb_eLocalJumpError  No block given.
 * @ingroup    defmethod
 */
void rb_need_block(void);

#ifndef __cplusplus
RBIMPL_ATTR_DEPRECATED(("by: rb_block_call since 1.9"))
#endif
/**
 * Old way to iterate a block.
 *
 * @deprecated     This is an old API.  Use rb_block_call() instead.
 * @warning        The passed  function must at  least once call a  ruby method
 *                 (to handle interrupts etc.)
 * @param[in]      func1  A function that could yield a value.
 * @param[in,out]  data1  Passed to `func1`
 * @param[in]      proc   A function acts as a block.
 * @param[in,out]  data2  Passed to `proc` as the data2 parameter.
 * @return         What `func1` returns.
 */
VALUE rb_iterate(VALUE (*func1)(VALUE), VALUE data1, rb_block_call_func_t proc, VALUE data2);

#ifdef __cplusplus
namespace ruby {
namespace backward {
/**
 * Old way to iterate a block.
 *
 * @deprecated     This is an old API.  Use rb_block_call() instead.
 * @warning        The passed  function must at  least once call a  ruby method
 *                 (to handle interrupts etc.)
 * @param[in]      iter   A function that could yield a value.
 * @param[in,out]  data1  Passed to `func1`
 * @param[in]      bl     A function acts as a block.
 * @param[in,out]  data2  Passed to `proc` as the data2 parameter.
 * @return         What `func1` returns.
 */
static inline VALUE
rb_iterate_deprecated(VALUE (*iter)(VALUE), VALUE data1, rb_block_call_func_t bl, VALUE data2)
{
    return ::rb_iterate(iter, data1, bl, data2);
}}}

RBIMPL_ATTR_DEPRECATED(("by: rb_block_call since 1.9"))
VALUE rb_iterate(VALUE (*func1)(VALUE), VALUE data1, rb_block_call_func_t proc, VALUE data2);
#endif

/**
 * Identical to  rb_funcallv(), except it  additionally passes a function  as a
 * block.  When the  method yields, `proc` is called with  the yielded value as
 * its first  argument, and  `data2` as  the second.   Yielded values  would be
 * packed into an array if multiple values are yielded at once.
 *
 * @param[in,out]  obj    Receiver.
 * @param[in]      mid    Method signature.
 * @param[in]      argc   Number of arguments.
 * @param[in]      argv   Arguments passed to `obj.mid`.
 * @param[in]      proc   A function acts as a block.
 * @param[in,out]  data2  Passed to `proc` as the data2 parameter.
 * @return         What `obj.mid` returns.
 */
VALUE rb_block_call(VALUE obj, ID mid, int argc, const VALUE *argv, rb_block_call_func_t proc, VALUE data2);

/**
 * Identical to rb_funcallv_kw(), except it additionally passes a function as a
 * block.   It can  also be  seen as  a routine  identical to  rb_block_call(),
 * except it handles keyword-ness of `argv[argc-1]`.
 *
 * @param[in,out]  obj       Receiver.
 * @param[in]      mid       Method signature.
 * @param[in]      argc      Number of arguments including the keywords.
 * @param[in]      argv      Arguments passed to `obj.mid`.
 * @param[in]      proc      A function acts as a block.
 * @param[in,out]  data2     Passed to `proc` as the data2 parameter.
 * @param[in]      kw_splat  Handling of keyword parameters:
 *   - RB_NO_KEYWORDS           `argv`'s last is not a keyword argument.
 *   - RB_PASS_KEYWORDS         `argv`'s last is a keyword argument.
 *   - RB_PASS_CALLED_KEYWORDS  it depends if there is a passed block.
 * @return         What `obj.mid` returns.
 */
VALUE rb_block_call_kw(VALUE obj, ID mid, int argc, const VALUE *argv, rb_block_call_func_t proc, VALUE data2, int kw_splat);

/**
 * Identical  to rb_rescue2(),  except it  does not  take a  list of  exception
 * classes.  This is a shorthand of:
 *
 * ```CXX
 * rb_rescue2(b_proc, data1, r_proc, data2, rb_eStandardError, (VALUE)0);
 * ```
 *
 * @param[in]      b_proc  A function which potentially raises an exception.
 * @param[in,out]  data1   Passed to `b_proc`.
 * @param[in]      r_proc  A function which rescues an exception in `b_proc`.
 * @param[in,out]  data2   The first argument of `r_proc`.
 * @return         The return value of `b_proc`  if no exception occurs, or the
 *                 return value of `r_proc` otherwise.
 * @see            rb_rescue
 * @see            rb_ensure
 * @see            rb_protect
 * @ingroup        exception
 */
VALUE rb_rescue(VALUE (*b_proc)(VALUE), VALUE data1, VALUE (*r_proc)(VALUE, VALUE), VALUE data2);

/**
 * An equivalent of `rescue` clause.
 *
 * First  it calls  the function  `b_proc` with  `data1` as  the argument.   If
 * nothing is thrown the function happily returns the return value of `b_proc`.
 * When `b_proc` raises an exception, and the exception is a kind of one of the
 * given  exception classes,  it  then  calls `r_proc`  with  `data2` and  that
 * exception.  If the exception does not match any of them, it propagates.
 *
 * @param[in]      b_proc  A function which potentially raises an exception.
 * @param[in,out]  data1   Passed to `b_proc`.
 * @param[in]      r_proc  A function which rescues an exception in `b_proc`.
 * @param[in,out]  data2   The first argument of `r_proc`.
 * @param[in]      ...     1 or  more exception classes.  Must be terminated by
 *                         `(VALUE)0`
 * @return         The return value of `b_proc`  if no exception occurs, or the
 *                 return value of `r_proc` otherwise.
 * @see            rb_rescue
 * @see            rb_ensure
 * @see            rb_protect
 * @ingroup        exception
 */
VALUE rb_rescue2(VALUE (*b_proc)(VALUE), VALUE data1, VALUE (*r_proc)(VALUE, VALUE), VALUE data2, ...);

/**
 * Identical to  rb_rescue2(), except  it takes  `va_list` instead  of variadic
 * number  of  arguments.   This  is  exposed to  3rd  parties  because  inline
 * functions use it.  Basically you don't have to bother.
 *
 * @param[in]      b_proc  A function which potentially raises an exception.
 * @param[in,out]  data1   Passed to `b_proc`.
 * @param[in]      r_proc  A function which rescues an exception in `b_proc`.
 * @param[in,out]  data2   The first argument of `r_proc`.
 * @param[in]      ap      1 or  more exception classes.  Must be terminated by
 *                         `(VALUE)0`
 * @return         The return value of `b_proc`  if no exception occurs, or the
 *                 return value of `r_proc` otherwise.
 * @see            rb_rescue
 * @see            rb_ensure
 * @see            rb_protect
 * @ingroup        exception
 */
VALUE rb_vrescue2(VALUE (*b_proc)(VALUE), VALUE data1, VALUE (*r_proc)(VALUE, VALUE), VALUE data2, va_list ap);

/**
 * An equivalent to `ensure` clause.   Calls the function `b_proc` with `data1`
 * as the argument, then calls `e_proc` with `data2` when execution terminated.
 *
 * @param[in]      b_proc     A function representing begin clause.
 * @param[in,out]  data1      Passed to `b_proc`.
 * @param[in]      e_proc     A function representing ensure clause.
 * @param[in,out]  data2      Passed to `e_proc`.
 * @retval         RUBY_Qnil  exception occurred inside of `b_proc`.
 * @retval         otherwise  The return value of `b_proc`.
 * @see            rb_rescue
 * @see            rb_rescue2
 * @see            rb_protect
 * @ingroup        exception
 */
VALUE rb_ensure(VALUE (*b_proc)(VALUE), VALUE data1, VALUE (*e_proc)(VALUE), VALUE data2);

/**
 * Executes the passed block and catches values thrown from inside of it.
 *
 * In case  the block does  not contain any  throw`, this function  returns the
 * value of the last expression evaluated.
 *
 * ```CXX
 * VALUE
 * iter(RB_BLOCK_CALL_FUNC_ARGLIST(yielded, callback))
 * {
 *     return INT2FIX(123);
 * }
 *
 * VALUE
 * method(VALUE self)
 * {
 *     return rb_catch("tag", iter, Qnil); // returns 123
 * }
 * ```
 *
 * In case there do exist `throw`, Ruby searches up its execution context for a
 * `catch` block.   When a matching catch  is found, the block  stops executing
 * and returns that thrown value instead.
 *
 * ```CXX
 * VALUE
 * iter(RB_BLOCK_CALL_FUNC_ARGLIST(yielded, callback))
 * {
 *     rb_throw("tag", 456);
 *     return INT2FIX(123);
 * }
 *
 * VALUE
 * method(VALUE self)
 * {
 *     return rb_catch("tag", iter, Qnil); // returns 456
 * }
 * ```
 *
 * @param[in]      tag   Arbitrary tag string.
 * @param[in]      func  Function pointer that acts as a block.
 * @param[in,out]  data  Extra parameter passed to `func`.
 * @return         Either caught value for `tag`, or the return value of `func`
 *                 if nothing is thrown.
 */
VALUE rb_catch(const char *tag, rb_block_call_func_t func, VALUE data);

/**
 * Identical to rb_catch(), except it catches arbitrary Ruby objects.
 *
 * @param[in]      tag   Arbitrary tag object.
 * @param[in]      func  Function pointer that acts as a block.
 * @param[in,out]  data  Extra parameter passed to `func`.
 * @return         Either caught value for `tag`, or the return value of `func`
 *                 if nothing is thrown.
 */
VALUE rb_catch_obj(VALUE tag, rb_block_call_func_t func, VALUE data);

RBIMPL_ATTR_NORETURN()
/**
 * Transfers control to the end of  the active `catch` block waiting for `tag`.
 * Raises  rb_eUncughtThrow if  there is  no `catch`  block for  the tag.   The
 * second  parameter supplies  a  return  value for  the  `catch` block,  which
 * otherwise defaults to ::RUBY_Qnil.  For examples, see rb_catch().
 *
 * @param[in]  tag               Tag string.
 * @param[in]  val               Value to throw.
 * @exception  rb_eUncughtThrow  There is no corresponding `catch` clause.
 * @note       It never returns.
 */
void rb_throw(const char *tag, VALUE val);

RBIMPL_ATTR_NORETURN()
/**
 * Identical to rb_throw(), except it allows  arbitrary Ruby object to become a
 * tag.
 *
 * @param[in]  tag               Arbitrary object.
 * @param[in]  val               Value to throw.
 * @exception  rb_eUncughtThrow  There is no corresponding `catch` clause.
 * @note       It never returns.
 */
void rb_throw_obj(VALUE tag, VALUE val);

RBIMPL_SYMBOL_EXPORT_END()

#endif /* RBIMPL_ITERATOR_H */
PK       ! O^'  '    ruby/internal/globals.hnu [        #ifndef RBIMPL_GLOBALS_H                             /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_GLOBALS_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Ruby-level global variables / constants, visible from C.
 */
#include "ruby/internal/attr/pure.h"
#include "ruby/internal/dllexport.h"
#include "ruby/internal/fl_type.h"
#include "ruby/internal/special_consts.h"
#include "ruby/internal/value.h"
#include "ruby/internal/value_type.h"

/**
 * @defgroup object Core objects and their operations
 *
 * @internal
 *
 * There are several  questionable constants listed in this  header file.  They
 * are intentionally left untouched for purely academic backwards compatibility
 * concerns.  But for instance do any one of 3rd party extension libraries even
 * need to know that there is NameError::Message?
 *
 * @endinternal
 *
 * @{
 */

RBIMPL_SYMBOL_EXPORT_BEGIN()

/**
 * @private
 *
 * @deprecated  This macro once was a thing in the old days, but makes no sense
 *              any  longer today.   Exists  here  for backwards  compatibility
 *              only.  You can safely forget about it.
 */
#define RUBY_INTEGER_UNIFICATION 1

RUBY_EXTERN VALUE rb_mKernel;                 /**< `Kernel` module. */
RUBY_EXTERN VALUE rb_mComparable;             /**< `Comparable` module. */
RUBY_EXTERN VALUE rb_mEnumerable;             /**< `Enumerable` module. */
RUBY_EXTERN VALUE rb_mErrno;                  /**< `Errno` module. */
RUBY_EXTERN VALUE rb_mFileTest;               /**< `FileTest` module. */
RUBY_EXTERN VALUE rb_mGC;                     /**< `GC` module. */
RUBY_EXTERN VALUE rb_mMath;                   /**< `Math` module. */
RUBY_EXTERN VALUE rb_mProcess;                /**< `Process` module. */
RUBY_EXTERN VALUE rb_mWaitReadable;           /**< `IO::WaitReadable` module. */
RUBY_EXTERN VALUE rb_mWaitWritable;           /**< `IO::WaitReadable` module. */

RUBY_EXTERN VALUE rb_cBasicObject;            /**< `BasicObject` class. */
RUBY_EXTERN VALUE rb_cObject;                 /**< `Object` class. */
RUBY_EXTERN VALUE rb_cArray;                  /**< `Array` class. */
RUBY_EXTERN VALUE rb_cBinding;                /**< `Binding` class. */
RUBY_EXTERN VALUE rb_cClass;                  /**< `Class` class. */
RUBY_EXTERN VALUE rb_cDir;                    /**< `Dir` class. */
RUBY_EXTERN VALUE rb_cEncoding;               /**< `Encoding` class. */
RUBY_EXTERN VALUE rb_cEnumerator;             /**< `Enumerator` class. */
RUBY_EXTERN VALUE rb_cFalseClass;             /**< `FalseClass` class. */
RUBY_EXTERN VALUE rb_cFile;                   /**< `File` class. */
RUBY_EXTERN VALUE rb_cComplex;                /**< `Complex` class. */
RUBY_EXTERN VALUE rb_cFloat;                  /**< `Float` class. */
RUBY_EXTERN VALUE rb_cHash;                   /**< `Hash` class. */
RUBY_EXTERN VALUE rb_cIO;                     /**< `IO` class. */
RUBY_EXTERN VALUE rb_cInteger;                /**< `Module` class. */
RUBY_EXTERN VALUE rb_cMatch;                  /**< `MatchData` class. */
RUBY_EXTERN VALUE rb_cMethod;                 /**< `Method` class. */
RUBY_EXTERN VALUE rb_cModule;                 /**< `Module` class. */
RUBY_EXTERN VALUE rb_cRefinement;             /**< `Refinement` class. */
RUBY_EXTERN VALUE rb_cNameErrorMesg;          /**< `NameError::Message` class. */
RUBY_EXTERN VALUE rb_cNilClass;               /**< `NilClass` class. */
RUBY_EXTERN VALUE rb_cNumeric;                /**< `Numeric` class. */
RUBY_EXTERN VALUE rb_cProc;                   /**< `Proc` class. */
RUBY_EXTERN VALUE rb_cRandom;                 /**< `Random` class. */
RUBY_EXTERN VALUE rb_cRange;                  /**< `Range` class. */
RUBY_EXTERN VALUE rb_cRational;               /**< `Rational` class. */
RUBY_EXTERN VALUE rb_cRegexp;                 /**< `Regexp` class. */
RUBY_EXTERN VALUE rb_cStat;                   /**< `File::Stat` class. */
RUBY_EXTERN VALUE rb_cString;                 /**< `String` class. */
RUBY_EXTERN VALUE rb_cStruct;                 /**< `Struct` class. */
RUBY_EXTERN VALUE rb_cSymbol;                 /**< `Sumbol` class. */
RUBY_EXTERN VALUE rb_cThread;                 /**< `Thread` class. */
RUBY_EXTERN VALUE rb_cTime;                   /**< `Time` class. */
RUBY_EXTERN VALUE rb_cTrueClass;              /**< `TrueClass` class. */
RUBY_EXTERN VALUE rb_cUnboundMethod;          /**< `UnboundMethod` class. */

/**
 * @}
 * @addtogroup exception
 * @{
 */

RUBY_EXTERN VALUE rb_eException;                 /**< Mother of all exceptions. */
RUBY_EXTERN VALUE rb_eStandardError;             /**< `StandardError` exception. */
RUBY_EXTERN VALUE rb_eSystemExit;                /**< `SystemExit` exception. */
RUBY_EXTERN VALUE rb_eInterrupt;                 /**< `Interrupt` exception. */
RUBY_EXTERN VALUE rb_eSignal;                    /**< `SignalException` exception. */
RUBY_EXTERN VALUE rb_eFatal;                     /**< `fatal` exception. */
RUBY_EXTERN VALUE rb_eArgError;                  /**< `ArgumentError` exception. */
RUBY_EXTERN VALUE rb_eEOFError;                  /**< `EOFError` exception. */
RUBY_EXTERN VALUE rb_eIndexError;                /**< `IndexError` exception. */
RUBY_EXTERN VALUE rb_eStopIteration;             /**< `StopIteration` exception. */
RUBY_EXTERN VALUE rb_eKeyError;                  /**< `KeyError` exception. */
RUBY_EXTERN VALUE rb_eRangeError;                /**< `RangeError` exception. */
RUBY_EXTERN VALUE rb_eIOError;                   /**< `IOError` exception. */
RUBY_EXTERN VALUE rb_eRuntimeError;              /**< `RuntimeError` exception. */
RUBY_EXTERN VALUE rb_eFrozenError;               /**< `FrozenError` exception. */
RUBY_EXTERN VALUE rb_eSecurityError;             /**< `SecurityError` exception. */
RUBY_EXTERN VALUE rb_eSystemCallError;           /**< `SystemCallError` exception. */
RUBY_EXTERN VALUE rb_eThreadError;               /**< `ThreadError` exception. */
RUBY_EXTERN VALUE rb_eTypeError;                 /**< `TypeError` exception. */
RUBY_EXTERN VALUE rb_eZeroDivError;              /**< `ZeroDivisionError` exception. */
RUBY_EXTERN VALUE rb_eNotImpError;               /**< `NotImplementedError` exception. */
RUBY_EXTERN VALUE rb_eNoMemError;                /**< `NoMemoryError` exception. */
RUBY_EXTERN VALUE rb_eNoMethodError;             /**< `NoMethodError` exception. */
RUBY_EXTERN VALUE rb_eFloatDomainError;          /**< `FloatDomainError` exception. */
RUBY_EXTERN VALUE rb_eLocalJumpError;            /**< `LocalJumpError` exception. */
RUBY_EXTERN VALUE rb_eSysStackError;             /**< `SystemStackError` exception. */
RUBY_EXTERN VALUE rb_eRegexpError;               /**< `RegexpError` exception. */
RUBY_EXTERN VALUE rb_eEncodingError;             /**< `EncodingError` exception. */
RUBY_EXTERN VALUE rb_eEncCompatError;            /**< `Encoding::CompatibilityError` exception. */
RUBY_EXTERN VALUE rb_eNoMatchingPatternError;    /**< `NoMatchingPatternError` exception. */
RUBY_EXTERN VALUE rb_eNoMatchingPatternKeyError; /**< `NoMatchingPatternKeyError` exception. */

RUBY_EXTERN VALUE rb_eScriptError;               /**< `ScriptError` exception. */
RUBY_EXTERN VALUE rb_eNameError;                 /**< `NameError` exception. */
RUBY_EXTERN VALUE rb_eSyntaxError;               /**< `SyntaxError` exception. */
RUBY_EXTERN VALUE rb_eLoadError;                 /**< `LoadError` exception. */

RUBY_EXTERN VALUE rb_eMathDomainError;           /**< `Math::DomainError` exception. */

/**
 * @}
 * @addtogroup object
 * @{
 */

RUBY_EXTERN VALUE rb_stdin;                      /**< `STDIN` constant. */
RUBY_EXTERN VALUE rb_stdout;                     /**< `STDOUT` constant. */
RUBY_EXTERN VALUE rb_stderr;                     /**< `STDERR` constant. */

RBIMPL_ATTR_PURE()
/**
 * Object  to class  mapping  function.   Every object  have  its class.   This
 * function obtains that.
 *
 * @param[in]  obj  Target object to query.
 * @return     The class of the given object.
 *
 * @internal
 *
 * This  function is  a super-duper  hot  path.  Optimised  targeting modern  C
 * compilers and x86_64 architecture.
 */
static inline VALUE
rb_class_of(VALUE obj)
{
    if (! RB_SPECIAL_CONST_P(obj)) {
        return RBASIC_CLASS(obj);
    }
    else if (obj == RUBY_Qfalse) {
        return rb_cFalseClass;
    }
    else if (obj == RUBY_Qnil) {
        return rb_cNilClass;
    }
    else if (obj == RUBY_Qtrue) {
        return rb_cTrueClass;
    }
    else if (RB_FIXNUM_P(obj)) {
        return rb_cInteger;
    }
    else if (RB_STATIC_SYM_P(obj)) {
        return rb_cSymbol;
    }
    else if (RB_FLONUM_P(obj)) {
        return rb_cFloat;
    }

#if !RUBY_DEBUG
    RBIMPL_UNREACHABLE_RETURN(Qfalse);
#else
    RUBY_ASSERT_FAIL("unexpected type");
#endif
}

#define CLASS_OF rb_class_of /**< @old{rb_class_of} */

RBIMPL_SYMBOL_EXPORT_END()

/** @} */

#endif /* RBIMPL_GLOBALS_H */
PK       ! |D_Wy8  y8    ruby/internal/value_type.hnu [        #ifndef RBIMPL_VALUE_TYPE_H                          /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_VALUE_TYPE_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines enum ::ruby_value_type.
 */
#include "ruby/internal/assume.h"
#include "ruby/internal/attr/artificial.h"
#include "ruby/internal/attr/cold.h"
#include "ruby/internal/attr/enum_extensibility.h"
#include "ruby/internal/attr/forceinline.h"
#include "ruby/internal/attr/pure.h"
#include "ruby/internal/cast.h"
#include "ruby/internal/constant_p.h"
#include "ruby/internal/core/rbasic.h"
#include "ruby/internal/dllexport.h"
#include "ruby/internal/error.h"
#include "ruby/internal/has/builtin.h"
#include "ruby/internal/special_consts.h"
#include "ruby/internal/stdbool.h"
#include "ruby/internal/value.h"
#include "ruby/assert.h"

#if defined(T_DATA)
/*
 * :!BEWARE!: (Recent?)   Solaris' <nfs/nfs.h>  have conflicting  definition of
 * T_DATA.  Let us stop here.  Please have a workaround like this:
 *
 * ```C
 * #include <ruby/ruby.h> // <- Include this one first.
 * #undef T_DATA          // <- ... and stick to RUBY_T_DATA forever.
 * #include <nfs/nfs.h