GER_UNIFICATION 1
#define RB_INTEGER_TYPE_P(obj) rb_integer_type_p(obj)
#if defined __GNUC__ && !GCC_VERSION_SINCE(4, 3, 0)
/* clang 3.x (4.2 compatible) can't eliminate CSE of RB_BUILTIN_TYPE
 * in inline function and caller function */
#define rb_integer_type_p(obj) \
    __extension__ ({ \
	const VALUE integer_type_obj = (obj); \
	(RB_FIXNUM_P(integer_type_obj) || \
	 (!RB_SPECIAL_CONST_P(integer_type_obj) && \
	  RB_BUILTIN_TYPE(integer_type_obj) == RUBY_T_BIGNUM)); \
    })
#else
static inline int
rb_integer_type_p(VALUE obj)
{
    return (RB_FIXNUM_P(obj) ||
	    (!RB_SPECIAL_CONST_P(obj) &&
	     RB_BUILTIN_TYPE(obj) == RUBY_T_BIGNUM));
}
#endif

#if SIZEOF_INT < SIZEOF_LONG
# define RB_INT2NUM(v) RB_INT2FIX((int)(v))
# define RB_UINT2NUM(v) RB_LONG2FIX((unsigned int)(v))
#else
static inline VALUE
rb_int2num_inline(int v)
{
    if (RB_FIXABLE(v))
	return RB_INT2FIX(v);
    else
	return rb_int2big(v);
}
#define RB_INT2NUM(x) rb_int2num_inline(x)

static inline VALUE
rb_uint2num_inline(unsigned int v)
{
    if (RB_POSFIXABLE(v))
	return RB_LONG2FIX(v);
    else
	return rb_uint2big(v);
}
#define RB_UINT2NUM(x) rb_uint2num_inline(x)
#endif
#define INT2NUM(x) RB_INT2NUM(x)
#define UINT2NUM(x) RB_UINT2NUM(x)

static inline VALUE
rb_long2num_inline(long v)
{
    if (RB_FIXABLE(v))
	return RB_LONG2FIX(v);
    else
	return rb_int2big(v);
}
#define RB_LONG2NUM(x) rb_long2num_inline(x)

static inline VALUE
rb_ulong2num_inline(unsigned long v)
{
    if (RB_POSFIXABLE(v))
	return RB_LONG2FIX(v);
    else
	return rb_uint2big(v);
}
#define RB_ULONG2NUM(x) rb_ulong2num_inline(x)

static inline char
rb_num2char_inline(VALUE x)
{
    if (RB_TYPE_P(x, RUBY_T_STRING) && (RSTRING_LEN(x)>=1))
	return RSTRING_PTR(x)[0];
    else
	return (char)(NUM2INT(x) & 0xff);
}
#define RB_NUM2CHR(x) rb_num2char_inline(x)

#define RB_CHR2FIX(x) RB_INT2FIX((long)((x)&0xff))

#define LONG2NUM(x) RB_LONG2NUM(x)
#define ULONG2NUM(x) RB_ULONG2NUM(x)
#define USHORT2NUM(x) RB_INT2FIX(x)
#define NUM2CHR(x) RB_NUM2CHR(x)
#define CHR2FIX(x) RB_CHR2FIX(x)

#if SIZEOF_LONG < SIZEOF_VALUE
#define RB_ST2FIX(h) RB_LONG2FIX((long)((h) > 0 ? (h) & (unsigned long)-1 >> 2 : (h) | ~((unsigned long)-1 >> 2)))
#else
#define RB_ST2FIX(h) RB_LONG2FIX((long)(h))
#endif
#define ST2FIX(h) RB_ST2FIX(h)

#define RB_ALLOC_N(type,n) ((type*)ruby_xmalloc2((size_t)(n),sizeof(type)))
#define RB_ALLOC(type) ((type*)ruby_xmalloc(sizeof(type)))
#define RB_ZALLOC_N(type,n) ((type*)ruby_xcalloc((size_t)(n),sizeof(type)))
#define RB_ZALLOC(type) (RB_ZALLOC_N(type,1))
#define RB_REALLOC_N(var,type,n) ((var)=(type*)ruby_xrealloc2((char*)(var),(size_t)(n),sizeof(type)))

#define ALLOC_N(type,n) RB_ALLOC_N(type,n)
#define ALLOC(type) RB_ALLOC(type)
#define ZALLOC_N(type,n) RB_ZALLOC_N(type,n)
#define ZALLOC(type) RB_ZALLOC(type)
#define REALLOC_N(var,type,n) RB_REALLOC_N(var,type,n)

#if GCC_VERSION_BEFORE(4,9,5)
/* GCC 4.9.2 reportedly has this feature and is broken.
 * The function is not officially documented below.
 * Seems we should not use it.
 * https://gcc.gnu.org/onlinedocs/gcc-4.9.4/gcc/Other-Builtins.html#Other-Builtins */
# undef HAVE_BUILTIN___BUILTIN_ALLOCA_WITH_ALIGN
#endif

#if defined(HAVE_BUILTIN___BUILTIN_ALLOCA_WITH_ALIGN) && defined(RUBY_ALIGNOF)
/* I don't know why but __builtin_alloca_with_align's second argument
   takes bits rather than bytes. */
#define ALLOCA_N(type, n) \
    (type*)__builtin_alloca_with_align((sizeof(type)*(n)), \
        RUBY_ALIGNOF(type) * CHAR_BIT)
#else
#define ALLOCA_N(type,n) ((type*)alloca(sizeof(type)*(n)))
#endif

void *rb_alloc_tmp_buffer(volatile VALUE *store, long len) RUBY_ATTR_ALLOC_SIZE((2));
void *rb_alloc_tmp_buffer_with_count(volatile VALUE *store, size_t len,size_t count) RUBY_ATTR_ALLOC_SIZE((2,3));
void rb_free_tmp_buffer(volatile VALUE *store);
NORETURN(void ruby_malloc_size_overflow(size_t, size_t));
#if HAVE_LONG_LONG && SIZEOF_SIZE_T * 2 <= SIZEOF_LONG_LONG
# define DSIZE_T unsigned LONG_LONG
#elif defined(HAVE_INT128_T)
# define DSIZE_T uint128_t
#endif
static inline int
rb_mul_size_overflow(size_t a, size_t b, size_t max, size_t *c)
{
#ifdef DSIZE_T
# ifdef __GNUC__
    __extension__
# endif
    DSIZE_T c2 = (DSIZE_T)a * (DSIZE_T)b;
    if (c2 > max) return 1;
    *c = (size_t)c2;
#else
    if (b != 0 && a > max / b) return 1;
    *c = a * b;
#endif
    return 0;
}
static inline void *
rb_alloc_tmp_buffer2(volatile VALUE *store, long count, size_t elsize)
{
    size_t cnt = (size_t)count;
    if (elsize == sizeof(VALUE)) {
	if (RB_UNLIKELY(cnt > LONG_MAX / sizeof(VALUE))) {
	    ruby_malloc_size_overflow(cnt, elsize);
	}
    }
    else {
	size_t size, max = LONG_MAX - sizeof(VALUE) + 1;
	if (RB_UNLIKELY(rb_mul_size_overflow(cnt, elsize, max, &size))) {
	    ruby_malloc_size_overflow(cnt, elsize);
	}
	cnt = (size + sizeof(VALUE) - 1) / sizeof(VALUE);
    }
    return rb_alloc_tmp_buffer_with_count(store, cnt * sizeof(VALUE), cnt);
}
/* allocates _n_ bytes temporary buffer and stores VALUE including it
 * in _v_.  _n_ may be e