ntents to format.
 * @exception   rb_eTypeError  `dst` is not a String.
 * @return      Passed `dst`.
 * @post        `dst` has the rendered output appended to its end.
 */
VALUE rb_str_catf(VALUE dst, const char *fmt, ...);

RBIMPL_ATTR_NONNULL((2))
RBIMPL_ATTR_FORMAT(RBIMPL_PRINTF_FORMAT, 2, 0)
/**
 * Identical to  rb_str_catf(), except it  takes a  `va_list`.  It can  also be
 * seen as a  routine identical to rb_vsprintf(), except it  renders the output
 * to the specified object rather than creating a new one.
 *
 * @param[out]  dst            String to modify.
 * @param[in]   fmt            A `printf`-like format specifier.
 * @param[in]   ap             Contents to format.
 * @exception   rb_eTypeError  `dst` is not a String.
 * @return      Passed `dst`.
 * @post        `dst` has the rendered output appended to its end.
 */
VALUE rb_str_vcatf(VALUE dst, const char *fmt, va_list ap);

/**
 * Formats a string.
 *
 * Returns  the string  resulting from  applying `fmt`  to `argv`.   The format
 * sequence  is a  mixture of  format specifiers  and other  verbatim contents.
 * Each format specifier starts with a `%`, and has the following structure:
 *
 * ```
 * %[flags][width][.precision]type
 * ```
 *
 * ...  which is  different from  that of  rb_sprintf().  Because  ruby has  no
 * `short` or `long`, there 