one anyways inside of rb_obj_init_copy().
 * - rb_obj_init_copy() returns something.  No need are there to add `, 1`.
 */
#define RB_OBJ_INIT_COPY(obj, orig) \
    ((obj) != (orig) && (rb_obj_init_copy((obj), (orig)), 1))
/** @old{RB_OBJ_INIT_COPY} */
#define OBJ_INIT_COPY(obj, orig) RB_OBJ_INIT_COPY(obj, orig)

/* object.c */

/**
 * Identical to  rb_class_new_instance(), except it passes  the passed keywords
 * if any to the `#initialize` method.
 *
 * @param[in]  argc           Number of objects of `argv`.
 * @param[in]  argv           Arbitrary number of method arguments.
 * @param[in]  klass          An instance of ::rb_cClass.
 * @exception  rb_eTypeError  `klass`'s allocator is undefined.
 * @exception  rb_eException  Any exceptions can happen inside.
 * @return     An allocated new instance of `klass`.
 * @note       This is _the_ implementation of `Object.new`.
 */
VALUE rb_class_new_instance_pass_kw(int argc, const VALUE *argv, VALUE klass);

/**
 * Allocates, then initialises an instance of  the given class.  It first calls
 * the passed  class' allocator to  obtain an uninitialised object,  then calls
 * its initialiser with the remaining arguments.
 *
 * @param[in]  argc           Number of objects of `argv`.
 * @param[in]  argv           Arguments passed to `#initialize`.
 * @param[in]  klass          An instance of ::rb_cClass.
 * @exception  rb_eTypeError  `klass`'s allocator is undefined.
 * @exception  rb_eException  Any exceptions can happen inside.
 * @return     An allocated new instance of `klass`.
 */
VALUE rb_class_new_instance(int argc, const VALUE *argv, VALUE klass);

/**
 * Identical to rb_class_new_instance(),  except you can specify  how to handle
 * the last element of the given array.
 *
 * @param[in]  argc             Number of objects of `argv`.
 * @param[in]  argv             Arbitrary number of method arguments.
 * @param[in]  klass            An instance of ::rb_cClass.
 * @param[in]  kw_splat         Handling of keyword parameters:
 *   - RB_NO_KEYWORDS           `argv`'s last is not a keyword argument.
 *   - RB_PASS_KEYWORDS         `argv`'s last is a keyword argument.
 *   - RB_PASS_CALLED_KEYWORDS  it depends if there is a passed block.
 * @exception  rb_eTypeError    `klass`'s allocator is undefined.
 * @exception  rb_eException    Any exceptions can happen inside.
 * @return     An allocated new instance of `klass`.
 */
VALUE rb_class_new_instance_kw(int argc, const VALUE *argv, VALUE klass, int kw_splat);

/**
 * Checks for equality of the passed objects, in terms of `Object#eql?`.
 *
 * @param[in]  lhs          Comparison left hand side.
 * @param[in]  rhs          Comparison right hand side.
 * @retval     non-zero     They are equal.
 * @retval     0            Otherwise.
 * @note       This  function  actually  calls `lhs.eql?(rhs)`  so  you  cannot
 *             implement your class' `#eql?` method using it.
 */
int rb_eql(VALUE lhs, VALUE rhs);

/**
 * Generates a textual representation of the given object.
 *
 * @param[in]  obj  Arbitrary ruby object.
 * @return     An instance of ::rb_cString that represents `obj`.
 * @note       This is  the default  implementation of `Object#to_s`  that each
 *             subclasses want to override.
 */
VALUE rb_any_to_s(VALUE obj);

/**
 * Generates a human-readable textual representation of the given object.  This
 * is  largely similar  to Ruby  level `Object#inspect`  but not  the same;  it
 * additionally escapes the inspection result  so that the string be compatible
 * with that of default internal (or default external, if absent).
 *
 * @param[in]  obj  Arbitrary ruby object.
 * @return     An instance of ::rb_cString that represents `obj`.
 */
VALUE rb_inspect(VALUE obj);

/**
 * Queries if the given object is a direct instance of the given class.
 *
 * @param[in]  obj            Arbitrary ruby object.
 * @param[in]  klass          An instance of ::rb_cModule.
 * @exception  rb_eTypeError  `klass` is neither module nor class.
 * @retval     RUBY_Qtrue     `obj` is an instance of `klass`.
 * @retval     RUBY_Qfalse    Otherwise.
 */
VALUE rb_obj_is_instance_of(VALUE obj, VALUE klass);

/**
 * Queries if the given object is  an instance (of possibly descendants) of the
 * given class.
 *
 * @param[in]  obj            Arbitrary ruby object.
 * @param[in]  klass          An instance of ::rb_cModule.
 * @exception  rb_eTypeError  `klass` is neither module nor class.
 * @retval     RUBY_Qtrue     `obj` is a `klass`.
 * @retval     RUBY_Qfalse    Otherwise.
 */
VALUE rb_obj_is_kind_of(VALUE obj, VALUE klass);

/**
 * Allocates an instance of the given class.
 *
 * @param[in]  klass          A class to instantiate.
 * @exception  rb_eTypeError  `klass` is not a class.
 * @return     An allocated, not yet initialised instance of `klass`.
 * @note       It calls  the allocator defined by  rb_define_alloc_func().  You
 *             cannot  use   this  function   to  define  an   allocator.   Use
 *             rb_newobj_of(), #TypedData_Make_Struct or others, instead.
 * @note       Usually  prefer  rb_class_new_instance() to  rb_obj_alloc()  and
 *             rb_obj_call_init().
 * @see        rb_class_new_instance()
 * @see        rb_obj_call_init()
 * @see        rb_define_alloc_func()
 * @see        rb_newobj_of()
 * @see        #TypedData_Make_Struct
