 `#initialize_clone`.  It  does almost  nothing.  Just raises  exceptions for
 * checks.
 *
 * @param[in]  dst              The destination object.
 * @param[in]  src              The source object.
 * @exception  rb_eFrozenError  `dst` is frozen.
 * @exception  rb_eTypeError    `dst` and `src` have different classes.
 * @return     Always returns `dst`.
 */
VALUE rb_obj_init_copy(VALUE src, VALUE dst);

/**
 * Just  calls  rb_obj_freeze_inline() inside.   Does  this  make any  sens  to
 * extension libraries?
 *
 * @param[out]  obj  Object to freeze.
 * @return      Verbatim `obj`.
 */
VALUE rb_obj_freeze(VALUE obj);

RBIMPL_ATTR_PURE()
/**
 * Just calls  RB_OBJ_FROZEN() inside.   Does this make  any sens  to extension
 * libraries?
 *
 * @param[in]  obj          Object in question.
 * @retval     RUBY_Qtrue   Yes it is.
 * @retval     RUBY_Qfalse  No it isn't.
 */
VALUE rb_obj_frozen_p(VALUE obj);

/* gc.c */

/**
 * Finds or  creates an integer  primary key of the  given object.  In  the old
 * days  this  function  was  a  purely  arithmetic  operation  that  maps  the
 * underlying memory  address where the  object resides into a  Ruby's integer.
 * Some time around  2.x this changed.  It no longer  relates its return values
 * to C level pointers.  This function  assigns some random number to the given
 * object  if absent.   The  same number  will be  returned  on all  subsequent
 * requests.  No two active objects share a number.
 *
 * @param[in]  obj  Arbitrary ruby object.
 * @return     An instance of ::rb_cInteger which is an "identifier" of `obj`.
 *
 * @internal
 *
 * The "some  random number" is  in fact a  monotonic-increasing process-global
 * unique integer, much like an  `INTEGER AUTO_INCREMENT PRIMARY KEY` column in
 * a MySQL table.
 */
VALUE rb_obj_id(VALUE obj);

RBIMPL_ATTR_CONST()
/**
 * Identical to rb_obj_id(), except it hesitates from allocating a new instance
 * of ::rb_cInteger.  rb_obj_id() could allocate ::RUBY_T_BIGNUM objects.  That
 * allocation  might  perhaps  impact  negatively.  On  such  situations,  this
 * function  instead returns  one-shot temporary  small integers  that need  no
 * allocations at all.  The values are  guaranteed unique at the moment, but no
 * future promise  is made; could  be reused.  Use of  this API should  be very
 * instant.  It is a failure to store the returned integer to somewhere else.
 *
 * In short it is difficult to use.
 *
 * @param[in]  obj  Arbitrary ruby object.
 * @return     An instance of ::rb_cInteger unique at the moment.
 *
 * @internal
 *
 * This is roughly the old behaviour of rb_obj_id().
 */
VALUE rb_memory_id(VALUE obj);

/* object.c */

RBIMPL_ATTR_PURE()
/**
 * Finds a "real" class.  As the name  implies there are class objects that are
 * surreal.   This function  takes a  class, traverses  its ancestry  tree, and
 * returns  its nearest  ancestor which  is neither  a module  nor a  singleton
 * class.
 *
 * @param[in]  klass        An instance of ::rb_cClass.
 * @retval     RUBY_Qfalse  No real class in `klass`' ancestry tree.
 * @retval     klass        `klass` itself is a real class.
 * @retval     otherwise    Nearest ancestor of `klass` who is real.
 */
VALUE rb_class_real(VALUE klass);

RBIMPL_ATTR_PURE()
/**
 * Determines if the given two modules are relatives.
 *
 * @param[in]  scion          Possible subclass.
 * @param[in]  ascendant      Possible superclass.
 * @exception  rb_eTypeError  `ascendant` is not a module.
 * @retval     RUBY_Qtrue     `scion` inherits, or is equal to `ascendant`.
 * @retval     RUBY_Qfalse    `ascendant` inherits `scion`.
 * @retval     RUBY_Qnil      They are not relatives.
 */
VALUE rb_class_inherited_p(VALUE scion, VALUE ascendant);

RBIMPL_ATTR_PURE()
/**
 * Queries the parent of the given class.
 *
 * @param[in]  klass          A child class.
 * @exception  rb_eTypeError  `klass` is a `Class.allocate`.
 * @retval     RUBY_Qfalse    `klass` has no superclass.
 * @retval     otherwise      `klass`' superclass.
 *
 * @internal
 *
 * Is there any class except ::rb_cBasicObject, that has no superclass?
 */
VALUE rb_class_superclass(VALUE klass);

RBIMPL_ATTR_NONNULL(())
/**
 * Converts an object into another type.  Calls the specified conversion method
 * if necessary.
 *
 * @param[in]  val            An object to convert.
 * @param[in]  type           A value of enum ::ruby_value_type.
 * @param[in]  name           Name to display on error (e.g. "Array").
 * @param[in]  mid            Conversion method (e.g. "to_ary").
 * @exception  rb_eTypeError  Failed to convert.
 * @return     An object of the specified type.
 */
VALUE rb_convert_type(VALUE val, int type, const char *name, const char *mid);

RBIMPL_ATTR_NONNULL(())
/**
 * Identical  to rb_convert_type(),  except it  returns ::RUBY_Qnil  instead of
 * raising  exceptions,  in  case  of  conversion  failure.   It  still  raises
 * exceptions  for various  reasons,  like when  the  conversion method  itself
 * raises, though.
 *
 * @param[in]  val            An object to convert.
 * @param[in]  type           A value of enum ::ruby_value_type.
 * @param[in]  name           Name to display on error (e.g. "Array").
 * @param[in]  mid            Conversion method (e.g. "to_ary").
 * @exception  rb_eTypeError  The `mid` does not generate `type`.
 * @retval     RUBY_Qnil      No conversion defined.
 * @retval     otherwise      An object of the specified type.
 */
VALUE rb_check_convert_type(VALUE val, int type, const char *name, const char *mid);

RBIMPL_ATTR_NONNULL(())
/**
 * Identical to rb_check_convert_type(), except the  return value type is fixed
 * to ::rb_cInteger.
 *
 * @param[in]  val            An object to convert.
 * @param[in]  mid            Conversion method (e.g. "to_ary").
 * @exception  rb_eTypeError  The `mid` does not generate an integer.
 * @retval     RUBY_Qnil      No conversion defined.
 * @retval     otherwise      An instance of ::rb_cInteger.
 */
VALUE rb_check_to_integer(VALUE val, const char *mid);

/**
 * This is complicated.
 *
 *   - When  the passed  object is  already  an instance  of ::rb_cFloat,  just
 *     returns it as-is.
 *
 *   - When  the passed  object is  something  numeric, the  function tries  to
 *     convert it using `#to_f` method.
 *
 *       - If that conversion fails (this happens for instance when the numeric
 *         is a complex) it returns ::RUBY_Qnil.
 *
 *       - Otherwise returns the conversion result.
 *
 *   - Otherwise it also returns ::RUBY_Qnil.
 *
 * @param[in]  val        An object to convert.
 * @retval     RUBY_Qnil  Conversion from `val` to float is undefined.
 * @retval     otherwise  Converted result.
 */
VALUE rb_check_to_float(VALUE val);

/**
 * Identical  to rb_check_to_int(),  except  it raises  in  case of  conversion
 * mismatch.
 *
 * @param[in]  val            An object to convert.
 * @exception  rb_eTypeError  `#to_int` does not generate an integer.
 * @return     An instance of ::rb_cInteger.
 */
VALUE rb_to_int(VALUE val);

/**
 * Identical to rb_check_to_integer(), except it uses `#to_int` for conversion.
 *
 * @param[in]  val            An object to convert.
 * @exception  rb_eTypeError  `#to_int` does not return an integer.
 * @retval     RUBY_Qnil      No conversion defined.
 * @retval     otherwise      An instance of ::rb_cInteger.
 */
VALUE rb_check_to_int(VALUE val);

/**
 * This  is the  logic behind  `Kernel#Integer`.  Numeric  types are  converted
 * directly,  with  floating  point   numbers  being  truncated.   Strings  are
 * interpreted  strictly; only  leading/trailing whitespaces,  plus/minus sign,
 * radix  indicators  such  as  `0x`,  digits,  and  underscores  are  allowed.
 * Anything else are converted by first trying `#to_int`, then `#to_i`.
 *
 * This is slightly stricter than `String#to_i`.
 *
 * @param[in]  val            An object to convert.
 * @exception  rb_eArgError   Malformed `val` passed.
 * @exception  rb_eTypeError  No conversion defined.
 * @return     An instance of ::rb_cInteger.
 */
VALUE rb_Integer(VALUE val);

/**
 * Identical to rb_check_to_float(), except it raises on error.
 *
 * @param[in]  val            An object to convert.
 * @exception  rb_eTypeError  No conversion defined.
 * @return     An instance of ::rb_cFloat.
 */
VALUE rb_to_float(VALUE val);

/**
 * This  is  the logic  behind  `Kernel#Float`.   Numeric types  are  converted
 * directly  to the  nearest value  that a  Float can  represent.  Strings  are
 * interpreted strictly;  only leading/trailing whitespaces are  allowed except
 * what `strtod` understands.  Anything else are converted using `#to_f`.
 *
 * This is slightly stricter than `String#to_f`.
 *
 * @param[in]  val            An object to convert.
 * @exception  rb_eArgError   Malformed `val` passed.
 * @exception  rb_eTypeError  No conversion defined.
 * @return     An instance of ::rb_cFloat.
 */
VALUE rb_Float(VALUE val);

/**
 * This is the logic behind  `Kernel#String`.  Arguments are converted by first
 * trying `#to_str`, then `#to_s`.
 *
 * @param[in]  val            An object to convert.
 * @exception  rb_eTypeError  No conversion defined.
 * @return     An instance of ::rb_cString.
 */
VALUE rb_String(VALUE val);

/**
 * This is the  logic behind `Kernel#Array`.  Arguments are  converted by first
 * trying `#to_ary`,  then `#to_a`,  and if  both failed,  returns an  array of
 * length 1 that contains the passed argument as the sole contents.
 *
 * @param[in]  val  An object to convert.
 * @return     An instance of ::rb_cArray.
 */
VALUE rb_Array(VALUE val);

/**
 * This is  the logic behind  `Kernel#Hash`.  Arguments are converted  by first
 * trying `#to_hash`.  if it failed, and  the argument is either ::RUBY_Qnil or
 * an empty array, returns an empty hash.  Otherwise an exception is raised.
 *
 * @param[in]  val            An object to convert.
 * @exception  rb_eTypeError  No conversion defined.
 * @return     An instance of ::rb_cHash.
 */
VALUE rb_Hash(VALUE val);

RBIMPL_ATTR_NONNULL(())
/**
 * Converts a textual representation of a  real number into a numeric, which is
 * the nearest value that the return type  can represent, of the value that the
 * argument represents.  This is in fact  a 2-in-1 function whose behaviour can
 * be controlled using  the second (mode) argument.  If the  mode is zero, this
 * function is in "historical"  mode which only understands "floating-constant"
 * defined at ISO/IEC 9899:1990 section 6.1.3.1.  If the mode is nonzero, it is
 * in  "extended"  mode,  which  also  accepts  "hexadecimal-floating-constant"
 * defined at ISO/IEC 9899:2018 section 6.4.4.2.
 *
 * @param[in]  str           A textual representation of a real number.
 * @param[in]  mode          Conversion mode, as described above.
 * @exception  rb_eArgError  Malformed `str` passed.
 * @see        https://bugs.ruby-lang.org/issues/2969
 * @note       Null pointers are allowed, and it returns 0.0 then.
 */
double rb_cstr_to_dbl(const char *str, int mode);

/**
 * Identical to rb_cstr_to_dbl(), except it  accepts a Ruby's string instead of
 * C's.
 *
 * @param[in]  str           A textual representation of a real number.
 * @param[in]  mode          Conversion mode, as described in rb_cstr_to_dbl().
 * @exception  rb_eArgError  Malformed `str` passed.
 * @see        https://bugs.ruby-lang.org/issues/2969
 */
double rb_str_to_dbl(VALUE str, int mode);

RBIMPL_SYMBOL_EXPORT_END()

#endif /* RBIMPL_INTERN_OBJECT_H */
PK       ! 
>  >    ruby/internal/intern/class.hnu [        #ifndef RBIMPL_INTERN_CLASS_H                        /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_INTERN_CLASS_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Public APIs related to ::rb_cClass/::rb_cModule.
 */
#include "ruby/internal/dllexport.h"
#include "ruby/internal/value.h"
#include "ruby/backward/2/stdarg.h"

RBIMPL_SYMBOL_EXPORT_BEGIN()

/* class.c */

/**
 * Creates a new, anonymous class.
 *
 * @param[in]  super          What would become a parent class.
 * @exception  rb_eTypeError  `super` is not something inheritable.
 * @return     An anonymous class that inherits `super`.
 */
VALUE rb_class_new(VALUE super);

/**
 * The comment  that comes with  this function  says `:nodoc:`.  Not  sure what
 * that means though.
 *
 * @param[out]  clone          Destination object.
 * @param[in]   orig           Source object.
 * @exception   rb_eTypeError  Cannot copy `orig`.
 * @return      The passed `clone`.
 */
VALUE rb_mod_init_copy(VALUE clone, VALUE orig);

/**
 * Asserts that  the given class  can derive a child  class.  A class  might or
 * might not be able to do so; for instance a singleton class cannot.
 *
 * @param[in]  super          Possible super class.
 * @exception  rb_eTypeError  No it cannot.
 * @post       Upon successful return `super` can derive.
 */
void rb_check_inheritable(VALUE super);

/**
 * This is a very badly designed API that creates an anonymous class.
 *
 * @param[in]  id             Discarded for no reason (why...).
 * @param[in]  super          What  would  become  a  parent  class.   0  means
 *                            ::rb_cObject.
 * @exception  rb_eTypeError  `super` is not something inheritable.
 * @return     An anonymous class that inherits `super`.
 * @warning    You must explicitly name the return value.
 */
VALUE rb_define_class_id(ID id, VALUE super);

/**
 * Identical  to rb_define_class_under(),  except  it takes  the  name in  ::ID
 * instead of C's string.
 *
 * @param[out]  outer          A class which contains the new class.
 * @param[in]   id             Name of the new class
 * @param[in]   super          A class from which the new class will derive.
 *                             0 means ::rb_cObject.
 * @exception   rb_eTypeError  The constant name `id`  is already taken but the
 *                             constant is not a class.
 * @exception   rb_eTypeError  The class  is already defined but  the class can
 *                             not be  reopened because  its superclass  is not
 *                             `super`.
 * @exception   rb_eArgError   `super` is NULL.
 * @return      The created class.
 * @post        `outer::id` refers the returned class.
 * @note        If a class named `id` is  already defined and its superclass is
 *              `super`, the function just returns the defined class.
 * @note        The  compaction  GC does  not  move  classes returned  by  this
 *              function.
 */
VALUE rb_define_class_id_under(VALUE outer, ID id, VALUE super);

/**
 * Creates a new, anonymous module.
 *
 * @return An anonymous module.
 */
VALUE rb_module_new(void);


/**
 * Creates a new, anonymous refinement.
 *
 * @return An anonymous refinement.
 */
VALUE rb_refinement_new(void);

/**
 * This is a very badly designed API that creates an anonymous module.
 *
 * @param[in]  id  Discarded for no reason (why...).
 * @return     An anonymous module.
 * @warning    You must explicitly name the return value.
 */
VALUE rb_define_module_id(ID id);

/**
 * Identical  to rb_define_module_under(),  except it  takes the  name in  ::ID
 * instead of C's string.
 *
 * @param[out]  outer          A class which contains the new module.
 * @param[in]   id             Name of the new module
 * @exception   rb_eTypeError  The constant name `id`  is already taken but the
 *                             constant is not a module.
 * @return      The created module.
 * @post        `outer::id` refers the returned module.
 * @note        The  compaction  GC does  not  move  classes returned  by  this
 *              function.
 */
VALUE rb_define_module_id_under(VALUE outer, ID id);

/**
 * Queries the list of  included modules.  It can also be seen  as a routine to
 * first  call rb_mod_ancestors(),  then  rejects non-modules  from the  return
 * value.
 *
 * @param[in]  mod  Class or Module.
 * @return     An array of modules that are either included or prepended in any
 *             of `mod`'s ancestry tree (including itself).
 */
VALUE rb_mod_included_modules(VALUE mod);

/**
 * Queries if the passed module is included by the module.  It can also be seen
 * as a routine to first call rb_mod_included_modules(), then see if the return
 * value contains the passed module.
 *
 * @param[in]  child          A Module.
 * @param[in]  parent         Another Module.
 * @exception  rb_eTypeError  `child` is not an instance of ::rb_cModule.
 * @retval     RUBY_Qtrue     `parent` is  either included or prepended  in any
 *                            of `child`'s ancestry tree (including itself).
 * @return     RUBY_Qfalse    Otherwise.
 */
VALUE rb_mod_include_p(VALUE child, VALUE parent);

/**
 * Queries the  module's ancestors.  This routine gathers classes  and modules
 * that  the  passed  module  either  inherits,  includes,  or  prepends,  then
 * recursively applies  that routine again  and again to the  collected entries
 * until the list doesn't grow up.
 *
 * @param[in]  mod  A module or a class.
 * @return     An array of  classes or modules that  `mod` possibly recursively
 *             inherits, includes, or prepends.
 *
 * @internal
 *
 * Above description  is written  in a  recursive language  but in  practice it
 * computes the return value iteratively.
 */
VALUE rb_mod_ancestors(VALUE mod);

/**
 * Queries the class's descendants. This  routine gathers classes that are
 * subclasses of the given class (or subclasses of those subclasses, etc.),
 * returning an array of classes that have the given class as an ancestor.
 * The returned array does not include the given class or singleton classes.
 *
 * @param[in]  klass A class.
 * @return     An array of classes where `klass` is an ancestor.
 *
 * @internal
 */
VALUE rb_class_descendants(VALUE klass);

/**
 * Queries the class's direct descendants. This  routine gathers classes that are
 * direct subclasses of the given class,
 * returning an array of classes that have the given class as a superclass.
 * The returned array does not include singleton classes.
 *
 * @param[in]  klass A class.
 * @return     An array of classes where `klass` is the `superclass`.
 *
 * @internal
 */
VALUE rb_class_subclasses(VALUE klass);


/**
 *  Returns the attached object for a singleton class.
 *  If the given class is not a singleton class, raises a TypeError.
 *
 * @param[in]  klass A class.
 * @return     The object which has the singleton class `klass`.
 *
 * @internal
 */
VALUE rb_class_attached_object(VALUE klass);

/**
 * Generates an array of symbols, which are the list of method names defined in
 * the passed class.
 *
 * @param[in]  argc          Number of objects of `argv`.
 * @param[in]  argv          Array of  at most  one object, which  controls (if
 *                           any) whether  the return array includes  the names
 *                           of methods defined in ancestors or not.
 * @param[in]  mod           A module or a class.
 * @exception  rb_eArgError  `argc` out of range.
 * @return     An array  of symbols collecting  names of instance  methods that
 *             are not private, defined at `mod`.
 */
VALUE rb_class_instance_methods(int argc, const VALUE *argv, VALUE mod);

/**
 * Identical to rb_class_instance_methods(), except it returns names of methods
 * that are public only.
 *
 * @param[in]  argc          Number of objects of `argv`.
 * @param[in]  argv          Array of  at most  one object, which  controls (if
 *                           any) whether  the return array includes  the names
 *                           of methods defined in ancestors or not.
 * @param[in]  mod           A module or a class.
 * @exception  rb_eArgError  `argc` out of range.
 * @return     An array  of symbols collecting  names of instance  methods that
 *             are public, defined at `mod`.
 */
VALUE rb_class_public_instance_methods(int argc, const VALUE *argv, VALUE mod);

/**
 * Identical to rb_class_instance_methods(), except it returns names of methods
 * that are protected only.
 *
 * @param[in]  argc          Number of objects of `argv`.
 * @param[in]  argv          Array of  at most  one object, which  controls (if
 *                           any) whether  the return array includes  the names
 *                           of methods defined in ancestors or not.
 * @param[in]  mod           A module or a class.
 * @exception  rb_eArgError  `argc` out of range.
 * @return     An array  of symbols collecting  names of instance  methods that
 *             are protected, defined at `mod`.
 */
VALUE rb_class_protected_instance_methods(int argc, const VALUE *argv, VALUE mod);

/**
 * Identical to rb_class_instance_methods(), except it returns names of methods
 * that are private only.
 *
 * @param[in]  argc          Number of objects of `argv`.
 * @param[in]  argv          Array of  at most  one object, which  controls (if
 *                           any) whether  the return array includes  the names
 *                           of methods defined in ancestors or not.
 * @param[in]  mod           A module or a class.
 * @exception  rb_eArgError  `argc` out of range.
 * @return     An array  of symbols collecting  names of instance  methods that
 *             are protected, defined at `mod`.
 */
VALUE rb_class_private_instance_methods(int argc, const VALUE *argv, VALUE mod);

/**
 * Identical  to  rb_class_instance_methods(),  except   it  returns  names  of
 * singleton methods instead of instance methods.
 *
 * @param[in]  argc          Number of objects of `argv`.
 * @param[in]  argv          Array of  at most  one object, which  controls (if
 *                           any) whether  the return array includes  the names
 *                           of methods defined in ancestors or not.
 * @param[in]  obj           Arbitrary ruby object.
 * @exception  rb_eArgError  `argc` out of range.
 * @return     An array  of symbols collecting  names of instance  methods that
 *             are not private, defined at the singleton class of `obj`.
 */
VALUE rb_obj_singleton_methods(int argc, const VALUE *argv, VALUE obj);

/**
 * Identical to rb_define_method(),  except it takes the name of  the method in
 * ::ID instead of C's string.
 *
 * @param[out]  klass  A module or a class.
 * @param[in]   mid    Name of the function.
 * @param[in]   func   The method body.
 * @param[in]   arity  The number of parameters.  See @ref defmethod.
 * @note        There are in fact 18 different prototypes for func.
 * @see         ::ruby::backward::cxxanyargs::define_method::rb_define_method_id
 */
void rb_define_method_id(VALUE klass, ID mid, VALUE (*func)(ANYARGS), int arity);

/* vm_method.c */

/**
 * Inserts a  method entry that hides  previous method definition of  the given
 * name.  This is not a deletion of  a method.  Method of the same name defined
 * in a parent class is kept invisible in this way.
 *
 * @param[out]  mod              The module to insert an undef.
 * @param[in]   mid              Name of the undef.
 * @exception   rb_eTypeError    `klass` is a non-module.
 * @exception   rb_eFrozenError  `klass` is frozen.
 * @exception   rb_eNameError    No such method named `klass#name`.
 * @post        `klass#name` is undefined.
 * @see         rb_undef_method
 *
 * @internal
 *
 * @shyouhei doesn't  understand why this  is not  the ::ID -taking  variant of
 * rb_undef_method(), given rb_remove_method() has its ::ID -taking counterpart
 * named rb_remove_method_id().
 */
void rb_undef(VALUE mod, ID mid);

/* class.c */

RBIMPL_ATTR_NONNULL(())
/**
 * Identical to rb_define_method(), except it defines a protected method.
 *
 * @param[out]  klass  A module or a class.
 * @param[in]   mid    Name of the function.
 * @param[in]   func   The method body.
 * @param[in]   arity  The number of parameters.  See @ref defmethod.
 * @note        There are in fact 18 different prototypes for func.
 * @see         ::ruby::backward::cxxanyargs::define_method::rb_define_protected_method
 */
void rb_define_protected_method(VALUE klass, const char *mid, VALUE (*func)(ANYARGS), int arity);

RBIMPL_ATTR_NONNULL(())
/**
 * Identical to rb_define_method(), except it defines a private method.
 *
 * @param[out]  klass  A module or a class.
 * @param[in]   mid    Name of the function.
 * @param[in]   func   The method body.
 * @param[in]   arity  The number of parameters.  See @ref defmethod.
 * @note        There are in fact 18 different prototypes for func.
 * @see         ::ruby::backward::cxxanyargs::define_method::rb_define_protected_method
 */
void rb_define_private_method(VALUE klass, const char *mid, VALUE (*func)(ANYARGS), int arity);

RBIMPL_ATTR_NONNULL(())
/**
 * Identical to rb_define_method(), except it defines a singleton method.
 *
 * @param[out]  obj    Arbitrary ruby object.
 * @param[in]   mid    Name of the function.
 * @param[in]   func   The method body.
 * @param[in]   arity  The number of parameters.  See @ref defmethod.
 * @note        There are in fact 18 different prototypes for func.
 * @see         ::ruby::backward::cxxanyargs::define_method::rb_define_singleton_method
 */
void rb_define_singleton_method(VALUE obj, const char *mid, VALUE(*func)(ANYARGS), int arity);

/**
 * Finds or creates the singleton class of the passed object.
 *
 * @param[out]  obj            Arbitrary ruby object.
 * @exception   rb_eTypeError  `obj` cannot have its singleton class.
 * @return      A (possibly newly allocated) instance of ::rb_cClass.
 * @post        `obj` has its singleton class, which is the return value.
 * @post        In case `obj` is a class, the returned singleton class also has
 *              its own  singleton class  in order to  keep consistency  of the
 *              inheritance structure of metaclasses.
 * @note        A new  singleton class will  be created  if `obj` did  not have
 *              one.
 * @note        The  singleton  classes   for  ::RUBY_Qnil,  ::RUBY_Qtrue,  and
 *              ::RUBY_Qfalse   are    ::rb_cNilClass,   ::rb_cTrueClass,   and
 *              ::rb_cFalseClass respectively.
 *
 * @internal
 *
 * You can _create_ a singleton class of a frozen object.  Intentional or ...?
 *
 * Nowadays there are wider range of  objects who cannot have singleton classes
 * than before.  For instance some string instances cannot for some reason.
 */
VALUE rb_singleton_class(VALUE obj);

RBIMPL_SYMBOL_EXPORT_END()

#endif /* RBIMPL_INTERN_CLASS_H */
PK       ! (j  j    ruby/internal/intern/select.hnu [        #ifndef RBIMPL_INTERN_SELECT_H                       /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_INTERN_SELECT_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Public APIs to provide ::rb_fd_select().
 * @note       Functions  and  structs defined  in  this  header file  are  not
 *             necessarily ruby-specific.  They don't need ::VALUE etc.
 */
#include "ruby/internal/config.h"

#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>         /* for NFDBITS (BSD Net/2) */
#endif

#include "ruby/internal/dllexport.h"

/* thread.c */
#if defined(NFDBITS) && defined(HAVE_RB_FD_INIT)
# include "ruby/internal/intern/select/largesize.h"
#elif defined(_WIN32)
# include "ruby/internal/intern/select/win32.h"
# /** Does nothing (defined for compatibility). */
# define rb_fd_resize(n, f) ((void)(f))
#else
# include "ruby/internal/intern/select/posix.h"
# /** Does nothing (defined for compatibility). */
# define rb_fd_resize(n, f) ((void)(f))
#endif

RBIMPL_SYMBOL_EXPORT_BEGIN()

struct timeval;

/**
 * Waits for multiple file descriptors at once.  This is basically a wrapper of
 * system-provided select() with releasing GVL, to allow other Ruby threads run
 * in parallel.
 *
 * @param[in]      nfds       Max FD in everything passed, plus one.
 * @param[in,out]  rfds       Set of FDs to wait for reads.
 * @param[in,out]  wfds       Set of FDs to wait for writes.
 * @param[in,out]  efds       Set of FDs to wait for OOBs.
 * @param[in,out]  timeout    Max blocking duration.
 * @retval         -1         Failed, errno set.
 * @retval          0         Timeout exceeded.
 * @retval         otherwise  Total number of file descriptors returned.
 * @post           `rfds` contains readable FDs.
 * @post           `wfds` contains writable FDs.
 * @post           `efds` contains exceptional FDs.
 * @post           `timeout` is the time left.
 * @note           All pointers are allowed to be null pointers.
 *
 * Although backend  threads can run in  parallel of this function,  touching a
 * file descriptor  from multiple threads  could be problematic.   For instance
 * what happens  when a  thread closes  a file descriptor  that is  selected by
 * someone else, vastly varies among operating systems.  You would better avoid
 * touching an fd from more than one threads.
 *
 * @internal
 *
 * Although  any file  descriptors are  possible here,  it makes  completely no
 * sense to pass  a descriptor that is  not `O_NONBLOCK`.  If you  want to know
 * the reason for  this limitatuon in detail, you might  find this thread super
 * interesting: https://lkml.org/lkml/2004/10/6/117
 */
int rb_thread_fd_select(int nfds, rb_fdset_t *rfds, rb_fdset_t *wfds, rb_fdset_t *efds, struct timeval *timeout);

RBIMPL_SYMBOL_EXPORT_END()

#endif /* RBIMPL_INTERN_SELECT_H */
PK       ! (        ruby/internal/intern/ruby.hnu [        #ifndef RBIMPL_INTERN_RUBY_H                         /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_INTERN_RUBY_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Process-global APIs.
 */
#include "ruby/internal/attr/nonnull.h"
#include "ruby/internal/dllexport.h"
#include "ruby/internal/value.h"

RBIMPL_SYMBOL_EXPORT_BEGIN()

/* ruby.c */
/** @alias{rb_get_argv} */
#define rb_argv rb_get_argv()

/**
 * The value of `$0` at process bootup.
 *
 * @note  This is just a snapshot of `$0`, not the backend storage of it.  `$0`
 *        could  become something  different because  it is  a writable  global
 *        variable.  Modifying  it for instance affects  `ps(1)` output.  Don't
 *        assume they are synced.
 */
RUBY_EXTERN VALUE rb_argv0;

/* io.c */

/**
 * Queries the arguments passed to the current process that you can access from
 * Ruby as `ARGV`.
 *
 * @return  An array of strings containing arguments passed to the process.
 */
VALUE rb_get_argv(void);

/* ruby.c */

RBIMPL_ATTR_NONNULL(())
/**
 * Loads the given  file.  This function opens the given  pathname for reading,
 * parses the contents as a Ruby  script, and returns an opaque "node" pointer.
 * You can then pass it to ruby_run_node() for evaluation.
 *
 * @param[in]  file  File name, or "-" to read from stdin.
 * @return     Opaque "node" pointer.
 */
void *rb_load_file(const char *file);

/**
 * Identical to rb_load_file(), except it takes the argument as a Ruby's string
 * instead of C's.
 *
 * @param[in]  file  File name, or "-" to read from stdin.
 * @return     Opaque "node" pointer.
 */
void *rb_load_file_str(VALUE file);

RBIMPL_SYMBOL_EXPORT_END()

#endif /* RBIMPL_INTERN_RUBY_H */
PK       ! o*}0  0    ruby/internal/intern/random.hnu [        #ifndef RBIMPL_INTERN_RANDOM_H                       /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_INTERN_RANDOM_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      MT19937 backended pseudo random number generator.
 * @see        Matsumoto,  M.,   Nishimura,  T.,  "Mersenne  Twister:   A  623-
 *             dimensionally   equidistributed   uniform  pseudorandom   number
 *             generator", ACM  Trans. on  Modeling and Computer  Simulation, 8
 *             (1): pp 3-30, 1998.  https://doi.org/10.1145/272991.272995
 */
#include "ruby/internal/dllexport.h"
#include "ruby/internal/value.h"

RBIMPL_SYMBOL_EXPORT_BEGIN()

/* random.c */

/**
 * Generates a 32 bit random number.
 *
 * @return  A random number.
 * @note    Now  that  we  have  ractors,  the  RNG  behind  this  function  is
 *          per-ractor.
 */
unsigned int rb_genrand_int32(void);

/**
 * Generates a `double` random number.
 *
 * @return  A random number.
 * @note    This function shares the RNG with rb_genrand_int32().
 */
double rb_genrand_real(void);

/**
 * Resets the RNG behind rb_genrand_int32()/rb_genrand_real().
 *
 * @post  The (now per-ractor) default RNG's internal state is cleared.
 */
void rb_reset_random_seed(void);

/**
 * Generates a String of random bytes.
 *
 * @param[in,out]  rnd  An instance of ::rb_cRandom.
 * @param[in]      n    Requested number of bytes.
 * @return         An instance of ::rb_cString, of binary, of `n` bytes length,
 *                 whose contents are random bits.
 *
 * @internal
 *
 * @shyouhei doesn't know if this is an  Easter egg or an official feature, but
 * this function can  take a wider range of objects,  such as `Socket::Ifaddr`.
 * The arguments are just silently ignored and the default RNG is used instead,
 * if they are non-RNG.
 */
VALUE rb_random_bytes(VALUE rnd, long n);

/**
 * Identical to rb_genrand_int32(), except it generates using the passed RNG.
 *
 * @param[in,out]  rnd  An instance of ::rb_cRandom.
 * @return         A random number.
 */
unsigned int rb_random_int32(VALUE rnd);

/**
 * Identical to rb_genrand_real(), except it generates using the passed RNG.
 *
 * @param[in,out]  rnd  An instance of ::rb_cRandom.
 * @return         A random number.
 */
double rb_random_real(VALUE rnd);

/**
 * Identical  to  rb_genrand_ulong_limited(),  except it  generates  using  the
 * passed RNG.
 *
 * @param[in,out]  rnd    An instance of ::rb_cRandom.
 * @param[in]      limit  Max possible return value.
 * @return         A random number, distributed in `[0, limit]` interval.
 * @note           Note it can return `limit`.
 * @note           Whether  the  return  value  distributes  uniformly  in  the
 *                 interval or not depends on  how the argument RNG behaves; at
 *                 least in case of MT19937 it does.
 */
unsigned long rb_random_ulong_limited(VALUE rnd, unsigned long limit);

/**
 * Generates a random number whose upper limit is `i`.
 *
 * @param[in]  i  Max possible return value.
 * @return     A random number, uniformly distributed in `[0, limit]` interval.
 * @note       Note it can return `i`.
 */
unsigned long rb_genrand_ulong_limited(unsigned long i);

RBIMPL_SYMBOL_EXPORT_END()

#endif /* RBIMPL_INTERN_RANDOM_H */
PK       ! K<S  <S    ruby/internal/intern/variable.hnu [        #ifndef RBIMPL_INTERN_VARIABLE_H                     /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_INTERN_VARIABLE_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Public APIs related to names inside of a Ruby program.
 */
#include "ruby/internal/attr/nonnull.h"
#include "ruby/internal/attr/noreturn.h"
#include "ruby/internal/dllexport.h"
#include "ruby/internal/value.h"
#include "ruby/st.h"

RBIMPL_SYMBOL_EXPORT_BEGIN()

/* variable.c */

/**
 * Queries the name of a module.
 *
 * @param[in]  mod        An instance of ::rb_cModule.
 * @retval     RUBY_Qnil  `mod` is anonymous.
 * @retval     otherwise  `mod` is onymous.
 */
VALUE rb_mod_name(VALUE mod);

/**
 * Identical  to  rb_mod_name(),  except   it  returns  `#<Class:  ...>`  style
 * inspection for anonymous modules.
 *
 * @param[in]  mod        An instance of ::rb_cModule.
 * @return     An instance of ::rb_cString representing `mod`'s path.
 */
VALUE rb_class_path(VALUE mod);

/**
 * @alias{rb_mod_name}
 *
 * @internal
 *
 * Am I missing something?  Why we have the same thing in different names?
 */
VALUE rb_class_path_cached(VALUE mod);

RBIMPL_ATTR_NONNULL(())
/**
 * Names a class.
 *
 * @param[out]  klass  Target module to name.
 * @param[out]  space  Namespace that `klass` shall reside.
 * @param[in]   name   Name of `klass`.
 * @post        `klass` has `space::klass` name.
 */
void rb_set_class_path(VALUE klass, VALUE space, const char *name);

/**
 * Identical  to rb_set_class_path(),  except  it accepts  the  name as  Ruby's
 * string instead of C's.
 *
 * @param[out]  klass  Target module to name.
 * @param[out]  space  Namespace that `klass` shall reside.
 * @param[in]   name   Name of `klass`.
 * @post        `klass` has `space::klass` name.
 */
void rb_set_class_path_string(VALUE klass, VALUE space, VALUE name);

/**
 * Identical to  rb_path2class(), except it  accepts the path as  Ruby's string
 * instead of C's.
 *
 * @param[in]  path           Path to query.
 * @exception  rb_eArgError   No such constant.
 * @exception  rb_eTypeError  The path resolved to a non-module.
 * @return     Resolved class.
 */
VALUE rb_path_to_class(VALUE path);

RBIMPL_ATTR_NONNULL(())
/**
 * Resolves a `Q::W::E::R`-style path string to the actual class it points.
 *
 * @param[in]  path           Path to query.
 * @exception  rb_eArgError   No such constant.
 * @exception  rb_eTypeError  The path resolved to a non-module.
 * @return     Resolved class.
 */
VALUE rb_path2class(const char *path);

/**
 * Queries the name of the given object's class.
 *
 * @param[in]  obj  Arbitrary object.
 * @return     An instance of ::rb_cString representing `obj`'s class' path.
 */
VALUE rb_class_name(VALUE obj);

/**
 * Kicks the autoload procedure as if it was "touched".
 *
 * @param[out]  space        Namespace where autoload is defined.
 * @param[in]   name         Name of the autoloaded constant.
 * @retval      RUBY_Qfalse  No such autoload.
 * @retval      RUBY_Qtrue   Autoload successfully initiated.
 * @note        As an  autoloaded library is expected  to define `space::name`,
 *              it is  a nature  of this function  to have  process-global side
 *              effects.
 * @note        Multiple threads  can simultaneously call this  API.  It blocks
 *              then.  That must not last indefinitely but can take longer than
 *              you expect.
 *
 * @internal
 *
 * @shyouhei has no idea why extension libraries should use this API.
 */
VALUE rb_autoload_load(VALUE space, ID name);

/**
 * Queries if an autoload is defined at a point.
 *
 * @param[in]  space      Namespace where autoload is defined.
 * @param[in]  name       Name of the autoloaded constant.
 * @retval     RUBY_Qnil  No such autoload.
 * @retval     otherwise  The feature (path) registered at `space::name`.
 */
VALUE rb_autoload_p(VALUE space, ID name);

/**
 * Traces a global variable.
 *
 * @param[in]  argc        Either 1 or 2.
 * @param[in]  argv        Variable name, optionally a Proc.
 * @retval     RUBY_Qnil   No previous tracers.
 * @retval     otherwise   Previous tracers.
 *
 * @internal
 *
 * @shyouhei has no idea why extension libraries should use this API.
 */
VALUE rb_f_trace_var(int argc, const VALUE *argv);

/**
 * Deletes the  passed tracer from the  passed global variable, or  if omitted,
 * deletes everything.
 *
 * @param[in]  argc        Either 1 or 2.
 * @param[in]  argv        Variable name, optionally a Proc.
 * @retval     RUBY_Qnil   No previous tracers.
 * @retval     otherwise   Deleted tracers.
 *
 * @internal
 *
 * @shyouhei has no idea why extension libraries should use this API.
 */
VALUE rb_f_untrace_var(int argc, const VALUE *argv);

/**
 * Queries the list of global variables.
 *
 * @return  The list of the name of the global variables.
 *
 * @internal
 *
 * Above description is in fact inaccurate.  This API interfaces with Ractors.
 */
VALUE rb_f_global_variables(void);

/**
 * Aliases  a global  variable.   Did you  know  that you  can  alias a  global
 * variable?  It is like aliasing methods:
 *
 * ```ruby
 * alias $dst $src
 * ```
 *
 * This C function does the same thing.
 *
 * @param[in]  dst  Destination name.
 * @param[in]  src  Source name.
 * @post       A global  variable named `dst`  is defined to  be an alias  of a
 *             global variable named `src`.
 *
 * @internal
 *
 * Above description is in fact inaccurate.  This API interfaces with Ractors.
 */
void rb_alias_variable(ID dst, ID src);

/**
 * Frees the list of instance variables.   3rd parties need not know, but there
 * are several ways  to store an object's instance variables,  depending on its
 * internal structure.   This function makes  sense when the passed  objects is
 * using so-called "generic" backend storage.  People need not be aware of this
 * working behind-the-scenes.
 *
 * @param[out]  obj  The object in question.
 *
 * @internal
 *
 * This just  destroys the given object.   @shyouhei has no idea  why extension
 * libraries should use this API.
 */
void rb_free_generic_ivar(VALUE obj);

/**
 * Identical to rb_iv_get(), except it accepts the name as an ::ID instead of a
 * C string.
 *
 * @param[in]  obj        Target object.
 * @param[in]  name       Target instance variable to query.
 * @retval     RUBY_nil   No such instance variable.
 * @retval     otherwise  The value assigned to the instance variable.
 */
VALUE rb_ivar_get(VALUE obj, ID name);

/**
 * Identical to rb_iv_set(), except it accepts the name as an ::ID instead of a
 * C string.
 *
 * @param[out]  obj              Target object.
 * @param[in]   name             Target instance variable.
 * @param[in]   val              Value to assign.
 * @exception   rb_eFrozenError  Can't modify `obj`.
 * @exception   rb_eArgError     `obj` has too many instance variables.
 * @return      Passed value.
 * @post        An  instance variable  named  `name` is  defined  if absent  on
 *              `obj`, whose value is set to `val`.
 */
VALUE rb_ivar_set(VALUE obj, ID name, VALUE val);

/**
 * Queries if  the instance variable  is defined  at the object.   This roughly
 * resembles `defined?(@name)` in `obj`'s context.
 *
 * @param[in]  obj          Target object.
 * @param[in]  name         Target instance variable to query.
 * @retval     RUBY_Qtrue   There is an instance variable.
 * @retval     RUBY_Qfalse  No such instance variable.
 */
VALUE rb_ivar_defined(VALUE obj, ID name);

/**
 * Iterates over an object's instance variables.
 *
 * @param[in]  obj   Target object.
 * @param[in]  func  Callback function.
 * @param[in]  arg   Passed as-is to the last argument of `func`.
 */
void rb_ivar_foreach(VALUE obj, int (*func)(ID name, VALUE val, st_data_t arg), st_data_t arg);

/**
 * Number of instance variables defined on an object.
 *
 * @param[in]  obj   Target object.
 * @return     Number of instance variables defined on `obj`.
 */
st_index_t rb_ivar_count(VALUE obj);

/**
 * Identical to rb_ivar_get()
 *
 * @param[in]  obj        Target object.
 * @param[in]  name       Target instance variable to query.
 * @retval     RUBY_nil   No such instance variable.
 * @retval     otherwise  The value assigned to the instance variable.
 *
 * @internal
 *
 * Am I missing something?  Why we have the same thing in different names?
 */
VALUE rb_attr_get(VALUE obj, ID name);

/**
 * Resembles `Object#instance_variables`.
 *
 * @param[in]  obj  Target object to query.
 * @return     An array of instance variable names for the receiver.
 * @note       Simply defining  an accessor  does not create  the corresponding
 *             instance variable.
 */
VALUE rb_obj_instance_variables(VALUE obj);

/**
 * Resembles `Object#remove_instance_variable`.
 *
 * @param[out]  obj   Target object.
 * @param[in]   name  Variable name to remove, either in Symbol or String.
 * @return      What was removed.
 * @pre         Instance variable named `name` is deleted from `obj`.
 */
VALUE rb_obj_remove_instance_variable(VALUE obj, VALUE name);

/**
 * This API is  mysterious.  It has been there since  the initial revision.  No
 * single bits of  documents has ever been written.  The  function name doesn't
 * describe anything.  What should be passed to the argument, or what should be
 * the  return value,  are not  obvious.  Yet  it has  evolved over  time.  The
 * source code is written in counter-intuitive way (as of 3.0).
 *
 * Simply put, don't try to understand this API.
 */
void *rb_mod_const_at(VALUE, void*);

/**
 * This is a variant of rb_mod_const_at().  As a result, it is also mysterious.
 * It _seems_ it iterates over the ancestry  tree of the module.  But what that
 * means is beyond a human brain.
 */
void *rb_mod_const_of(VALUE, void*);

/**
 * This is  another mysterious  API that  comes with no  documents at  all.  It
 * seems it expects  some specific data structure for the  passed pointer.  But
 * the details has  never been made explicit.  It seems  nobody should use this
 * API.
 */
VALUE rb_const_list(void*);

/**
 * Resembles  `Module#constants`.   List  up   the  constants  defined  at  the
 * receiver.  This  includes the  names of constants  in any  included modules,
 * unless `argv[0]` is ::RUBY_Qfalse.
 *
 * The  implementation  makes  no  guarantees  about the  order  in  which  the
 * constants are yielded.
 *
 * @param[in]  argc  Either 0 or 1.
 * @param[in]  argv  Pointer to ::RUBY_Qfalse, if `argc == 1`.
 * @param[in]  recv  Target namespace.
 * @return     An array of symbols, which are constant names under `recv`.
 */
VALUE rb_mod_constants(int argc, const VALUE *argv, VALUE recv);

/**
 * Resembles `Module#remove_const`.
 *
 * @param[out]  space  Target namespace.
 * @param[in]   name   Variable name to remove, either in Symbol or String.
 * @return      What was removed.
 * @pre         Constant named `space::name` is deleted.
 * @note        In case what was removed was in  fact a module or a class, this
 *              operation does  not affect its  name.  Which means  when people
 *              for instance  look at  it using `p`  etc., it  still introduces
 *              itself using the deleted name.  Can confuse people.
 */
VALUE rb_mod_remove_const(VALUE space, VALUE name);

/**
 * Queries if the constant is defined at the namespace.
 *
 * @param[in]  space        Target namespace.
 * @param[in]  name         Target name to query.
 * @retval     RUBY_Qtrue   There is a constant.
 * @retval     RUBY_Qfalse  No such constant.
 *
 * @internal
 *
 * The return values are not typo!  This function returns ruby values casted to
 * `int`.  Completely brain-damaged design.
 */
int rb_const_defined(VALUE space, ID name);

/**
 * Identical to rb_const_defined(), except it  doesn't look for parent classes.
 * For  instance  `Array`  is  a  toplevel  constant,  which  is  visible  from
 * everywhere.  But this  function does not take such things  into account.  It
 * concerns only what is directly defined inside of the given namespace.
 *
 * @param[in]  space        Target namespace.
 * @param[in]  name         Target name to query.
 * @retval     RUBY_Qtrue   There is a constant.
 * @retval     RUBY_Qfalse  No such constant.
 *
 * @internal
 *
 * The return values are not typo!  This function returns ruby values casted to
 * `int`.  Completely brain-damaged design.
 */
int rb_const_defined_at(VALUE space, ID name);

/**
 * Identical  to  rb_const_defined(),  except  it  returns  false  for  private
 * constants.
 *
 * @param[in]  space        Target namespace.
 * @param[in]  name         Target name to query.
 * @retval     RUBY_Qtrue   There is a constant.
 * @retval     RUBY_Qfalse  No such constant.
 *
 * @internal
 *
 * What does "from" mean?  The name sounds quite cryptic.
 *
 * The return values are not typo!  This function returns ruby values casted to
 * `int`.  Completely brain-damaged design.
 */
int rb_const_defined_from(VALUE space, ID name);

/**
 * Identical to rb_const_defined(), except it returns the actual defined value.
 *
 * @param[in]  space          Target namespace.
 * @param[in]  name           Target name to query.
 * @exception  rb_eNameError  No such constant.
 * @return     The defined constant.
 *
 * @internal
 *
 * Above description is in fact inaccurate.  This API interfaces with Ractors.
 */
VALUE rb_const_get(VALUE space, ID name);

/**
 * Identical  to rb_const_defined_at(),  except it  returns the  actual defined
 * value.  It can also be seen as a routine identical to rb_const_get(), except
 * it doesn't look for parent classes.
 *
 * @param[in]  space          Target namespace.
 * @param[in]  name           Target name to query.
 * @exception  rb_eNameError  No such constant.
 * @return     The defined constant.
 *
 * @internal
 *
 * Above description is in fact inaccurate.  This API interfaces with Ractors.
 */
VALUE rb_const_get_at(VALUE space, ID name);

/**
 * Identical  to rb_const_defined_at(),  except it  returns the  actual defined
 * value.  It can also be seen as a routine identical to rb_const_get(), except
 * it doesn't return a private constant.
 *
 * @param[in]  space          Target namespace.
 * @param[in]  name           Target name to query.
 * @exception  rb_eNameError  No such constant.
 * @return     The defined constant.
 *
 * @internal
 *
 * Above description is in fact inaccurate.  This API interfaces with Ractors.
 */
VALUE rb_const_get_from(VALUE space, ID name);

/**
 * Names a constant.
 *
 * @param[out]  space          Target namespace.
 * @param[in]   name           Target name to query.
 * @param[in]   val            Value to define.
 * @exception   rb_eTypeError  `space` is not a module.
 * @post        `name` is a constant under `space`, whose value is `val`.
 * @note        You can reassign.
 *
 * @internal
 *
 * Above description is in fact inaccurate.  This API interfaces with Ractors.
 */
void rb_const_set(VALUE space, ID name, VALUE val);

/**
 * Identical to rb_mod_remove_const(), except it takes the name as ::ID instead
 * of ::VALUE.
 *
 * @param[out]  space  Target namespace.
 * @param[in]   name   Variable name to remove, either in Symbol or String.
 * @return      What was removed.
 * @pre         Constant named `space::name` is deleted.
 * @note        In case what was removed was in  fact a module or a class, this
 *              operation does  not affect its  name.  Which means  when people
 *              for instance  look at  it using `p`  etc., it  still introduces
 *              itself using the deleted name.  Can confuse people.
 */
VALUE rb_const_remove(VALUE space, ID name);

#if 0 /* EXPERIMENTAL: remove if no problem */
RBIMPL_ATTR_NORETURN()
/**
 * This is the default implementation of `Module#const_missing`.
 *
 * @param[in]  space          Target namespace.
 * @param[in]  name           Target name that is nonexistent.
 * @exception  rb_eNameError  Always.
 */
VALUE rb_mod_const_missing(VALUE space, VALUE name);
#endif

/**
 * Queries if the given class has the given class variable.
 *
 * @param[in]  klass        Target class.
 * @param[in]  name         Name to query.
 * @return     RUBY_Qtrue   Yes there is.
 * @return     RUBY_Qfalse  No there isn't.
 * @pre        `klass` must be an instance of rb_cModule.
 *
 * @internal
 *
 * Above description is in fact inaccurate.  This API interfaces with Ractors.
 */
VALUE rb_cvar_defined(VALUE klass, ID name);

/**
 * Assigns a value to a class variable.
 *
 * @param[out]  klass  Target class.
 * @param[in]   name   Variable name.
 * @param[in]   val    Value to be assigned.
 * @post        `klass` has a class variable named `name` whose value is `val`.
 *
 * @internal
 *
 * Above description is in fact inaccurate.  This API interfaces with Ractors.
 */
void rb_cvar_set(VALUE klass, ID name, VALUE val);

/**
 * Obtains a value from a class variable.
 *
 * @param[in]  klass             Target class.
 * @param[in]  name              Variable name.
 * @exception  rb_eNameError     Uninitialised class variable.
 * @exception  rb_eRuntimeError  `[Bug#14541]` situation.
 * @return     Class variable named `name` under `klass`.
 *
 * @internal
 *
 * Above description is in fact inaccurate.  This API interfaces with Ractors.
 */
VALUE rb_cvar_get(VALUE klass, ID name);

RBIMPL_ATTR_NONNULL(())
/**
 * Identical  to rb_cvar_get(),  except  it takes  additional "front"  pointer.
 * This  extra parameter  is a  buffer,  which will  have the  class where  the
 * queried class variable actually resides.
 *
 * @param[in]   klass             Target class.
 * @param[in]   name              Variable name.
 * @param[out]  front             Return buffer.
 * @exception   rb_eNameError     Uninitialised class variable.
 * @exception   rb_eRuntimeError  `[Bug#14541]` situation.
 * @return      Class variable named `name` under `klass`.
 * @post        `front` has the class object,  which is an ancestor of `klass`,
 *              where the queried class variable actually resides.
 *
 * @internal
 *
 * Above description is in fact inaccurate.  This API interfaces with Ractors.
 */
VALUE rb_cvar_find(VALUE klass, ID name, VALUE *front);

RBIMPL_ATTR_NONNULL(())
/**
 * Identical to rb_cvar_set(), except it accepts C's string instead of ::ID.
 *
 * @param[out]  klass  Target class.
 * @param[in]   name   Variable name.
 * @param[in]   val    Value to be assigned.
 * @post        `klass` has a class variable named `name` whose value is `val`.
 */
void rb_cv_set(VALUE klass, const char *name, VALUE val);

RBIMPL_ATTR_NONNULL(())
/**
 * Identical to rb_cvar_get(), except it accepts