cter set's  collating sequence,  carrying to  the next-left
 * character for a rollover, and prepending another character if necessary:
 *
 * ```ruby
 * s = "\u03A1"
 * s.succ # => "\u03A3"  # There is no such thing like \u03A2.
 * s = 255.chr * 3
 * s # => "\xFF\xFF\xFF"
 * s.succ # => "\x01\x00\x00\x00"
 * ```
 *
 * Carrying can occur between and among mixtures of alphanumeric characters:
 *
 * ```ruby
 * s = 'zz99zz99'
 * s.succ # => "aaa00aa00"
 * s = '99zz99zz'
 * s.succ # => "100aa00aa"
 * s = '1.9.9'
 * s.succ # => "2.0.0"
 * ```
 *
 * @param[in]  orig  Predecessor string.
 * @return     Successor string.
 */
VALUE rb_str_succ(VALUE orig);

RBIMPL_ATTR_NONNULL(())
/**
 * @private
 *
 * This is an implementation detail.  Don't bother.
 *
 * @param[in]  str  A C string.
 * @return     `strlen`, casted to `long`.
 */
static inline long
rbimpl_strlen(const char *str)
{
    return RBIMPL_CAST((long)strlen(str));
}

RBIMPL_ATTR_NONNULL(())
/**
 * @private
 *
 * This is an implementation detail.  Don't bother.
 *
 * @param[in]  str  A C string literal.
 * @return     Corresponding Ruby string.
 */
static inline VALUE
rbimpl_str_new_cstr(const char *str)
{
    long len = rbimpl_strlen(str);
    return rb_str_new_static(str, len);
}

RBIMPL_ATTR_NONNULL(())
/**
 * @private
 *
 * This is an implementation detail.  Don't bother.
 *
 * @param[in]  str  A C string literal.
 * @return     Corresponding Ruby string.
 */
static inline VALUE
rbimpl_usascii_str_new_cstr(const char *str)
{
    long len = rbimpl_strlen(str);
    return rb_usascii_str_new_static(str, len);
}

RBIMPL_ATTR_NONNULL(())
/**
 * @private
 *
 * This is an implementation detail.  Don't bother.
 *
 * @param[in]  str  A C string literal.
 * @return     Corresponding Ruby string.
 */
static inline VALUE
rbimpl_utf8_str_new_cstr(const char *str)
{
    long len = rbimpl_strlen(str);
    return rb_utf8_str_new_static(str, len);
}

RBIMPL_ATTR_NONNULL(())
/**
 * @private
 *
 * This is an implementation detail.  Don't bother.
 *
 * @param[in]  str  A C string literal.
 * @return     Corresponding Ruby string.
 */
static inline VALUE
rbimpl_external_str_new_cstr(const char *str)
{
    long len = rbimpl_strlen(str);
    return rb_external_str_new(str, len);
}

RBIMPL_ATTR_NONNULL(())
/**
 * @private
 *
 * This is an implementation detail.  Don't bother.
 *
 * @param[in]  str  A C string literal.
 * @return     Corresponding Ruby string.
 */
static inline VALUE
rbimpl_locale_str_new_cstr(const char *str)
{
    long len = rbimpl_strlen(str);
    return rb_locale_str_new(str, len);
}

RBIMPL_ATTR_NONNULL(())
/**
 * @private
 *
 * This is an implementation detail.  Don't bother.
 *
 * @param[in]  str  A C string literal.
 * @return     Corresponding Ruby string.
 */
static inline VALUE
rbimpl_str_buf_new_cstr(const char *str)
{
    long len = rbimpl_strlen(str);
    VALUE buf = rb_str_buf_new(len);
    return rb_str_buf_cat(buf, str, len);
}

RBIMPL_ATTR_NONNULL(())
/**
 * @private
 *
 * This is an implementation detail.  Don't bother.
 *
 * @param[out]  buf  A string buffer.
 * @param[in]   str  A C string literal.
 * @return      `buf` itself.
 */
static inline VALUE
rbimpl_str_cat_cstr(VALUE buf, const char *str)
{
    long len = rbimpl_strlen(str);
    return rb_str_cat(buf, str, len);
}

RBIMPL_ATTR_NONNULL(())
/**
 * @private
 *
 * This is an implementation detail.  Don't bother.
 *
 * @param[in]  exc  An exception class.
 * @param[in]  str  A C string literal.
 * @return     An instance of `exc`.
 */
static inline VALUE
rbimpl_exc_new_cstr(VALUE exc, const char *str)
{
    long len = rbimpl_strlen(str);
    return rb_exc_new(exc, str, len);
}

/**
 * Allocates an instance of ::rb_cString.
 *
 * @param[in]  str             A memory region of `len` bytes length.
 * @param[in]  len             Length  of `ptr`,  in bytes,  not including  the
 *                             terminating NUL character.
 * @exception  rb_eNoMemError  Failed to allocate `len+1` bytes.
 * @exception  rb_eArgError    `len` is negative.
 * @return     An  instance   of  ::rb_cString,  of  `len`   bytes  length,  of
 *             "binary" encoding, whose contents are verbatim copy of `str`.
 * @pre        At  least  `len` bytes  of  continuous  memory region  shall  be
 *             accessible via `str`.
 */
#define rb_str_new(str, len)                    \
    ((RBIMPL_CONSTANT_P(str) &&                 \
      RBIMPL_CONSTANT_P(len) ?                  \
      rb_str_new_static      :                  \
      rb_str_new) ((str), (len)))

/**
 * Identical to #rb_str_new, except it assumes  the passed pointer is a pointer
 * to a C string.
 *
 * @param[in]  str             A C string.
 * @exception  rb_eNoMemError  Failed to allocate memory.
 * @return     An  instance  of  ::rb_cString,   of  "binary"  encoding,  whose
 *             contents are verbatim copy of `str`.
 * @pre        `str` must not be a null pointer.
 */
#define rb_str_new_cstr(str)                    \
    ((RBIMPL_CONSTANT_P(str) ?                  \
      rbimpl_str_new_cstr    :                  \
      rb_str_new_cstr) (str))

/**
 * Identical  to  #rb_str_new, except  it  generates  a  string of  "US  ASCII"
 * encoding.  This  is different from  rb_external_str_new(), not only  for the
 * output encoding, but also it doesn't convert the contents.
 *
 * @param[in]  str             A memory region of `len` bytes length.
 * @param[in]  len             Length  of `str`,  in bytes,  not including  the
 *                             terminating NUL character.
 * @exception  rb_eNoMemError  Failed to allocate `len+1` bytes.
 * @exception  rb_eArgError    `len` is negative.
 * @return     An  instance   of  ::rb_cString,  of  `len`   bytes  length,  of
 *             "US ASCII" encoding, whose contents are verbatim copy of `str`.
 */
#define rb_usascii_str_new(str, len)            \
    ((RBIMPL_CONSTANT_P(str)    &&              \
      RBIMPL_CONSTANT_P(len)    ?               \
      rb_usascii_str_new_static :               \
      rb_usascii_str_new) ((str), (len)))

/**
 * Identical to #rb_str_new, except it generates a string of "UTF-8" encoding.
 *
 * @param[in]  str             A memory region of `len` bytes length.
 * @param[in]  len             Length  of `str`,  in bytes,  not including  the
 *                             terminating NUL character.
 * @exception  rb_eNoMemError  Failed to allocate `len+1` bytes.
 * @exception  rb_eArgError    `len` is negative.
 * @return     An  instance   of  ::rb_cString,  of  `len`   bytes  length,  of
 *             "UTF-8" encoding, whose contents are verbatim copy of `str`.
 */
#define rb_utf8_str_new(str, len)               \
    ((RBIMPL_CONSTANT_P(str) &&                 \
      RBIMPL_CONSTANT_P(len) ?                  \
      rb_utf8_str_new_static :                  \
      rb_utf8_str_new) ((str), (len)))

/**
 * Identical to  #rb_str_new_cstr, except it  generates a string of  "US ASCII"
 * encoding.    It   can   also   be   seen   as   a   routine   Identical   to
 * #rb_usascii_str_new, except it assumes the passed  pointer is a pointer to a
 * C string.
 *
 * @param[in]  str             A C string.
 * @exception  rb_eNoMemError  Failed to allocate memory.
 * @return     An  instance  of ::rb_cString,  of  "US  ASCII" encoding,  whose
 *             contents are verbatim copy of `str`.
 * @pre        `str` must not be a null pointer.
 */
#define rb_usascii_str_new_cstr(str)            \
    ((RBIMPL_CONSTANT_P(str)      ?             \
      rbimpl_usascii_str_new_cstr :             \
      rb_usascii_str_new_cstr) (str))

/**
 * Identical  to #rb_str_new_cstr,  except  it generates  a  string of  "UTF-8"
 * encoding.  It can  also be seen as a routine  Identical to #rb_utf8_str_new,
 * except it assumes the passed pointer is a pointer to a C string.
 *
 * @param[in]  str             A C string.
 * @exception  rb_eNoMemError  Failed to allocate memory.
 * @return     An instance of ::rb_cString, of "UTF-8" encoding, whose contents
 *             are verbatim copy of `str`.
 * @pre        `str` must not be a null pointer.
 */
#define rb_utf8_str_new_cstr(str)               \
    ((RBIMPL_CONSTANT_P(str)   ?                \
      rbimpl_utf8_str_new_cstr :                \
      rb_utf8_str_new_cstr) (str))

/**
 * Identical  to #rb_str_new_cstr,  except it  generates a  string of  "default
 * external" encoding.
 *
 * @param[in]  str             A C string.
 * @exception  rb_eNoMemError  Failed to allocate memory.
 * @return     An instance  of ::rb_cString.  In case  encoding conversion from
 *             "default internal"  to "default external" is  fully defined over
 *             the  given  contents, then  the  return  value  is a  string  of
 *             "default external"  encoding, whose  contents are  the converted
 *             ones.  Otherwise the string is a junk.
 * @warning    It doesn't raise on a conversion failure and silently ends up in
 *             a  corrupted  output.  You  can  know  the failure  by  querying
 *             `valid_encoding?` of the result object.
 * @pre        `str` must not be a null pointer.
 */
#define rb_external_str_new_cstr(str)           \
    ((RBIMPL_CONSTANT_P(str)       ?            \
      rbimpl_external_str_new_cstr :            \
      rb_external_str_new_cstr) (str))

/**
 * Identical  to #rb_external_str_new_cstr,  except  it generates  a string  of
 * "locale" encoding instead of "default external".
 *
 * @param[in]  str             A C string.
 * @exception  rb_eNoMemError  Failed to allocate memory.
 * @return     An instance  of ::rb_cString.  In case  encoding conversion from
 *             "default internal" to  "locale" is fully defined  over the given
 *             contents,  then  the  return  value  is  a  string  of  "locale"
 *             encoding, whose contents are  the converted ones.  Otherwise the
 *             string is a junk.
 * @warning    It doesn't raise on a conversion failure and silently ends up in
 *             a  corrupted  output.  You  can  know  the failure  by  querying
 *             `valid_encoding?` of the result object.
 * @pre        `str` must not be a null pointer.
 */
#define rb_locale_str_new_cstr(str)             \
    ((RBIMPL_CONSTANT_P(str)     ?              \
      rbimpl_locale_str_new_cstr :              \
      rb_locale_str_new_cstr) (str))

/**
 * Identical to #rb_str_new_cstr, except done differently.
 *
 * @param[in]  str             A C string.
 * @exception  rb_eNoMemError  Failed to allocate memory.
 * @return     An  instance  of  ::rb_cString,   of  "binary"  encoding,  whose
 *             contents are verbatim copy of `str`.
 * @pre        `str` must not be a null pointer.
 */
#define rb_str_buf_new_cstr(str)                \
    ((RBIMPL_CONSTANT_P(str)  ?                 \
      rbimpl_str_buf_new_cstr :                 \
      rb_str_buf_new_cstr) (str))

/**
 * Identical to rb_str_cat(), except it assumes the passed pointer is a pointer
 * to a C string.
 *
 * @param[out]  buf                 Destination object.
 * @param[in]   str                 Contents to append.
 * @exception   rb_eArgError        Result string too big.
 * @return      The passed `buf`.
 * @pre         `buf` must not be any arbitrary objects except ::RString.
 * @pre         `str` must not be a null pointer.
 * @post        `buf` has the contents of `str` appended.
 */
#define rb_str_cat_cstr(buf, str)               \
    ((RBIMPL_CONSTANT_P(str) ?                  \
      rbimpl_str_cat_cstr    :                  \
      rb_str_cat_cstr) ((buf), (str)))

/**
 * Identical to rb_exc_new(), except it assumes the passed pointer is a pointer
 * to a C string.
 *
 * @param[out]  exc  A subclass of ::rb_eException.
 * @param[in]   str  Message to raise.
 * @return      An instance of `exc` whose message is `str`.
 * @pre         `str` must not be a null pointer.
 */
#define rb_exc_new_cstr(exc, str)               \
    ((RBIMPL_CONSTANT_P(str) ?                  \
      rbimpl_exc_new_cstr    :                  \
      rb_exc_new_cstr) ((exc), (str)))

#define rb_str_new2 rb_str_new_cstr                  /**< @old{rb_str_new_cstr} */
#define rb_str_new3 rb_str_new_shared                /**< @old{rb_str_new_shared} */
#define rb_str_new4 rb_str_new_frozen                /**< @old{rb_str_new_frozen} */
#define rb_str_new5 rb_str_new_with_class            /**< @old{rb_str_new_with_class} */
#define rb_str_buf_new2 rb_str_buf_new_cstr          /**< @old{rb_str_buf_new_cstr} */
#define rb_usascii_str_new2 rb_usascii_str_new_cstr  /**< @old{rb_usascii_str_new_cstr} */
#define rb_str_buf_cat rb_str_cat                    /**< @alias{rb_str_cat} */
#define rb_str_buf_cat2 rb_str_cat_cstr              /**< @old{rb_usascii_str_new_cstr} */
#define rb_str_cat2 rb_str_cat_cstr                  /**< @old{rb_str_cat_cstr} */

/**
 * Length of a string literal.
 *
 * @param[in]  str  A C String literal.
 * @return     An integer  constant expression that represents  `str`'s length,
 *             in bytes, not including the terminating NUL character.
 */
#define rb_strlen_lit(str) (sizeof(str "") - 1)

/**
 * Identical to rb_str_new_static(), except it cannot take string variables.
 *
 * @param[in]  str  A C string literal.
 * @pre        `str` must not be a variable.
 * @return     An instance of ::rb_cString, of "binary" encoding, whose backend
 *             storage is the passed C string literal.
 * @warning    It is  a very  bad idea to  write to a  C string  literal (often
 *             immediate  SEGV shall  occur).  Consider  return values  of this
 *             function be read-only.
 */
#define rb_str_new_lit(str) rb_str_new_static((str), rb_strlen_lit(str))

/**
 * Identical  to  rb_usascii_str_new_static(),  except it  cannot  take  string
 * variables.
 *
 * @param[in]  str           A C string literal.
 * @pre        `str` must not be a variable.
 * @return     An  instance  of ::rb_cString,  of  "US  ASCII" encoding,  whose
 *             backend storage is the passed C string literal.
 * @warning    It is  a very  bad idea to  write to a  C string  literal (often
 *             immediate  SEGV shall  occur).  Consider  return values  of this
 *             function be read-only.
 */
#define rb_usascii_str_new_lit(str) rb_usascii_str_new_static((str), rb_strlen_lit(str))

/**
 * Identical  to   rb_utf8_str_new_static(),  except  it  cannot   take  string
 * variables.
 *
 * @param[in]  str           A C string literal.
 * @pre        `str` must not be a variable.
 * @return     An instance of ::rb_cString,  of "UTF-8" encoding, whose backend
 *             storage is the passed C string literal.
 * @warning    It is  a very  bad idea to  write to a  C string  literal (often
 *             immediate  SEGV shall  occur).  Consider  return values  of this
 *             function be read-only.
 */
#define rb_utf8_str_new_lit(str) rb_utf8_str_new_static((str), rb_strlen_lit(str))

/**
 * Identical  to   rb_enc_str_new_static(),  except   it  cannot   take  string
 * variables.
 *
 * @param[in]  str           A C string literal.
 * @param[in]  enc           A pointer to an encoding.
 * @pre        `str` must not be a variable.
 * @return     An  instance  of ::rb_cString,  of  the  passed encoding,  whose
 *             backend storage is the passed C string literal.
 * @warning    It is  a very  bad idea to  write to a  C string  literal (often
 *             immediate  SEGV shall  occur).  Consider  return values  of this
 *             function be read-only.
 */
#define rb_enc_str_new_lit(str, enc) rb_enc_str_new_static((str), rb_strlen_lit(str), (enc))

#define rb_str_new_literal(str) rb_str_new_lit(str)                    /**< @alias{rb_str_new_lit} */
#define rb_usascii_str_new_literal(str) rb_usascii_str_new_lit(str)    /**< @alias{rb_usascii_str_new_lit} */
#define rb_utf8_str_new_literal(str) rb_utf8_str_new_lit(str)          /**< @alias{rb_utf8_str_new_lit} */
#define rb_enc_str_new_literal(str, enc) rb_enc_str_new_lit(str, enc)  /**< @alias{rb_enc_str_new_lit} */

RBIMPL_SYMBOL_EXPORT_END()

#endif /* RBIMPL_INTERN_STRING_H */
PK       ! Ãx.  x.    ruby/internal/intern/hash.hnu [        #ifndef RBIMPL_INTERN_HASH_H                         /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_INTERN_HASH_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Public APIs related to ::rb_cHash.
 */
#include "ruby/internal/attr/nonnull.h"
#include "ruby/internal/dllexport.h"
#include "ruby/internal/value.h"
#include "ruby/st.h"

RBIMPL_SYMBOL_EXPORT_BEGIN()

/* hash.c */

RBIMPL_ATTR_NONNULL(())
/**
 * Identical to rb_st_foreach(), except it  raises exceptions when the callback
 * function tampers the table during iterating over it.
 *
 * @param[in]  st                Table to iterate over.
 * @param[in]  func              Callback function to apply.
 * @param[in]  arg               Passed as-is to `func`.
 * @exception  rb_eRuntimeError  `st` was tampered during iterating.
 *
 * @internal
 *
 * This is declared here because exceptions are Ruby level concept.
 *
 * This is in fact a very thin wrapper of rb_st_foreach_check().
 */
void rb_st_foreach_safe(struct st_table *st, st_foreach_callback_func *func, st_data_t arg);

/** @alias{rb_st_foreach_safe} */
#define st_foreach_safe rb_st_foreach_safe

/**
 * Try  converting an  object to  its hash  representation using  its `to_hash`
 * method, if any.  If there is no such thing, returns ::RUBY_Qnil.
 *
 * @param[in]  obj            Arbitrary ruby object to convert.
 * @exception  rb_eTypeError  `obj.to_hash` returned something non-Hash.
 * @retval     RUBY_Qnil      No conversion from `obj` to hash defined.
 * @retval     otherwise      Converted hash representation of `obj`.
 * @see        rb_io_check_io
 * @see        rb_check_array_type
 * @see        rb_check_string_type
 *
 * @internal
 *
 * There   is  no   rb_hash_to_hash()   that   analogous  to   rb_str_to_str().
 * Intentional or ...?
 */
VALUE rb_check_hash_type(VALUE obj);

RBIMPL_ATTR_NONNULL(())
/**
 * Iterates   over  a   hash.   This   basically   does  the   same  thing   as
 * rb_st_foreach().  But because the passed hash is a Ruby object, its keys and
 * values are both Ruby objects.
 *
 * @param[in]  hash              An instance of ::rb_cHash to iterate over.
 * @param[in]  func              Callback function to yield.
 * @param[in]  arg               Passed as-is to `func`.
 * @exception  rb_eRuntimeError  `hash` was tampered during iterating.
 */
void rb_hash_foreach(VALUE hash, int (*func)(VALUE key, VALUE val, VALUE arg), VALUE arg);

/**
 * Calculates a message  authentication code of the passed  object.  The return
 * value is  a very small  integer used as  an index of a  key of a  table.  In
 * order  to calculate  the value  this function  calls `#hash`  method of  the
 * passed  object.  Ruby  provides you  a default  implementation.  But  if you
 * implement  your class  in C,  that  default implementation  cannot know  the
 * underlying data structure.  You must implement your own `#hash` method then,
 * which  must return  an integer  of  uniform distribution  in a  sufficiently
 * instant manner.
 *
 * @param[in]  obj            Arbitrary Ruby object.
 * @exception  rb_eTypeError  `obj.hash` returned something non-Integer.
 * @return     A small integer.
 * @note       `#hash` can return very big integers, but they get truncated.
 */
VALUE rb_hash(VALUE obj);

/**
 * Creates a new, empty hash object.
 *
 * @return  An allocated new instance of ::rb_cHash.
 */
VALUE rb_hash_new(void);

/**
 * Identical to rb_hash_new(), except it additionally specifies how many keys
 * it is expected to contain. This way you can create a hash that is large enough
 * for your need. For large hashes it means it won't need to be reallocated and
 * rehashed as much, improving performance.
 *
 * @param[in]  capa  Designed capacity of the hash.
 * @return     An empty Hash, whose capacity is `capa`.
 */
VALUE rb_hash_new_capa(long capa);

/**
 * Duplicates a hash.
 *
 * @param[in]  hash  An instance of ::rb_cHash.
 * @return     An  allocated new  instance  of ::rb_cHash,  whose contents  are
 *             a verbatim copy of from `hash`.
 */
VALUE rb_hash_dup(VALUE hash);

/** @alias{rb_obj_freeze} */
VALUE rb_hash_freeze(VALUE obj);

/**
 * Queries the given key  in the given hash table.  If there is  the key in the
 * hash, returns the  value associated with the key.  Otherwise  it returns the
 * "default" value (defined per hash table).
 *
 * @param[in]  hash  Hash table to look into.
 * @param[in]  key   Hash key to look for.
 * @return     Either the value associated with the  key, or the default one if
 *             absent.
 */
VALUE rb_hash_aref(VALUE hash, VALUE key);

/**
 * Identical  to  rb_hash_aref(),  except  it always  returns  ::RUBY_Qnil  for
 * misshits.
 *
 * @param[in]  hash  Hash table to look into.
 * @param[in]  key   Hash key to look for.
 * @return     Either  the value  associated with  the key,  or ::RUBY_Qnil  if
 *             absent.
 * @note       A hash can  store ::RUBY_Qnil as an ordinary  value.  You cannot
 *             distinguish whether the  key is missing, or  just its associated
 *             value happens to be ::RUBY_Qnil, as far as you use this API.
 */
VALUE rb_hash_lookup(VALUE hash, VALUE key);

/**
 * Identical  to rb_hash_lookup(),  except you  can specify  what to  return on
 * misshits.  This is much like 2-arguments version of `Hash#fetch`.
 *
 * ```CXX
 * VALUE hash;
 * VALUE key;
 * VALUE tmp = rb_obj_alloc(rb_cObject);
 * VALUE val = rb_hash_lookup2(hash, key, tmp);
 * if (val == tmp) {
 *     printf("misshit");
 * }
 * else {
 *     printf("hit");
 * }
 * ```
 *
 * @param[in]  hash       Hash table to look into.
 * @param[in]  key        Hash key to look for.
 * @param[in]  def        Default value.
 * @retval     def        `hash` does not have `key`.
 * @retval     otherwise  The value associated with `key`.
 */
VALUE rb_hash_lookup2(VALUE hash, VALUE key, VALUE def);

/**
 * Identical  to rb_hash_lookup(),  except  it yields  the (implicitly)  passed
 * block instead of returning ::RUBY_Qnil.
 *
 * @param[in]  hash          Hash table to look into.
 * @param[in]  key           Hash key to look for.
 * @exception  rb_eKeyError  No block given.
 * @return     Either  the value  associated with  the key,  or what  the block
 *             evaluates to if absent.
 */
VALUE rb_hash_fetch(VALUE hash, VALUE key);

/**
 * Inserts or replaces ("upsert"s) the objects into the given hash table.  This
 * basically associates the  given value with the given key.   On duplicate key
 * this function updates its associated value with the given one.  Otherwise it
 * inserts the association at the end of the table.
 *
 * @param[out]  hash             Target hash table to modify.
 * @param[in]   key              Arbitrary Ruby object.
 * @param[in]   val              A value to be associated with `key`.
 * @exception   rb_eFrozenError  `hash` is frozen.
 * @return      The passed `val`
 * @post        `val` is associated with `key` in `hash`.
 */
VALUE rb_hash_aset(VALUE hash, VALUE key, VALUE val);

/**
 * Swipes everything out of the passed hash table.
 *
 * @param[out]  hash             Target to clear.
 * @exception   rb_eFrozenError  `hash`is frozen.
 * @return      The passed `hash`
 * @post        `hash` has no contents.
 */
VALUE rb_hash_clear(VALUE hash);

/**
 * Deletes each entry for which the block  returns a truthy value.  If there is
 * no block given, it returns an enumerator that does the thing.
 *
 * @param[out]  hash             Target hash to modify.
 * @exception   rb_eFrozenError  `hash` is frozen.
 * @retval      hash             The hash is modified.
 * @retval      otherwise        An instance of ::rb_cEnumerator that does it.
 */
VALUE rb_hash_delete_if(VALUE hash);

/**
 * Deletes the passed key from the passed hash table, if any.
 *
 * @param[out]  hash       Target hash to modify.
 * @param[in]   key        Key to delete.
 * @retval      RUBY_Qnil  `hash` has no such key as `key`.
 * @retval      otherwise  What was associated with `key`.
 * @post        `hash` has no such key as `key`.
 */
VALUE rb_hash_delete(VALUE hash, VALUE key);

/**
 * Inserts  a list  of  key-value pairs  into  a  hash table  at  once.  It  is
 * semantically  identical to  repeatedly  calling rb_hash_aset(),  but can  be
 * faster than that.
 *
 * @param[in]   argc  Length of `argv`, must be even.
 * @param[in]   argv  A list of key, value, key, value, ...
 * @param[out]  hash  Target hash table to modify.
 * @post        `hash` has contents from `argv`.
 * @note        `argv` is allowed to be NULL as long as `argc` is zero.
 *
 * @internal
 *
 * What happens for  duplicated keys?  Well it silently discards  older ones to
 * accept the newest (rightmost) one.  This behaviour also mimics repeated call
 * of rb_hash_aset().
 */
void rb_hash_bulk_insert(long argc, const VALUE *argv, VALUE hash);

/**
 * Type of callback functions to pass to rb_hash_update_by().
 *
 * @param[in]  newkey  A key of the table.
 * @param[in]  oldkey  Value associated with `key` in hash1.
 * @param[in]  value   Value associated with `key` in hash2.
 * @return     Either one of the passed values to take.
 */
typedef VALUE rb_hash_update_func(VALUE newkey, VALUE oldkey, VALUE value);

/**
 * Destructively merges two hash tables into one.  It resolves key conflicts by
 * calling the passed function and take its return value.
 *
 * @param[out]  hash1             Target hash to be modified.
 * @param[in]   hash2             A hash to merge into `hash1`.
 * @param[in]   func              Conflict reconciler.
 * @exception   rb_eFrozenError   `hash1` is frozen.
 * @exception   rb_eRuntimeError  `hash2` is updated instead.
 * @return      The passed `hash1`.
 * @post        Contents of `hash2` is merged into `hash1`.
 * @note        You can  pass zero to  `func`.  This means values  from `hash2`
 *              are always taken.
 */
VALUE rb_hash_update_by(VALUE hash1, VALUE hash2, rb_hash_update_func *func);

/* file.c */

/**
 * This function is mysterious.  What it does is not immediately obvious.  Also
 * what it does seems platform dependent.
 *
 * @param[in]  path       A local path.
 * @retval     0          The "check" succeeded.
 * @retval     otherwise  The "check" failed.
 */
int rb_path_check(const char *path);

/* hash.c */

/**
 * Destructively removes every environment variables of the running process.
 *
 * @return  The `ENV` object.
 * @post    The process has no environment variables.
 */
VALUE rb_env_clear(void);

/**
 * Identical to  #RHASH_SIZE(), except  it returns the  size in  Ruby's integer
 * instead of C's.
 *
 * @param[in]  hash  A hash object.
 * @return     The size of the hash.
 */
VALUE rb_hash_size(VALUE hash);

RBIMPL_SYMBOL_EXPORT_END()

#endif /* RBIMPL_INTERN_HASH_H */
PK       ! `      ruby/internal/intern/parse.hnu [        #ifndef RBIMPL_INTERN_PARSE_H                        /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_INTERN_PARSE_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Public APIs related to ::rb_cSymbol.
 */
#include "ruby/internal/attr/const.h"
#include "ruby/internal/attr/nonnull.h"
#include "ruby/internal/dllexport.h"
#include "ruby/internal/value.h"

RBIMPL_SYMBOL_EXPORT_BEGIN()

/* symbol.c */

/**
 * Calculates an ID of attribute writer.   For instance it returns `:foo=` when
 * passed `:foo`.
 *
 * @param[in]  id             An id.
 * @exception  rb_eNameError  `id` is not for attributes (e.g. operator).
 * @return     Calculated name of attribute writer.
 */
ID rb_id_attrset(ID id);

RBIMPL_ATTR_CONST()
/**
 * Classifies the given ID, then sees if it is a constant.  In case an ID is in
 * Unicode (likely), its  "constant"-ness is determined if  its first character
 * is  either upper  case or  title case.   Otherwise it  is detected  if case-
 * folding the first character changes its case or not.
 *
 * @param[in]  id  An id to classify.
 * @retval     1   It is a constant.
 * @retval     0   It isn't.
 */
int rb_is_const_id(ID id);

RBIMPL_ATTR_CONST()
/**
 * Classifies the  given ID, then  sees if it is  a global variable.   A global
 * variable must start with `$`.
 *
 * @param[in]  id  An id to classify.
 * @retval     1   It is a global variable.
 * @retval     0   It isn't.
 */
int rb_is_global_id(ID id);

RBIMPL_ATTR_CONST()
/**
 * Classifies  the given  ID, then  sees  if it  is an  instance variable.   An
 * instance variable must start with `@`, but not `@@`.
 *
 * @param[in]  id  An id to classify.
 * @retval     1   It is an instance variable.
 * @retval     0   It isn't.
 */
int rb_is_instance_id(ID id);

RBIMPL_ATTR_CONST()
/**
 * Classifies  the given  ID,  then sees  if  it is  an  attribute writer.   An
 * attribute writer is otherwise a local variable, except it ends with `=`.
 *
 * @param[in]  id  An id to classify.
 * @retval     1   It is an attribute writer.
 * @retval     0   It isn't.
 */
int rb_is_attrset_id(ID id);

RBIMPL_ATTR_CONST()
/**
 * Classifies the  given ID,  then sees  if it  is a  class variable.   A class
 * variable is must start with `@@`.
 *
 * @param[in]  id  An id to classify.
 * @retval     1   It is a class variable.
 * @retval     0   It isn't.
 */
int rb_is_class_id(ID id);

RBIMPL_ATTR_CONST()
/**
 * Classifies the  given ID,  then sees  if it  is a  local variable.   A local
 * variable starts  with a lowercase  character, followed by  some alphanumeric
 * characters or `_`, then ends with anything other than `!`, `?`, or `=`.
 *
 * @param[in]  id  An id to classify.
 * @retval     1   It is a local variable.
 * @retval     0   It isn't.
 */
int rb_is_local_id(ID id);

RBIMPL_ATTR_CONST()
/**
 * Classifies the  given ID,  then sees  if it  is a  junk ID.   An ID  with no
 * special syntactic structure is considered  junk.  This category includes for
 * instance punctuation.
 *
 * @param[in]  id  An id to classify.
 * @retval     1   It is a junk.
 * @retval     0   It isn't.
 */
int rb_is_junk_id(ID);

RBIMPL_ATTR_NONNULL(())
/**
 * Sees if  the passed C string  constructs a valid syntactic  symbol.  Invalid
 * ones for instance includes whitespaces.
 *
 * @param[in]  str  A C string to check.
 * @retval     1    It is a valid symbol name.
 * @retval     0    It is invalid as a symbol name.
 */
int rb_symname_p(const char *str);

/* vm.c */

/**
 * Queries the last match, or `Regexp.last_match`, or the `$~`.  You don't have
 * to use it, because in reality you can get `$~` using rb_gv_get() as usual.
 *
 * @retval  RUBY_Qnil  The method has not ran a regular expression.
 * @retval  otherwise  An instance of ::rb_cMatch.
 */
VALUE rb_backref_get(void);

/**
 * Updates `$~`.  You don't have to use it, because in reality you can set `$~`
 * using rb_gv_set() as usual.
 *
 * @param[in]  md  Arbitrary Ruby object.
 * @post       The passed object is assigned to `$~`.
 *
 * @internal
 *
 * Yes, this  function bypasses  the Check_Type()  that would  normally prevent
 * evil souls from assigning  evil objects to `$~`.  Use of  this function is a
 * really bad smell.
 */
void rb_backref_set(VALUE md);

/**
 * Queries the last  line, or the `$_`.   You don't have to use  it, because in
 * reality you can get `$_` using rb_gv_get() as usual.
 *
 * @retval  RUBY_Qnil  There has never been a "line" yet.
 * @retval  otherwise  The last set `$_` value.
 */
VALUE rb_lastline_get(void);

/**
 * Updates `$_`.  You don't have to use it, because in reality you can set `$_`
 * using rb_gv_set() as usual.
 *
 * @param[in]  str  Arbitrary Ruby object.
 * @post       The passed object is assigned to `$_`.
 *
 * @internal
 *
 * Unlike `$~`, you can assign non-strings to `$_`, even from ruby scripts.
 */
void rb_lastline_set(VALUE str);

/* symbol.c */

/**
 * Collects every single bits of symbols  that have ever interned in the entire
 * history of the current process.
 *
 * @return  An array that contains all symbols that have ever existed.
 */
VALUE rb_sym_all_symbols(void);

RBIMPL_SYMBOL_EXPORT_END()

#endif /* RBIMPL_INTERN_PARSE_H */
PK       ! Mh  h    ruby/internal/intern/io.hnu [        #ifndef RBIMPL_INTERN_IO_H                           /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_INTERN_IO_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Public APIs related to ::rb_cIO.
 */
#include "ruby/internal/dllexport.h"
#include "ruby/internal/value.h"

RBIMPL_SYMBOL_EXPORT_BEGIN()

/* io.c */

/**
 * @private
 *
 * @deprecated  This macro once was a thing in the old days, but makes no sense
 *              any  longer today.   Exists  here  for backwards  compatibility
 *              only.  You can safely forget about it.
 */
#define rb_defout rb_stdout

/* string.c */ /* ...why? moved in commit de7161526014b781468cea5d84411e23be */

/**
 * The field  separator character for  inputs, or  the `$;`.  This  affects how
 * `String#split` works.   You can set this  via the `-F` command  line option.
 * You can  also assign arbitrary  ruby objects programmatically, but  it makes
 * best sense for you to assign a regular expression here.
 *
 * @internal
 *
 * Tidbit: "fs" comes from AWK's `FS` variable.
 */
RUBY_EXTERN VALUE rb_fs;

/* io.c */ /* ...why? given rb_fs is in string.c? */

/**
 * The field  separator character for outputs,  or the `$,`.  This  affects how
 * `Array#join` works.
 *
 * @deprecated Assigning  anything other than  ::RUBY_Qnil to this  variable is
 *             deprecated.
 */
RUBY_EXTERN VALUE rb_output_fs;

/**
 * The record  separator character for inputs,  or the `$/`.  This  affects how
 * `IO#gets` works.  You can set this via the `-0` command line option.
 *
 * @deprecated Assigning  anything other than  ::RUBY_Qnil to this  variable is
 *             deprecated.
 *
 * @internal
 *
 * Tidbit: "rs" comes from AWK's `RS` variable.
 */
RUBY_EXTERN VALUE rb_rs;

/**
 * This is the default  value of ::rb_rs, i.e. `"\n"`.  It  seems it has always
 * been just a newline string since the beginning.  Not sure why C codes has to
 * use this, given there is no way for ruby programs to interface.
 *
 * Also it has not been deprecated for unknown reasons.
 */
RUBY_EXTERN VALUE rb_default_rs;

/**
 