the given object.  Its list of instance variables
 * are copied, but  not the objects they reference.  It  also copies the frozen
 * value state.
 *
 * @param[in]  obj            Arbitrary ruby object.
 * @exception  rb_eException  `#initialize_copy` can raise anything.
 * @return     A "clone" of `obj`.
 *
 * @internal
 *
 * Unlike ruby-level `Object#clone`, there is no way to control the frozen-ness
 * of the return value.
 */
VALUE rb_obj_clone(VALUE obj);

/**
 * Duplicates  the  given   object.   This  does  almost  the   same  thing  as
 * rb_obj_clone() do.  However  it does not copy the singleton  class (if any).
 * It also doesn't copy frozen-ness.
 *
 * @param[in]  obj            Arbitrary ruby object.
 * @exception  rb_eException  `#initialize_copy` can raise anything.
 * @return     A shallow copy of `obj`.
 */
VALUE rb_obj_dup(VALUE obj);

/**
 * Default  