t about  the allocator  function
 * parameter; it is  for internal use only.  Extension libraries  are unable to
 * properly allocate a ruby struct, because `RStruct` is opaque.
 *
 * @internal
 *
 * Several flags must be set up properly for ::RUBY_T_STRUCT objects, which are
 * also missing for extension libraries.
 *
 * @endinternal
 *
 * @param[in]  name           Name of the class.
 * @param[in]  super          Superclass of the defining class.
 * @param[in]  func           Must be 0 for extension libraries.
 * @param[in]  ...            Arbitrary number of  `const char*`, terminated by
 *                            zero.  Each of which are the name of fields.
 * @exception  rb_eNameError  `name` is not a constant name.
 * @exception  rb_eTypeError  `name` is already taken.
 * @exception  rb_eArgError    Duplicated field name.
 * @return     The defined class.
 * @post       Global toplevel constant `name` is defined.
 * @note       `name` is allowed  to be a null pointer.   This function creates
 *             an anonymous struct class then.
 */
VALUE rb_struct_define_without_accessor(const char *name, VALUE super, rb_alloc_func_t func, ...);

RBIMPL_ATTR_NONNULL((2))
/**
 * Identical  to  rb_struct_define_without_accessor(),  except it  defines  the
 * class under the specified namespace instead of global toplevel.  It can also
 * be seen as  a routine identical to rb_struct_define_under(),  except it does
 * not define accessor methods.
 *
 * @param[out]  outer          Namespace that the defining class shall reside.
 * @param[in]   class_name     Name of the class.
 * @param[in]   super          Superclass of the defining class.
 * @param[in]   alloc          Must be 0 for extension libraries.
 * @param[in]   ...            Arbitrary number of `const char*`, terminated by
 *                             zero.  Each of which are the name of fields.
 * @exception   rb_eNameError  `class_name` is not a constant name.
 * @exception   rb_eTypeError  `class_name` is already taken.
 * @exception   rb_eArgError    Duplicated field name.
 * @return      The defined class.
 * @post        `class_name` is a constant under `outer`.
 * @note        In contrast to  rb_struct_define_without_accessor(), it doesn't
 *              make any sense to pass a null name.
 */
VALUE rb_struct_define_without_accessor_under(VALUE outer, const char *class_name, VALUE super, rb_alloc_func_t alloc, ...);

RBIMPL_SYMBOL_EXPORT_END()

#endif /* RBIMPL_INTERN_STRUCT_H */
PK       ! IL  L    ruby/internal/intern/object.hnu [        #ifndef RBIMPL_INTERN_OBJECT_H                       /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_INTERN_OBJECT_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Public APIs related to ::rb_cObject.
 */
#include "ruby/internal/attr/const.h"
#include "ruby/internal/attr/deprecated.h"
#include "ruby/internal/attr/nonnull.h"
#include "ruby/internal/attr/pure.h"
#include "ruby/internal/dllexport.h"
#include "ruby/internal/value.h"

RBIMPL_SYMBOL_EXPORT_BEGIN()

/**
 * This macro is (used but) mysteri