  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_ASSUME / #RBIMPL_UNREACHABLE.
 *
 * These macros must be defined at once because:
 *
 * - #RBIMPL_ASSUME could fallback to #RBIMPL_UNREACHABLE.
 * - #RBIMPL_UNREACHABLE could fallback to #RBIMPL_ASSUME.
 */
#include "ruby/internal/config.h"
#include "ruby/internal/cast.h"
#include "ruby/internal/compiler_since.h"
#include "ruby/internal/has/builtin.h"
#include "ruby/internal/warning_push.h"

/** @cond INTERNAL_MACRO */
#if defined(HAVE___ASSUME)
# define RBIMPL_HAVE___ASSUME
#endif
/** @endcond */

/** Wraps (or simulates) `__builtin_unreachable`. */
#if RBIMPL_HAS_BUILTIN(__builtin_unreachable)
# define RBIMPL_UNREACHABLE_RETURN(_) __builtin_unreachable()

#elif defined(RBIMPL_HAVE___ASSUME)
# define RBIMPL_UNREACHABLE_RETURN(_) return (__assume(0), (_))

#else
# define RBIMPL_UNREACHABLE_RETURN(_) return (_)
#endif

/** Wraps 