od.
 * @exception      rb_eTypeError      Can't convert `*namep` into ::rb_cString.
 * @exception      rb_eEncodingError  Given string is non-ASCII.
 * @retval         RUBY_Qnil          No such id ever existed in the history.
 * @retval         otherwise          The id that represents the given name.
 * @post           The object  that `*namep`  points to  is a  converted result
 *                 object, which  is always an instance  of either ::rb_cSymbol
 *                 or ::rb_cString.
 * @see            https://bugs.ruby-lang.org/issues/5072
 *
 * @internal
 *
 * @shyouhei doesn't know why this has to raise rb_eEncodingError.
 */
VALUE rb_check_symbol(volatile VALUE *namep);
RBIMPL_SYMBOL_EXPORT_END()

RBIMPL_ATTR_PURE()
RBIMPL_ATTR_NONNULL(())
/**
 * This  is a  "tiny  optimisation" over  rb_intern().  If  you  pass a  string
 * _literal_, and if your C compiler can special-case strlen of such literal to
 * strength-reduce  into  an  integer  constant expression,  then  this  inline
 * function can precalc a part of conversion.
 *
 * @note       This function also works  happily for non-constant strings.  Why
 *             bother then?  Just apply liberally to everything.
 * @note       But  #rb_intern() could  be faster  on compilers  with statement
 *             expressions, because they can cache the created ::ID.
 * @param[in]  str               The name of the id.
 * @exception  rb_eRuntimeError  Too many symbols.
 * @return     A (possibly new) id whose value is the given str.
 * @note       These days  Ruby internally has  two kinds of symbols  (static /
 *             dynamic).  Symbols  created using  this function would  become a
 *             static one; i.e. would never be  garbage collected.  It is up to
 *             you to avoid memory leaks.  Think twice before using it.
 */
static inline ID
rb_intern_const(const char *str)
{
    size_t len = strlen(str);
    return rb_intern2(str, RBIMPL_CAST((long)len));
}

RBIMPL_ATTR_NOALIAS()
RBIMPL_ATTR_NONNULL(())
/**
 * @private
 *
 * This is an implementation detail of #rb_intern().  Just don't use it.
 */
static inline ID
rbimpl