 It
 * was a bad idea to expose this function  to 3rd parties, but we can no longer
 * delete it.
 */
rb_gvar_marker_t rb_gvar_undef_marker;

/**
 * This is the getter function that  backs global variables defined from a ruby
 * script.  Extension  libraries can use this  if its global variable  needs no
 * custom logic.
 */
rb_gvar_getter_t rb_gvar_val_getter;

/**
 * This is the setter function that  backs global variables defined from a ruby
 * script.  Extension  libraries can use this  if its global variable  needs no
 * custom logic.
 */
rb_gvar_setter_t rb_gvar_val_setter;

/**
 * This is the setter function that  backs global variables defined from a ruby
 * script.  Extension  libraries can use this  if its global variable  needs no
 * custom logic.
 */
rb_gvar_marker_t rb_gvar_val_marker;

/**
 * @deprecated
 *
 * This function has no actual usage (than in ruby itself).  Please ignore.  It
 * was a bad idea to expose this function  to 3rd parties, but we can no longer
 * delete it.
 */
rb_gvar_getter_t rb_gvar_var_getter;

/**
 * @deprecated
 *
 * This function has no actual usage (than in ruby itself).  Please ignore.  It
 * was a bad idea to expose this function  to 3rd parties, but we can no longer
 * delete it.
 */
rb_gvar_setter_t rb_gvar_var_setter;

/**
 * @deprecated
 *
 * This function has no actual usage (than in ruby itself).  Please ignore.  It
 * was a bad idea to expose this function  to 3rd parties, but we can no longer
 * delete it.
 */
rb_gvar_marker_t rb_gvar_var_marker;

RBIMPL_ATTR_NORETURN()
/**
 * This function just raises ::rb_eNameError.   Handy when you want to prohibit
 * a global variable from being squashed by someone.
 */
rb_gvar_setter_t rb_gvar_readonly_setter;

RBIMPL_ATTR_NONNULL(())
/**
 * "Shares" a global variable between Ruby and C.  Normally a Ruby-level global
 * variable  is stored  somewhere deep  inside of  the interpreter's  execution
 * context, but this way you can explicitly specify its storage.
 *
 * ```CXX
 * static VALUE foo;
 *
 * extern "C" void
 * init_Foo(void)
 * {
 *     foo = rb_eval_string("...");
 *     rb_define_variable("$foo", &foo);
 * }
 * ```
 *
 * In the above  example a Ruby global  variable named `$foo` is stored  in a C
 * global variable named `foo`.
 *
 * @param[in]  name  Variable (Ruby side).
 * @param[in]  var   Variable (C side).
 * @post       Ruby level  global variable named  `name` is defined  if absent,
 *             and its storage is set to `var`.
 */
void rb_define_variable(const char *name, VALUE *var);

RBIMPL_ATTR_NONNULL((1))
/**
 * Defines a global variable that  is purely function-backended.  By using this
 * API a programmer can define a  global variable that dynamically changes from
 * time to time.
 *
 * @param[in]  name   Variable name, in C's string.
 * @param[in]  getter A getter function.
 * @param[in]  setter A setter function.
 * @post       Ruby level global variable named `name` is defined if absent.
 *
 * @internal
 *
 * @shyouhei doesn't know if this is an  Easter egg or an official feature, but
 * you can pass  0 to the third argument (setter).   That effectively nullifies
 * any efforts to write to the defining global variable.
 */
void rb_define_virtual_variable(const char *name, rb_gvar_getter_t *getter, rb_gvar_setter_t *setter);

RBIMPL_ATTR_NONNULL((1))
/**
 * Identical to  rb_define_virtual_variable(), but can also  specify a storage.
 * A programmer can use the storage for e.g.  memoisation, storing intermediate
 * computation result, etc.
 *
 * Also you can pass 0 to this function, unlike other variants:
 *
 *   - When getter is 0 ::rb_gvar_var_getter is used instead.
 *   - When setter is 0 ::rb_gvar_var_setter is used instead.
 *   - When data is 0, you must  specify a non-zero setter function.  Otherwise
 *     ::rb_gvar_var_setter tries to write to `*NULL`, and just causes SEGV.
 *
 * @param[in]  name   Variable name, in C's string.
 * @param[in]  var    Variable storage.
 * @param[in]  getter A getter function.
 * @param[in]  setter A setter function.
 * @post       Ruby level global variable named `name` is defined if absent.
 */
void rb_define_hooked_variable(const char *name, VALUE *var, rb_gvar_getter_t *getter, rb_gvar_setter_t *setter);

RBIMPL_ATTR_NONNULL(())
/**
 * Identical to rb_define_variable(), except it does not allow Ruby programs to
 * assign values  to such  global variable.   C codes can  still set  values at
 * will.   This  could be  handy  for  you  when implementing  an  `errno`-like
 * experience, where  a method updates a  read-only global variable as  a side-
 * effect.
 *
 * @param[in]  name  Variable (Ruby side).
 * @param[in]  var   Variable (C side).
 * @post       Ruby level  global variable named  `name` is defined  if absent,
 *             and its storage is set to `var`.
 */
void rb_define_readonly_variable(const char *name, const VALUE *var);

RBIMPL_ATTR_NONNULL(())
/**
 * Defines a Ruby level constant under a namespace.
 *
 * @param[out]  klass            Namespace for the constant to reside.
 * @param[in]   name             Name of the constant.
 * @param[in]   val              Value of the constant.
 * @exception   rb_eTypeError    `klass` is not a kind of ::rb_cModule.
 * @exception   rb_eFrozenError  `klass` is frozen.
 * @post        Ruby level constant `klass::name` is defined to be `val`.
 * @note        This API  does not stop  you from  defining a constant  that is
 *              unable  to   reach  from   ruby  (like  for   instance  passing
 *              non-capital letter to `name`).
 * @note        This API  does not  stop you from  overwriting a  constant that
 *              already exist.
 *
 * @internal
 *
 * Above description is in fact inaccurate.  This API interfaces with Ractors.
 */
void rb_define_const(VALUE klass, const char *name, VALUE val);

RBIMPL_ATTR_NONNULL(())
/**
 * Identical  to  rb_define_const(),  except   it  defines  that  of  "global",
 * i.e. toplevel constant.
 *
 * @param[in]   name             Name of the constant.
 * @param[in]   val              Value of the constant.
 * @exception   rb_eFrozenError  ::rb_cObject is frozen.
 * @post        Ruby level constant \::name is defined to be `val`.
 * @note        This API  does not stop  you from  defining a constant  that is
 *              unable  to   reach  from   ruby  (like  for   instance  passing
 *              non-capital letter to `name`).
 * @note        This API  does not  stop you from  overwriting a  constant that
 *              already exist.
 */
void rb_define_global_const(const char *name, VALUE val);

RBIMPL_ATTR_NONNULL(())
/**
 * Asserts  that the  given  constant  is deprecated.   Attempt  to refer  such
 * constant will produce a warning.
 *
 * @param[in]  mod              Namespace of the target constant.
 * @param[in]  name             Name of the constant.
 * @exception  rb_eNameError    No such constant.
 * @exception  rb_eFrozenError  `mod` is frozen.
 * @post       `name` under `mod` is deprecated.
 */
void rb_deprecate_constant(VALUE mod, const char *name);

RBIMPL_ATTR_NONNULL(())
/**
 * Assigns to a global variable.
 *
 * @param[in]  name  Target global variable.
 * @param[in]  val   Value to assign.
 * @return     Passed value.
 * @post       Ruby level  global variable named  `name` is defined  if absent,
 *             whose value is set to `val`.
 *
 * @internal
 *
 * Above  description  is  in  fact   inaccurate.   This  API  interfaces  with
 * `set_trace_func`.
 */
VALUE rb_gv_set(const char *name, VALUE val);

RBIMPL_ATTR_NONNULL(())
/**
 * Obtains a global variable.
 *
 * @param[in]  name       Global variable to query.
 * @retval     RUBY_Qnil  The global variable does not exist.
 * @retval     otherwise  The value assigned to the global variable.
 *
 * @internal
 *
 * Unlike rb_gv_set(), there is no way to trace this function.
 */
VALUE rb_gv_get(const char *name);

RBIMPL_ATTR_NONNULL(())
/**
 * Obtains an instance variable.
 *
 * @param[in]  obj                Target object.
 * @param[in]  name               Target instance variable to query.
 * @exception  rb_eEncodingError  `name` is corrupt (contains Hanzi etc.).
 * @retval     RUBY_nil           No such instance variable.
 * @retval     otherwise          The value assigned to the instance variable.
 */
VALUE rb_iv_get(VALUE obj, const char *name);

RBIMPL_ATTR_NONNULL(())
/**
 * Assigns to an instance variable.
 *
 * @param[out]  obj                Target object.
 * @param[in]   name               Target instance variable.
 * @param[in]   val                Value to assign.
 * @exception   rb_eFrozenError    Can't modify `obj`.
 * @exception   rb_eArgError       `obj` has too many instance variables.
 * @return      Passed value.
 * @post        An  instance variable  named  `name` is  defined  if absent  on
 *              `obj`, whose value is set to `val`.
 *
 * @internal
 *
 * This function does not stop you form creating an ASCII-incompatible instance
 * variable, but there is no way to get one because rb_iv_get raises exceptions
 * for such things.  This design seems broken...  But no idea why.
 */
VALUE rb_iv_set(VALUE obj, const char *name, VALUE val);

RBIMPL_SYMBOL_EXPORT_END()

#endif /* RBIMPL_VARIABLE_H */
PK       ! {8  8    ruby/internal/dllexport.hnu [        #ifndef RBIMPL_DLLEXPORT_H                           /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_DLLEXPORT_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Tweaking visibility of C variables/functions.
 */
#include "ruby/internal/config.h"
#include "ruby/internal/compiler_is.h"

/**
 * Declaration of externally visible global variables.  Here "externally" means
 * they should  be visible  from extension  libraries.  Depending  on operating
 * systems (dynamic linkers,  to be precise), global variables inside  of a DLL
 * may  or may  not be  visible  form outside  of  that DLL  by default.   This
 * declaration manually tweaks  that default and ensures  the declared variable
 * be truly globally visible.
 *
 * ```CXX
 * extern VALUE foo;      // hidden on some OS
 * RUBY_EXTERN VALUE foo; // ensure visible
 * ```
 */
#undef RUBY_EXTERN
#if defined(MJIT_HEADER) && defined(_WIN32)
# define RUBY_EXTERN extern __declspec(dllimport)
#elif defined(RUBY_EXPORT)
# define RUBY_EXTERN extern
#elif defined(_WIN32)
# define RUBY_EXTERN extern __declspec(dllimport)
#else
# define RUBY_EXTERN extern
#endif

#ifndef RUBY_SYMBOL_EXPORT_BEGIN
# define RUBY_SYMBOL_EXPORT_BEGIN /* begin */
#endif

#ifndef RUBY_SYMBOL_EXPORT_END
# define RUBY_SYMBOL_EXPORT_END   /* end */
#endif

#ifndef RUBY_FUNC_EXPORTED
# define RUBY_FUNC_EXPORTED /* void */
#endif

/**
 * @cond INTERNAL_MACRO
 *
 * These MJIT related macros are placed here because translate_mjit_header can
 * need them.  Extension libraries should not touch.
 */

/* These macros are used for functions which are exported only for MJIT
   and NOT ensured to be exported in future versions. */

#if ! defined(MJIT_HEADER)
# define MJIT_FUNC_EXPORTED RUBY_FUNC_EXPORTED
#elif ! RBIMPL_COMPILER_IS(MSVC)
# define MJIT_FUNC_EXPORTED RUBY_FUNC_EXPORTED
#else
# define MJIT_FUNC_EXPORTED static
#endif

#define MJIT_SYMBOL_EXPORT_BEGIN RUBY_SYMBOL_EXPORT_BEGIN
#define MJIT_SYMBOL_EXPORT_END   RUBY_SYMBOL_EXPORT_END

/* On mswin, MJIT header transformation can't be used since cl.exe can't output
   preprocessed output preserving macros. So this `MJIT_STATIC` is needed
   to force non-static function to static on MJIT header to avoid symbol conflict. */
#ifdef MJIT_HEADER
# define MJIT_STATIC static
#else
# define MJIT_STATIC
#endif

/** @endcond */

/** Shortcut macro equivalent to `RUBY_SYMBOL_EXPORT_BEGIN extern "C" {`.
 * \@shyouhei finds it handy. */
#if defined(__DOXYGEN__)
# define RBIMPL_SYMBOL_EXPORT_BEGIN() /* void */
#elif defined(__cplusplus)
# define RBIMPL_SYMBOL_EXPORT_BEGIN() RUBY_SYMBOL_EXPORT_BEGIN extern "C" {
#else
# define RBIMPL_SYMBOL_EXPORT_BEGIN() RUBY_SYMBOL_EXPORT_BEGIN
#endif

/** Counterpart of #RBIMPL_SYMBOL_EXPORT_BEGIN */
#if defined(__DOXYGEN__)
# define RBIMPL_SYMBOL_EXPORT_END() /* void */
#elif defined(__cplusplus)
# define RBIMPL_SYMBOL_EXPORT_END() } RUBY_SYMBOL_EXPORT_END
#else
# define RBIMPL_SYMBOL_EXPORT_END()   RUBY_SYMBOL_EXPORT_END
#endif
#endif /* RBIMPL_DLLEXPORT_H */
PK       ! 9      ruby/internal/abi.hnu [        #ifndef RUBY_ABI_H
#define RUBY_ABI_H

#ifdef RUBY_ABI_VERSION /* should match the definition in config.h */

/* This number represents Ruby's ABI version.
 *
 * In development Ruby, it should be bumped every time an ABI incompatible
 * change is introduced. This will force other developers to rebuild extension
 * gems.
 *
 * The following cases are considered as ABI incompatible changes:
 * - Changing any data structures.
 * - Changing macros or inline functions causing a change in behavior.
 * - Deprecating or removing function declarations.
 *
 * The following cases are NOT considered as ABI incompatible changes:
 * - Any changes that does not involve the header files in the `include`
 *   directory.
 * - Adding macros, inline functions, or function declarations.
 * - Backwards compatible refactors.
 * - Editing comments.
 *
 * In released versions of Ruby, this number is not defined since teeny
 * versions of Ruby should guarantee ABI compatibility.
 */
#define RUBY_ABI_VERSION 3

/* Windows does not support weak symbols so ruby_abi_version will not exist
 * in the shared library. */
#if defined(HAVE_FUNC_WEAK) && !defined(_WIN32) && !defined(__MINGW32__) && !defined(__CYGWIN__)
# define RUBY_DLN_CHECK_ABI
#endif
#endif  /* RUBY_ABI_VERSION */

#ifdef RUBY_DLN_CHECK_ABI

# ifdef __cplusplus
extern "C" {
# endif

RUBY_FUNC_EXPORTED unsigned long long __attribute__((weak))
ruby_abi_version(void)
{
# ifdef RUBY_ABI_VERSION
    return RUBY_ABI_VERSION;
# else
    return 0;
# endif
}

# ifdef __cplusplus
}
# endif

#endif

#endif
PK       ! a04  4    ruby/internal/rgengc.hnu [        #ifndef RBIMPL_RGENGC_H                              /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_RGENGC_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      RGENGC write-barrier APIs.
 * @see        Sasada,  K.,  "Gradual  write-barrier   insertion  into  a  Ruby
 *             interpreter",   in  proceedings   of   the   2019  ACM   SIGPLAN
 *             International  Symposium on  Memory Management  (ISMM 2019),  pp
 *             115-121, 2019.  https://doi.org/10.1145/3315573.3329986
 */
#include "ruby/internal/attr/artificial.h"
#include "ruby/internal/attr/maybe_unused.h"
#include "ruby/internal/attr/pure.h"
#include "ruby/internal/dllexport.h"
#include "ruby/internal/special_consts.h"
#include "ruby/internal/stdbool.h"
#include "ruby/internal/value.h"
#include "ruby/assert.h"

/**
 * @private
 *
 * @deprecated  This macro once was a thing in the old days, but makes no sense
 *              any  longer today.   Exists  here  for backwards  compatibility
 *              only.  You can safely forget about it.
 */
#undef USE_RGENGC
#define USE_RGENGC 1

/**
 * @private
 *
 * This is  a compile-time flag  to enable/disable incremental GC  feature.  It
 * has to  be set at  the time  ruby itself compiles.   Makes no sense  for 3rd
 * parties.  It is safe  for them to set this though;  that just doesn't change
 * anything.
 */
#ifndef USE_RINCGC
# define USE_RINCGC 1
#endif

/**
 * @deprecated  This macro seems  broken.  Setting this to  anything other than
 *              zero just doesn't compile.  We need to KonMari.
 */
#ifndef USE_RGENGC_LOGGING_WB_UNPROTECT
# define USE_RGENGC_LOGGING_WB_UNPROTECT 0
#endif

/**
 * @private
 *
 * This  is   a  compile-time   flag  to   enable/disable  write   barrier  for
 * struct ::RArray.  It has to be set  at the time ruby itself compiles.  Makes
 * no sense for 3rd parties.
 */
#ifndef RGENGC_WB_PROTECTED_ARRAY
# define RGENGC_WB_PROTECTED_ARRAY 1
#endif

/**
 * @private
 *
 * This  is   a  compile-time   flag  to   enable/disable  write   barrier  for
 * struct ::RHash.  It has  to be set at the time  ruby itself compiles.  Makes
 * no sense for 3rd parties.
 */
#ifndef RGENGC_WB_PROTECTED_HASH
# define RGENGC_WB_PROTECTED_HASH 1
#endif

/**
 * @private
 *
 * This  is   a  compile-time   flag  to   enable/disable  write   barrier  for
 * struct ::RStruct.  It has to be set at the time ruby itself compiles.  Makes
 * no sense for 3rd parties.
 */
#ifndef RGENGC_WB_PROTECTED_STRUCT
# define RGENGC_WB_PROTECTED_STRUCT 1
#endif

/**
 * @private
 *
 * This  is   a  compile-time   flag  to   enable/disable  write   barrier  for
 * struct ::RString.  It has to be set at the time ruby itself compiles.  Makes
 * no sense for 3rd parties.
 */
#ifndef RGENGC_WB_PROTECTED_STRING
# define RGENGC_WB_PROTECTED_STRING 1
#endif

/**
 * @private
 *
 * This  is   a  compile-time   flag  to   enable/disable  write   barrier  for
 * struct ::RObject.  It has to be set at the time ruby itself compiles.  Makes
 * no sense for 3rd parties.
 */
#ifndef RGENGC_WB_PROTECTED_OBJECT
# define RGENGC_WB_PROTECTED_OBJECT 1
#endif

/**
 * @private
 *
 * This  is   a  compile-time   flag  to   enable/disable  write   barrier  for
 * struct ::RRegexp.  It has to be set at the time ruby itself compiles.  Makes
 * no sense for 3rd parties.
 */
#ifndef RGENGC_WB_PROTECTED_REGEXP
# define RGENGC_WB_PROTECTED_REGEXP 1
#endif

/**
 * @private
 *
 * This  is   a  compile-time   flag  to   enable/disable  write   barrier  for
 * struct ::RClass.  It has to be set  at the time ruby itself compiles.  Makes
 * no sense for 3rd parties.
 */
#ifndef RGENGC_WB_PROTECTED_CLASS
# define RGENGC_WB_PROTECTED_CLASS 1
#endif

/**
 * @private
 *
 * This  is   a  compile-time   flag  to   enable/disable  write   barrier  for
 * struct ::RFloat.  It has to be set  at the time ruby itself compiles.  Makes
 * no sense for 3rd parties.
 */
#ifndef RGENGC_WB_PROTECTED_FLOAT
# define RGENGC_WB_PROTECTED_FLOAT 1
#endif

/**
 * @private
 *
 * This  is   a  compile-time   flag  to   enable/disable  write   barrier  for
 * struct ::RComplex.   It has  to be  set at  the time  ruby itself  compiles.
 * Makes no sense for 3rd parties.
 */
#ifndef RGENGC_WB_PROTECTED_COMPLEX
# define RGENGC_WB_PROTECTED_COMPLEX 1
#endif

/**
 * @private
 *
 * This  is   a  compile-time   flag  to   enable/disable  write   barrier  for
 * struct ::RRational.  It  has to  be set  at the  time ruby  itself compiles.
 * Makes no sense for 3rd parties.
 */
#ifndef RGENGC_WB_PROTECTED_RATIONAL
# define RGENGC_WB_PROTECTED_RATIONAL 1
#endif

/**
 * @private
 *
 * This  is   a  compile-time   flag  to   enable/disable  write   barrier  for
 * struct ::RBignum.  It has to be set at the time ruby itself compiles.  Makes
 * no sense for 3rd parties.
 */
#ifndef RGENGC_WB_PROTECTED_BIGNUM
# define RGENGC_WB_PROTECTED_BIGNUM 1
#endif

/**
 * @private
 *
 * @deprecated  This macro once was a thing in the old days, but makes no sense
 *              any  longer today.   Exists  here  for backwards  compatibility
 *              only.  You can safely forget about it.
 *
 * @internal
 *
 * @shyouhei doesn't think anybody uses this right now.
 */
#ifndef RGENGC_WB_PROTECTED_NODE_CREF
# define RGENGC_WB_PROTECTED_NODE_CREF 1
#endif

/**
 * @defgroup rgengc Write barrier (WB) interfaces:
 *
 * @note The following  core interfaces can  be changed in the  future.  Please
 *       catch up if you want to insert WB into C-extensions correctly.
 *
 * @{
 */

/**
 * Declaration of a "back" pointer.  This  is a write barrier for new reference
 * from  "old"  generation  to  "young" generation.   It  writes  `young`  into
 * `*slot`, which is a pointer inside of `old`.
 *
 * @param[in]   old    An old object.
 * @param[in]   slot   A pointer inside of `old`.
 * @param[out]  young  A young object.
 */
#define RB_OBJ_WRITE(old, slot, young) \
    RBIMPL_CAST(rb_obj_write((VALUE)(old), (VALUE *)(slot), (VALUE)(young), __FILE__, __LINE__))

/**
 * Identical to #RB_OBJ_WRITE(), except it doesn't write any values, but only a
 * WB declaration.   `oldv` is  replaced value  with `b`  (not used  in current
 * Ruby).
 *
 * @param[in]   old    An old object.
 * @param[in]   oldv   An object previously stored inside of `old`.
 * @param[out]  young  A young object.
 */
#define RB_OBJ_WRITTEN(old, oldv, young) \
    RBIMPL_CAST(rb_obj_written((VALUE)(old), (VALUE)(oldv), (VALUE)(young), __FILE__, __LINE__))
/** @} */

#define OBJ_PROMOTED_RAW RB_OBJ_PROMOTED_RAW /**< @old{RB_OBJ_PROMOTED_RAW} */
#define OBJ_PROMOTED     RB_OBJ_PROMOTED     /**< @old{RB_OBJ_PROMOTED} */
#define OBJ_WB_UNPROTECT RB_OBJ_WB_UNPROTECT /**< @old{RB_OBJ_WB_UNPROTECT} */

/**
 * Asserts that the passed object is  not fenced by write barriers.  Objects of
 * such  property do  not contribute  to  generational GCs.   They are  scanned
 * always.
 *
 * @param[out]  x  An object that would not be protected by the barrier.
 */
#define RB_OBJ_WB_UNPROTECT(x) rb_obj_wb_unprotect(x, __FILE__, __LINE__)

/**
 * Identical  to #RB_OBJ_WB_UNPROTECT(),  except it  can also  assert that  the
 * given object is of given type.
 *
 * @param[in]   type  One of `ARRAY`, `STRING`, etc.
 * @param[out]  obj   An object of `type` that would not be protected.
 *
 * @internal
 *
 * @shyouhei doesn't understand why this has to be visible from extensions.
 */
#define RB_OBJ_WB_UNPROTECT_FOR(type, obj) \
    (RGENGC_WB_PROTECTED_##type ? OBJ_WB_UNPROTECT(obj) : obj)

/**
 * @private
 *
 * This is an implementation detail of rb_obj_wb_unprotect().  People don't use
 * it directly.
 */
#define RGENGC_LOGGING_WB_UNPROTECT rb_gc_unprotect_logging

/** @cond INTERNAL_MACRO */
#define RB_OBJ_PROMOTED_RAW RB_OBJ_PROMOTED_RAW
#define RB_OBJ_PROMOTED     RB_OBJ_PROMOTED
/** @endcond */

RBIMPL_SYMBOL_EXPORT_BEGIN()
/**
 * This  is  the  implementation  of  #RB_OBJ_WRITE().   People  don't  use  it
 * directly.
 *
 * @param[in]   old    An object that points to `young`.
 * @param[out]  young  An object that is referenced from `old`.
 */
void rb_gc_writebarrier(VALUE old, VALUE young);

/**
 * This is the  implementation of #RB_OBJ_WB_UNPROTECT().  People  don't use it
 * directly.
 *
 * @param[out] obj  An object that does not participate in WB.
 */
void rb_gc_writebarrier_unprotect(VALUE obj);

#if USE_RGENGC_LOGGING_WB_UNPROTECT
/**
 * @private
 *
 * This  is  the   implementation  of  #RGENGC_LOGGING_WB_UNPROTECT().   People
 * don't use it directly.
 *
 * @param[in]  objptr    Don't  know why  this  is  a pointer  to  void but  in
 *                       reality this is  a pointer to an object  that is about
 *                       to be un-protected.
 * @param[in]  filename  Pass C's `__FILE__` here.
 * @param[in]  line      Pass C's `__LINE__` here.
 */
void rb_gc_unprotect_logging(void *objptr, const char *filename, int line);
#endif

RBIMPL_SYMBOL_EXPORT_END()

RBIMPL_ATTR_PURE_UNLESS_DEBUG()
RBIMPL_ATTR_ARTIFICIAL()
/**
 * This  is the  implementation  of #RB_OBJ_PROMOTED().   People  don't use  it
 * directly.
 *
 * @param[in]  obj    An object to query.
 * @retval     true   The object is "promoted".
 * @retval     false  The object is young.  Have not experienced GC at all.
 */
static inline bool
RB_OBJ_PROMOTED_RAW(VALUE obj)
{
    RBIMPL_ASSERT_OR_ASSUME(RB_FL_ABLE(obj));
    return RB_FL_ANY_RAW(obj,  RUBY_FL_PROMOTED);
}

RBIMPL_ATTR_PURE_UNLESS_DEBUG()
RBIMPL_ATTR_ARTIFICIAL()
/**
 * Tests if the object is "promoted" -- that is, whether the object experienced
 * one or more GC marks.
 *
 * @param[in]  obj    An object to query.
 * @retval     true   The object is "promoted".
 * @retval     false  The object is young.  Have not experienced GC at all.
 * @note       Hello, is anyone actively calling this function?  @shyouhei have
 *             never seen  any actual usages  outside of the  GC implementation
 *             itself.
 */
static inline bool
RB_OBJ_PROMOTED(VALUE obj)
{
    if (! RB_FL_ABLE(obj)) {
        return false;
    }
    else {
        return RB_OBJ_PROMOTED_RAW(obj);
    }
}

/**
 * This is the  implementation of #RB_OBJ_WB_UNPROTECT().  People  don't use it
 * directly.
 *
 * @param[out]  x         An object that does not participate in WB.
 * @param[in]   filename  C's `__FILE__` of the caller function.
 * @param[in]   line      C's `__LINE__` of the caller function.
 * @return      x
 */
static inline VALUE
rb_obj_wb_unprotect(
    VALUE x,
    RBIMPL_ATTR_MAYBE_UNUSED()
    const char *filename,
    RBIMPL_ATTR_MAYBE_UNUSED()
    int line)
{
#if USE_RGENGC_LOGGING_WB_UNPROTECT
    RGENGC_LOGGING_WB_UNPROTECT(RBIMPL_CAST((void *)x), filename, line);
#endif
    rb_gc_writebarrier_unprotect(x);
    return x;
}

/**
 * @private
 *
 * This  is  the implementation  of  #RB_OBJ_WRITTEN().   People don't  use  it
 * directly.
 *
 * @param[in]   a         An old object.
 * @param[in]   oldv      An object previously stored inside of `old`.
 * @param[out]  b         A young object.
 * @param[in]   filename  C's `__FILE__` of the caller function.
 * @param[in]   line      C's `__LINE__` of the caller function.
 * @return      a
 */
static inline VALUE
rb_obj_written(
    VALUE a,
    RBIMPL_ATTR_MAYBE_UNUSED()
    VALUE oldv,
    VALUE b,
    RBIMPL_ATTR_MAYBE_UNUSED()
    const char *filename,
    RBIMPL_ATTR_MAYBE_UNUSED()
    int line)
{
#if USE_RGENGC_LOGGING_WB_UNPROTECT
    RGENGC_LOGGING_OBJ_WRITTEN(a, oldv, b, filename, line);
#endif

    if (!RB_SPECIAL_CONST_P(b)) {
        rb_gc_writebarrier(a, b);
    }

    return a;
}

/**
 * @private
 *
 * This  is  the  implementation  of  #RB_OBJ_WRITE().   People  don't  use  it
 * directly.
 *
 * @param[in]   a         An old object.
 * @param[in]   slot      A pointer inside of `old`.
 * @param[out]  b         A young object.
 * @param[in]   filename  C's `__FILE__` of the caller function.
 * @param[in]   line      C's `__LINE__` of the caller function.
 * @return      a
 */
static inline VALUE
rb_obj_write(
    VALUE a, VALUE *slot, VALUE b,
    RBIMPL_ATTR_MAYBE_UNUSED()
    const char *filename,
    RBIMPL_ATTR_MAYBE_UNUSED()
    int line)
{
#ifdef RGENGC_LOGGING_WRITE
    RGENGC_LOGGING_WRITE(a, slot, b, filename, line);
#endif

    *slot = b;

    rb_obj_written(a, RUBY_Qundef /* ignore `oldv' now */, b, filename, line);
    return a;
}

#endif /* RBIMPL_RGENGC_H */
PK       ! <
  <
    ruby/internal/attr/deprecated.hnu [        #ifndef RBIMPL_ATTR_DEPRECATED_H                     /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ATTR_DEPRECATED_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_ATTR_DEPRECATED.
 */
#include "ruby/internal/compiler_since.h"
#include "ruby/internal/has/attribute.h"
#include "ruby/internal/has/c_attribute.h"
#include "ruby/internal/has/cpp_attribute.h"
#include "ruby/internal/has/declspec_attribute.h"
#include "ruby/internal/has/extension.h"

/** Wraps (or simulates) `[[deprecated]]` */
#if defined(__COVERITY__)
/* Coverity Scan emulates gcc but seems not to support this attribute correctly */
# define RBIMPL_ATTR_DEPRECATED(msg)

#elif RBIMPL_HAS_EXTENSION(attribute_deprecated_with_message)
# define RBIMPL_ATTR_DEPRECATED(msg) __attribute__((__deprecated__ msg))

#elif defined(__cplusplus) && RBIMPL_COMPILER_SINCE(GCC, 10, 1, 0) && RBIMPL_COMPILER_BEFORE(GCC, 10, 3, 0)
# /* https://gcc.gnu.org/bugzilla/show_bug.cgi?id=95302 */
# define RBIMPL_ATTR_DEPRECATED(msg) /* disable until they fix this bug */

#elif RBIMPL_COMPILER_SINCE(GCC, 4, 5, 0)
# define RBIMPL_ATTR_DEPRECATED(msg) __attribute__((__deprecated__ msg))

#elif RBIMPL_COMPILER_SINCE(Intel, 13, 0, 0)
# define RBIMPL_ATTR_DEPRECATED(msg) __attribute__((__deprecated__ msg))

#elif RBIMPL_HAS_ATTRIBUTE(deprecated) /* but not with message. */
# define RBIMPL_ATTR_DEPRECATED(msg) __attribute__((__deprecated__))

#elif RBIMPL_COMPILER_SINCE(MSVC, 14, 0, 0)
# define RBIMPL_ATTR_DEPRECATED(msg) __declspec(deprecated msg)

#elif RBIMPL_HAS_DECLSPEC_ATTRIBUTE(deprecated)
# define RBIMPL_ATTR_DEPRECATED(msg) __declspec(deprecated)

#elif RBIMPL_HAS_CPP_ATTRIBUTE(deprecated)
# define RBIMPL_ATTR_DEPRECATED(msg) [[deprecated msg]]

#elif RBIMPL_HAS_C_ATTRIBUTE(deprecated)
# define RBIMPL_ATTR_DEPRECATED(msg) [[deprecated msg]]

#else
# define RBIMPL_ATTR_DEPRECATED(msg) /* void */
#endif

/** This is when a function is used internally (for backwards compatibility
 * etc.), but extension libraries must consider it deprecated. */
#if defined(RUBY_EXPORT)
# define RBIMPL_ATTR_DEPRECATED_EXT(msg) /* void */
#else
# define RBIMPL_ATTR_DEPRECATED_EXT(msg) RBIMPL_ATTR_DEPRECATED(msg)
#endif

#endif /* RBIMPL_ATTR_DEPRECATED_H */
PK       ! >UY  Y    ruby/internal/attr/noreturn.hnu [        #ifndef RBIMPL_ATTR_NORETURN_H                       /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ATTR_NORETURN_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_ATTR_NORETURN.
 */
#include "ruby/internal/has/attribute.h"
#include "ruby/internal/has/cpp_attribute.h"
#include "ruby/internal/has/declspec_attribute.h"

/** Wraps (or simulates) `[[noreturn]]` */
#if RBIMPL_HAS_DECLSPEC_ATTRIBUTE(noreturn)
# define RBIMPL_ATTR_NORETURN() __declspec(noreturn)

#elif RBIMPL_HAS_ATTRIBUTE(noreturn)
# define RBIMPL_ATTR_NORETURN() __attribute__((__noreturn__))

#elif RBIMPL_HAS_CPP_ATTRIBUTE(noreturn)
# define RBIMPL_ATTR_NORETURN() [[noreturn]]

#elif defined(__STDC_VERSION__) && (__STDC_VERSION__ >= 201112)
# define RBIMPL_ATTR_NORETURN() _Noreturn

#elif defined(_Noreturn)
# /* glibc <sys/cdefs.h> has this macro. */
# define RBIMPL_ATTR_NORETURN() _Noreturn

#else
# define RBIMPL_ATTR_NORETURN() /* void */
#endif

#endif /* RBIMPL_ATTR_NORETURN_H */
PK       ! wq?       ruby/internal/attr/diagnose_if.hnu [        #ifndef RBIMPL_ATTR_DIAGNOSE_IF_H                    /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ATTR_DIAGNOSE_IF_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_ATTR_DIAGNOSE_IF.
 */
#include "ruby/internal/has/attribute.h"
#include "ruby/internal/warning_push.h"

/** Wraps (or simulates) `__attribute__((diagnose_if))` */
#if RBIMPL_COMPILER_BEFORE(Clang, 5, 0, 0)
# /* https://bugs.llvm.org/show_bug.cgi?id=34319 */
# define RBIMPL_ATTR_DIAGNOSE_IF(_, __, ___) /* void */

#elif RBIMPL_HAS_ATTRIBUTE(diagnose_if)
# define RBIMPL_ATTR_DIAGNOSE_IF(_, __, ___) \
    RBIMPL_WARNING_PUSH() \
    RBIMPL_WARNING_IGNORED(-Wgcc-compat) \
    __attribute__((__diagnose_if__(_, __, ___))) \
    RBIMPL_WARNING_POP()

#else
# define RBIMPL_ATTR_DIAGNOSE_IF(_, __, ___) /* void */
#endif

#endif /* RBIMPL_ATTR_DIAGNOSE_IF_H */
PK       ! Ϟ]b  b    ruby/internal/attr/error.hnu [        #ifndef RBIMPL_ATTR_ERROR_H                          /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ATTR_ERROR_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_ATTR_ERROR.
 */
#include "ruby/internal/has/attribute.h"

/** Wraps (or simulates) `__attribute__((error))` */
#if RBIMPL_HAS_ATTRIBUTE(error)
# define RBIMPL_ATTR_ERROR(msg) __attribute__((__error__ msg))
#else
# define RBIMPL_ATTR_ERROR(msg) /* void */
#endif

#endif /* RBIMPL_ATTR_ERROR_H */
PK       ! 5@[      ruby/internal/attr/nodiscard.hnu [        #ifndef RBIMPL_ATTR_NODISCARD_H                      /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ATTR_NODISCARD_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_ATTR_NODISCARD.
 */
#include "ruby/internal/has/attribute.h"
#include "ruby/internal/has/c_attribute.h"
#include "ruby/internal/has/cpp_attribute.h"

/**
 * Wraps  (or simulates)  `[[nodiscard]]`.  In  C++  (at least  since C++20)  a
 * nodiscard attribute can  have a message why the result shall not be ignored.
 * However GCC attribute and SAL annotation cannot take them.
 */
#if RBIMPL_HAS_CPP_ATTRIBUTE(nodiscard)
# define RBIMPL_ATTR_NODISCARD() [[nodiscard]]
#elif RBIMPL_HAS_C_ATTRIBUTE(nodiscard)
# define RBIMPL_ATTR_NODISCARD() [[nodiscard]]
#elif RBIMPL_HAS_ATTRIBUTE(warn_unused_result)
# define RBIMPL_ATTR_NODISCARD() __attribute__((__warn_unused_result__))
#elif defined(_Check_return_)
# /* Take SAL definition. */
# define RBIMPL_ATTR_NODISCARD() _Check_return_
#else
# define RBIMPL_ATTR_NODISCARD() /* void */
#endif

#endif /* RBIMPL_ATTR_NODISCARD_H */
PK       ! v  v    ruby/internal/attr/nonstring.hnu [        #ifndef RBIMPL_ATTR_NONSTRING_H                        /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ATTR_NONSTRING_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_ATTR_NONSTRING.
 */
#include "ruby/internal/has/attribute.h"

/** Wraps (or simulates) `__attribute__((nonstring))` */
#if RBIMPL_HAS_ATTRIBUTE(nonstring)
# define RBIMPL_ATTR_NONSTRING() __attribute__((nonstring))
#else
# define RBIMPL_ATTR_NONSTRING() /* void */
#endif

#endif /* RBIMPL_ATTR_NONSTRING_H */
PK       ! ܄ґ    !  ruby/internal/attr/maybe_unused.hnu [        #ifndef RBIMPL_ATTR_MAYBE_UNUSED_H                   /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ATTR_MAYBE_UNUSED_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_ATTR_MAYBE_UNUSED.
 */
#include "ruby/internal/has/attribute.h"
#include "ruby/internal/has/c_attribute.h"
#include "ruby/internal/has/cpp_attribute.h"

/** Wraps  (or simulates)  `[[maybe_unused]]` */
#if RBIMPL_HAS_CPP_ATTRIBUTE(maybe_unused)
# define RBIMPL_ATTR_MAYBE_UNUSED() [[maybe_unused]]
#elif RBIMPL_HAS_C_ATTRIBUTE(maybe_unused)
# define RBIMPL_ATTR_MAYBE_UNUSED() [[maybe_unused]]
#elif RBIMPL_HAS_ATTRIBUTE(unused)
# define RBIMPL_ATTR_MAYBE_UNUSED() __attribute__((__unused__))
#else
# define RBIMPL_ATTR_MAYBE_UNUSED() /* void */
#endif

#endif /* RBIMPL_ATTR_MAYBE_UNUSED */
PK       ! 2=      ruby/internal/attr/const.hnu [        #ifndef RBIMPL_ATTR_CONST_H                          /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_ATTR_CONST_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either