orage
 *             instance; which has at least  `newelems` * `newsiz` bytes width,
 *             with appropriate alignment detected  by the underlying realloc()
 *             routine.
 * @pre        The passed pointer must point  to a valid live storage instance.
 *             It is a failure to pass an already freed pointer.
 * @post       In  case the  function  returns the  passed  pointer as-is,  the
 *             storage  instance that  the  pointer holds  is  either grown  or
 *             shrunken  to   have  at  least  `newelems`   *  `newsiz`  bytes.
 *             Otherwise a valid pointer to  a newly allocated storage instance
 *             is returned.   In this case  `ptr` is  invalidated as if  it was
 *             passed to ruby_xfree().
 * @note       It doesn't return NULL.
 * @warning    Unlike some  realloc() implementations,  passing zero  to either
 *             `newelems`   or  `elemsiz`   are   not  the   same  as   calling
 *             ruby_xfree(),   because  this   function  never   returns  NULL.
 *             Something meaningful still returns then.
 * @warning    It is  a failure not to  check the return value.   Do not assume
 *             anything on  it.  It could  be either identical to,  or distinct
 *             form the passed argument.
 * @warning    Do not  assume anything  on the alignment  of the  return value.
 *             There is  no guarantee  that it  inherits the  passed argument's
 *             one.
 * @warning    The return  value shall  be invalidated  exactly once  by either
 *             ruby_xfree(),  ruby_xrealloc(), or  ruby_xrealloc2().   It is  a
 *             failure to pass it to system free(), because the system and Ruby
 *             might or might not share the same malloc() implementation.
 */
void *ruby_xrealloc2(void *ptr, size_t newelems, size_t newsiz)
RBIMPL_ATTR_NOEXCEPT(realloc(ptr, newelems * newsiz))
;

/**
 * Deallocates a storage instance.
 *
 * @param[out]  ptr  Either
 *                     - NULL, or
 *                     - a valid pointer previously returned from one of:
 *                       - ruby_xmalloc(),
 *                       - ruby_xmalloc2(),
 *                       - ruby_xcalloc(),
 *                       - ruby_xrealloc(), or
 *                       - ruby_xrealloc2().
 * @pre         The passed pointer must point to a valid live storage instance.
 *              It is a failure to pass an already freed pointer.
 * @post        The  storage  instance  pointed  by  the  passed  pointer  gets
 *              invalidated; it is no longer addressable.
 * @warning     Every single storage instance  that was previously allocated by
 *              either    ruby_xmalloc(),   ruby_xmalloc2(),    ruby_xcalloc(),
 *              ruby_xrealloc(),  or  ruby_xrealloc2()   shall  be  invalidated
 *              exactly once by  either passing it to  ruby_xfree(), or passing
 *              it to  either ruby_xrealloc(), ruby_xrealloc2() then  check the
 *              return value for invalidation.
 * @warning     Do not pass anything other  than pointers described above.  For
 *              instance pointers returned from malloc() or mmap() shall not be
 *              passed  to   this  function,  because  the   underlying  memory
 *              management mechanism could differ.
 * @warning     Do  not pass  any invalid  pointers  to this  function e.g.  by
 *              calling it twice with a same argument.
 */
void ruby_xfree(void *ptr)
RBIMPL_ATTR_NOEXCEPT(free(ptr))
;

#if USE_GC_MALLOC_OBJ_INFO_DETAILS
# define ruby_xmalloc(s1)            ruby_xmalloc_with_location(s1, __FILE__, __LINE__)
# define ruby_xmalloc2(s1, s2)       ruby_xmalloc2_with_location(s1, s2, __FILE__, __LINE__)
# define ruby_xcalloc(s1, s2)        ruby_xcalloc_with_location(s1, s2, __FILE__, __LINE__)
# define ruby_xrealloc(ptr, s1)      ruby_xrealloc_with_location(ptr, s1, __FILE__, __LINE__)
# define ruby_xrealloc2(ptr, s1, s2) ruby_xrealloc2_with_location(ptr, s1, s2, __FILE__, __LINE__)

RBIMPL_ATTR_NODISCARD()
RBIMPL_ATTR_RESTRICT()
RBIMPL_ATTR_RETURNS_NONNULL()
RBIMPL_ATTR_ALLOC_SIZE((1))
void *ruby_xmalloc_body(size_t size)
RBIMPL_ATTR_NOEXCEPT(malloc(size))
;

RBIMPL_ATTR_NODISCARD()
RBIMPL_ATTR_RESTRICT()
RBIMPL_ATTR_RETURNS_NONNULL()
RBIMPL_ATTR_ALLOC_SIZE((1,2))
void *ruby_xmalloc2_body(size_t nelems, size_t elemsiz)
RBIMPL_ATTR_NOEXCEPT(malloc(nelems * elemsiz))
;

RBIMPL_ATTR_NODISCARD()
RBIMPL_ATTR_RESTRICT()
RBIMPL_ATTR_RETURNS_NONNULL()
RBIMPL_ATTR_ALLOC_SIZE((1,2))
void *ruby_xcalloc_body(size_t nelems, size_t elemsiz)
RBIMPL_ATTR_NOEXCEPT(calloc(nelems, elemsiz))
;

RBIMPL_ATTR_NODISCARD()
RBIMPL_ATTR_RETURNS_NONNULL()
RBIMPL_ATTR_ALLOC_SIZE((2))
void *ruby_xrealloc_body(void *ptr, size_t newsiz)
RBIMPL_ATTR_NOEXCEPT(realloc(ptr, newsiz))
;

RBIMPL_ATTR_NODISCARD()
RBIMPL_ATTR_RETURNS_NONNULL()
RBIMPL_ATTR_ALLOC_SIZE((2,3))
void *ruby_xrealloc2_body(void *ptr, size_t newelems, size_t newsiz)
RBIMPL_ATTR_NOEXCEPT(realloc(ptr, newelems * newsiz))
;

RUBY_EXTERN const char *ruby_malloc_info_file;
RUBY_EXTERN int ruby_malloc_info_line;

static inline void *
ruby_xmalloc_with_location(size_t s, const char *file, int line)
{
    void *ptr;
    ruby_malloc_info_file = file;
    ruby_malloc_info_line = line;
    ptr = ruby_xmalloc_body(s);
    ruby_malloc_info_file = NULL;
    return ptr;
}

static inline void *
ruby_xmalloc2_with_location(size_t s1, size_t s2, const char *file, int line)
{
    void *ptr;
    ruby_malloc_info_file = file;
    ruby_malloc_info_line = line;
    ptr = ruby_xmalloc2_body(s1, s2);
    ruby_malloc_info_file = NULL;
    