singleton_class_of()`) where return  value of this function
 * is passed to RB_FL_SET_RAW().
 */
static inline VALUE
RB_OBJ_FROZEN_RAW(VALUE obj)
{
    return RB_FL_TEST_RAW(obj, RUBY_FL_FREEZE);
}

RBIMPL_ATTR_PURE_UNLESS_DEBUG()
RBIMPL_ATTR_ARTIFICIAL()
/**
 * Checks if an object is frozen.
 *
 * @param[in]  obj    Object in question.
 * @retval     true   Yes it is.
 * @retval     false  No it isn't.
 */
static inline bool
RB_OBJ_FROZEN(VALUE obj)
{
    if (! RB_FL_ABLE(obj)) {
        return true;
    }
    else {
        return RB_OBJ_FROZEN_RAW(obj);
    }
}

RBIMPL_ATTR_ARTIFICIAL()
/**
 * This is an  implenentation detail of RB_OBJ_FREEZE().  3rd  parties need not
 * use this.  Just always use RB_OBJ_FREEZE().
 *
 * @param[out]  obj  Object in question.
 */
static inline void
RB_OBJ_FREEZE_RAW(VALUE obj)
{
    RB_FL_SET_RAW(obj, RUBY_FL_FREEZE);
}

RUBY_SYMBOL_EXPORT_BEGIN
void rb_obj_freeze_inline(VALUE obj);
RUBY_SYMBOL_EXPORT_END

#endif /* RBIMPL_FL_TYPE_H */
PK       ! 1Q  Q    ruby/internal/method.hnu [        #ifndef RBIMPL_METHOD_H                              /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_METHOD_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Creation and modification of Ruby methods.
 */
#include "ruby/internal/attr/nonnull.h"
#include "ruby/internal/dllexport.h"
#include "ruby/internal/value.h"
#include "ruby/backward/2/stdarg.h"

/**
 * @defgroup  defmethod  Defining methods
 *
 * There are some APIs to define a method from C.
 * These API takes a C function as a method body.
 *
 * ### Method body functions
 *
 * Method body functions must return a VALUE and
 * can be one of the following form:
 *
 * #### Fixed number of parameters
 *
 * This form is a normal C function, excepting it takes
 * a receiver object as the first argument.
 *
 * ```CXX
 * static VALUE my_method(VALUE self, VALUE x, VALUE y);
 * ```
 *
 * #### argc and argv style
 *
 * This form takes three parameters: argc, argv and self.
 * self is the receiver. argc is the number of arguments.
 * argv is a pointer to an array of the arguments.
 *
 * ```CXX
 * static VALUE my_method(int argc, VALUE *argv, VALUE self);
 * ```
 *
 * #### Ruby array style
 *
 * This form takes two parameters: self and args.
 * self is the receiver. args is an Array object which
 * contains the arguments.
 *
 * ```CXX
 * static VALUE my_method(VALUE self, VALUE args);
 * ```
 *
 * ### Number of parameters
 *
 * Method defining APIs takes the number of parameters which the
 * method will takes. This number is called argc.
 * argc can be:
 *
 *   - Zero or positive number.
 *     This means the method body function takes a fixed number of parameters.
 *
 *   - `-1`.
 *     This means the method body function is "argc and argv" style.
 *
 *   - `-2`.
 *     This means the method body function is "self and args" style.
 *
 * @{
 */

RBIMPL_SYMBOL_EXPORT_BEGIN()

RBIMPL_ATTR_NONNULL(())
/**
 * Defines a method.
 *
 * @param[out]  klass  A module or a class.
 * @param[in]   mid    Name of the function.
 * @param[in]   func   The method body.
 * @param[in]   arity  The number of parameters.  See @ref defmethod.
 * @note        There are in fact 18 different prototypes for func.
 * @see         ::ruby::backward::cxxanyargs::define_method::rb_define_method
 */
void rb_define_method(VALUE klass, const char *mid, VALUE (*func)(ANYARGS), int arity);

RBIMPL_ATTR_NONNULL(())
/**
 * Defines a module function for a module.
 *
 * @param[out]  klass  A module or a class.
 * @param[in]   mid    Name of the function.
 * @param[in]   func   The method body.
 * @param[in]   arity  The number of parameters.  See @ref defmethod.
 * @note        There are in fact 18 different prototypes for func.
 * @see         ::ruby::backward::cxxanyargs::define_method::rb_define_module_function
 */
void rb_define_module_function(VALUE klass, const char *mid, VALUE (*func)(ANYARGS), int arity);

RBIMPL_ATTR_NONNULL(())
/**
 * Defines a global function.
 *
 * @param[in]  mid    Name of the function.
 * @param[in]  func   The method body.
 * @param[in]  arity  The number of parameters.  See @ref defmethod.
 * @note       There are in fact 18 different prototypes for func.
 * @see        ::ruby::backward::cxxanyargs::define_method::rb_define_global_function
 */
void rb_define_global_function(const char *mid, VALUE (*func)(ANYARGS), int arity);

RBIMPL_ATTR_NONNULL(())
/**
 * Defines an undef of a method.  -- What?
 *
 * In ruby, there are two separate concepts called "undef" and "remove_method".
 * The thing you imagine when you  "un-define" a method is remove_method.  This
 * one on the  other hand is masking of a  previous method definition.  Suppose
 * for instance:
 *
 * ```ruby
 * class Foo
 *   def foo
 *   end
 * end
 *
 * class Bar < Foo
 *   def bar
 *     foo
 *   end
 * end
 *
 * class Baz < Foo
 *   undef foo            # <--- (*1)
 * end
 * ```
 *
 * This `undef foo` at `(*1)` must not eliminate `Foo#foo`, because that method
 * is also used from `Bar#bar`.  So  instead of physically executing the target
 * method, `undef` inserts  a special filtering entry to the  class (`Baz` this
 * case).  That entry,  when called, acts as  if there were no  methods at all.
 * But the original can still be accessible, via ways like `Bar#bar` above.
 *
 * @param[out]  klass            The class to insert an undef.
 * @param[in]   name             Name of the undef.
 * @exception   rb_eTypeError    `klass` is a non-module.
 * @exception   rb_eFrozenError  `klass` is frozen.
 * @see         rb_remove_method
 */
void rb_undef_method(VALUE klass, const char *name);

RBIMPL_ATTR_NONNULL(())
/**
 * Defines an alias of a method.
 *
 * @param[in,out]  klass            The class which the original method belongs
 *                                  to; this is also  where the new method will
 *                                  belong to.
 * @param[in]      dst              A new name for the method.
 * @param[in]      src              The original name of the method.
 * @exception      rb_eTypeError    `klass` is a non-module.
 * @exception      rb_eFrozenError  `klass` is frozen.
 * @exception      rb_eNameError    There is  no such method named  as `src` in
 *                                  `klass`.
 *
 * @internal
 *
 * Above  description  is   in  fact  a  bit  inaccurate   because  it  ignores
 * Refinements.
 */
void rb_define_alias(VALUE klass, const char *dst, const char *src);

RBIMPL_ATTR_NONNULL(())
/**
 * Defines public accessor method(s) for an attribute.
 *
 * @param[out]  klass            The class which the attribute will belong to.
 * @param[in]   name             Name of the attribute.
 * @param[in]   read             Whether to define a getter method.
 * @param[in]   write            Whether to define a setter method.
 * @exception   rb_eTypeError    `klass` is a non-module.
 * @exception   rb_eFrozenError  `klass` is frozen.
 * @exception   rb_eNameError    `name` invalid as an attr e.g. an operator.
 */
void rb_define_attr(VALUE klass, const char *name, int read, int write);

/** @} */

RBIMPL_SYMBOL_EXPORT_END()

#endif /* RBIMPL_METHOD_H */
PK       ! M&$9  9    ruby/internal/compiler_is.hnu [        #ifndef RBIMPL_COMPILER_IS_H                         /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_COMPILER_IS_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Defines #RBIMPL_COMPILER_IS.
 */

/**
 * @brief   Checks if the compiler is of given brand.
 * @param   cc     Compiler brand, like `MSVC`.
 * @retval  true   It is.
 * @retval  false  It isn't.
 */
#define RBIMPL_COMPILER_IS(cc) RBIMPL_COMPILER_IS_ ## cc

#include "ruby/internal/compiler_is/apple.h"
#include "ruby/internal/compiler_is/clang.h"
#include "ruby/internal/compiler_is/gcc.h"
#include "ruby/internal/compiler_is/intel.h"
#include "ruby/internal/compiler_is/msvc.h"
#include "ruby/internal/compiler_is/sunpro.h"
/* :TODO: Other possible compilers to support:
 *
 * - IBM  XL: recent  XL are  clang-backended  so some  tweaks like  we do  for
 *   Apple's might be needed.
 *
 * - ARM's armclang: ditto, it can be clang-backended.  */

#endif /* RBIMPL_COMPILER_IS_H */
PK       ! ZMD  MD    ruby/internal/xmalloc.hnu [        #ifndef RBIMPL_XMALLOC_H                             /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_XMALLOC_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl`   are
 *             implementation details.   Don't take  them as canon.  They could
 *             rapidly appear then vanish.  The name (path) of this header file
 *             is also an  implementation detail.  Do not expect  it to persist
 *             at the place it is now.  Developers are free to move it anywhere
 *             anytime at will.
 * @note       To  ruby-core:  remember  that   this  header  can  be  possibly
 *             recursively included  from extension  libraries written  in C++.
 *             Do not  expect for  instance `__VA_ARGS__` is  always available.
 *             We assume C99  for ruby itself but we don't  assume languages of
 *             extension libraries.  They could be written in C++98.
 * @brief      Declares ::ruby_xmalloc().
 */
#include "ruby/internal/config.h"

#ifdef STDC_HEADERS
# include <stddef.h>
#endif

#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#endif

#include "ruby/internal/attr/alloc_size.h"
#include "ruby/internal/attr/nodiscard.h"
#include "ruby/internal/attr/noexcept.h"
#include "ruby/internal/attr/restrict.h"
#include "ruby/internal/attr/returns_nonnull.h"
#include "ruby/internal/dllexport.h"

/**
 * @private
 * @warning  Do not touch this macro.
 * @warning  It is an implementation detail.
 * @warning  It was a failure at the first place to let you know about it.
 * @warning  The  value of  this  macro  must match  for  ruby  itself and  all
 *           extension  libraries, otherwise  serious  memory corruption  shall
 *           occur.
 */
#ifndef USE_GC_MALLOC_OBJ_INFO_DETAILS
# define USE_GC_MALLOC_OBJ_INFO_DETAILS 0
#endif

#define xmalloc   ruby_xmalloc   /**< @old{ruby_xmalloc} */
#define xmalloc2  ruby_xmalloc2  /**< @old{ruby_xmalloc2} */
#define xcalloc   ruby_xcalloc   /**< @old{ruby_xcalloc} */
#define xrealloc  ruby_xrealloc  /**< @old{ruby_xrealloc} */
#define xrealloc2 ruby_xrealloc2 /**< @old{ruby_xrealloc2} */
#define xfree     ruby_xfree     /**< @old{ruby_xfree} */

RBIMPL_SYMBOL_EXPORT_BEGIN()

RBIMPL_ATTR_NODISCARD()
RBIMPL_ATTR_RESTRICT()
RBIMPL_ATTR_RETURNS_NONNULL()
RBIMPL_ATTR_ALLOC_SIZE((1))
/**
 * Allocates a  storage instance.  It is  largely the same as  system malloc(),
 * except:
 *
 *   - It raises Ruby exceptions instead of returning NULL, and
 *   - In case of `ENOMEM` it tries to GC to make some room.
 *
 * @param[in]  size            Requested amount of memory.
 * @exception  rb_eNoMemError  No space left for `size` bytes allocation.
 * @return     A valid pointer  to an allocated storage instance;  which has at
 *             least `size` bytes width, with appropriate alignment detected by
 *             the underlying malloc() routine.
 * @note       It doesn't return NULL.
 * @note       Unlike some malloc() implementations, it allocates something and
 *    