 @warning    The return  value shall  be invalidated  exactly once  by either
 *             ruby_xfree(),  ruby_xrealloc(), or  ruby_xrealloc2().   It is  a
 *             failure to pass it to system free(), because the system and Ruby
 *             might or might not share the same malloc() implementation.
 */
void *ruby_xmalloc(size_t size)
RBIMPL_ATTR_NOEXCEPT(malloc(size))
;

RBIMPL_ATTR_NODISCARD()
RBIMPL_ATTR_RESTRICT()
RBIMPL_ATTR_RETURNS_NONNULL()
RBIMPL_ATTR_ALLOC_SIZE((1,2))
/**
 * Identical to ruby_xmalloc(), except it allocates `nelems` * `elemsiz` bytes.
 * This is needed  because the multiplication could integer  overflow.  On such
 * situations  Ruby does  not try  to  allocate at  all but  raises Ruby  level
 * exceptions  instead.  If  there  is  no integer  overflow  the behaviour  is
 * exactly the same as `ruby_xmalloc(nelems*elemsiz)`.
 *
 * @param[in]  nelems          Number of elements.
 * @param[in]  elemsiz         Size of an element.
 * @exception  rb_eNoMemError  No space left for allocation.
 * @exception  rb_eArgError    `nelems` * `elemsiz` would overflow.
 * @return     A valid pointer  to an allocated storage instance;  which has at
 *             least  `nelems`  *  `elemsiz`   bytes  width,  with  appropriate
 *             alignment detected by the underlying malloc() routine.
 * @note       It doesn't return NULL.
 * @note       Unlike some malloc() implementations, it allocates something and
 *             returns a  meaningful value even  when `nelems` or  `elemsiz` or
 *             both are zero.
 * @warning    The return  value shall  be invalidated  exactly once  by either
 *             ruby_xfree(),  ruby_xrealloc(), or  ruby_xrealloc2().   It is  a
 *             failure to pass it to system free(), because the system and Ruby
 *             might or might not share the same malloc() implementation.
 */
void *ruby_xmalloc2(size_t nelems, size_t elemsiz)
RBIMPL_ATTR_NOEXCEPT(malloc(nelems * elemsiz))
;

RBIMPL_ATTR_NODISCARD()
RBIMPL_ATTR_RESTRICT()
RBIMPL_ATTR_RETURNS_NONNULL()
RBIMPL_ATTR_ALLOC_SIZE((1,2))
/**
 * Identical  to  ruby_xmalloc2(),  except  it returns  a  zero-filled  storage
 * instance.  It  can also be  seen as  a routine identical  to ruby_xmalloc(),
 * except it calls calloc() instead of malloc().
 *
 * @param[in]  nelems          Number of elements.
 * @param[in]  elemsiz         Size of an element.
 * @exception  rb_eNoMemError  No space left for allocation.
 * @exception  rb_eArgError    `nelems` * `elemsiz` would overflow.
 * @return     A valid pointer  to an allocated storage instance;  which has at
 *             least  `nelems`  *  `elemsiz`   bytes  width,  with  appropriate
 *             alignment detected by the underlying calloc() routine.
 * @post       The returned storage instance is filled with zeros.
 * @note       It doesn't return NULL.
 * @note       Unlike some calloc() implementations, it allocates something and
 *             returns a  meaningful value even  when `nelems` or  `elemsiz` or
 *             both are zero.
 * @warning    The return  value shall  be invalidated  exactly once  by either
 *             ruby_xfree(),  ruby_xrealloc(), or  ruby_xrealloc2().   It is  a
 *             failure to pass it to system free(), because the system and Ruby
 *             might or might not share the same malloc() implementation.
 */
void *ruby_xcalloc(size_t nelems, size_t elemsiz)
RBIMPL_ATTR_NOEXCEPT(calloc(nelems, elemsiz))
;

RBIMPL_ATTR_NODISCARD()
RBIMPL_ATTR_RETURNS_NONNULL()
RBIMPL_ATTR_ALLOC_SIZE((2))
/**
 * Resize the storage instance.
 *
 * @param[in]  ptr             A valid  pointer to a storage  instance that was
 *                             previously returned from either:
 *                               - ruby_xmalloc(),
 *                               - ruby_xmalloc2(),
 *                               - ruby_xcalloc(),
 *                               - ruby_xrealloc(), or
 *                               - ruby_xrealloc2().
 * @param[in]  newsiz          Requested new amount of memory.
 * @exception  rb_eNoMemError  No space left for `newsiz` bytes allocation.
 * @return     A  valid  pointer  to   a  (possibly  newly  allocated)  storage
 *             instance;  which  has  at   least  `newsiz`  bytes  width,  with
 *             appropriate  alignment  detected  by  the  underlying  realloc()
 *             routine.
 * @pre        The passed pointer must point  to a valid live storage instance.
 *             It is a failure to pass an already freed pointer.
 * @post       In  case the  function  returns the  passed  pointer as-is,  the
 *             storage  instance that  the  pointer holds  is  either grown  or
 *             shrunken  to have  at least  `newsiz` bytes.  Otherwise a  valid
 *             pointer to a  newly allocated storage instance  is returned.  In
 *             this  case  `ptr`  is  invalidated   as  if  it  was  passed  to
 *             ruby_xfree().
 * @note       It doesn't return NULL.
 * @warning    Unlike some realloc() implementations,  passing zero to `newsiz`
 *             is not the  same as calling ruby_xfree(),  because this function
 *             never returns NULL.  Something meaningful still returns then.
 * @warning    It is  a failure not to  check the return value.   Do not assume
 *             anything on  it.  It could  be either identical to,  or distinct
 *             form the passed argument.
 * @warning    Do not  assume anything  on the alignment  of the  return value.
 *             There is  no guarantee  that it  inherits the  passed argument's
 *             one.
 * @warning    The return  value shall  be invalidated  exactly once  by either
 *             ruby_xfree(),  ruby_xrealloc(), or  ruby_xrealloc2().   It is  a
 *             failure to pass it to system free(), because the system and Ruby
 *             might or might not share the same malloc() implementation.
 */
void *ruby_xrealloc(void *ptr, size_t newsiz)
RBIMPL_ATTR_NOEXCEPT(realloc(ptr, newsiz))
;

RBIMPL_ATTR_NODISCARD()
RBIMPL_ATTR_RETURNS_NONNULL()
RBIMPL_ATTR_ALLOC_SIZE((2,3))
/**
 * Identical to ruby_xrealloc(),  except it resizes the  given storage instance
 * to `newelems` *  `newsiz` bytes.  This is needed  because the multiplication
 * could integer overflow.   On such situations Ruby does not  try to touch the
 * contents  of  argument pointer  at  all  but  raises Ruby  level  exceptions
 * instead.  If there is no integer  overflow the behaviour is exactly the same
 * as `ruby_xrealloc(ptr,nelems*elemsiz)`.
 *
 * This  is   roughly  the  same   as  reallocarray()  function   that  OpenBSD
 * etc. provides, but also interacts with our GC.
 *
 * @param[in]  ptr             A valid  pointer to a storage  instance that was
 *                             previously returned from either:
 *                               - ruby_xmalloc(),
 *                               - ruby_xmalloc2(),
 *                               - ruby_xcalloc(),
 *                               - ruby_xrealloc(), or
 *                               - ruby_xrealloc2().
 * @param[in]  newelems        Requested new number of elements.
 * @param[in]  newsiz          Requested new size of each element.
 * @exception  rb_eNoMemError  No space left for  allocation.
 * @exception  rb_eArgError    `newelems` * `newsiz` would overflow.
 * @re