d issue
 * warnings.  Ruby internals are pure C so they should not bother.
 */
#include "ruby/internal/compiler_since.h"
#include "ruby/internal/has/warning.h"
#include "ruby/internal/warning_push.h"

#if ! defined(__cplusplus)
# define RBIMPL_CAST(expr) (expr)

#elif RBIMPL_COMPILER_SINCE(GCC, 4, 6, 0)
# /* g++ has -Wold-style-cast since 1997 or so, but its _Pragma is broken. */
# /* See https://gcc.godbolt.org/z/XWhU6J */
# define RBIMPL_CAST(expr) (expr)
# pragma GCC diagnostic ignored "-Wold-style-cast"

#elif RBIMPL_HAS_WARNING("-Wold-style-cast")
# define RBIMPL_CAST(expr)                   \
    RBIMPL_WARNING_PUSH()                    \
    RBIMPL_WARNING_IGNORED(-Wold-style-cast) \
    (expr)                                  \
    RBIMPL_WARNING_POP()

#else
# define RBIMPL_CAST(expr) (expr)
#endif

#endif /* RBIMPL_CAST_H */
PK       ! 7k.L  L    ruby/internal/fl_type.hnu [        #ifndef RBIMPL_FL_TYPE_H                             /*-*-C++-*-vi:se ft=cpp:*/
#define RBIMPL_FL_TYPE_H
/**
 * @file
 * @author     Ruby developers <ruby-core@ruby-lang.org>
 * @copyright  This  file  is   a  part  of  the   programming  language  Ruby.
 *             Permission  is hereby  granted,  to  either redistribute  and/or
 *             modify this file, provided that  the conditions mentioned in the
 *             file COPYING are met.  Consult the file for details.
 * @warning    Symbols   prefixed  with   either  `RBIMPL`   or  `rbimpl` 