     Can't convert `name` into ::rb_cString.
 * @exception  rb_eRuntimeError  Too many symbols.
 * @return     A (possibly new) id whose value is the given name.
 * @note       These   days  Ruby   internally   has  two   kinds  of   symbols
 *             (static/dynamic).   Symbols created  using  this function  would
 *             become dynamic ones; i.e. would  be garbage collected.  It could
 *             be safer for you to use it than alternatives, when applicable.
 */
VALUE rb_to_symbol(VALUE name);

RBIMPL_ATTR_NONNULL(())
/**
 * Identical to  rb_check_id(), except it  returns an instance  of ::rb_cSymbol
 * instead.
 *
 * @param[in,out]  namep              A pointer to a name to query.
 * @pre            The object referred  by `*namep` must either  be an instance
 *                 of ::rb_cSymbol, or an inst