GNORE_BITS)

#ifdef USE_INTERIOR_NODES
/* number of bits used for MAP_TOP and MAP_MID nodes */
#define INTERIOR_BITS ((ADDRESS_BITS - ARENA_BITS + 2) / 3)
#else
#define INTERIOR_BITS 0
#endif

#define MAP_TOP_BITS INTERIOR_BITS
#define MAP_TOP_LENGTH (1 << MAP_TOP_BITS)
#define MAP_TOP_MASK (MAP_TOP_LENGTH - 1)

#define MAP_MID_BITS INTERIOR_BITS
#define MAP_MID_LENGTH (1 << MAP_MID_BITS)
#define MAP_MID_MASK (MAP_MID_LENGTH - 1)

#define MAP_BOT_BITS (ADDRESS_BITS - ARENA_BITS - 2*INTERIOR_BITS)
#define MAP_BOT_LENGTH (1 << MAP_BOT_BITS)
#define MAP_BOT_MASK (MAP_BOT_LENGTH - 1)

#define MAP_BOT_SHIFT ARENA_BITS
#define MAP_MID_SHIFT (MAP_BOT_BITS + MAP_BOT_SHIFT)
#define MAP_TOP_SHIFT (MAP_MID_BITS + MAP_MID_SHIFT)

#define AS_UINT(p) ((uintptr_t)(p))
#define MAP_BOT_INDEX(p) ((AS_UINT(p) >> MAP_BOT_SHIFT) & MAP_BOT_MASK)
#define MAP_MID_INDEX(p) ((AS_UINT(p) >> MAP_MID_SHIFT) & MAP_MID_MASK)
#define MAP_TOP_INDEX(p) ((AS_UINT(p) >> MAP_TOP_SHIFT) & MAP_TOP_MASK)

#if IGNORE_BITS > 0
/* Return the ignored part of the pointer address.  Those bits should be same
 * for all valid pointers if IGNORE_BITS is set correctly.
 */
#define HIGH_BITS(p) (AS_UINT(p) >> ADDRESS_BITS)
#else
#define HIGH_BITS(p) 0
#endif


/* This is the leaf of the radix tree.  See arena_map_mark_used() for the
 * meaning of these members. */
typedef struct {
    int32_t tail_hi;
    int32_t tail_lo;
} arena_coverage_t;

typedef struct arena_map_bot {
    /* The members tail_hi and tail_lo are accessed together.  So, it
     * better to have them as an array of structs, rather than two
     * arrays.
     */
    arena_coverage_t arenas[MAP_BOT_LENGTH];
} arena_map_bot_t;

#ifdef USE_INTERIOR_NODES
typedef struct arena_map_mid {
    struct arena_map_bot *ptrs[MAP_MID_LENGTH];
} arena_map_mid_t;

typedef struct arena_map_top {
    struct arena_map_mid *ptrs[MAP_TOP_LENGTH];
} arena_map_top_t;
#endif

struct _obmalloc_usage {
    /* The root of radix tree.  Note that by initializing like this, the memory
     * should be in the BSS.  The OS will only memory map pages as the MAP_MID
     * nodes get used (OS pages are demand loaded as needed).
     */
#ifdef USE_INTERIOR_NODES
    arena_map_top_t arena_map_root;
    /* accounting for number of used interior nodes */
    int arena_map_mid_count;
    int arena_map_bot_count;
#else
    arena_map_bot_t arena_map_root;
#endif
};

#endif /* WITH_PYMALLOC_RADIX_TREE */


struct _obmalloc_global_state {
    int dump_debug_stats;
    Py_ssize_t interpreter_leaks;
};

struct _obmalloc_state {
    struct _obmalloc_pools pools;
    struct _obmalloc_mgmt mgmt;
#if WITH_PYMALLOC_RADIX_TREE
    struct _obmalloc_usage usage;
#endif
};


#undef  uint


/* Allocate memory directly from the O/S virtual memory system,
 * where supported. Otherwise fallback on malloc */
void *_PyObject_VirtualAlloc(size_t size);
void _PyObject_VirtualFree(void *, size_t size);


/* This function returns the number of allocated memory blocks, regardless of size */
extern Py_ssize_t _Py_GetGlobalAllocatedBlocks(void);
#define _Py_GetAllocatedBlocks() \
    _Py_GetGlobalAllocatedBlocks()
extern Py_ssize_t _PyInterpreterState_GetAllocatedBlocks(PyInterpreterState *);
extern void _PyInterpreterState_FinalizeAllocatedBlocks(PyInterpreterState *);
extern int _PyMem_init_obmalloc(PyInterpreterState *interp);
extern bool _PyMem_obmalloc_state_on_heap(PyInterpreterState *interp);


#ifdef WITH_PYMALLOC
// Export the symbol for the 3rd party 'guppy3' project
PyAPI_FUNC(int) _PyObject_DebugMallocStats(FILE *out);
#endif


#ifdef __cplusplus
}
#endif
#endif  // !Py_INTERNAL_OBMALLOC_H
PK       ! r;9
  
  '  python3.13/internal/pycore_pymem_init.hnu [        #ifndef Py_INTERNAL_PYMEM_INIT_H
#define Py_INTERNAL_PYMEM_INIT_H
#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif


/********************************/
/* the allocators' initializers */

extern void * _PyMem_RawMalloc(void *, size_t);
extern void * _PyMem_RawCalloc(void *, size_t, size_t);
extern void * _PyMem_RawRealloc(void *, void *, size_t);
extern void _PyMem_RawFree(void *, void *);
#define PYRAW_ALLOC {NULL, _PyMem_RawMalloc, _PyMem_RawCalloc, _PyMem_RawRealloc, _PyMem_RawFree}

#ifdef Py_GIL_DISABLED
// Py_GIL_DISABLED requires mimalloc
extern void* _PyObject_MiMalloc(void *, size_t);
extern void* _PyObject_MiCalloc(void *, size_t, size_t);
extern void _PyObject_MiFree(void *, void *);
extern void* _PyObject_MiRealloc(void *, void *, size_t);
#  define PYOBJ_ALLOC {NULL, _PyObject_MiMalloc, _PyObject_MiCalloc, _PyObject_MiRealloc, _PyObject_MiFree}
extern void* _PyMem_MiMalloc(void *, size_t);
extern void* _PyMem_MiCalloc(void *, size_t, size_t);
extern void _PyMem_MiFree(void *, void *);
extern void* _PyMem_MiRealloc(void *, void *, size_t);
#  define PYMEM_ALLOC {NULL, _PyMem_MiMalloc, _PyMem_MiCalloc, _PyMem_MiRealloc, _PyMem_MiFree}
#elif defined(WITH_PYMALLOC)
extern void* _PyObject_Malloc(void *, size_t);
extern void* _PyObject_Calloc(void *, size_t, size_t);
extern void _PyObject_Free(void *, void *);
extern void* _PyObject_Realloc(void *, void *, size_t);
#  define PYOBJ_ALLOC {NULL, _PyObject_Malloc, _PyObject_Calloc, _PyObject_Realloc, _PyObject_Free}
#  define PYMEM_ALLOC PYOBJ_ALLOC
#else
# define PYOBJ_ALLOC PYRAW_ALLOC
# define PYMEM_ALLOC PYOBJ_ALLOC
#endif  // WITH_PYMALLOC


extern void* _PyMem_DebugRawMalloc(void *, size_t);
extern void* _PyMem_DebugRawCalloc(void *, size_t, size_t);
extern void* _PyMem_DebugRawRealloc(void *, void *, size_t);
extern void _PyMem_DebugRawFree(void *, void *);

extern void* _PyMem_DebugMalloc(void *, size_t);
extern void* _PyMem_DebugCalloc(void *, size_t, size_t);
extern void* _PyMem_DebugRealloc(void *, void *, size_t);
extern void _PyMem_DebugFree(void *, void *);

#define PYDBGRAW_ALLOC(runtime) \
    {&(runtime).allocators.debug.raw, _PyMem_DebugRawMalloc, _PyMem_DebugRawCalloc, _PyMem_DebugRawRealloc, _PyMem_DebugRawFree}
#define PYDBGMEM_ALLOC(runtime) \
    {&(runtime).allocators.debug.mem, _PyMem_DebugMalloc, _PyMem_DebugCalloc, _PyMem_DebugRealloc, _PyMem_DebugFree}
#define PYDBGOBJ_ALLOC(runtime) \
    {&(runtime).allocators.debug.obj, _PyMem_DebugMalloc, _PyMem_DebugCalloc, _PyMem_DebugRealloc, _PyMem_DebugFree}

extern void * _PyMem_ArenaAlloc(void *, size_t);
extern void _PyMem_ArenaFree(void *, void *, size_t);

#ifdef Py_DEBUG
# define _pymem_allocators_standard_INIT(runtime) \
    { \
        PYDBGRAW_ALLOC(runtime), \
        PYDBGMEM_ALLOC(runtime), \
        PYDBGOBJ_ALLOC(runtime), \
    }
# define _pymem_is_debug_enabled_INIT 1
#else
# define _pymem_allocators_standard_INIT(runtime) \
    { \
        PYRAW_ALLOC, \
        PYMEM_ALLOC, \
        PYOBJ_ALLOC, \
    }
# define _pymem_is_debug_enabled_INIT 0
#endif

#define _pymem_allocators_debug_INIT \
   { \
       {'r', PYRAW_ALLOC}, \
       {'m', PYMEM_ALLOC}, \
       {'o', PYOBJ_ALLOC}, \
   }

#  define _pymem_allocators_obj_arena_INIT \
    { NULL, _PyMem_ArenaAlloc, _PyMem_ArenaFree }


#define _Py_mem_free_queue_INIT(queue) \
    { \
        .head = LLIST_INIT(queue.head), \
    }

#ifdef __cplusplus
}
#endif
#endif  // !Py_INTERNAL_PYMEM_INIT_H
PK       ! fq    &  python3.13/internal/pycore_setobject.hnu [        #ifndef Py_INTERNAL_SETOBJECT_H
#define Py_INTERNAL_SETOBJECT_H
#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif

// Export for '_abc' shared extension
PyAPI_FUNC(int) _PySet_NextEntry(
    PyObject *set,
    Py_ssize_t *pos,
    PyObject **key,
    Py_hash_t *hash);

// Export for '_pickle' shared extension
PyAPI_FUNC(int) _PySet_NextEntryRef(
    PyObject *set,
    Py_ssize_t *pos,
    PyObject **key,
    Py_hash_t *hash);

// Export for '_pickle' shared extension
PyAPI_FUNC(int) _PySet_Update(PyObject *set, PyObject *iterable);

// Export for the gdb plugin's (python-gdb.py) benefit
PyAPI_DATA(PyObject *) _PySet_Dummy;

PyAPI_FUNC(int) _PySet_Contains(PySetObject *so, PyObject *key);

// Clears the set without acquiring locks. Used by _PyCode_Fini.
extern void _PySet_ClearInternal(PySetObject *so);

#ifdef __cplusplus
}
#endif
#endif  // !Py_INTERNAL_SETOBJECT_H
PK       ! ތ>  >  $  python3.13/internal/pycore_backoff.hnu [        
#ifndef Py_INTERNAL_BACKOFF_H
#define Py_INTERNAL_BACKOFF_H
#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif

#include <assert.h>
#include <stdbool.h>
#include <stdint.h>


typedef struct {
    union {
        struct {
            uint16_t backoff : 4;
            uint16_t value : 12;
        };
        uint16_t as_counter;  // For printf("%#x", ...)
    };
} _Py_BackoffCounter;


/* 16-bit countdown counters using exponential backoff.

   These are used by the adaptive specializer to count down until
   it is time to specialize an instruction. If specialization fails
   the counter is reset using exponential backoff.

   Another use is for the Tier 2 optimizer to decide when to create
   a new Tier 2 trace (executor). Again, exponential backoff is used.

   The 16-bit counter is structured as a 12-bit unsigned 'value'
   and a 4-bit 'backoff' field. When resetting the counter, the
   backoff field is incremented (until it reaches a limit) and the
   value is set to a bit mask representing the value 2**backoff - 1.
   The maximum backoff is 12 (the number of value bits).

   There is an exceptional value which must not be updated, 0xFFFF.
*/

#define UNREACHABLE_BACKOFF 0xFFFF

static inline bool
is_unreachable_backoff_counter(_Py_BackoffCounter counter)
{
    return counter.as_counter == UNREACHABLE_BACKOFF;
}

static inline _Py_BackoffCounter
make_backoff_counter(uint16_t value, uint16_t backoff)
{
    assert(backoff <= 15);
    assert(value <= 0xFFF);
    _Py_BackoffCounter result;
    result.value = value;
    result.backoff = backoff;
    return result;
}

static inline _Py_BackoffCounter
forge_backoff_counter(uint16_t counter)
{
    _Py_BackoffCounter result;
    result.as_counter = counter;
    return result;
}

static inline _Py_BackoffCounter
restart_backoff_counter(_Py_BackoffCounter counter)
{
    assert(!is_unreachable_backoff_counter(counter));
    if (counter.backoff < 12) {
        return make_backoff_counter((1 << (counter.backoff + 1)) - 1, counter.backoff + 1);
    }
    else {
        return make_backoff_counter((1 << 12) - 1, 12);
    }
}

static inline _Py_BackoffCounter
pause_backoff_counter(_Py_BackoffCounter counter)
{
    return make_backoff_counter(counter.value | 1, counter.backoff);
}

static inline _Py_BackoffCounter
advance_backoff_counter(_Py_BackoffCounter counter)
{
    if (!is_unreachable_backoff_counter(counter)) {
        return make_backoff_counter((counter.value - 1) & 0xFFF, counter.backoff);
    }
    else {
        return counter;
    }
}

static inline bool
backoff_counter_triggers(_Py_BackoffCounter counter)
{
    return counter.value == 0;
}

/* Initial JUMP_BACKWARD counter.
 * This determines when we create a trace for a loop.
* Backoff sequence 16, 32, 64, 128, 256, 512, 1024, 2048, 4096. */
#define JUMP_BACKWARD_INITIAL_VALUE 16
#define JUMP_BACKWARD_INITIAL_BACKOFF 4
static inline _Py_BackoffCounter
initial_jump_backoff_counter(void)
{
    return make_backoff_counter(JUMP_BACKWARD_INITIAL_VALUE,
                                JUMP_BACKWARD_INITIAL_BACKOFF);
}

/* Initial exit temperature.
 * Must be larger than ADAPTIVE_COOLDOWN_VALUE,
 * otherwise when a side exit warms up we may construct
 * a new trace before the Tier 1 code has properly re-specialized.
 * Backoff sequence 64, 128, 256, 512, 1024, 2048, 4096. */
#define COLD_EXIT_INITIAL_VALUE 64
#define COLD_EXIT_INITIAL_BACKOFF 6

static inline _Py_BackoffCounter
initial_temperature_backoff_counter(void)
{
    return make_backoff_counter(COLD_EXIT_INITIAL_VALUE,
                                COLD_EXIT_INITIAL_BACKOFF);
}

/* Unreachable backoff counter. */
static inline _Py_BackoffCounter
initial_unreachable_backoff_counter(void)
{
    return forge_backoff_counter(UNREACHABLE_BACKOFF);
}

#ifdef __cplusplus
}
#endif
#endif /* !Py_INTERNAL_BACKOFF_H */
PK       ! \o!  !  #  python3.13/internal/pycore_pymath.hnu [        #ifndef Py_INTERNAL_PYMATH_H
#define Py_INTERNAL_PYMATH_H
#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif


/* _Py_ADJUST_ERANGE1(x)
 * _Py_ADJUST_ERANGE2(x, y)
 * Set errno to 0 before calling a libm function, and invoke one of these
 * macros after, passing the function result(s) (_Py_ADJUST_ERANGE2 is useful
 * for functions returning complex results).  This makes two kinds of
 * adjustments to errno:  (A) If it looks like the platform libm set
 * errno=ERANGE due to underflow, clear errno. (B) If it looks like the
 * platform libm overflowed but didn't set errno, force errno to ERANGE.  In
 * effect, we're trying to force a useful implementation of C89 errno
 * behavior.
 * Caution:
 *    This isn't reliable.  C99 no longer requires libm to set errno under
 *        any exceptional condition, but does require +- HUGE_VAL return
 *        values on overflow.  A 754 box *probably* maps HUGE_VAL to a
 *        double infinity, and we're cool if that's so, unless the input
 *        was an infinity and an infinity is the expected result.  A C89
 *        system sets errno to ERANGE, so we check for that too.  We're
 *        out of luck if a C99 754 box doesn't map HUGE_VAL to +Inf, or
 *        if the returned result is a NaN, or if a C89 box returns HUGE_VAL
 *        in non-overflow cases.
 */
static inline void _Py_ADJUST_ERANGE1(double x)
{
    if (errno == 0) {
        if (x == Py_HUGE_VAL || x == -Py_HUGE_VAL) {
            errno = ERANGE;
        }
    }
    else if (errno == ERANGE && x == 0.0) {
        errno = 0;
    }
}

static inline void _Py_ADJUST_ERANGE2(double x, double y)
{
    if (x == Py_HUGE_VAL || x == -Py_HUGE_VAL ||
        y == Py_HUGE_VAL || y == -Py_HUGE_VAL)
    {
        if (errno == 0) {
            errno = ERANGE;
        }
    }
    else if (errno == ERANGE) {
        errno = 0;
    }
}


//--- HAVE_PY_SET_53BIT_PRECISION macro ------------------------------------
//
// The functions _Py_dg_strtod() and _Py_dg_dtoa() in Python/dtoa.c (which are
// required to support the short float repr introduced in Python 3.1) require
// that the floating-point unit that's being used for arithmetic operations on
// C doubles is set to use 53-bit precision.  It also requires that the FPU
// rounding mode is round-half-to-even, but that's less often an issue.
//
// If your FPU isn't already set to 53-bit precision/round-half-to-even, and
// you want to make use of _Py_dg_strtod() and _Py_dg_dtoa(), then you should:
//
//     #define HAVE_PY_SET_53BIT_PRECISION 1
//
// and also give appropriate definitions for the following three macros:
//
// * _Py_SET_53BIT_PRECISION_HEADER: any variable declarations needed to
//   use the two macros below.
// * _Py_SET_53BIT_PRECISION_START: store original FPU settings, and
//   set FPU to 53-bit precision/round-half-to-even
// * _Py_SET_53BIT_PRECISION_END: restore original FPU settings
//
// The macros are designed to be used within a single C function: see
// Python/pystrtod.c for an example of their use.


// Get and set x87 control word for gcc/x86
#ifdef HAVE_GCC_ASM_FOR_X87
#define HAVE_PY_SET_53BIT_PRECISION 1

// Functions defined in Python/pymath.c
extern unsigned short _Py_get_387controlword(void);
extern void _Py_set_387controlword(unsigned short);

#define _Py_SET_53BIT_PRECISION_HEADER                                  \
    unsigned short old_387controlword, new_387controlword
#define _Py_SET_53BIT_PRECISION_START                                   \
    do {                                                                \
        old_387controlword = _Py_get_387controlword();                  \
        new_387controlword = (old_387controlword & ~0x0f00) | 0x0200;   \
        if (new_387controlword != old_387controlword) {                 \
            _Py_set_387controlword(new_387controlword);                 \
        }                                                               \
    } while (0)
#define _Py_SET_53BIT_PRECISION_END                                     \
    do {                                                                \
        if (new_387controlword != old_387controlword) {                 \
            _Py_set_387controlword(old_387controlword);                 \
        }                                                               \
    } while (0)
#endif

// Get and set x87 control word for VisualStudio/x86.
// x87 is not supported in 64-bit or ARM.
#if defined(_MSC_VER) && !defined(_WIN64) && !defined(_M_ARM)
#define HAVE_PY_SET_53BIT_PRECISION 1

#include <float.h>                // __control87_2()

#define _Py_SET_53BIT_PRECISION_HEADER \
    unsigned int old_387controlword, new_387controlword, out_387controlword
    // We use the __control87_2 function to set only the x87 control word.
    // The SSE control word is unaffected.
#define _Py_SET_53BIT_PRECISION_START                                   \
    do {                                                                \
        __control87_2(0, 0, &old_387controlword, NULL);                 \
        new_387controlword =                                            \
          (old_387controlword & ~(_MCW_PC | _MCW_RC)) | (_PC_53 | _RC_NEAR); \
        if (new_387controlword != old_387controlword) {                 \
            __control87_2(new_387controlword, _MCW_PC | _MCW_RC,        \
                          &out_387controlword, NULL);                   \
        }                                                               \
    } while (0)
#define _Py_SET_53BIT_PRECISION_END                                     \
    do {                                                                \
        if (new_387controlword != old_387controlword) {                 \
            __control87_2(old_387controlword, _MCW_PC | _MCW_RC,        \
                          &out_387controlword, NULL);                   \
        }                                                               \
    } while (0)
#endif


// MC68881
#ifdef HAVE_GCC_ASM_FOR_MC68881
#define HAVE_PY_SET_53BIT_PRECISION 1
#define _Py_SET_53BIT_PRECISION_HEADER \
    unsigned int old_fpcr, new_fpcr
#define _Py_SET_53BIT_PRECISION_START                                   \
    do {                                                                \
        __asm__ ("fmove.l %%fpcr,%0" : "=g" (old_fpcr));                \
        /* Set double precision / round to nearest.  */                 \
        new_fpcr = (old_fpcr & ~0xf0) | 0x80;                           \
        if (new_fpcr != old_fpcr) {                                     \
              __asm__ volatile ("fmove.l %0,%%fpcr" : : "g" (new_fpcr));\
        }                                                               \
    } while (0)
#define _Py_SET_53BIT_PRECISION_END                                     \
    do {                                                                \
        if (new_fpcr != old_fpcr) {                                     \
            __asm__ volatile ("fmove.l %0,%%fpcr" : : "g" (old_fpcr));  \
        }                                                               \
    } while (0)
#endif

// Default definitions are empty
#ifndef _Py_SET_53BIT_PRECISION_HEADER
#  define _Py_SET_53BIT_PRECISION_HEADER
#  define _Py_SET_53BIT_PRECISION_START
#  define _Py_SET_53BIT_PRECISION_END
#endif


//--- _PY_SHORT_FLOAT_REPR macro -------------------------------------------

// If we can't guarantee 53-bit precision, don't use the code
// in Python/dtoa.c, but fall back to standard code.  This
// means that repr of a float will be long (17 significant digits).
//
// Realistically, there are two things that could go wrong:
//
// (1) doubles aren't IEEE 754 doubles, or
// (2) we're on x86 with the rounding precision set to 64-bits
//     (extended precision), and we don't know how to change
//     the rounding precision.
#if !defined(DOUBLE_IS_LITTLE_ENDIAN_IEEE754) && \
    !defined(DOUBLE_IS_BIG_ENDIAN_IEEE754) && \
    !defined(DOUBLE_IS_ARM_MIXED_ENDIAN_IEEE754)
#  define _PY_SHORT_FLOAT_REPR 0
#endif

// Double rounding is symptomatic of use of extended precision on x86.
// If we're seeing double rounding, and we don't have any mechanism available
// for changing the FPU rounding precision, then don't use Python/dtoa.c.
#if defined(X87_DOUBLE_ROUNDING) && !defined(HAVE_PY_SET_53BIT_PRECISION)
#  define _PY_SHORT_FLOAT_REPR 0
#endif

#ifndef _PY_SHORT_FLOAT_REPR
#  define _PY_SHORT_FLOAT_REPR 1
#endif


#ifdef __cplusplus
}
#endif
#endif /* !Py_INTERNAL_PYMATH_H */
PK       ! cȁ    '  python3.13/internal/pycore_pathconfig.hnu [        #ifndef Py_INTERNAL_PATHCONFIG_H
#define Py_INTERNAL_PATHCONFIG_H
#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif

// Export for '_testinternalcapi' shared extension
PyAPI_FUNC(void) _PyPathConfig_ClearGlobal(void);

extern PyStatus _PyPathConfig_ReadGlobal(PyConfig *config);
extern PyStatus _PyPathConfig_UpdateGlobal(const PyConfig *config);
extern const wchar_t * _PyPathConfig_GetGlobalModuleSearchPath(void);

extern int _PyPathConfig_ComputeSysPath0(
    const PyWideStringList *argv,
    PyObject **path0);


#ifdef __cplusplus
}
#endif
#endif /* !Py_INTERNAL_PATHCONFIG_H */
PK       ! e    #  python3.13/internal/pycore_strhex.hnu [        #ifndef Py_INTERNAL_STRHEX_H
#define Py_INTERNAL_STRHEX_H
#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif

// Returns a str() containing the hex representation of argbuf.
// Export for '_hashlib' shared extension.
PyAPI_FUNC(PyObject*) _Py_strhex(const
    char* argbuf,
    const Py_ssize_t arglen);

// Returns a bytes() containing the ASCII hex representation of argbuf.
extern PyObject* _Py_strhex_bytes(
    const char* argbuf,
    const Py_ssize_t arglen);

// These variants include support for a separator between every N bytes:
extern PyObject* _Py_strhex_with_sep(
    const char* argbuf,
    const Py_ssize_t arglen,
    PyObject* sep,
    const int bytes_per_group);

// Export for 'binascii' shared extension
PyAPI_FUNC(PyObject*) _Py_strhex_bytes_with_sep(
    const char* argbuf,
    const Py_ssize_t arglen,
    PyObject* sep,
    const int bytes_per_group);

#ifdef __cplusplus
}
#endif
#endif /* !Py_INTERNAL_STRHEX_H */
PK       ! xd    $  python3.13/internal/pycore_context.hnu [        #ifndef Py_INTERNAL_CONTEXT_H
#define Py_INTERNAL_CONTEXT_H

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif

#include "pycore_freelist.h"      // _PyFreeListState
#include "pycore_hamt.h"          // PyHamtObject


extern PyTypeObject _PyContextTokenMissing_Type;

/* runtime lifecycle */

PyStatus _PyContext_Init(PyInterpreterState *);


/* other API */

typedef struct {
    PyObject_HEAD
} _PyContextTokenMissing;

struct _pycontextobject {
    PyObject_HEAD
    PyContext *ctx_prev;
    PyHamtObject *ctx_vars;
    PyObject *ctx_weakreflist;
    int ctx_entered;
};


struct _pycontextvarobject {
    PyObject_HEAD
    PyObject *var_name;
    PyObject *var_default;
#ifndef Py_GIL_DISABLED
    PyObject *var_cached;
    uint64_t var_cached_tsid;
    uint64_t var_cached_tsver;
#endif
    Py_hash_t var_hash;
};


struct _pycontexttokenobject {
    PyObject_HEAD
    PyContext *tok_ctx;
    PyContextVar *tok_var;
    PyObject *tok_oldval;
    int tok_used;
};


// _testinternalcapi.hamt() used by tests.
// Export for '_testcapi' shared extension
PyAPI_FUNC(PyObject*) _PyContext_NewHamtForTests(void);


#endif /* !Py_INTERNAL_CONTEXT_H */
PK       ! QNoI	  	  #  python3.13/internal/pycore_codecs.hnu [        #ifndef Py_INTERNAL_CODECS_H
#define Py_INTERNAL_CODECS_H
#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif

#include "pycore_lock.h"          // PyMutex

/* Initialize codecs-related state for the given interpreter, including
   registering the first codec search function. Must be called before any other
   PyCodec-related functions, and while only one thread is active. */
extern PyStatus _PyCodec_InitRegistry(PyInterpreterState *interp);

/* Finalize codecs-related state for the given interpreter. No PyCodec-related
   functions other than PyCodec_Unregister() may be called after this. */
extern void _PyCodec_Fini(PyInterpreterState *interp);

extern PyObject* _PyCodec_Lookup(const char *encoding);

/* Text codec specific encoding and decoding API.

   Checks the encoding against a list of codecs which do not
   implement a str<->bytes encoding before attempting the
   operation.

   Please note that these APIs are internal and should not
   be used in Python C extensions.

   XXX (ncoghlan): should we make these, or something like them, public
   in Python 3.5+?

 */
extern PyObject* _PyCodec_LookupTextEncoding(
   const char *encoding,
   const char *alternate_command);

extern PyObject* _PyCodec_EncodeText(
   PyObject *object,
   const char *encoding,
   const char *errors);

extern PyObject* _PyCodec_DecodeText(
   PyObject *object,
   const char *encoding,
   const char *errors);

/* These two aren't actually text encoding specific, but _io.TextIOWrapper
 * is the only current API consumer.
 */
extern PyObject* _PyCodecInfo_GetIncrementalDecoder(
   PyObject *codec_info,
   const char *errors);

extern PyObject* _PyCodecInfo_GetIncrementalEncoder(
   PyObject *codec_info,
   const char *errors);

// Per-interpreter state used by codecs.c.
struct codecs_state {
    // A list of callable objects used to search for codecs.
    PyObject *search_path;

    // A dict mapping codec names to codecs returned from a callable in
    // search_path.
    PyObject *search_cache;

    // A dict mapping error handling strategies to functions to implement them.
    PyObject *error_registry;

#ifdef Py_GIL_DISABLED
    // Used to safely delete a specific item from search_path.
    PyMutex search_path_mutex;
#endif

    // Whether or not the rest of the state is initialized.
    int initialized;
};

#ifdef __cplusplus
}
#endif
#endif /* !Py_INTERNAL_CODECS_H */
PK       ! f!  !  %  python3.13/internal/pycore_symtable.hnu [        #ifndef Py_INTERNAL_SYMTABLE_H
#define Py_INTERNAL_SYMTABLE_H
#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif

struct _mod;   // Type defined in pycore_ast.h

typedef enum _block_type {
    FunctionBlock, ClassBlock, ModuleBlock,
    // Used for annotations if 'from __future__ import annotations' is active.
    // Annotation blocks cannot bind names and are not evaluated.
    AnnotationBlock,

    // The following blocks are used for generics and type aliases. These work
    // mostly like functions (see PEP 695 for details). The three different
    // blocks function identically; they are different enum entries only so
    // that error messages can be more precise.

    // The block to enter when processing a "type" (PEP 695) construction,
    // e.g., "type MyGeneric[T] = list[T]".
    TypeAliasBlock,
    // The block to enter when processing a "generic" (PEP 695) object,
    // e.g., "def foo[T](): pass" or "class A[T]: pass".
    TypeParametersBlock,
    // The block to enter when processing the bound, the constraint tuple
    // or the default value of a single "type variable" in the formal sense,
    // i.e., a TypeVar, a TypeVarTuple or a ParamSpec object (the latter two
    // do not support a bound or a constraint tuple).
    TypeVariableBlock,
} _Py_block_ty;

typedef enum _comprehension_type {
    NoComprehension = 0,
    ListComprehension = 1,
    DictComprehension = 2,
    SetComprehension = 3,
    GeneratorExpression = 4 } _Py_comprehension_ty;

/* source location information */
typedef struct {
    int lineno;
    int end_lineno;
    int col_offset;
    int end_col_offset;
} _Py_SourceLocation;

#define SRC_LOCATION_FROM_AST(n) \
    (_Py_SourceLocation){ \
               .lineno = (n)->lineno, \
               .end_lineno = (n)->end_lineno, \
               .col_offset = (n)->col_offset, \
               .end_col_offset = (n)->end_col_offset }

static const _Py_SourceLocation NO_LOCATION = {-1, -1, -1, -1};

/* __future__ information */
typedef struct {
    int ff_features;                    /* flags set by future statements */
    _Py_SourceLocation ff_location;     /* location of last future statement */
} _PyFutureFeatures;

struct _symtable_entry;

struct symtable {
    PyObject *st_filename;          /* name of file being compiled,
                                       decoded from the filesystem encoding */
    struct _symtable_entry *st_cur; /* current symbol table entry */
    struct _symtable_entry *st_top; /* symbol table entry for module */
    PyObject *st_blocks;            /* dict: map AST node addresses
                                     *       to symbol table entries */
    PyObject *st_stack;             /* list: stack of namespace info */
    PyObject *st_global;            /* borrowed ref to st_top->ste_symbols */
    int st_nblocks;                 /* number of blocks used. kept for
                                       consistency with the corresponding
                                       compiler structure */
    PyObject *st_private;           /* name of current class or NULL */
    _PyFutureFeatures *st_future;   /* module's future features that affect
                                       the symbol table */
    int recursion_depth;            /* current recursion depth */
    int recursion_limit;            /* recursion limit */
};

typedef struct _symtable_entry {
    PyObject_HEAD
    PyObject *ste_id;        /* int: key in ste_table->st_blocks */
    PyObject *ste_symbols;   /* dict: variable names to flags */
    PyObject *ste_name;      /* string: name of current block */
    PyObject *ste_varnames;  /* list of function parameters */
    PyObject *ste_children;  /* list of child blocks */
    PyObject *ste_directives;/* locations of global and nonlocal statements */
    PyObject *ste_mangled_names; /* set of names for which mangling should be applied */

    _Py_block_ty ste_type;
    // Optional string set by symtable.c and used when reporting errors.
    // The content of that string is a description of the current "context".
    //
    // For instance, if we are processing the default value of the type
    // variable "T" in "def foo[T = int](): pass", `ste_scope_info` is
    // set to "a TypeVar default".
    const char *ste_scope_info;

    int ste_nested;      /* true if block is nested */
    unsigned ste_free : 1;        /* true if block has free variables */
    unsigned ste_child_free : 1;  /* true if a child block has free vars,
                                     including free refs to globals */
    unsigned ste_generator : 1;   /* true if namespace is a generator */
    unsigned ste_coroutine : 1;   /* true if namespace is a coroutine */
    _Py_comprehension_ty ste_comprehension;  /* Kind of comprehension (if any) */
    unsigned ste_varargs : 1;     /* true if block has varargs */
    unsigned ste_varkeywords : 1; /* true if block has varkeywords */
    unsigned ste_returns_value : 1;  /* true if namespace uses return with
                                        an argument */
    unsigned ste_needs_class_closure : 1; /* for class scopes, true if a
                                             closure over __class__
                                             should be created */
    unsigned ste_needs_classdict : 1; /* for class scopes, true if a closure
                                         over the class dict should be created */
    unsigned ste_comp_inlined : 1; /* true if this comprehension is inlined */
    unsigned ste_comp_iter_target : 1; /* true if visiting comprehension target */
    unsigned ste_can_see_class_scope : 1; /* true if this block can see names bound in an
                                             enclosing class scope */
    int ste_comp_iter_expr; /* non-zero if visiting a comprehension range expression */
    int ste_lineno;          /* first line of block */
    int ste_col_offset;      /* offset of first line of block */
    int ste_end_lineno;      /* end line of block */
    int ste_end_col_offset;  /* end offset of first line of block */
    int ste_opt_lineno;      /* lineno of last exec or import * */
    int ste_opt_col_offset;  /* offset of last exec or import * */
    struct symtable *ste_table;
} PySTEntryObject;

extern PyTypeObject PySTEntry_Type;

#define PySTEntry_Check(op) Py_IS_TYPE((op), &PySTEntry_Type)

extern long _PyST_GetSymbol(PySTEntryObject *, PyObject *);
extern int _PyST_GetScope(PySTEntryObject *, PyObject *);
extern int _PyST_IsFunctionLike(PySTEntryObject *);

extern struct symtable* _PySymtable_Build(
    struct _mod *mod,
    PyObject *filename,
    _PyFutureFeatures *future);
extern PySTEntryObject* _PySymtable_Lookup(struct symtable *, void *);

extern void _PySymtable_Free(struct symtable *);

extern PyObject *_Py_MaybeMangle(PyObject *privateobj, PySTEntryObject *ste, PyObject *name);
extern PyObject* _Py_Mangle(PyObject *p, PyObject *name);

/* Flags for def-use information */

#define DEF_GLOBAL 1             /* global stmt */
#define DEF_LOCAL 2              /* assignment in code block */
#define DEF_PARAM (2<<1)         /* formal parameter */
#define DEF_NONLOCAL (2<<2)      /* nonlocal stmt */
#define USE (2<<3)               /* name is used */
#define DEF_FREE (2<<4)          /* name used but not defined in nested block */
#define DEF_FREE_CLASS (2<<5)    /* free variable from class's method */
#define DEF_IMPORT (2<<6)        /* assignment occurred via import */
#define DEF_ANNOT (2<<7)         /* this name is annotated */
#define DEF_COMP_ITER (2<<8)     /* this name is a comprehension iteration variable */
#define DEF_TYPE_PARAM (2<<9)    /* this name is a type parameter */
#define DEF_COMP_CELL (2<<10)    /* this name is a cell in an inlined comprehension */

#define DEF_BOUND (DEF_LOCAL | DEF_PARAM | DEF_IMPORT)

/* GLOBAL_EXPLICIT and GLOBAL_IMPLICIT are used internally by the symbol
   table.  GLOBAL is returned from PyST_GetScope() for either of them.
   It is stored in ste_symbols at bits 13-16.
*/
#define SCOPE_OFFSET 12
#define SCOPE_MASK (DEF_GLOBAL | DEF_LOCAL | DEF_PARAM | DEF_NONLOCAL)

#define LOCAL 1
#define GLOBAL_EXPLICIT 2
#define GLOBAL_IMPLICIT 3
#define FREE 4
#define CELL 5

#define GENERATOR 1
#define GENERATOR_EXPRESSION 2

// Used by symtablemodule.c
extern struct symtable* _Py_SymtableStringObjectFlags(
    const char *str,
    PyObject *filename,
    int start,
    PyCompilerFlags *flags);

int _PyFuture_FromAST(
    struct _mod * mod,
    PyObject *filename,
    _PyFutureFeatures* futures);

#ifdef __cplusplus
}
#endif
#endif /* !Py_INTERNAL_SYMTABLE_H */
PK       ! {    $  python3.13/internal/pycore_ucnhash.hnu [        /* Unicode name database interface */
#ifndef Py_INTERNAL_UCNHASH_H
#define Py_INTERNAL_UCNHASH_H
#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif

/* revised ucnhash CAPI interface (exported through a "wrapper") */

#define PyUnicodeData_CAPSULE_NAME "unicodedata._ucnhash_CAPI"

typedef struct {

    /* Get name for a given character code.
       Returns non-zero if success, zero if not.
       Does not set Python exceptions. */
    int (*getname)(Py_UCS4 code, char* buffer, int buflen,
                   int with_alias_and_seq);

    /* Get character code for a given name.
       Same error handling as for getname(). */
    int (*getcode)(const char* name, int namelen, Py_UCS4* code,
                   int with_named_seq);

} _PyUnicode_Name_CAPI;

extern _PyUnicode_Name_CAPI* _PyUnicode_GetNameCAPI(void);

#ifdef __cplusplus
}
#endif
#endif /* !Py_INTERNAL_UCNHASH_H */
PK       ! :3  3  #  python3.13/internal/pycore_import.hnu [        #ifndef Py_LIMITED_API
#ifndef Py_INTERNAL_IMPORT_H
#define Py_INTERNAL_IMPORT_H
#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif

#include "pycore_lock.h"          // PyMutex
#include "pycore_hashtable.h"     // _Py_hashtable_t

extern int _PyImport_IsInitialized(PyInterpreterState *);

// Export for 'pyexpat' shared extension
PyAPI_FUNC(int) _PyImport_SetModule(PyObject *name, PyObject *module);

extern int _PyImport_SetModuleString(const char *name, PyObject* module);

extern void _PyImport_AcquireLock(PyInterpreterState *interp);
extern void _PyImport_ReleaseLock(PyInterpreterState *interp);
extern void _PyImport_ReInitLock(PyInterpreterState *interp);

// This is used exclusively for the sys and builtins modules:
extern int _PyImport_FixupBuiltin(
    PyThreadState *tstate,
    PyObject *mod,
    const char *name,            /* UTF-8 encoded string */
    PyObject *modules
    );

// Export for many shared extensions, like '_json'
PyAPI_FUNC(PyObject*) _PyImport_GetModuleAttr(PyObject *, PyObject *);

// Export for many shared extensions, like '_datetime'
PyAPI_FUNC(PyObject*) _PyImport_GetModuleAttrString(const char *, const char *);


struct _import_runtime_state {
    /* The builtin modules (defined in config.c). */
    struct _inittab *inittab;
    /* The most recent value assigned to a PyModuleDef.m_base.m_index.
       This is incremented each time PyModuleDef_Init() is called,
       which is just about every time an extension module is imported.
       See PyInterpreterState.modules_by_index for more info. */
    Py_ssize_t last_module_index;
    struct {
        /* A lock to guard the cache. */
        PyMutex mutex;
        /* The actual cache of (filename, name, PyModuleDef) for modules.
           Only legacy (single-phase init) extension modules are added
           and only if they support multiple initialization (m_size >- 0)
           or are imported in the main interpreter.
           This is initialized lazily in fix_up_extension() in import.c.
           Modules are added there and looked up in _imp.find_extension(). */
        _Py_hashtable_t *hashtable;
    } extensions;
    /* Package context -- the full module name for package imports */
    const char * pkgcontext;
};

struct _import_state {
    /* cached sys.modules dictionary */
    PyObject *modules;
    /* This is the list of module objects for all legacy (single-phase init)
       extension modules ever loaded in this process (i.e. imported
       in this interpreter or in any other).  Py_None stands in for
       modules that haven't actually been imported in this interpreter.

       A module's index (PyModuleDef.m_base.m_index) is used to look up
       the corresponding module object for this interpreter, if any.
       (See PyState_FindModule().)  When any extension module
       is initialized during import, its moduledef gets initialized by
       PyModuleDef_Init(), and the first time that happens for each
       PyModuleDef, its index gets set to the current value of
       a global counter (see _PyRuntimeState.imports.last_module_index).
       The entry for that index in this interpreter remains unset until
       the module is actually imported here.  (Py_None is used as
       a placeholder.)  Note that multi-phase init modules always get
       an index for which there will never be a module set.

       This is initialized lazily in PyState_AddModule(), which is also
       where modules get added. */
    PyObject *modules_by_index;
    /* importlib module._bootstrap */
    PyObject *importlib;
    /* override for config->use_frozen_modules (for tests)
       (-1: "off", 1: "on", 0: no override) */
    int override_frozen_modules;
    int override_multi_interp_extensions_check;
#ifdef HAVE_DLOPEN
    int dlopenflags;
#endif
    PyObject *import_func;
    /* The global import lock. */
    _PyRecursiveMutex lock;
    /* diagnostic info in PyImport_ImportModuleLevelObject() */
    struct {
        int import_level;
        PyTime_t accumulated;
        int header;
    } find_and_load;
};

#ifdef HAVE_DLOPEN
#  include <dlfcn.h>              // RTLD_NOW, RTLD_LAZY
#  if HAVE_DECL_RTLD_NOW
#    define _Py_DLOPEN_FLAGS RTLD_NOW
#  else
#    define _Py_DLOPEN_FLAGS RTLD_LAZY
#  endif
#  define DLOPENFLAGS_INIT .dlopenflags = _Py_DLOPEN_FLAGS,
#else
#  define _Py_DLOPEN_FLAGS 0
#  define DLOPENFLAGS_INIT
#endif

#define IMPORTS_INIT \
    { \
        DLOPENFLAGS_INIT \
        .find_and_load = { \
            .header = 1, \
        }, \
    }

extern void _PyImport_ClearCore(PyInterpreterState *interp);

extern Py_ssize_t _PyImport_GetNextModuleIndex(void);
extern const char * _PyImport_ResolveNameWithPackageContext(const char *name);
extern const char * _PyImport_SwapPackageContext(const char *newcontext);

extern int _PyImport_GetDLOpenFlags(PyInterpreterState *interp);
extern void _PyImport_SetDLOpenFlags(PyInterpreterState *interp, int new_val);

extern PyObject * _PyImport_InitModules(PyInterpreterState *interp);
extern PyObject * _PyImport_GetModules(PyInterpreterState *interp);
extern void _PyImport_ClearModules(PyInterpreterState *interp);

extern void _PyImport_ClearModulesByIndex(PyInterpreterState *interp);

extern int _PyImport_InitDefaultImportFunc(PyInterpreterState *interp);
extern int _PyImport_IsDefaultImportFunc(
        PyInterpreterState *interp,
        PyObject *func);

extern PyObject * _PyImport_GetImportlibLoader(
        PyInterpreterState *interp,
        const char *loader_name);
extern PyObject * _PyImport_GetImportlibExternalLoader(
        PyInterpreterState *interp,
        const char *loader_name);
extern PyObject * _PyImport_BlessMyLoader(
        PyInterpreterState *interp,
        PyObject *module_globals);
extern PyObject * _PyImport_ImportlibModuleRepr(
        PyInterpreterState *interp,
        PyObject *module);


extern PyStatus _PyImport_Init(void);
extern void _PyImport_Fini(void);
extern void _PyImport_Fini2(void);

extern PyStatus _PyImport_InitCore(
        PyThreadState *tstate,
        PyObject *sysmod,
        int importlib);
extern PyStatus _PyImport_InitExternal(PyThreadState *tstate);
extern void _PyImport_FiniCore(PyInterpreterState *interp);
extern void _PyImport_FiniExternal(PyInterpreterState *interp);


extern PyObject* _PyImport_GetBuiltinModuleNames(void);

struct _module_alias {
    const char *name;                 /* ASCII encoded string */
    const char *orig;                 /* ASCII encoded string */
};

// Export these 3 symbols for test_ctypes
PyAPI_DATA(const struct _frozen*) _PyImport_FrozenBootstrap;
PyAPI_DATA(const struct _frozen*) _PyImport_FrozenStdlib;
PyAPI_DATA(const struct _frozen*) _PyImport_FrozenTest;

extern const struct _module_alias * _PyImport_FrozenAliases;

extern int _PyImport_CheckSubinterpIncompatibleExtensionAllowed(
    const char *name);


// Export for '_testinternalcapi' shared extension
PyAPI_FUNC(int) _PyImport_ClearExtension(PyObject *name, PyObject *filename);

#ifdef Py_GIL_DISABLED
// Assuming that the GIL is enabled from a call to
// _PyEval_EnableGILTransient(), resolve the transient request depending on the
// state of the module argument:
// - If module is NULL or a PyModuleObject with md_gil == Py_MOD_GIL_NOT_USED,
//   call _PyEval_DisableGIL().
// - Otherwise, call _PyEval_EnableGILPermanent(). If the GIL was not already
//   enabled permanently, issue a warning referencing the module's name.
//
// This function may raise an exception.
extern int _PyImport_CheckGILForModule(PyObject *module, PyObject *module_name);
#endif

#ifdef __cplusplus
}
#endif
#endif /* !Py_INTERNAL_IMPORT_H */
#endif /* !Py_LIMITED_API */
PK       ! `ʉ    '  python3.13/internal/pycore_exceptions.hnu [        #ifndef Py_INTERNAL_EXCEPTIONS_H
#define Py_INTERNAL_EXCEPTIONS_H
#ifdef __cplusplus
extern "C" {
#endif

#ifndef Py_BUILD_CORE
#  error "this header requires Py_BUILD_CORE define"
#endif


/* runtime lifecycle */

extern PyStatus _PyExc_InitState(PyInterpreterState *);
extern PyStatus _PyExc_InitGlobalObjects(PyInterpreterState *);
extern int _PyExc_InitTypes(PyInterpreterState *);
extern void _PyExc_Fini(PyInterpreterState *);


/* other API */

struct _Py_exc_state {
    // The dict mapping from errno codes to OSError subclasses
    PyObject *errnomap;
    PyBaseExceptionObject *memerrors_freelist;
    int memerrors_numfree;
#ifdef Py_GIL_DISABLED
    PyMutex memerrors_lock;
#endif
    // The ExceptionGroup type
    PyObject *PyExc_ExceptionGroup;
};

extern void _PyExc_ClearExceptionGroupType(PyInterpreterState *);


#ifdef __cplusplus
}
#endif
#endif /* !Py_INTERNAL_EXCEPTIONS_H */
PK       ! W-  -  )  python3.13/internal/pycore_uop_metadata.hnu [        // This file is generated by Tools/cases_generator/uop_metadata_generator.py
// from:
//   Python/bytecodes.c
// Do not edit!

#ifndef Py_CORE_UOP_METADATA_H
#define Py_CORE_UOP_METADATA_H
#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include "pycore_uop_ids.h"
extern const uint16_t _PyUop_Flags[MAX_UOP_ID+1];
extern const uint8_t _PyUop_Replication[MAX_UOP_ID+1];
extern const char * const _PyOpcode_uop_name[MAX_UOP_ID+1];

extern int _PyUop_num_popped(int opcode, int oparg);

#ifdef NEED_OPCODE_METADATA
const uint16_t _PyUop_Flags[MAX_UOP_ID+1] = {
    [_NOP] = HAS_PURE_FLAG,
    [_RESUME_CHECK] = HAS_DEOPT_FLAG,
    [_LOAD_FAST_CHECK] = HAS_ARG_FLAG | HAS_LOCAL_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_LOAD_FAST_0] = HAS_LOCAL_FLAG | HAS_PURE_FLAG,
    [_LOAD_FAST_1] = HAS_LOCAL_FLAG | HAS_PURE_FLAG,
    [_LOAD_FAST_2] = HAS_LOCAL_FLAG | HAS_PURE_FLAG,
    [_LOAD_FAST_3] = HAS_LOCAL_FLAG | HAS_PURE_FLAG,
    [_LOAD_FAST_4] = HAS_LOCAL_FLAG | HAS_PURE_FLAG,
    [_LOAD_FAST_5] = HAS_LOCAL_FLAG | HAS_PURE_FLAG,
    [_LOAD_FAST_6] = HAS_LOCAL_FLAG | HAS_PURE_FLAG,
    [_LOAD_FAST_7] = HAS_LOCAL_FLAG | HAS_PURE_FLAG,
    [_LOAD_FAST] = HAS_ARG_FLAG | HAS_LOCAL_FLAG | HAS_PURE_FLAG,
    [_LOAD_FAST_AND_CLEAR] = HAS_ARG_FLAG | HAS_LOCAL_FLAG,
    [_LOAD_FAST_LOAD_FAST] = HAS_ARG_FLAG | HAS_LOCAL_FLAG,
    [_LOAD_CONST] = HAS_ARG_FLAG | HAS_CONST_FLAG | HAS_PURE_FLAG,
    [_STORE_FAST_0] = HAS_LOCAL_FLAG,
    [_STORE_FAST_1] = HAS_LOCAL_FLAG,
    [_STORE_FAST_2] = HAS_LOCAL_FLAG,
    [_STORE_FAST_3] = HAS_LOCAL_FLAG,
    [_STORE_FAST_4] = HAS_LOCAL_FLAG,
    [_STORE_FAST_5] = HAS_LOCAL_FLAG,
    [_STORE_FAST_6] = HAS_LOCAL_FLAG,
    [_STORE_FAST_7] = HAS_LOCAL_FLAG,
    [_STORE_FAST] = HAS_ARG_FLAG | HAS_LOCAL_FLAG,
    [_STORE_FAST_LOAD_FAST] = HAS_ARG_FLAG | HAS_LOCAL_FLAG,
    [_STORE_FAST_STORE_FAST] = HAS_ARG_FLAG | HAS_LOCAL_FLAG,
    [_POP_TOP] = HAS_PURE_FLAG,
    [_PUSH_NULL] = HAS_PURE_FLAG,
    [_END_SEND] = HAS_PURE_FLAG,
    [_UNARY_NEGATIVE] = HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_UNARY_NOT] = HAS_PURE_FLAG,
    [_TO_BOOL] = HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_TO_BOOL_BOOL] = HAS_EXIT_FLAG,
    [_TO_BOOL_INT] = HAS_EXIT_FLAG | HAS_ESCAPES_FLAG,
    [_TO_BOOL_LIST] = HAS_EXIT_FLAG,
    [_TO_BOOL_NONE] = HAS_EXIT_FLAG,
    [_TO_BOOL_STR] = HAS_EXIT_FLAG | HAS_ESCAPES_FLAG,
    [_REPLACE_WITH_TRUE] = 0,
    [_UNARY_INVERT] = HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_GUARD_BOTH_INT] = HAS_EXIT_FLAG,
    [_GUARD_NOS_INT] = HAS_EXIT_FLAG,
    [_GUARD_TOS_INT] = HAS_EXIT_FLAG,
    [_BINARY_OP_MULTIPLY_INT] = HAS_ERROR_FLAG | HAS_PURE_FLAG,
    [_BINARY_OP_ADD_INT] = HAS_ERROR_FLAG | HAS_PURE_FLAG,
    [_BINARY_OP_SUBTRACT_INT] = HAS_ERROR_FLAG | HAS_PURE_FLAG,
    [_GUARD_BOTH_FLOAT] = HAS_EXIT_FLAG,
    [_GUARD_NOS_FLOAT] = HAS_EXIT_FLAG,
    [_GUARD_TOS_FLOAT] = HAS_EXIT_FLAG,
    [_BINARY_OP_MULTIPLY_FLOAT] = HAS_PURE_FLAG,
    [_BINARY_OP_ADD_FLOAT] = HAS_PURE_FLAG,
    [_BINARY_OP_SUBTRACT_FLOAT] = HAS_PURE_FLAG,
    [_GUARD_BOTH_UNICODE] = HAS_EXIT_FLAG,
    [_BINARY_OP_ADD_UNICODE] = HAS_ERROR_FLAG | HAS_PURE_FLAG,
    [_BINARY_SUBSCR] = HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_BINARY_SLICE] = HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_STORE_SLICE] = HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_BINARY_SUBSCR_LIST_INT] = HAS_DEOPT_FLAG,
    [_BINARY_SUBSCR_STR_INT] = HAS_DEOPT_FLAG,
    [_BINARY_SUBSCR_TUPLE_INT] = HAS_DEOPT_FLAG,
    [_BINARY_SUBSCR_DICT] = HAS_DEOPT_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_LIST_APPEND] = HAS_ARG_FLAG | HAS_ERROR_FLAG,
    [_SET_ADD] = HAS_ARG_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_STORE_SUBSCR] = HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_STORE_SUBSCR_LIST_INT] = HAS_DEOPT_FLAG,
    [_STORE_SUBSCR_DICT] = HAS_DEOPT_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_DELETE_SUBSCR] = HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_CALL_INTRINSIC_1] = HAS_ARG_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_CALL_INTRINSIC_2] = HAS_ARG_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_POP_FRAME] = 0,
    [_GET_AITER] = HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_GET_ANEXT] = HAS_ERROR_FLAG | HAS_ERROR_NO_POP_FLAG | HAS_ESCAPES_FLAG,
    [_GET_AWAITABLE] = HAS_ARG_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_YIELD_VALUE] = HAS_ARG_FLAG | HAS_ESCAPES_FLAG,
    [_POP_EXCEPT] = HAS_ESCAPES_FLAG,
    [_LOAD_ASSERTION_ERROR] = 0,
    [_LOAD_BUILD_CLASS] = HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_STORE_NAME] = HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_DELETE_NAME] = HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG | HAS_ERROR_NO_POP_FLAG | HAS_ESCAPES_FLAG,
    [_UNPACK_SEQUENCE] = HAS_ARG_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_UNPACK_SEQUENCE_TWO_TUPLE] = HAS_ARG_FLAG | HAS_DEOPT_FLAG,
    [_UNPACK_SEQUENCE_TUPLE] = HAS_ARG_FLAG | HAS_DEOPT_FLAG,
    [_UNPACK_SEQUENCE_LIST] = HAS_ARG_FLAG | HAS_DEOPT_FLAG,
    [_UNPACK_EX] = HAS_ARG_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_STORE_ATTR] = HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_DELETE_ATTR] = HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_STORE_GLOBAL] = HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_DELETE_GLOBAL] = HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG | HAS_ERROR_NO_POP_FLAG | HAS_ESCAPES_FLAG,
    [_LOAD_LOCALS] = HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_LOAD_GLOBAL] = HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_GUARD_GLOBALS_VERSION] = HAS_DEOPT_FLAG,
    [_GUARD_BUILTINS_VERSION] = HAS_DEOPT_FLAG,
    [_LOAD_GLOBAL_MODULE] = HAS_ARG_FLAG | HAS_DEOPT_FLAG,
    [_LOAD_GLOBAL_BUILTINS] = HAS_ARG_FLAG | HAS_DEOPT_FLAG,
    [_DELETE_FAST] = HAS_ARG_FLAG | HAS_LOCAL_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_MAKE_CELL] = HAS_ARG_FLAG | HAS_FREE_FLAG | HAS_ERROR_FLAG | HAS_ERROR_NO_POP_FLAG,
    [_DELETE_DEREF] = HAS_ARG_FLAG | HAS_FREE_FLAG | HAS_ERROR_FLAG | HAS_ERROR_NO_POP_FLAG | HAS_ESCAPES_FLAG,
    [_LOAD_FROM_DICT_OR_DEREF] = HAS_ARG_FLAG | HAS_FREE_FLAG | HAS_ERROR_FLAG | HAS_ERROR_NO_POP_FLAG | HAS_ESCAPES_FLAG,
    [_LOAD_DEREF] = HAS_ARG_FLAG | HAS_FREE_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_STORE_DEREF] = HAS_ARG_FLAG | HAS_FREE_FLAG | HAS_ESCAPES_FLAG,
    [_COPY_FREE_VARS] = HAS_ARG_FLAG,
    [_BUILD_STRING] = HAS_ARG_FLAG | HAS_ERROR_FLAG,
    [_BUILD_TUPLE] = HAS_ARG_FLAG | HAS_ERROR_FLAG,
    [_BUILD_LIST] = HAS_ARG_FLAG | HAS_ERROR_FLAG,
    [_LIST_EXTEND] = HAS_ARG_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_SET_UPDATE] = HAS_ARG_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_BUILD_MAP] = HAS_ARG_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_SETUP_ANNOTATIONS] = HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_BUILD_CONST_KEY_MAP] = HAS_ARG_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_DICT_UPDATE] = HAS_ARG_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_DICT_MERGE] = HAS_ARG_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_MAP_ADD] = HAS_ARG_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_LOAD_SUPER_ATTR_ATTR] = HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_LOAD_SUPER_ATTR_METHOD] = HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_LOAD_ATTR] = HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_GUARD_TYPE_VERSION] = HAS_EXIT_FLAG,
    [_CHECK_MANAGED_OBJECT_HAS_VALUES] = HAS_DEOPT_FLAG,
    [_LOAD_ATTR_INSTANCE_VALUE_0] = HAS_DEOPT_FLAG,
    [_LOAD_ATTR_INSTANCE_VALUE_1] = HAS_DEOPT_FLAG,
    [_LOAD_ATTR_INSTANCE_VALUE] = HAS_ARG_FLAG | HAS_DEOPT_FLAG | HAS_OPARG_AND_1_FLAG,
    [_CHECK_ATTR_MODULE] = HAS_DEOPT_FLAG,
    [_LOAD_ATTR_MODULE] = HAS_ARG_FLAG | HAS_DEOPT_FLAG,
    [_CHECK_ATTR_WITH_HINT] = HAS_DEOPT_FLAG,
    [_LOAD_ATTR_WITH_HINT] = HAS_ARG_FLAG | HAS_NAME_FLAG | HAS_DEOPT_FLAG,
    [_LOAD_ATTR_SLOT_0] = HAS_DEOPT_FLAG,
    [_LOAD_ATTR_SLOT_1] = HAS_DEOPT_FLAG,
    [_LOAD_ATTR_SLOT] = HAS_ARG_FLAG | HAS_DEOPT_FLAG | HAS_OPARG_AND_1_FLAG,
    [_CHECK_ATTR_CLASS] = HAS_DEOPT_FLAG,
    [_LOAD_ATTR_CLASS_0] = 0,
    [_LOAD_ATTR_CLASS_1] = 0,
    [_LOAD_ATTR_CLASS] = HAS_ARG_FLAG | HAS_OPARG_AND_1_FLAG,
    [_GUARD_DORV_NO_DICT] = HAS_DEOPT_FLAG,
    [_STORE_ATTR_INSTANCE_VALUE] = 0,
    [_STORE_ATTR_SLOT] = 0,
    [_COMPARE_OP] = HAS_ARG_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_COMPARE_OP_FLOAT] = HAS_ARG_FLAG,
    [_COMPARE_OP_INT] = HAS_ARG_FLAG | HAS_DEOPT_FLAG,
    [_COMPARE_OP_STR] = HAS_ARG_FLAG,
    [_IS_OP] = HAS_ARG_FLAG,
    [_CONTAINS_OP] = HAS_ARG_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_CONTAINS_OP_SET] = HAS_ARG_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_CONTAINS_OP_DICT] = HAS_ARG_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_CHECK_EG_MATCH] = HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_CHECK_EXC_MATCH] = HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_IS_NONE] = 0,
    [_GET_LEN] = HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_MATCH_CLASS] = HAS_ARG_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_MATCH_MAPPING] = 0,
    [_MATCH_SEQUENCE] = 0,
    [_MATCH_KEYS] = HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_GET_ITER] = HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_GET_YIELD_FROM_ITER] = HAS_ERROR_FLAG | HAS_ERROR_NO_POP_FLAG | HAS_ESCAPES_FLAG,
    [_FOR_ITER_TIER_TWO] = HAS_DEOPT_FLAG | HAS_ERROR_FLAG | HAS_ERROR_NO_POP_FLAG | HAS_ESCAPES_FLAG,
    [_ITER_CHECK_LIST] = HAS_EXIT_FLAG,
    [_GUARD_NOT_EXHAUSTED_LIST] = HAS_EXIT_FLAG,
    [_ITER_NEXT_LIST] = 0,
    [_ITER_CHECK_TUPLE] = HAS_EXIT_FLAG,
    [_GUARD_NOT_EXHAUSTED_TUPLE] = HAS_EXIT_FLAG,
    [_ITER_NEXT_TUPLE] = 0,
    [_ITER_CHECK_RANGE] = HAS_EXIT_FLAG,
    [_GUARD_NOT_EXHAUSTED_RANGE] = HAS_EXIT_FLAG,
    [_ITER_NEXT_RANGE] = HAS_ERROR_FLAG,
    [_FOR_ITER_GEN_FRAME] = HAS_ARG_FLAG | HAS_DEOPT_FLAG,
    [_WITH_EXCEPT_START] = HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_PUSH_EXC_INFO] = 0,
    [_GUARD_DORV_VALUES_INST_ATTR_FROM_DICT] = HAS_DEOPT_FLAG,
    [_GUARD_KEYS_VERSION] = HAS_DEOPT_FLAG,
    [_LOAD_ATTR_METHOD_WITH_VALUES] = HAS_ARG_FLAG,
    [_LOAD_ATTR_METHOD_NO_DICT] = HAS_ARG_FLAG,
    [_LOAD_ATTR_NONDESCRIPTOR_WITH_VALUES] = HAS_ARG_FLAG,
    [_LOAD_ATTR_NONDESCRIPTOR_NO_DICT] = HAS_ARG_FLAG,
    [_CHECK_ATTR_METHOD_LAZY_DICT] = HAS_DEOPT_FLAG,
    [_LOAD_ATTR_METHOD_LAZY_DICT] = HAS_ARG_FLAG,
    [_CHECK_PERIODIC] = HAS_EVAL_BREAK_FLAG,
    [_PY_FRAME_GENERAL] = HAS_ARG_FLAG | HAS_ERROR_FLAG | HAS_ERROR_NO_POP_FLAG | HAS_ESCAPES_FLAG,
    [_CHECK_FUNCTION_VERSION] = HAS_ARG_FLAG | HAS_EXIT_FLAG,
    [_CHECK_METHOD_VERSION] = HAS_ARG_FLAG | HAS_EXIT_FLAG,
    [_EXPAND_METHOD] = HAS_ARG_FLAG,
    [_CHECK_IS_NOT_PY_CALLABLE] = HAS_ARG_FLAG | HAS_EXIT_FLAG,
    [_CALL_NON_PY_GENERAL] = HAS_ARG_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_CHECK_CALL_BOUND_METHOD_EXACT_ARGS] = HAS_ARG_FLAG | HAS_EXIT_FLAG,
    [_INIT_CALL_BOUND_METHOD_EXACT_ARGS] = HAS_ARG_FLAG,
    [_CHECK_PEP_523] = HAS_DEOPT_FLAG,
    [_CHECK_FUNCTION_EXACT_ARGS] = HAS_ARG_FLAG | HAS_EXIT_FLAG,
    [_CHECK_STACK_SPACE] = HAS_ARG_FLAG | HAS_DEOPT_FLAG,
    [_INIT_CALL_PY_EXACT_ARGS_0] = HAS_PURE_FLAG,
    [_INIT_CALL_PY_EXACT_ARGS_1] = HAS_PURE_FLAG,
    [_INIT_CALL_PY_EXACT_ARGS_2] = HAS_PURE_FLAG,
    [_INIT_CALL_PY_EXACT_ARGS_3] = HAS_PURE_FLAG,
    [_INIT_CALL_PY_EXACT_ARGS_4] = HAS_PURE_FLAG,
    [_INIT_CALL_PY_EXACT_ARGS] = HAS_ARG_FLAG | HAS_PURE_FLAG,
    [_PUSH_FRAME] = 0,
    [_CALL_TYPE_1] = HAS_ARG_FLAG | HAS_DEOPT_FLAG,
    [_CALL_STR_1] = HAS_ARG_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_CALL_TUPLE_1] = HAS_ARG_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_EXIT_INIT_CHECK] = HAS_ERROR_FLAG | HAS_ERROR_NO_POP_FLAG | HAS_ESCAPES_FLAG,
    [_CALL_BUILTIN_CLASS] = HAS_ARG_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_CALL_BUILTIN_O] = HAS_ARG_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_CALL_BUILTIN_FAST] = HAS_ARG_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_CALL_BUILTIN_FAST_WITH_KEYWORDS] = HAS_ARG_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_CALL_LEN] = HAS_ARG_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG | HAS_ERROR_NO_POP_FLAG | HAS_ESCAPES_FLAG,
    [_CALL_ISINSTANCE] = HAS_ARG_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG | HAS_ERROR_NO_POP_FLAG | HAS_ESCAPES_FLAG,
    [_CALL_METHOD_DESCRIPTOR_O] = HAS_ARG_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_CALL_METHOD_DESCRIPTOR_FAST_WITH_KEYWORDS] = HAS_ARG_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_CALL_METHOD_DESCRIPTOR_NOARGS] = HAS_ARG_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_CALL_METHOD_DESCRIPTOR_FAST] = HAS_ARG_FLAG | HAS_DEOPT_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_MAKE_FUNCTION] = HAS_ERROR_FLAG | HAS_ERROR_NO_POP_FLAG | HAS_ESCAPES_FLAG,
    [_SET_FUNCTION_ATTRIBUTE] = HAS_ARG_FLAG | HAS_ESCAPES_FLAG,
    [_RETURN_GENERATOR] = HAS_ERROR_FLAG | HAS_ERROR_NO_POP_FLAG | HAS_ESCAPES_FLAG,
    [_BUILD_SLICE] = HAS_ARG_FLAG | HAS_ERROR_FLAG,
    [_CONVERT_VALUE] = HAS_ARG_FLAG | HAS_ERROR_FLAG,
    [_FORMAT_SIMPLE] = HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_FORMAT_WITH_SPEC] = HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_COPY] = HAS_ARG_FLAG | HAS_PURE_FLAG,
    [_BINARY_OP] = HAS_ARG_FLAG | HAS_ERROR_FLAG | HAS_ESCAPES_FLAG,
    [_SWAP] = HAS_ARG_FLAG | HAS_PURE_FLAG,
    [_GUARD_IS_TRUE_POP] = HAS_EXIT_FLAG,
    [_GUARD_IS_FALSE_POP] = HAS_EXIT_FLAG,
    [_GUARD_IS_NONE_POP] = HAS_EXIT_FLAG,
    [_GUARD_IS_NOT_NONE_POP] = HAS_EXIT_FLAG,
    [_JUMP_TO_TOP] = 0,
    [_SET_IP] = 0,
    [_CHECK_STACK_SPACE_OPERAND] = HAS_DEOPT_FLAG,
    [_SAVE_RETURN_OFFSET] = HAS_ARG_FLAG,
    [_EXIT_TRACE] = 0,
    [_CHECK_VALIDITY] = HAS_DEOPT_FLAG,
    [_LOAD_CONST_INLINE] = HAS_PURE_FLAG,
    [_LOAD_CONST_INLINE_BORROW] = HAS_PURE_FLAG,
    [_POP_TOP_LOAD_CONST_INLINE_BORROW] = HAS_PURE_FLAG,
    [_LOAD_CONST_INLINE_WITH_NULL] = HAS_PURE_FLAG,
    [_LOAD_CONST_INLINE_BORROW_WITH_NULL] = HAS_PURE_FLAG,
    [_CHECK_FUNCTION] = HAS_DEOPT_FLAG,
    [_INTERNAL_INCREMENT_OPT_COUNTER] = 0,
    [_COLD_EXIT] = HAS_ARG_FLAG | HAS_ESCAPES_FLAG,
    [_DYNAMIC_EXIT] = HAS_ARG_FLAG | HAS_ESCAPES_FLAG,
    [_START_EXECUTOR] = HAS_DEOPT_FLAG,
    [_FATAL_ERROR] = 0,
    [_CHECK_VALIDITY_AND_SET_IP] = HAS_DEOPT_FLAG,
    [_DEOPT] = 0,
    [_ERROR_POP_N] = HAS_ARG_FLAG,
    [_TIER2_RESUME_CHECK] = HAS_DEOPT_FLAG,
};

const uint8_t _PyUop_Replication[MAX_UOP_ID+1] = {
    [_LOAD_FAST] = 8,
    [_STORE_FAST] = 8,
    [_INIT_CALL_PY_EXACT_ARGS] = 5,
};

const char *const _PyOpcode_uop_name[MAX_UOP_ID+1] = {
    [_BINARY_OP] = "_BINARY_OP",
    [_BINARY_OP_ADD_FLOAT] = "_BINARY_OP_ADD_FLOAT",
    [_BINARY_OP_ADD_INT] = "_BINARY_OP_ADD_INT",
    [_BINARY_OP_ADD_UNICODE] = "_BINARY_OP_ADD_UNICODE",
    [_BINARY_OP_MULTIPLY_FLOAT] = "_BINARY_OP_MULTIPLY_FLOAT",
    [_BINARY_OP_MULTIPLY_INT] = "_BINARY_OP_MULTIPLY_INT",
    [_BINARY_OP_SUBTRACT_FLOAT] = "_BINARY_OP_SUBTRACT_FLOAT",
    [_BINARY_OP_SUBTRACT_INT] = "_BINARY_OP_SUBTRACT_INT",
    [_BINARY_SLICE] = "_BINARY_SLICE",
    [_BINARY_SUBSCR] = "_BINARY_SUBSCR",
    [_BINARY_SUBSCR_DICT] = "_BINARY_SUBSCR_DICT",
    [_BINARY_SUBSCR_LIST_INT] = "_BINARY_SUBSCR_LIST_INT",
    [_BINARY_SUBSCR_STR_INT] = "_BINARY_SUBSCR_STR_INT",
    [_BINARY_SUBSCR_TUPLE_INT] = "_BINARY_SUBSCR_TUPLE_INT",
    [_BUILD_CONST_KEY_MAP] = "_BUILD_CONST_KEY_MAP",
    [_BUILD_LIST] = "_BUILD_LIST",
    [_BUILD_MAP] = "_BUILD_MAP",
    [_BUILD_SLICE] = "_BUILD_SLICE",
    [_BUILD_STRING] = "_BUILD_STRING",
    [_BUILD_TUPLE] = "_BUILD_TUPLE",
    [_CALL_BUILTIN_CLASS] = "_CALL_BUILTIN_CLASS",
    [_CALL_BUILTIN_FAST] = "_CALL_BUILTIN_FAST",
    [_CALL_BUILTIN_FAST_WITH_KEYWORDS] = "_CALL_BUILTIN_FAST_WITH_KEYWORDS",
    [_CALL_BUILTIN_O] = "_CALL_BUILTIN_O",
    [_CALL_INTRINSIC_1] = "_CALL_INTRINSIC_1",
    [_CALL_INTRINSIC_2] = "_CALL_INTRINSIC_2",
    [_CALL_ISINSTANCE] = "_CALL_ISINSTANCE",
    [_CALL_LEN] = "_CALL_LEN",
    [_CALL_METHOD_DESCRIPTOR_FAST] = "_CALL_METHOD_DESCRIPTOR_FAST",
    [_CALL_METHOD_DESCRIPTOR_FAST_WITH_KEYWORDS] = "_CALL_METHOD_DESCRIPTOR_FAST_WITH_KEYWORDS",
    [_CALL_METHOD_DESCRIPTOR_NOARGS] = "_CALL_METHOD_DESCRIPTOR_NOARGS",
    [_CALL_METHOD_DESCRIPTOR_O] = "_CALL_METHOD_DESCRIPTOR_O",
    [_CALL_NON_PY_GENERAL] = "_CALL_NON_PY_GENERAL",
    [_CALL_STR_1] = "_CALL_STR_1",
    [_CALL_TUPLE_1] = "_CALL_TUPLE_1",
    [_CALL_TYPE_1] = "_CALL_TYPE_1",
    [_CHECK_ATTR_CLASS] = "_CHECK_ATTR_CLASS",
    [_CHECK_ATTR_METHOD_LAZY_DICT] = "_CHECK_ATTR_METHOD_LAZY_DICT",
    [_CHECK_ATTR_MODULE] = "_CHECK_ATTR_MODULE",
    [_CHECK_ATTR_WITH_HINT] = "_CHECK_ATTR_WITH_HINT",
    [_CHECK_CALL_BOUND_METHOD_EXACT_ARGS] = "_CHECK_CALL_BOUND_METHOD_EXACT_ARGS",
    [_CHECK_EG_MATCH] = "_CHECK_EG_MATCH",
    [_CHECK_EXC_MATCH] = "_CHECK_EXC_MATCH",
    [_CHECK_FUNCTION] = "_CHECK_FUNCTION",
    [_CHECK_FUNCTION_EXACT_ARGS] = "_CHECK_FUNCTION_EXACT_ARGS",
    [_CHECK_FUNCTION_VERSION] = "_CHECK_FUNCTION_VERSION",
    [_CHECK_IS_NOT_PY_CALLABLE] = "_CHECK_IS_NOT_PY_CALLABLE",
    [_CHECK_MANAGED_OBJECT_HAS_VALUES] = "_CHECK_MANAGED_OBJECT_HAS_VALUES",
    [_CHECK_METHOD_VERSION] = "_CHECK_METHOD_VERSION",
    [_CHECK_PEP_523] = "_CHECK_PEP_523",
    [_CHECK_PERIODIC] = "_CHECK_PERIODIC",
    [_CHECK_STACK_SPACE] = "_CHECK_STACK_SPACE",
    [_CHECK_STACK_SPACE_OPERAND] = "_CHECK_STACK_SPACE_OPERAND",
    [_CHECK_VALIDITY] = "_CHECK_VALIDITY",
    [_CHECK_VALIDITY_AND_SET_IP] = "_CHECK_VALIDITY_AND_SET_IP",
    [_COLD_EXIT] = "_COLD_EXIT",
    [_COMPARE_OP] = "_COMPARE_OP",
    [_COMPARE_OP_FLOAT] = "_COMPARE_OP_FLOAT",
    [_COMPARE_OP_INT] = "_COMPARE_OP_INT",
    [_COMPARE_OP_STR] = "_COMPARE_OP_STR",
    [_CONTAINS_OP] = "_CONTAINS_OP",
    [_CONTAINS_OP_DICT] = "_CONTAINS_OP_DICT",
    [_CONTAINS_OP_SET] = "_CONTAINS_OP_SET",
    [_CONVERT_VALUE] = "_CONVERT_VALUE",
    [_COPY] = "_COPY",
    [_COPY_FREE_VARS] = "_COPY_FREE_VARS",
    [_DELETE_ATTR] = "_DELETE_ATTR",
    [_DELETE_DEREF] = "_DELETE_DEREF",
    [_DELETE_FAST] = "_DELETE_FAST",
    [_DELETE_GLOBAL] = "_DELETE_GLOBAL",
    [_DELETE_NAME] = "_DELETE_NAME",
    [_DELETE_SUBSCR] = "_DELETE_SUBSCR",
    [_DEOPT] = "_DEOPT",
    [_DICT_MERGE] = "_DICT_MERGE",
    [_DICT_UPDATE] = "_DICT_UPDATE",
    [_DYNAMIC_EXIT] = "_DYNAMIC_EXIT",
    [_END_SEND] = "_END_SEND",
    [_ERROR_POP_N] = "_ERROR_POP_N",
    [_EXIT_INIT_CHECK] = "_EXIT_INIT_CHECK",
    [_EXIT_TRACE] = "_EXIT_TRACE",
    [_EXPAND_METHOD] = "_EXPAND_METHOD",
    [_FATAL_ERROR] = "_FATAL_ERROR",
    [_FORMAT_SIMPLE] = "_FORMAT_SIMPLE",
    [_FORMAT_WITH_SPEC] = "_FORMAT_WITH_SPEC",
    [_FOR_ITER_GEN_FRAME] = "_FOR_ITER_GEN_FRAME",
    [_FOR_ITER_TIER_TWO] = "_FOR_ITER_TIER_TWO",
    [_GET_AITER] = "_GET_AITER",
    [_GET_ANEXT] = "_GET_ANEXT",
    [_GET_AWAITABLE] = "_GET_AWAITABLE",
    [_GET_ITER] = "_GET_ITER",
    [_GET_LEN] = "_GET_LEN",
    [_GET_YIELD_FROM_ITER] = "_GET_YIELD_FROM_ITER",
    [_GUARD_BOTH_FLOAT] = "_GUARD_BOTH_FLOAT",
    [_GUARD_BOTH_INT] = "_GUARD_BOTH_INT",
    [_GUARD_BOTH_UNICODE] = "_GUARD_BOTH_UNICODE",
    [_GUARD_BUILTINS_VERSION] = "_GUARD_BUILTINS_VERSION",
    [_GUARD_DORV_NO_DICT] = "_GUARD_DORV_NO_DICT",
    [_GUARD_DORV_VALUES_INST_ATTR_FROM_DICT] = "_GUARD_DORV_VALUES_INST_ATTR_FROM_DICT",
    [_GUARD_GLOBALS_VERSION] = "_GUARD_GLOBALS_VERSION",
    [_GUARD_IS_FALSE_POP] = "_GUARD_IS_FALSE_POP",
    [_GUARD_IS_NONE_POP] = "_GUARD_IS_NONE_POP",
    [_GUARD_IS_NOT_NONE_POP] = "_GUARD_IS_NOT_NONE_POP",
    [_GUARD_IS_TRUE_POP] = "_GUARD_IS_TRUE_POP",
    [_GUARD_KEYS_VERSION] = "_GUARD_KEYS_VERSION",
    [_GUARD_NOS_FLOAT] = "_GUARD_NOS_FLOAT",
    [_GUARD_NOS_INT] = "_GUARD_NOS_INT",
    [_GUARD_NOT_EXHAUSTED_LIST] = "_GUARD_NOT_EXHAUSTED_LIST",
    [_GUARD_NOT_EXHAUSTED_RANGE] = "_GUARD_NOT_EXHAUSTED_RANGE",
    [_GUARD_NOT_EXHAUSTED_TUPLE] = "_GUARD_NOT_EXHAUSTED_TUPLE",
    [_GUARD_TOS_FLOAT] = "_GUARD_TOS_FLOAT",
    [_GUARD_TOS_INT] = "_GUARD_TOS_INT",
    [_GUARD_TYPE_VERSION] = "_GUARD_TYPE_VERSION",
    [_INIT_CALL_BOUND_METHOD_EXACT_ARGS] = "_INIT_CALL_BOUND_METHOD_EXACT_ARGS",
    [_INIT_CALL_PY_EXACT_ARGS] = "_INIT_CALL_PY_EXACT_ARGS",
    [_INIT_CALL_PY_EXACT_ARGS_0] = "_INIT_CALL_PY_EXACT_ARGS_0",
    [_INIT_CALL_PY_EXACT_ARGS_1] = "_INIT_CALL_PY_EXACT_ARGS_1",
    [_INIT_CALL_PY_EXACT_ARGS_2] = "_INIT_CALL_PY_EXACT_ARGS_2",
    [_INIT_CALL_PY_EXACT_ARGS_3] = "_INIT_CALL_PY_EXACT_ARGS_3",
    [_INIT_CALL_PY_EXACT_ARGS_4] = "_INIT_CALL_PY_EXACT_ARGS_4",
    [_INTERNAL_INCREMENT_OPT_COUNTER] = "_INTERNAL_INCREMENT_OPT_COUNTER",
    [_IS_NONE] = "_IS_NONE",
    [_IS_OP] = "_IS_OP",
    [_ITER_CHECK_LIST] = "_ITER_CHECK_LIST",
    [_ITER_CHECK_RANGE] = "_ITER_CHECK_RANGE",
    [_ITER_CHECK_TUPLE] = "_ITER_CHECK_TUPLE",
    [_ITER_NEXT_LIST] = "_ITER_NEXT_LIST",
    [_ITER_NEXT_RANGE] = "_ITER_NEXT_RANGE",
    [_ITER_NEXT_TUPLE] = "_ITER_NEXT_TUPLE",
    [_JUMP_TO_TOP] = "_JUMP_TO_TOP",
    [_LIST_APPEND] = "_LIST_APPEND",
    [_LIST_EXTEND] = "_LIST_EXTEND",
    [_LOAD_ASSERTION_ERROR] = "_LOAD_ASSERTION_ERROR",
    [_LOAD_ATTR] = "_LOAD_ATTR",
    [_LOAD_ATTR_CLASS] = "_LOAD_ATTR_CLASS",
    [_LOAD_ATTR_CLASS_0] = "_LOAD_ATTR_CLASS_0",
    [_LOAD_ATTR_CLASS_1] = "_LOAD_ATTR_CLASS_1",
    [_LOAD_ATTR_INSTANCE_VALUE] = "_LOAD_ATTR_INSTANCE_VALUE",
    [_LOAD_ATTR_INSTANCE_VALUE_0] = "_LOAD_ATTR_INSTANCE_VALUE_0",
    [_LOAD_ATTR_INSTANCE_VALUE_1] = "_LOAD_ATTR_INSTANCE_VALUE_1",
    [_LOAD_ATTR_METHOD_LAZY_DICT] = "_LOAD_ATTR_METHOD_LAZY_DICT",
    [_LOAD_ATTR_METHOD_NO_DICT] = "_LOAD_ATTR_METHOD_NO_DICT",
    [_LOAD_ATTR_METHOD_WITH_VALUES] = "_LOAD_ATTR_METHOD_WITH_VALUES",
    [_LOAD_ATTR_MODULE] = "_LOAD_ATTR_MODULE",
    [_LOAD_ATTR_NONDESCRIPTOR_NO_DICT] = "_LOAD_ATTR_NONDESCRIPTOR_NO_DICT",
    [_LOAD_ATTR_NONDESCRIPTOR_WITH_VALUES] = "_LOAD_ATTR_NONDESCRIPTOR_WITH_VALUES",
    [_LOAD_ATTR_SLOT] = "_LOAD_ATTR_SLOT",
    [_LOAD_ATTR_SLOT_0] = "_LOAD_ATTR_SLOT_0",
    [_LOAD_ATTR_SLOT_1] = "_LOAD_ATTR_SLOT_1",
    [_LOAD_ATTR_WITH_HINT] = "_LOAD_ATTR_WITH_HINT",
    [_LOAD_BUILD_CLASS] = "_LOAD_BUILD_CLASS",
    [_LOAD_CONST] = "_LOAD_CONST",
    [_LOAD_CONST_INLINE] = "_LOAD_CONST_INLINE",
    [_LOAD_CONST_INLINE_BORROW] = "_LOAD_CONST_INLINE_BORROW",
    [_LOAD_CONST_INLINE_BORROW_WITH_NULL] = "_LOAD_CONST_INLINE_BORROW_WITH_NULL",
    [_LOAD_CONST_INLINE_WITH_NULL] = "_LOAD_CONST_INLINE_WITH_NULL",
    [_LOAD_DEREF] = "_LOAD_DEREF",
    [_LOAD_FAST] = "_LOAD_FAST",
    [_LOAD_FAST_0] = "_LOAD_FAST_0",
    [_LOAD_FAST_1] = "_LOAD_FAST_1",
    [_LOAD_FAST_2] = "_LOAD_FAST_2",
    [_LOAD_FAST_3] = "_LOAD_FAST_3",
    [_LOAD_FAST_4] = "_LOAD_FAST_4",
    [_LOAD_FAST_5] = "_LOAD_FAST_5",
    [_LOAD_FAST_6] = "_LOAD_FAST_6",
    [_LOAD_FAST_7] = "_LOAD_FAST_7",
    [_LOAD_FAST_AND_CLEAR] = "_LOAD_FAST_AND_CLEAR",
    [_LOAD_FAST_CHECK] = "_LOAD_FAST_CHECK",
    [_LOAD_FAST_LOAD_FAST] = "_LOAD_FAST_LOAD_FAST",
    [_LOAD_FROM_DICT_OR_DEREF] = "_LOAD_FROM_DICT_OR_DEREF",
    [_LOAD_GLOBAL] = "_LOAD_GLOBAL",
    [_LOAD_GLOBAL_BUILTINS] = "_LOAD_GLOBAL_BUILTINS",
    [_LOAD_GLOBAL_MODULE] = "_LOAD_GLOBAL_MODULE",
    [_LOAD_LOCALS] = "_LOAD_LOCALS",
    [_LOAD_SUPER_ATTR_ATTR] = "_LOAD_SUPER_ATTR_ATTR",
    [_LOAD_SUPER_ATTR_METHOD] = "_LOAD_SUPER_ATTR_METHOD",
    [_MAKE_CELL] = "_MAKE_CELL",
    [_MAKE_FUNCTION] = "_MAKE_FUNCTION",
    [_MAP_ADD] = "_MAP_ADD",
    [_MATCH_CLASS] = "_MATCH_CLASS",
    [_MATCH_KEYS] = "_MATCH_KEYS",
    [_MATCH_MAPPING] = "_MATCH_MAPPING",
    [_MATCH_SEQUENCE] = "_MATCH_SEQUENCE",
    [_NOP] = "_NOP",
    [_POP_EXCEPT] = "_POP_EXCEPT",
    [_POP_FRAME] = "_POP_FRAME",
    [_POP_TOP] = "_POP_TOP",
    [_POP_TOP_LOAD_CONST_INLINE_BORROW] = "_POP_TOP_LOAD_CONST_INLINE_BORROW",
    [_PUSH_EXC_INFO] = "_PUSH_EXC_INFO",
    [_PUSH_FRAME] = "_PUSH_FRAME",
    [_PUSH_NULL] = "_PUSH_NULL",
    [_PY_FRAME_GENERAL] = "_PY_FRAME_GENERAL",
    [_REPLACE_WITH_TRUE] = "_REPLACE_WITH_TRUE",
    [_RESUME_CHECK] = "_RESUME_CHECK",
    [_RETURN_GENERATOR] = "_RETURN_GENERATOR",
    [_SAVE_RETURN_OFFSET] = "_SAVE_RETURN_OFFSET",
    [_SETUP_ANNOTATIONS] = "_SETUP_ANNOTATIONS",
    [_SET_ADD] = "_SET_ADD",
    [_SET_FUNCTION_ATTRIBUTE] = "_SET_FUNCTION_ATTRIBUTE",
    [_SET_IP] = "_SET_IP",
    [_SET_UPDATE] = "_SET_UPDATE",
    [_START_EXECUTOR] = "_START_EXECUTOR",
    [_STORE_ATTR] = "_STORE_ATTR",
    [_STORE_ATTR_INSTANCE_VALUE] = "_STORE_ATTR_INSTANCE_VALUE",
    [_STORE_ATTR_SLOT] = "_STORE_ATTR_SLOT",
    [_STORE_DEREF] = "_STORE_DEREF",
    [_STORE_FAST] = "_STORE_FAST",
    [_STORE_FAST_0] = "_STORE_FAST_0",
    [_STORE_FAST_1] = "_STORE_FAST_1",
    [_STORE_FAST_2] = "_STORE_FAST_2",
    [_STORE_FAST_3] = "_STORE_FAST_3",
    [_STORE_FAST_4] = "_STORE_FAST_4",
    [_STORE_FAST_5] = "_STORE_FAST_5",
    [_STORE_FAST_6] = "_STORE_FAST_6",
    [_STORE_FAST_7] = "_STORE_FAST_7",
    [_STORE_FAST_LOAD_FAST] = "_STORE_FAST_LOAD_FAST",
    [_STORE_FAST_STORE_FAST] = "_STORE_FAST_STORE_FAST",
    [_STORE_GLOBAL] = "_STORE_GLOBAL",
    [_STORE_NAME] = "_STORE_NAME",
    [_STORE_SLICE] = "_STORE_SLICE",
    [_STORE_SUBSCR] = "_STORE_SUBSCR",
    [_STORE_SUBSCR_DICT] = "_STORE_SUBSCR_DICT",
    [_STORE_SUBSCR_LIST_INT] = "_STORE_SUBSCR_LIST_INT",
    [_SWAP] = "_SWAP",
    [_TIER2_RESUME_CHECK] = "_TIER2_RESUME_CHECK",
    [_TO_BOOL] = "_TO_BOOL",
    [_TO_BOOL_BOOL] = "_TO_BOOL_BOOL",
    [_TO_BOOL_INT] = "_TO_BOOL_INT",
    [_TO_BOOL_LIST] = "_TO_BOOL_LIST",
    [_TO_BOOL_NONE] = "_TO_BOOL_NONE",
    [_TO_BOOL_STR] = "_TO_BOOL_STR",
    [_UNARY_INVERT] = "_UNARY_INVERT",
    [_UNARY_NEGATIVE] = "_UNARY_NEGATIVE",
    [_UNARY_NOT] = "_UNARY_NOT",
    [_UNPACK_EX] = "_UNPACK_EX",
    [_UNPACK_SEQUENCE] = "_UNPACK_SEQUENCE",
    [_UNPACK_SEQUENCE_LIST] = "_UNPACK_SEQUENCE_LIST",
    [_UNPACK_SEQUENCE_TUPLE] = "_UNPACK_SEQUENCE_TUPLE",
    [_UNPACK_SEQUENCE_TWO_TUPLE] = "_UNPACK_SEQUENCE_TWO_TUPLE",
    [_WITH_EXCEPT_START] = "_WITH_EXCEPT_START",
    [_YIELD_VALUE] = "_YIELD_VALUE",
};
int _PyUop_num_popped(int opcode, int oparg)
{
    switch(opcode) {
        case _NOP:
            return 0;
        case _RESUME_CHECK:
            return 0;
        case _LOAD_FAST_CHECK:
            return 0;
        case _LOAD_FAST_0:
            return 0;
        case _LOAD_FAST_1:
            return 0;
        case _LOAD_FAST_2:
            return 0;
        case _LOAD_FAST_3:
            return 0;
        case _LOAD_FAST_4:
            return 0;
        case _LOAD_FAST_5:
            return 0;
        case _LOAD_FAST_6:
            return 0;
        case _LOAD_FAST_7:
            return 0;
        case _LOAD_FAST:
            return 0;
        case _LOAD_FAST_AND_CLEAR:
            return 0;
        case _LOAD_FAST_LOAD_FAST:
            return 0;
        case _LOAD_CONST:
            return 0;
        case _STORE_FAST_0:
            return 1;
        case _STORE_FAST_1:
            return 1;
        case _STORE_FAST_2:
            return 1;
        case _STORE_FAST_3:
            return 1;
        case _STORE_FAST_4:
            return 1;
        case _STORE_FAST_5:
            return 1;
        case _STORE_FAST_6:
            return 1;
        case _STORE_FAST_7:
            return 1;
        case _STORE_FAST:
            return 1;
        case _STORE_FAST_LOAD_FAST:
            return 1;
        case _STORE_FAST_STORE_FAST:
            return 2;
        case _POP_TOP:
            return 1;
        case _PUSH_NULL:
            return 0;
        case _END_SEND:
            return 2;
        case _UNARY_NEGATIVE:
            return 1;
        case _UNARY_NOT:
            return 1;
        case _TO_BOOL:
            return 1;
        case _TO_BOOL_BOOL:
            return 1;
        case _TO_BOOL_INT:
            return 1;
        case _TO_BOOL_LIST:
            return 1;
        case _TO_BOOL_NONE:
            return 1;
        case _TO_BOOL_STR:
            return 1;
        case _REPLACE_WITH_TRUE:
            return 1;
        case _UNARY_INVERT:
            return 1;
        case _GUARD_BOTH_INT:
            return 2;
        case _GUARD_NOS_INT:
            return 2;
        case _GUARD_TOS_INT:
            return 1;
        case _BINARY_OP_MULTIPLY_INT:
            return 2;
        case _BINARY_OP_ADD_INT:
            return 2;
        case _BINARY_OP_SUBTRACT_INT:
            return 2;
        case _GUARD_BOTH_FLOAT:
            return 2;
        case _GUARD_NOS_FLOAT:
            return 2;
        case _GUARD_TOS_FLOAT:
            return 1;
        case _BINARY_OP_MULTIPLY_FLOAT:
            return 2;
        case _BINARY_OP_ADD_FLOAT:
            return 2;
        case _BINARY_OP_SUBTRACT_FLOAT:
            return 2;
        case _GUARD_BOTH_UNICODE:
            return 2;
        case _BINARY_OP_ADD_UNICODE:
            return 2;
        case _BINARY_SUBSCR:
            return 2;
        case _BINARY_SLICE:
            return 3;
        case _STORE_SLICE:
            return 4;
        case _BINARY_SUBSCR_LIST_INT:
            return 2;
        case _BINARY_SUBSCR_STR_INT:
            return 2;
        case _BINARY_SUBSCR_TUPLE_INT:
            return 2;
        case _BINARY_SUBSCR_DICT:
            return 2;
        case _LIST_APPEND:
            return 2 + (oparg-1);
        case _SET_ADD:
            return 2 + (oparg-1);
        case _STORE_SUBSCR:
            return 3;
        case _STORE_SUBSCR_LIST_INT:
            return 3;
        case _STORE_SUBSCR_DICT:
            return 3;
        case _DELETE_SUBSCR:
            return 2;
        case _CALL_INTRINSIC_1:
            return 1;
        case _CALL_INTRINSIC_2:
            return 2;
        case _POP_FRAME:
            return 1;
        case _GET_AITER:
            return 1;
        case _GET_ANEXT:
            return 1;
        case _GET_AWAITABLE:
            return 1;
        case _YIELD_VALUE:
            return 1;
        case _POP_EXCEPT:
            return 1;
        case _LOAD_ASSERTION_ERROR:
            return 0;
        case _LOAD_BUILD_CLASS:
            return 0;
        case _STORE_NAME:
            return 1;
        case _DELETE_NAME:
            return 0;
        case _UNPACK_SEQUENCE:
            return 1;
        case _UNPACK_SEQUENCE_TWO_TUPLE:
            return 1;
        case _UNPACK_SEQUENCE_TUPLE:
            return 1;
        case _UNPACK_SEQUENCE_LIST:
            return 1;
        case _UNPACK_EX:
            return 1;
        case _STORE_ATTR:
            return 2;
        case _DELETE_ATTR:
            return 1;
        case _STORE_GLOBAL:
            return 1;
        case _DELETE_GLOBAL:
            return 0;
        case _LOAD_LOCALS:
            return 0;
        case _LOAD_GLOBAL:
            return 0;
        case _GUARD_GLOBALS_VERSION:
            return 0;
        case _GUARD_BUILTINS_VERSION:
            return 0;
        case _LOAD_GLOBAL_MODULE:
            return 0;
        case _LOAD_GLOBAL_BUILTINS:
            return 0;
        case _DELETE_FAST:
            return 0;
        case _MAKE_CELL:
            return 0;
        case _DELETE_DEREF:
            return 0;
        case _LOAD_FROM_DICT_OR_DEREF:
            return 1;
        case _LOAD_DEREF:
            return 0;
        case _STORE_DEREF:
            return 1;
        case _COPY_FREE_VARS:
            return 0;
        case _BUILD_STRING:
            return oparg;
        case _BUILD_TUPLE:
            return oparg;
        case _BUILD_LIST:
            return oparg;
        case _LIST_EXTEND:
            return 2 + (oparg-1);
        case _SET_UPDATE:
            return 2 + (oparg-1);
        case _BUILD_MAP:
            return oparg*2;
        case _SETUP_ANNOTATIONS:
            return 0;
        case _BUILD_CONST_KEY_MAP:
            return 1 + oparg;
        case _DICT_UPDATE:
            return 2 + (oparg - 1);
        case _DICT_MERGE:
            return 5 + (oparg - 1);
        case _MAP_ADD:
            return 3 + (oparg - 1);
        case _LOAD_SUPER_ATTR_ATTR:
            return 3;
        case _LOAD_SUPER_ATTR_METHOD:
            return 3;
        case _LOAD_ATTR:
            return 1;
        case _GUARD_TYPE_VERSION:
            return 1;
        case _CHECK_MANAGED_OBJECT_HAS_VALUES:
            return 1;
        case _LOAD_ATTR_INSTANCE_VALUE_0:
            return 1;
        case _LOAD_ATTR_INSTANCE_VALUE_1:
            return 1;
        case _LOAD_ATTR_INSTANCE_VALUE:
            return 1;
        case _CHECK_ATTR_MODULE:
            return 1;
        case _LOAD_ATTR_MODULE:
            return 1;
        case _CHECK_ATTR_WITH_HINT:
            return 1;
        case _LOAD_ATTR_WITH_HINT:
            return 1;
        case _LOAD_ATTR_SLOT_0:
            return 1;
        case _LOAD_ATTR_SLOT_1:
            return 1;
        case _LOAD_ATTR_SLOT:
            return 1;
        case _CHECK_ATTR_CLASS:
            return 1;
        case _LOAD_ATTR_CLASS_0:
            return 1;
        case _LOAD_ATTR_CLASS_1:
            return 1;
        case _LOAD_ATTR_CLASS:
            return 1;
        case _GUARD_DORV_NO_DICT:
            return 1;
        case _STORE_ATTR_INSTANCE_VALUE:
            return 2;
        case _STORE_ATTR_SLOT:
            return 2;
        case _COMPARE_OP:
            return 2;
        case _COMPARE_OP_FLOAT:
            return 2;
        case _COMPARE_OP_INT:
            return 2;
        case _COMPARE_OP_STR:
            return 2;
        case _IS_OP:
            return 2;
        case _CONTAINS_OP:
            return 2;
        case _CONTAINS_OP_SET:
            return 2;
        case _CONTAINS_OP_DICT:
            return 2;
        case _CHECK_EG_MATCH:
            return 2;
        case _CHECK_EXC_MATCH:
            return 2;
        case _IS_NONE:
            return 1;
        case _GET_LEN:
            return 1;
        case _MATCH_CLASS:
            return 3;
        case _MATCH_MAPPING:
            return 1;
        case _MATCH_SEQUENCE:
            return 1;
        case _MATCH_KEYS:
            return 2;
        case _GET_ITER:
            return 1;
        case _GET_YIELD_FROM_ITER:
            return 1;
        case _FOR_ITER_TIER_TWO:
            return 1;
        case _ITER_CHECK_LIST:
            return 1;
        case _GUARD_NOT_EXHAUSTED_LIST:
            return 1;
        case _ITER_NEXT_LIST:
            return 1;
        case _ITER_CHECK_TUPLE:
            return 1;
        case _GUARD_NOT_EXHAUSTED_TUPLE:
            return 1;
        case _ITER_NEXT_TUPLE:
            return 1;
        case _ITER_CHECK_RANGE:
            return 1;
        case _GUARD_NOT_EXHAUSTED_RANGE:
            return 1;
        case _ITER_NEXT_RANGE:
            return 1;
        case _FOR_ITER_GEN_FRAME:
            return 1;
        case _WITH_EXCEPT_START:
            return 4;
        case _PUSH_EXC_INFO:
            return 1;
        case _GUARD_DORV_VALUES_INST_ATTR_FROM_DICT:
            return 1;
        case _GUARD_KEYS_VERSION:
            return 1;
        case _LOAD_ATTR_METHOD_WITH_VALUES:
            return 1;
        case _LOAD_ATTR_METHOD_NO_DICT:
            return 1;
        case _LOAD_ATTR_NONDESCRIPTOR_WITH_VALUES:
            return 1;
        case _LOAD_ATTR_NONDESCRIPTOR_NO_DICT:
            return 1;
        case _CHECK_ATTR_METHOD_LAZY_DICT:
            return 1;
        case _LOAD_ATTR_METHOD_LAZY_DICT:
            return 1;
        case _CHECK_PERIODIC:
            return 0;
        case _PY_FRAME_GENERAL:
            return 2 + oparg;
        case _CHECK_FUNCTION_VERSION:
            return 2 + oparg;
        case _CHECK_METHOD_VERSION:
            return 2 + oparg;
        case _EXPAND_METHOD:
            return 2 + oparg;
        case _CHECK_IS_NOT_PY_CALLABLE:
            return 2 + oparg;
        case _CALL_NON_PY_GENERAL:
            return 2 + oparg;
        case _CHECK_CALL_BOUND_METHOD_EXACT_ARGS:
            return 2 + oparg;
        case _INIT_CALL_BOUND_METHOD_EXACT_ARGS:
            return 2 + oparg;
        case _CHECK_PEP_523:
            return 0;
        case _CHECK_FUNCTION_EXACT_ARGS:
            return 2 + oparg;
        case _CHECK_STACK_SPACE:
            return 2 + oparg;
        case _INIT_CALL_PY_EXACT_ARGS_0:
            return 2 + oparg;
        case _INIT_CALL_PY_EXACT_ARGS_1:
            return 2 + oparg;
        case _INIT_CALL_PY_EXACT_ARGS_2:
            return 2 + oparg;
        case _INIT_CALL_PY_EXACT_ARGS_3:
            return 2 + oparg;
        case _INIT_CALL_PY_EXACT_ARGS_4:
            return 2 + oparg;
        case _INIT_CALL_PY_EXACT_ARGS:
            return 2 + oparg;
        case _PUSH_FRAME:
            return 1;
        case _CALL_TYPE_1:
            return 3;
        case _CALL_STR_1:
            return 3;
        case _CALL_TUPLE_1:
            return 3;
        case _EXIT_INIT_CHECK:
            return 1;
        case _CALL_BUILTIN_CLASS:
            return 2 + oparg;
        case _CALL_BUILTIN_O:
            return 2 + oparg;
        case _CALL_BUILTIN_FAST:
            return 2 + oparg;
        case _CALL_BUILTIN_FAST_WITH_KEYWORDS:
            return 2 + oparg;
        case _CALL_LEN:
            return 2 