e_FromTimespec(PyTime_t *tp, const struct timespec *ts);

// Convert a timestamp to a timespec structure (nanosecond resolution).
// tv_nsec is always positive.
// Raise an exception and return -1 on error, return 0 on success.
// Export for '_testinternalcapi' shared extension.
PyAPI_FUNC(int) _PyTime_AsTimespec(PyTime_t t, struct timespec *ts);

// Similar to _PyTime_AsTimespec() but don't raise an exception on overflow.
// On overflow, clamp tv_sec to PyTime_t min/max.
// Export for '_testinternalcapi' shared extension.
PyAPI_FUNC(void) _PyTime_AsTimespec_clamp(PyTime_t t, struct timespec *ts);
#endif


// Compute t1 + t2. Clamp to [PyTime_MIN; PyTime_MAX] on overflow.
extern PyTime_t _PyTime_Add(PyTime_t t1, PyTime_t t2);

// Structure used by time.get_clock_info()
typedef struct {
    const char *implementation;
    int monotonic;
    int adjustable;
    double resolution;
} _Py_clock_info_t;

// Get the current time from the system clock.
// On success, set *t and *info (if not NULL), and return 0.
// On error, raise an exception and return -1.
extern int _PyTime_TimeWithInfo(
    PyTime_t *t,
    _Py_clock_info_t *info);

// Get the time of a monotonic clock, i.e. a clock that cannot go backwards.
// The clock is not affected by system clock updates. The reference point of
// the returned value is undefined, so that only the difference between the
// results of consecutive calls is valid.
//
// Fill info (if set) with information of the function used to get the time.
//
// Return